from datetime import datetime

from pydantic import BaseModel


class Monitoring(BaseModel):
    pass


class MonitoringUnit(BaseModel):
    status: bool
    timestamp: datetime


class GoogleCalendar(Monitoring):
    read_access: MonitoringUnit | None = None
    write_access: MonitoringUnit | None = None


class Zoom(Monitoring):
    recording_access: MonitoringUnit | None = None


class GoogleMeet(Monitoring):
    recording_access: MonitoringUnit | None = None


class AttendanceControl(Monitoring):
    pass


class GoogleDrive(Monitoring):
    share_access: MonitoringUnit | None = None


class Telegram(Monitoring):
    send_access: MonitoringUnit | None = None


class Email(Monitoring):
    pass
