from pydantic import BaseModel, EmailStr

from . import monitoring


class BaseUnit(BaseModel):
    """Базовый юнит интеграции. Содержит мониторинг; данные добавляются в наследниках."""
    monitoring: monitoring.Monitoring


class Integration(BaseModel):
    """Базовая модель интеграции: содержит только список юнитов."""
    units: list[BaseUnit]


class GoogleCalendar(Integration):
    class Unit(BaseUnit):
        calendar_id: str
        monitoring: monitoring.GoogleCalendar

    units: list[Unit]


class Zoom(Integration):
    class Unit(BaseUnit):
        account_id: str
        monitoring: monitoring.Zoom

    units: list[Unit]


class GoogleMeet(Integration):
    class Unit(BaseUnit):
        account_id: str
        monitoring: monitoring.GoogleMeet

    units: list[Unit]


class AttendanceControl(Integration):
    class Unit(BaseUnit):
        names: list[str]
        monitoring: monitoring.AttendanceControl

    units: list[Unit]


class GoogleDrive(Integration):
    class Unit(BaseUnit):
        account_id: str
        monitoring: monitoring.GoogleDrive

    units: list[Unit]


class Telegram(Integration):
    class Unit(BaseUnit):
        telegram_id: int
        user_name: str | None
        name: str
        surname: str | None
        monitoring: monitoring.Telegram

    units: list[Unit]

class Email(Integration):
    class Unit(BaseUnit):
        email: EmailStr
        monitoring: monitoring.Email

    units: list[Unit]