from pydantic import BaseModel, model_validator

from . import configs


class GetIntegrationConfig(BaseModel):
    domain: str
    integration: str
    payload: configs.AttendanceControlConfig

    @model_validator(mode="before")
    def pick_payload_model(cls, data: dict):
        model = configs._MAP.get(data.get("integration"))
        if not model:
            raise ValueError(f"Unknown integration: {data.get('integration')}")
        if isinstance(data.get("payload"), dict):
            data["payload"] = model.model_validate(data["payload"])
        return data
