from enum import StrEnum, auto

from pydantic import BaseModel


class TextError(BaseModel):
    class Type(StrEnum):
        API_KEY_REQUIRED = auto()
        API_KEY_INVALID = auto()
        INVALID_UUID = auto()
        DOMAIN_NOT_FOUND = auto()
        INTEGRATION_NOT_FOUND = auto()
        USER_NOT_FOUND_FOR_INTEGRATIONS = auto()
        USER_NOT_FOUND = auto()
        INTEGRATION_UNIT_NOT_FOUND = auto()
        MONITORING_TYPE_NOT_FOUND = auto()
        EMAIL_NOT_MATCH_DOMAIN_PATTERN = auto()
        USER_EMAIL_CONFLICT = auto()
        INTEGRATION_NOT_AVAILABLE_FOR_DOMAIN = auto()
        USER_DOMAIN_MISMATCH = auto()
        USER_DOMAIN_MISMATCH_FOR_INVALIDATED = auto()
        INTERNAL_SERVER_ERROR = auto()

    detail: Type | str
