from enum import StrEnum, auto


class MonitoringType(StrEnum):
    pass


class GoogleCalendar(MonitoringType):
    read_access = auto()
    write_access = auto()


class Zoom(MonitoringType):
    recording_access = auto()


class GoogleMeet(MonitoringType):
    recording_access = auto()


class AttendanceControl(MonitoringType):
    pass


class GoogleDrive(MonitoringType):
    share_access = auto()


class Telegram(MonitoringType):
    send_access = auto()


class Email(MonitoringType):
    pass
