from pydantic import BaseModel


class DependenciesHealthResponse(BaseModel):
    """
    Ответ на запрос проверки зависимостей сервиса.
    Соответствует схеме DependenciesHealthResponse из OpenAPI спецификации версии 0.1.0.
    
    Примечание: фактическая реализация может включать дополнительные поля
    (openai, deepgram), не указанные в OpenAPI спецификации.
    """
    config: bool
    database: bool
    openai: bool = False
    deepgram: bool = False

