from datetime import datetime
from typing import Optional
from enum import StrEnum, auto

from pydantic import BaseModel


class Attendee(BaseModel):
    """
    Участник конференции.
    """
    user_uuid: str | None
    email: str


class VcCreds(BaseModel):
    """
    Данные для входа в конференцию (VC credentials).
    """
    class ZoomCreds(BaseModel):
        """
        Данные для входа в Zoom конференцию.
        """
        conference_id: int
        password: str
        link: Optional[str] = None
        host: Optional[str] = None

    class GoogleMeetCreds(BaseModel):
        """
        Данные для входа в Google Meet конференцию.
        """
        link: str

    google_meet: Optional[GoogleMeetCreds] = None
    zoom: Optional[ZoomCreds] = None


class Event(BaseModel):
    """
    Информация о событии.
    Соответствует схеме Event из OpenAPI спецификации версии 0.1.0.
    """
    uuid: str
    domain: str
    title: Optional[str] = None
    start_ts: datetime
    end_ts: datetime
    organizer: Optional[Attendee] = None
    attendees: Optional[list[Attendee]] = None
    vc_credentials: VcCreds
    event_id: Optional[str] = None
    recurring_event_id: Optional[str] = None

