from enum import Enum, auto


class AdapterException(RuntimeError):
    def __str__(self):
        return f"({type(self)}) {super().__str__()}"

    def __repr__(self):
        return str(self)


class NotAuthorizedException(AdapterException):
    pass


class NotFoundException(AdapterException):
    class Entity(Enum):
        event = auto()
        domain = auto()


class BadRequestException(AdapterException):
    """
    400-level client error that is not semantically a conflict or authorization error.
    """
    class Reason(Enum):
        pass  # Зарезервировано для будущих специфичных ошибок


class UnprocessableEntityException(AdapterException):
    """
    422-level validation errors.
    """
    class Reason(Enum):
        invalid_uuid = auto()


class ConflictException(AdapterException):
    class Reason(Enum):
        pass  # Зарезервировано для будущих специфичных ошибок


class UnknownException(AdapterException):
    pass

