from datetime import datetime

from pydantic import BaseModel


class Interval(BaseModel):
    begin_dt: datetime
    end_dt: datetime


class Attendance(BaseModel):
    user_uuid: str
    class Event(BaseModel):
        event_uuid: str
        held: Interval | None

    event: Event
    attended: Interval | None
    is_organizer: bool
