from pydantic import BaseModel


class UserStats(BaseModel):
    """Статистика пользователя."""

    class MeetingsStats(BaseModel):
        """Статистика по встречам."""
        total_num: int
        not_held_num: int
        attended_num: int
        missed_num: int

    class AttendedMeetingsStats(BaseModel):
        """Статистика по посещенным встречам."""
        total_held_min: int
        missed_min: int
        lateness_num: int
        lateness_avg_min: int | None

    user_uuid: str
    meetings: MeetingsStats
    attended_meetings: AttendedMeetingsStats
