from enum import StrEnum, auto

from pydantic import BaseModel


class TextError(BaseModel):
    class Type(StrEnum):
        API_KEY_REQUIRED = auto()
        API_KEY_INVALID = auto()

        INTEGRATION_NOT_ENABLED_FOR_DOMAIN = auto()

        EVENT_NOT_FOUND = auto()
        USER_NOT_FOUND = auto()

        INTERNAL_SERVER_ERROR = auto()

    detail: Type | str
