from datetime import date as Date

from pydantic import BaseModel

from ..enums import ModifyEventStatus
from ..utils import main


class AttendanceResponse(BaseModel):
    """Ответ на создание/обновление посещения."""
    event_uuid: str
    user_uuid: str | None = None
    confidence: float | None = None
    status: ModifyEventStatus


class UserAttendance(BaseModel):
    """Посещение пользователя с информацией о событии."""
    event: main.Attendance.Event
    # Поле обязательно по контракту, но само значение может быть null.
    attended: main.Interval | None
    is_organizer: bool


class AttendancesByDayResponse(BaseModel):
    """Ответ с посещениями пользователя за день."""
    user_uuid: str
    # В контракте поле date не обязательно и может быть null.
    date: Date | None = None
    attendances: list[UserAttendance]

