from enum import Enum, auto


class AdapterException(RuntimeError):
    def __str__(self):
        return f"({type(self)}) {super().__str__()}"

    def __repr__(self):
        return str(self)


class NotAuthorizedException(AdapterException):
    pass


class ForbiddenException(AdapterException):
    class Entity(Enum):
        integration_not_enabled_for_domain = auto()


class NotFoundException(AdapterException):
    class Entity(Enum):
        event = auto()
        user = auto()


class BadRequestException(AdapterException):
    """
    400-level client errors.
    """
    class Entity(Enum):
        event_not_registered = auto()


class NotAcceptableException(AdapterException):
    """
    406-level client errors.
    """
    class Entity(Enum):
        confidence_too_low = auto()


class UnprocessableEntityException(AdapterException):
    """
    422-level validation errors.
    """
    pass


class UnknownException(AdapterException):
    pass
