from datetime import datetime

from pydantic import BaseModel, EmailStr

from .integrations import integrations
from ..enums import UserType


class Integrations(BaseModel):
    google_calendar: integrations.GoogleCalendar | None = None
    zoom: integrations.Zoom | None = None
    google_meet: integrations.GoogleMeet | None = None
    attendance_control: integrations.AttendanceControl | None = None
    google_drive: integrations.GoogleDrive | None = None
    telegram: integrations.Telegram | None = None
    email: integrations.Email | None = None


class Emails(BaseModel):
    main_email: EmailStr
    additional_emails: list[EmailStr]


class User(BaseModel):
    uuid: str
    domain: str

    type: UserType

    emails: Emails
    integrations: Integrations

    created: datetime
    removed: datetime | None
