from enum import Enum, auto

class AdapterException(RuntimeError):
    def __str__(self):
        return f"({type(self)}) {super().__str__()}"

    def __repr__(self):
        return str(self)


class NotAuthorizedException(AdapterException):
    pass


class NotFoundException(AdapterException):
    class Entity(Enum):
        domain = auto()
        user = auto()
        integration = auto()
        monitoring_unit = auto()
        monitoring_type = auto()


class BadRequestException(AdapterException):
    """
    400-level client error that is not semantically a conflict or authorization error.
    """
    class Reason(Enum):
        email_not_match_domain_pattern = auto()


class UnprocessableEntityException(AdapterException):
    """
    422-level validation errors.
    """
    class Reason(Enum):
        invalid_uuid = auto()
        user_email_conflict = auto()
        integration_not_available_for_domain = auto()


class ConflictException(AdapterException):
    class Reason(Enum):
        user_domain_mismatch = auto()
        user_domain_mismatch_for_invalidated = auto()


class UnknownException(AdapterException):
    pass
