# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['improved_datamodel_codegen',
 'improved_datamodel_codegen.model',
 'improved_datamodel_codegen.model.pydantic',
 'improved_datamodel_codegen.parser']

package_data = \
{'': ['*'],
 'improved_datamodel_codegen.model': ['template/*', 'template/pydantic/*']}

install_requires = \
['PySnooper>=0.4.1,<2.0.0',
 'argcomplete>=1.10,<3.0',
 'black>=19.10b0',
 'genson>=1.2.1,<2.0',
 'inflect>=4.1.0,<6.0',
 'isort>=4.3.21,<6.0',
 'jinja2>=2.10.1,<4.0',
 'openapi-spec-validator>=0.2.8,<=0.5.1',
 'packaging',
 'prance>=0.18.2,<1.0',
 'toml>=0.10.0,<1.0.0']

extras_require = \
{':python_full_version < "3.9.8"': ['typed-ast>=1.4.2'],
 ':python_full_version >= "3.9.8"': ['typed-ast>=1.5.0'],
 ':python_version < "3.10"': ['pydantic[email]>=1.5.1,<2.0'],
 ':python_version >= "3.10" and python_version < "3.11"': ['pydantic[email]>=1.9.0,<2.0'],
 ':python_version >= "3.11"': ['pydantic[email]>=1.10.0,<2.0'],
 'http': ['httpx']}

entry_points = \
{'console_scripts': ['datamodel-codegen = '
                     'datamodel_code_generator.__main__:main']}

setup_kwargs = {
    'name': 'improved-datamodel-codegen',
    'version': '1.2.0',
    'description': 'Datamodel Code Generator',
    'long_description': '# datamodel-code-generator\n> Note: This is a fork\n\nThis code generator creates [pydantic](https://docs.pydantic.dev/) model and [dataclasses.dataclass](https://docs.python.org/3/library/dataclasses.html) from an openapi file and others.\n\n[![Build Status](https://github.com/koxudaxi/datamodel-code-generator/workflows/Test/badge.svg)](https://github.com/koxudaxi/datamodel-code-generator/actions?query=workflow%3ATest)\n[![PyPI version](https://badge.fury.io/py/datamodel-code-generator.svg)](https://pypi.python.org/pypi/datamodel-code-generator)\n[![Downloads](https://pepy.tech/badge/datamodel-code-generator/month)](https://pepy.tech/project/datamodel-code-generator)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/datamodel-code-generator)](https://pypi.python.org/pypi/datamodel-code-generator)\n[![codecov](https://codecov.io/gh/koxudaxi/datamodel-code-generator/branch/master/graph/badge.svg)](https://codecov.io/gh/koxudaxi/datamodel-code-generator)\n![license](https://img.shields.io/github/license/koxudaxi/datamodel-code-generator.svg)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n\n## Help\nSee [documentation](https://koxudaxi.github.io/datamodel-code-generator) for more details.\n\n## Sponsors\n[![JetBrains](https://avatars.githubusercontent.com/u/60931315?s=200&v=4)](https://github.com/JetBrainsOfficial)\n\n## Quick Installation\n\nTo install `datamodel-code-generator`:\n```bash\n$ pip install datamodel-code-generator\n```\n\n## Simple usage\nYou can generate models from a local file.\n```bash\n$ datamodel-codegen --input api.yaml --output model.py\n```\n\n<details>\n<summary>api.yaml</summary>\n\n```yaml\nopenapi: "3.0.0"\ninfo:\n  version: 1.0.0\n  title: Swagger Petstore\n  license:\n    name: MIT\nservers:\n  - url: http://petstore.swagger.io/v1\npaths:\n  /pets:\n    get:\n      summary: List all pets\n      operationId: listPets\n      tags:\n        - pets\n      parameters:\n        - name: limit\n          in: query\n          description: How many items to return at one time (max 100)\n          required: false\n          schema:\n            type: integer\n            format: int32\n      responses:\n        \'200\':\n          description: A paged array of pets\n          headers:\n            x-next:\n              description: A link to the next page of responses\n              schema:\n                type: string\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Pets"\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n                x-amazon-apigateway-integration:\n                  uri:\n                    Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                  passthroughBehavior: when_no_templates\n                  httpMethod: POST\n                  type: aws_proxy\n    post:\n      summary: Create a pet\n      operationId: createPets\n      tags:\n        - pets\n      responses:\n        \'201\':\n          description: Null response\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n                x-amazon-apigateway-integration:\n                  uri:\n                    Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                  passthroughBehavior: when_no_templates\n                  httpMethod: POST\n                  type: aws_proxy\n  /pets/{petId}:\n    get:\n      summary: Info for a specific pet\n      operationId: showPetById\n      tags:\n        - pets\n      parameters:\n        - name: petId\n          in: path\n          required: true\n          description: The id of the pet to retrieve\n          schema:\n            type: string\n      responses:\n        \'200\':\n          description: Expected response to a valid request\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Pets"\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n    x-amazon-apigateway-integration:\n      uri:\n        Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n      passthroughBehavior: when_no_templates\n      httpMethod: POST\n      type: aws_proxy\ncomponents:\n  schemas:\n    Pet:\n      required:\n        - id\n        - name\n      properties:\n        id:\n          type: integer\n          format: int64\n        name:\n          type: string\n        tag:\n          type: string\n    Pets:\n      type: array\n      items:\n        $ref: "#/components/schemas/Pet"\n    Error:\n      required:\n        - code\n        - message\n      properties:\n        code:\n          type: integer\n          format: int32\n        message:\n          type: string\n    apis:\n      type: array\n      items:\n        type: object\n        properties:\n          apiKey:\n            type: string\n            description: To be used as a dataset parameter value\n          apiVersionNumber:\n            type: string\n            description: To be used as a version parameter value\n          apiUrl:\n            type: string\n            format: uri\n            description: "The URL describing the dataset\'s fields"\n          apiDocumentationUrl:\n            type: string\n            format: uri\n            description: A URL to the API console for each API\n```\n\n</details>\n\n<details>\n<summary>model.py</summary>\n\n```python\n# generated by datamodel-codegen:\n#   filename:  api.yaml\n#   timestamp: 2020-06-02T05:28:24+00:00\n\nfrom __future__ import annotations\n\nfrom typing import List, Optional\n\nfrom pydantic import AnyUrl, BaseModel, Field\n\n\nclass Pet(BaseModel):\n    id: int\n    name: str\n    tag: Optional[str] = None\n\n\nclass Pets(BaseModel):\n    __root__: List[Pet]\n\n\nclass Error(BaseModel):\n    code: int\n    message: str\n\n\nclass Api(BaseModel):\n    apiKey: Optional[str] = Field(\n        None, description=\'To be used as a dataset parameter value\'\n    )\n    apiVersionNumber: Optional[str] = Field(\n        None, description=\'To be used as a version parameter value\'\n    )\n    apiUrl: Optional[AnyUrl] = Field(\n        None, description="The URL describing the dataset\'s fields"\n    )\n    apiDocumentationUrl: Optional[AnyUrl] = Field(\n        None, description=\'A URL to the API console for each API\'\n    )\n\n\nclass Apis(BaseModel):\n    __root__: List[Api]\n```\n</details>\n\n## Which project uses it?\nThese OSS use datamodel-code-generator to generate many models. We can learn about use-cases from these projects.\n- [Netflix/consoleme](https://github.com/Netflix/consoleme)\n  - *[How do I generate models from the Swagger specification?](https://github.com/Netflix/consoleme/blob/master/docs/gitbook/faq.md#how-do-i-generate-models-from-the-swagger-specification)*\n- [DataDog/integrations-core](https://github.com/DataDog/integrations-core)\n  - *[Config models](https://github.com/DataDog/integrations-core/blob/master/docs/developer/meta/config-models.md)*\n- [awslabs/aws-lambda-powertools-python](https://github.com/awslabs/aws-lambda-powertools-python)\n  - *Not used. But, introduced [advanced-use-cases](https://awslabs.github.io/aws-lambda-powertools-python/2.6.0/utilities/parser/#advanced-use-cases) in the official docuemnt*\n- [open-metadata/OpenMetadata](https://github.com/open-metadata/OpenMetadata)\n  - [Makefile](https://github.com/open-metadata/OpenMetadata/blob/main/Makefile)\n- [airbytehq/airbyte](https://github.com/airbytehq/airbyte)\n  - *[code-generator/Dockerfile](https://github.com/airbytehq/airbyte/blob/master/tools/code-generator/Dockerfile)*\n- [IBM/compliance-trestle](https://github.com/IBM/compliance-trestle)\n  - *[Building the models from the OSCAL schemas.](https://github.com/IBM/compliance-trestle/blob/develop/docs/contributing/website.md#building-the-models-from-the-oscal-schemas)*\n- [SeldonIO/MLServer](https://github.com/SeldonIO/MLServer)\n  - *[generate-types.sh](https://github.com/SeldonIO/MLServer/blob/master/hack/generate-types.sh)*\n## Supported input types\n-  OpenAPI 3 (YAML/JSON, [OpenAPI Data Type](https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.2.md#data-types))\n-  JSON Schema ([JSON Schema Core](http://json-schema.org/draft/2019-09/json-schema-validation.html)/[JSON Schema Validation](http://json-schema.org/draft/2019-09/json-schema-validation.html))\n-  JSON/YAML/CSV Data (it will be converted to JSON Schema)\n-  Python dictionary (it will be converted to JSON Schema)\n\n## Supported output types\n- [pydantic](https://docs.pydantic.dev/).BaseModel\n- [dataclasses.dataclass](https://docs.python.org/3/library/dataclasses.html)\n\n## Installation\n\nTo install `datamodel-code-generator`:\n```bash\n$ pip install datamodel-code-generator\n```\n\n### `http` extra option\nIf you want to resolve `$ref` for remote files then you should specify `http` extra option.\n```bash\n$ pip install datamodel-code-generator[http]\n```\n\n### Docker Image\nThe docker image is in [Docker Hub](https://hub.docker.com/r/koxudaxi/datamodel-code-generator)\n```bash\n$ docker pull koxudaxi/datamodel-code-generator\n```\n\n## Advanced Uses\nYou can genearte models from a URL.\n```bash\n$ datamodel-codegen --url https://<INPUT FILE URL> --output model.py\n```\nThis method needs  [http extra option](#http-extra-option)\n\n\n## All Command Options\n\nThe `datamodel-codegen` command:\n```bash\nusage: datamodel-codegen [-h] [--input INPUT] [--url URL]\n                         [--http-headers HTTP_HEADER [HTTP_HEADER ...]]\n                         [--http-ignore-tls]\n                         [--input-file-type {auto,openapi,jsonschema,json,yaml,dict,csv}]\n                         [--output-model-type {pydantic.BaseModel,dataclasses.dataclass}]\n                         [--openapi-scopes {schemas,paths,tags,parameters} [{schemas,paths,tags,parameters} ...]]\n                         [--output OUTPUT] [--base-class BASE_CLASS]\n                         [--field-constraints] [--use-annotated]\n                         [--use-non-positive-negative-number-constrained-types]\n                         [--field-extra-keys FIELD_EXTRA_KEYS [FIELD_EXTRA_KEYS ...]]\n                         [--field-include-all-keys]\n                         [--field-extra-keys-without-x-prefix FIELD_EXTRA_KEYS_WITHOUT_X_PREFIX [FIELD_EXTRA_KEYS_WITHOUT_X_PREFIX ...]] \n                         [--snake-case-field]\n                         [--original-field-name-delimiter ORIGINAL_FIELD_NAME_DELIMITER]\n                         [--strip-default-none]\n                         [--disable-appending-item-suffix]\n                         [--allow-population-by-field-name]\n                         [--allow-extra-fields] [--enable-faux-immutability]\n                         [--use-default] [--force-optional]\n                         [--strict-nullable]\n                         [--strict-types {str,bytes,int,float,bool} [{str,bytes,int,float,bool} ...]]\n                         [--disable-timestamp] [--use-standard-collections]\n                         [--use-generic-container-types]\n                         [--use-union-operator] [--use-schema-description]\n                         [--use-field-description] [--use-default-kwarg]\n                         [--reuse-model] [--keep-model-order]\n                         [--collapse-root-models]\n                         [--enum-field-as-literal {all,one}]\n                         [--set-default-enum-member]\n                         [--empty-enum-field-name EMPTY_ENUM_FIELD_NAME]\n                         [--capitalise-enum-members]\n                         [--special-field-name-prefix SPECIAL_FIELD_NAME_PREFIX]\n                         [--remove-special-field-name-prefix]\n                         [--use-subclass-enum] [--class-name CLASS_NAME]\n                         [--use-title-as-name]\n                         [--custom-template-dir CUSTOM_TEMPLATE_DIR]\n                         [--extra-template-data EXTRA_TEMPLATE_DATA]\n                         [--aliases ALIASES]\n                         [--target-python-version {3.6,3.7,3.8,3.9,3.10,3.11}]\n                         [--wrap-string-literal] [--validation]\n                         [--use-double-quotes] [--encoding ENCODING] [--debug]\n                         [--disable-warnings] [--version]\n\noptions:\n  -h, --help            show this help message and exit\n  --input INPUT         Input file/directory (default: stdin)\n  --url URL             Input file URL. `--input` is ignored when `--url` is\n                        used\n  --http-headers HTTP_HEADER [HTTP_HEADER ...]\n                        Set headers in HTTP requests to the remote host.\n                        (example: "Authorization: Basic dXNlcjpwYXNz")\n  --http-ignore-tls     Disable verification of the remote host\'s TLS\n                        certificate\n  --input-file-type {auto,openapi,jsonschema,json,yaml,dict,csv}\n                        Input file type (default: auto)\n  --output-model-type {pydantic.BaseModel,dataclasses.dataclass}\n                        Output model type (default: pydantic.BaseModel)\n  --openapi-scopes {schemas,paths,tags,parameters} [{schemas,paths,tags,parameters} ...]\n                        Scopes of OpenAPI model generation (default: schemas)\n  --output OUTPUT       Output file (default: stdout)\n  --base-class BASE_CLASS\n                        Base Class (default: pydantic.BaseModel)\n  --field-constraints   Use field constraints and not con* annotations\n  --use-annotated       Use typing.Annotated for Field(). Also, `--field-\n                        constraints` option will be enabled.\n  --use-non-positive-negative-number-constrained-types\n                        Use the Non{Positive,Negative}{FloatInt} types instead\n                        of the corresponding con* constrained types.\n  --field-extra-keys FIELD_EXTRA_KEYS [FIELD_EXTRA_KEYS ...]\n                        Add extra keys to field parameters\n  --field-include-all-keys\n                        Add all keys to field parameters\n  --field-extra-keys-without-x-prefix\n                        Add extra keys with `x-` prefix to field parameters.\n                        The extra keys are stripped of the `x-` prefix.\n  --snake-case-field    Change camel-case field name to snake-case\n  --original-field-name-delimiter ORIGINAL_FIELD_NAME_DELIMITER\n                        Set delimiter to convert to snake case. This option\n                        only can be used with --snake-case-field (default: `_`\n                        )\n  --strip-default-none  Strip default None on fields\n  --disable-appending-item-suffix\n                        Disable appending `Item` suffix to model name in an\n                        array\n  --allow-population-by-field-name\n                        Allow population by field name\n  --allow-extra-fields  Allow to pass extra fields, if this flag is not\n                        passed, extra fields are forbidden.\n  --enable-faux-immutability\n                        Enable faux immutability\n  --use-default         Use default value even if a field is required\n  --force-optional      Force optional for required fields\n  --strict-nullable     Treat default field as a non-nullable field (Only\n                        OpenAPI)\n  --strict-types {str,bytes,int,float,bool} [{str,bytes,int,float,bool} ...]\n                        Use strict types\n  --disable-timestamp   Disable timestamp on file headers\n  --use-standard-collections\n                        Use standard collections for type hinting (list, dict)\n  --use-generic-container-types\n                        Use generic container types for type hinting\n                        (typing.Sequence, typing.Mapping). If `--use-standard-\n                        collections` option is set, then import from\n                        collections.abc instead of typing\n  --use-union-operator  Use | operator for Union type (PEP 604).\n  --use-schema-description\n                        Use schema description to populate class docstring\n  --use-field-description\n                        Use schema description to populate field docstring\n  --use-default-kwarg   Use `default=` instead of a positional argument for\n                        Fields that have default values.\n  --reuse-model         Re-use models on the field when a module has the model\n                        with the same content\n  --keep-model-order    Keep generated models\' order\n  --collapse-root-models\n                        Models generated with a root-type field will be\n                        mergedinto the models using that root-type model\n  --enum-field-as-literal {all,one}\n                        Parse enum field as literal. all: all enum field type\n                        are Literal. one: field type is Literal when an enum\n                        has only one possible value\n  --set-default-enum-member\n                        Set enum members as default values for enum field\n  --empty-enum-field-name EMPTY_ENUM_FIELD_NAME\n                        Set field name when enum value is empty (default: `_`)\n  --capitalise-enum-members\n                        Capitalize field names on enum\n  --special-field-name-prefix SPECIAL_FIELD_NAME_PREFIX\n                        Set field name prefix when first character can\'t be\n                        used as Python field name (default: `field`)\n  --remove-special-field-name-prefix\n                        Remove field name prefix when first character can\'t be\n                        used as Python field name\n  --use-subclass-enum   Define Enum class as subclass with field type when\n                        enum has type (int, float, bytes, str)\n  --class-name CLASS_NAME\n                        Set class name of root model\n  --use-title-as-name   use titles as class names of models\n  --custom-template-dir CUSTOM_TEMPLATE_DIR\n                        Custom template directory\n  --extra-template-data EXTRA_TEMPLATE_DATA\n                        Extra template data\n  --aliases ALIASES     Alias mapping file\n  --target-python-version {3.6,3.7,3.8,3.9,3.10,3.11}\n                        target python version (default: 3.7)\n  --wrap-string-literal\n                        Wrap string literal by using black `experimental-\n                        string-processing` option (require black 20.8b0 or\n                        later)\n  --validation          Enable validation (Only OpenAPI)\n  --use-double-quotes   Model generated with double quotes. Single quotes or\n                        your black config skip_string_normalization value will\n                        be used without this option.\n  --encoding ENCODING   The encoding of input and output (default: cp1252)\n  --debug               show debug message\n  --disable-warnings    disable warnings\n  --version             show version\n```\n\n\n## Implemented list\n### OpenAPI 3 and JsonSchema\n#### DataType\n-  string (include patter/minLength/maxLenght)\n-  number (include maximum/exclusiveMaximum/minimum/exclusiveMinimum/multipleOf/le/ge)\n-  integer (include maximum/exclusiveMaximum/minimum/exclusiveMinimum/multipleOf/le/ge)\n-  boolean\n-  array\n-  object\n\n##### String Format\n-  date\n-  datetime\n-  time\n-  password\n-  email\n-  idn-email\n-  uuid (uuid1/uuid2/uuid3/uuid4/uuid5)\n-  ipv4\n-  ipv6\n-  ipv4-network\n-  ipv6-network\n-  hostname\n-  decimal\n\n#### Other schema\n-  enum (as enum.Enum or typing.Literal)\n-  allOf (as Multiple inheritance)\n-  anyOf (as typing.Union)\n-  oneOf (as typing.Union)\n-  $ref ([http extra](#http-extra-option) is required when resolving $ref for remote files.)\n-  $id (for [JSONSchema](https://json-schema.org/understanding-json-schema/structuring.html#the-id-property))\n\n\n## Related projects\n### fastapi-code-generator\nThis code generator creates [FastAPI](https://github.com/tiangolo/fastapi) app from an openapi file.\n\n[https://github.com/koxudaxi/fastapi-code-generator](https://github.com/koxudaxi/fastapi-code-generator)\n\n### pydantic-pycharm-plugin\n[A JetBrains PyCharm plugin](https://plugins.jetbrains.com/plugin/12861-pydantic) for [`pydantic`](https://github.com/samuelcolvin/pydantic).\n\n[https://github.com/koxudaxi/pydantic-pycharm-plugin](https://github.com/koxudaxi/pydantic-pycharm-plugin)\n\n## PyPi\n\n[https://pypi.org/project/datamodel-code-generator](https://pypi.org/project/datamodel-code-generator)\n\n## License\n\ndatamodel-code-generator is released under the MIT License. http://www.opensource.org/licenses/mit-license\n',
    'author': 'Koudai Aono',
    'author_email': 'koxudaxi@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/koxudaxi/datamodel-code-generator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
