import { Alarm } from '@aws-cdk/aws-cloudwatch';
import { Construct } from '@aws-cdk/core';
/**
 * Props for `WebCanary`.
 */
export interface WebCanaryProps {
    /**
     * Display name for the web canary
     */
    readonly displayName: string;
    /**
     * The URL of the website to ping.
     */
    readonly url: string;
}
/**
 * A canary that periodically sends an HTTP GET request to a specific URL.
 */
export declare class WebCanary extends Construct {
    /**
     * This alarm is raised if there are more than 2 failures within 5 minutes.
     */
    readonly alarm: Alarm;
    constructor(scope: Construct, id: string, props: WebCanaryProps);
}
