"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.requireEnv = void 0;
const process_1 = require("process");
function requireEnv(name) {
    const result = process_1.env[name];
    if (!result) {
        throw new Error(`No value specified for required environment variable: ${name}`);
    }
    return result;
}
exports.requireEnv = requireEnv;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW52LmxhbWJkYS1zaGFyZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYmFja2VuZC9zaGFyZWQvZW52LmxhbWJkYS1zaGFyZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQThCO0FBRTlCLFNBQWdCLFVBQVUsQ0FBQyxJQUFZO0lBQ3JDLE1BQU0sTUFBTSxHQUFHLGFBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN6QixJQUFJLENBQUMsTUFBTSxFQUFFO1FBQ1gsTUFBTSxJQUFJLEtBQUssQ0FBQyx5REFBeUQsSUFBSSxFQUFFLENBQUMsQ0FBQztLQUNsRjtJQUNELE9BQU8sTUFBTSxDQUFDO0FBQ2hCLENBQUM7QUFORCxnQ0FNQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGVudiB9IGZyb20gJ3Byb2Nlc3MnO1xuXG5leHBvcnQgZnVuY3Rpb24gcmVxdWlyZUVudihuYW1lOiBzdHJpbmcpOiBzdHJpbmcge1xuICBjb25zdCByZXN1bHQgPSBlbnZbbmFtZV07XG4gIGlmICghcmVzdWx0KSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBObyB2YWx1ZSBzcGVjaWZpZWQgZm9yIHJlcXVpcmVkIGVudmlyb25tZW50IHZhcmlhYmxlOiAke25hbWV9YCk7XG4gIH1cbiAgcmV0dXJuIHJlc3VsdDtcbn1cbiJdfQ==