"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compressContent = void 0;
const zlib_1 = require("zlib");
const MINIMUM_SIZE_TO_COMPRESS = 1024;
/**
 * Compresses the content of the provided `buffer` if it is large enough to
 * warrant the effort, and if the compressed output is actually smaller than
 * the input.
 *
 * @param buffer the buffer to be compressed.
 *
 * @returns the result of the operation.
 */
function compressContent(buffer) {
    if (buffer.length < MINIMUM_SIZE_TO_COMPRESS) {
        return { buffer };
    }
    const gz = zlib_1.gzipSync(buffer, { level: 9 });
    // If it did not compress well, we'll keep the un-compressed original...
    if (gz.length >= buffer.length) {
        return { buffer };
    }
    return { buffer: gz, contentEncoding: 'gzip' };
}
exports.compressContent = compressContent;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcHJlc3MtY29udGVudC5sYW1iZGEtc2hhcmVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2JhY2tlbmQvc2hhcmVkL2NvbXByZXNzLWNvbnRlbnQubGFtYmRhLXNoYXJlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwrQkFBZ0M7QUFFaEMsTUFBTSx3QkFBd0IsR0FBRyxJQUFLLENBQUM7QUFFdkM7Ozs7Ozs7O0dBUUc7QUFDSCxTQUFnQixlQUFlLENBQUMsTUFBYztJQUM1QyxJQUFJLE1BQU0sQ0FBQyxNQUFNLEdBQUcsd0JBQXdCLEVBQUU7UUFDNUMsT0FBTyxFQUFFLE1BQU0sRUFBRSxDQUFDO0tBQ25CO0lBQ0QsTUFBTSxFQUFFLEdBQUcsZUFBUSxDQUFDLE1BQU0sRUFBRSxFQUFFLEtBQUssRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0lBQzFDLHdFQUF3RTtJQUN4RSxJQUFJLEVBQUUsQ0FBQyxNQUFNLElBQUksTUFBTSxDQUFDLE1BQU0sRUFBRTtRQUM5QixPQUFPLEVBQUUsTUFBTSxFQUFFLENBQUM7S0FDbkI7SUFDRCxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUUsRUFBRSxlQUFlLEVBQUUsTUFBTSxFQUFFLENBQUM7QUFDakQsQ0FBQztBQVZELDBDQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZ3ppcFN5bmMgfSBmcm9tICd6bGliJztcblxuY29uc3QgTUlOSU1VTV9TSVpFX1RPX0NPTVBSRVNTID0gMV8wMjQ7XG5cbi8qKlxuICogQ29tcHJlc3NlcyB0aGUgY29udGVudCBvZiB0aGUgcHJvdmlkZWQgYGJ1ZmZlcmAgaWYgaXQgaXMgbGFyZ2UgZW5vdWdoIHRvXG4gKiB3YXJyYW50IHRoZSBlZmZvcnQsIGFuZCBpZiB0aGUgY29tcHJlc3NlZCBvdXRwdXQgaXMgYWN0dWFsbHkgc21hbGxlciB0aGFuXG4gKiB0aGUgaW5wdXQuXG4gKlxuICogQHBhcmFtIGJ1ZmZlciB0aGUgYnVmZmVyIHRvIGJlIGNvbXByZXNzZWQuXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgb3BlcmF0aW9uLlxuICovXG5leHBvcnQgZnVuY3Rpb24gY29tcHJlc3NDb250ZW50KGJ1ZmZlcjogQnVmZmVyKTogQ29tcHJlc3NDb250ZW50UmVzdWx0IHtcbiAgaWYgKGJ1ZmZlci5sZW5ndGggPCBNSU5JTVVNX1NJWkVfVE9fQ09NUFJFU1MpIHtcbiAgICByZXR1cm4geyBidWZmZXIgfTtcbiAgfVxuICBjb25zdCBneiA9IGd6aXBTeW5jKGJ1ZmZlciwgeyBsZXZlbDogOSB9KTtcbiAgLy8gSWYgaXQgZGlkIG5vdCBjb21wcmVzcyB3ZWxsLCB3ZSdsbCBrZWVwIHRoZSB1bi1jb21wcmVzc2VkIG9yaWdpbmFsLi4uXG4gIGlmIChnei5sZW5ndGggPj0gYnVmZmVyLmxlbmd0aCkge1xuICAgIHJldHVybiB7IGJ1ZmZlciB9O1xuICB9XG4gIHJldHVybiB7IGJ1ZmZlcjogZ3osIGNvbnRlbnRFbmNvZGluZzogJ2d6aXAnIH07XG59XG5cbi8qKlxuICogVGhlIHJlc3VsdCBvZiBhIGBjb21wcmVzc0NvbnRlbnRgIGNhbGwuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29tcHJlc3NDb250ZW50UmVzdWx0IHtcbiAgLyoqXG4gICAqIFRoZSBwb3NzaWJseSBjb21wcmVzc2VkIGJ1ZmZlci4gVGhpcyBtYXkgYmUgdGhlIHVuLW1vZGlmaWVkIGlucHV0IGJ1ZmZlci5cbiAgICovXG4gIHJlYWRvbmx5IGJ1ZmZlcjogQnVmZmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgY29udGVudC1lbmNvZGluZyB0aGF0IHNob3VsZCBiZSBhcHBsaWVkIHRvIHRoZSBvYmplY3QuIFRoaXMgaXNcbiAgICogdW5kZWZpbmVkIGlmIHRoZSBpbnB1dCBoYXMgbm90IGJlZW4gbW9kaWZpZWQuXG4gICAqL1xuICByZWFkb25seSBjb250ZW50RW5jb2Rpbmc/OiAnZ3ppcCc7XG59XG4iXX0=