/// <reference types="node" />
/**
 * Compresses the content of the provided `buffer` if it is large enough to
 * warrant the effort, and if the compressed output is actually smaller than
 * the input.
 *
 * @param buffer the buffer to be compressed.
 *
 * @returns the result of the operation.
 */
export declare function compressContent(buffer: Buffer): CompressContentResult;
/**
 * The result of a `compressContent` call.
 */
export interface CompressContentResult {
    /**
     * The possibly compressed buffer. This may be the un-modified input buffer.
     */
    readonly buffer: Buffer;
    /**
     * The content-encoding that should be applied to the object. This is
     * undefined if the input has not been modified.
     */
    readonly contentEncoding?: 'gzip';
}
