import type { StateMachineInput } from '../payload-schema';
export declare type Input = Pick<StateMachineInput, 'package'>;
/**
 * This function checks whether the catalog object needs updating following the
 * ingestion of the provided package object. This is the case if the package is
 * representative of a new major version line, or if the package is newer than,
 * or at the same version than the one already in catalog for the same major
 * version line.
 *
 * This is used to reduce how many calls are made into the catalog builder
 * function, as that function runs with singleton concurrency. This ultimately
 * allows workflows to complete faster when they are targetting older versions
 * of packages.
 */
export declare function handler(event: Input): Promise<boolean>;
