"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MissingDocumentationWidget = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
const _lambda_architecture_1 = require("../_lambda-architecture");
const constants_1 = require("../shared/constants");
const missing_documentation_widget_function_1 = require("./missing-documentation-widget-function");
class MissingDocumentationWidget extends aws_cloudwatch_1.ConcreteWidget {
    constructor(scope, id, props) {
        var _a, _b;
        super((_a = props.width) !== null && _a !== void 0 ? _a : 6, (_b = props.height) !== null && _b !== void 0 ? _b : 6);
        this.handler = new missing_documentation_widget_function_1.MissingDocumentationWidgetFunction(scope, id, {
            architecture: _lambda_architecture_1.gravitonLambdaIfAvailable(scope),
            description: '[ConstructHub/MissingDocumentationWidget] Is a custom CloudWatch widget handler',
            environment: { BUCKET_NAME: props.bucket.bucketName },
            memorySize: 1024,
            timeout: core_1.Duration.seconds(15),
        });
        core_1.Tags.of(this.handler).add('function-purpose', 'cloudwatch-custom-widget');
        props.bucket.grantRead(this.handler, constants_1.MISSING_DOCUMENTATION_KEY_PATTERN);
        this.language = props.language;
        this.title = props.title;
    }
    toJson() {
        return [{
                type: 'custom',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    endpoint: this.handler.functionArn,
                    params: {
                        language: this.language.name,
                    },
                    title: this.title,
                    updateOn: {
                        refresh: true,
                        resize: false,
                        timeRange: false,
                    },
                },
            }];
    }
}
exports.MissingDocumentationWidget = MissingDocumentationWidget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWlzc2luZy1kb2N1bWVudGF0aW9uLXdpZGdldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9iYWNrZW5kL2ludmVudG9yeS9taXNzaW5nLWRvY3VtZW50YXRpb24td2lkZ2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDREQUF5RDtBQUV6RCx3Q0FBMEQ7QUFDMUQsa0VBQW9FO0FBQ3BFLG1EQUF3RTtBQUV4RSxtR0FBNkY7QUFVN0YsTUFBYSwwQkFBMkIsU0FBUSwrQkFBYztJQUs1RCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQzs7UUFDckYsS0FBSyxPQUFDLEtBQUssQ0FBQyxLQUFLLG1DQUFJLENBQUMsUUFBRSxLQUFLLENBQUMsTUFBTSxtQ0FBSSxDQUFDLENBQUMsQ0FBQztRQUUzQyxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksMEVBQWtDLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUMvRCxZQUFZLEVBQUUsZ0RBQXlCLENBQUMsS0FBSyxDQUFDO1lBQzlDLFdBQVcsRUFBRSxpRkFBaUY7WUFDOUYsV0FBVyxFQUFFLEVBQUUsV0FBVyxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsVUFBVSxFQUFFO1lBQ3JELFVBQVUsRUFBRSxJQUFLO1lBQ2pCLE9BQU8sRUFBRSxlQUFRLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztTQUM5QixDQUFDLENBQUM7UUFDSCxXQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUUsMEJBQTBCLENBQUMsQ0FBQztRQUUxRSxLQUFLLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLDZDQUFpQyxDQUFDLENBQUM7UUFFeEUsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBRU0sTUFBTTtRQUNYLE9BQU8sQ0FBQztnQkFDTixJQUFJLEVBQUUsUUFBUTtnQkFDZCxLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7Z0JBQ2pCLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtnQkFDbkIsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFDO2dCQUNULENBQUMsRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFDVCxVQUFVLEVBQUU7b0JBQ1YsUUFBUSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVztvQkFDbEMsTUFBTSxFQUFFO3dCQUNOLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUk7cUJBQzdCO29CQUNELEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztvQkFDakIsUUFBUSxFQUFFO3dCQUNSLE9BQU8sRUFBRSxJQUFJO3dCQUNiLE1BQU0sRUFBRSxLQUFLO3dCQUNiLFNBQVMsRUFBRSxLQUFLO3FCQUNqQjtpQkFDRjthQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQTVDRCxnRUE0Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25jcmV0ZVdpZGdldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJztcbmltcG9ydCB7IElCdWNrZXQgfSBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBUYWdzLCBEdXJhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgZ3Jhdml0b25MYW1iZGFJZkF2YWlsYWJsZSB9IGZyb20gJy4uL19sYW1iZGEtYXJjaGl0ZWN0dXJlJztcbmltcG9ydCB7IE1JU1NJTkdfRE9DVU1FTlRBVElPTl9LRVlfUEFUVEVSTiB9IGZyb20gJy4uL3NoYXJlZC9jb25zdGFudHMnO1xuaW1wb3J0IHsgRG9jdW1lbnRhdGlvbkxhbmd1YWdlIH0gZnJvbSAnLi4vc2hhcmVkL2xhbmd1YWdlJztcbmltcG9ydCB7IE1pc3NpbmdEb2N1bWVudGF0aW9uV2lkZ2V0RnVuY3Rpb24gfSBmcm9tICcuL21pc3NpbmctZG9jdW1lbnRhdGlvbi13aWRnZXQtZnVuY3Rpb24nO1xuXG5leHBvcnQgaW50ZXJmYWNlIE1pc3NpbmdEb2N1bWVudGF0aW9uV2lkZ2V0UHJvcHMge1xuICByZWFkb25seSBidWNrZXQ6IElCdWNrZXQ7XG4gIHJlYWRvbmx5IGxhbmd1YWdlOiBEb2N1bWVudGF0aW9uTGFuZ3VhZ2U7XG4gIHJlYWRvbmx5IHRpdGxlPzogc3RyaW5nO1xuICByZWFkb25seSB3aWR0aD86IG51bWJlcjtcbiAgcmVhZG9ubHkgaGVpZ2h0PzogbnVtYmVyO1xufVxuXG5leHBvcnQgY2xhc3MgTWlzc2luZ0RvY3VtZW50YXRpb25XaWRnZXQgZXh0ZW5kcyBDb25jcmV0ZVdpZGdldCB7XG4gIHByaXZhdGUgcmVhZG9ubHkgaGFuZGxlcjogTWlzc2luZ0RvY3VtZW50YXRpb25XaWRnZXRGdW5jdGlvbjtcbiAgcHJpdmF0ZSByZWFkb25seSBsYW5ndWFnZTogRG9jdW1lbnRhdGlvbkxhbmd1YWdlO1xuICBwcml2YXRlIHJlYWRvbmx5IHRpdGxlPzogc3RyaW5nO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTWlzc2luZ0RvY3VtZW50YXRpb25XaWRnZXRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzLndpZHRoID8/IDYsIHByb3BzLmhlaWdodCA/PyA2KTtcblxuICAgIHRoaXMuaGFuZGxlciA9IG5ldyBNaXNzaW5nRG9jdW1lbnRhdGlvbldpZGdldEZ1bmN0aW9uKHNjb3BlLCBpZCwge1xuICAgICAgYXJjaGl0ZWN0dXJlOiBncmF2aXRvbkxhbWJkYUlmQXZhaWxhYmxlKHNjb3BlKSxcbiAgICAgIGRlc2NyaXB0aW9uOiAnW0NvbnN0cnVjdEh1Yi9NaXNzaW5nRG9jdW1lbnRhdGlvbldpZGdldF0gSXMgYSBjdXN0b20gQ2xvdWRXYXRjaCB3aWRnZXQgaGFuZGxlcicsXG4gICAgICBlbnZpcm9ubWVudDogeyBCVUNLRVRfTkFNRTogcHJvcHMuYnVja2V0LmJ1Y2tldE5hbWUgfSxcbiAgICAgIG1lbW9yeVNpemU6IDFfMDI0LFxuICAgICAgdGltZW91dDogRHVyYXRpb24uc2Vjb25kcygxNSksXG4gICAgfSk7XG4gICAgVGFncy5vZih0aGlzLmhhbmRsZXIpLmFkZCgnZnVuY3Rpb24tcHVycG9zZScsICdjbG91ZHdhdGNoLWN1c3RvbS13aWRnZXQnKTtcblxuICAgIHByb3BzLmJ1Y2tldC5ncmFudFJlYWQodGhpcy5oYW5kbGVyLCBNSVNTSU5HX0RPQ1VNRU5UQVRJT05fS0VZX1BBVFRFUk4pO1xuXG4gICAgdGhpcy5sYW5ndWFnZSA9IHByb3BzLmxhbmd1YWdlO1xuICAgIHRoaXMudGl0bGUgPSBwcm9wcy50aXRsZTtcbiAgfVxuXG4gIHB1YmxpYyB0b0pzb24oKSB7XG4gICAgcmV0dXJuIFt7XG4gICAgICB0eXBlOiAnY3VzdG9tJyxcbiAgICAgIHdpZHRoOiB0aGlzLndpZHRoLFxuICAgICAgaGVpZ2h0OiB0aGlzLmhlaWdodCxcbiAgICAgIHg6IHRoaXMueCxcbiAgICAgIHk6IHRoaXMueSxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgZW5kcG9pbnQ6IHRoaXMuaGFuZGxlci5mdW5jdGlvbkFybixcbiAgICAgICAgcGFyYW1zOiB7XG4gICAgICAgICAgbGFuZ3VhZ2U6IHRoaXMubGFuZ3VhZ2UubmFtZSxcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6IHRoaXMudGl0bGUsXG4gICAgICAgIHVwZGF0ZU9uOiB7XG4gICAgICAgICAgcmVmcmVzaDogdHJ1ZSxcbiAgICAgICAgICByZXNpemU6IGZhbHNlLFxuICAgICAgICAgIHRpbWVSYW5nZTogZmFsc2UsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH1dO1xuICB9XG59XG4iXX0=