"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const AWS = require("aws-sdk");
const env_lambda_shared_1 = require("../shared/env.lambda-shared");
const constants_1 = require("./constants");
const s3 = new AWS.S3();
async function handler(event) {
    var _a;
    console.log(JSON.stringify({ event }));
    const bucket = env_lambda_shared_1.requireEnv(constants_1.ENV_DELETE_OBJECT_DATA_BUCKET_NAME);
    const records = (_a = event.Records) !== null && _a !== void 0 ? _a : [];
    for (const record of records) {
        const objectKey = record.body;
        console.log(`deleting s3://${bucket}/${objectKey}`);
        await s3.deleteObject({ Bucket: bucket, Key: objectKey }).promise();
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJ1bmUtcXVldWUtaGFuZGxlci5sYW1iZGEuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYmFja2VuZC9kZW55LWxpc3QvcHJ1bmUtcXVldWUtaGFuZGxlci5sYW1iZGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQStCO0FBQy9CLG1FQUF5RDtBQUN6RCwyQ0FBaUU7QUFFakUsTUFBTSxFQUFFLEdBQUcsSUFBSSxHQUFHLENBQUMsRUFBRSxFQUFFLENBQUM7QUFFakIsS0FBSyxVQUFVLE9BQU8sQ0FBQyxLQUF5Qjs7SUFDckQsT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBRXZDLE1BQU0sTUFBTSxHQUFHLDhCQUFVLENBQUMsOENBQWtDLENBQUMsQ0FBQztJQUU5RCxNQUFNLE9BQU8sU0FBRyxLQUFLLENBQUMsT0FBTyxtQ0FBSSxFQUFFLENBQUM7SUFFcEMsS0FBSyxNQUFNLE1BQU0sSUFBSSxPQUFPLEVBQUU7UUFDNUIsTUFBTSxTQUFTLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUM5QixPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixNQUFNLElBQUksU0FBUyxFQUFFLENBQUMsQ0FBQztRQUNwRCxNQUFNLEVBQUUsQ0FBQyxZQUFZLENBQUMsRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLEdBQUcsRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO0tBQ3JFO0FBQ0gsQ0FBQztBQVpELDBCQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgQVdTIGZyb20gJ2F3cy1zZGsnO1xuaW1wb3J0IHsgcmVxdWlyZUVudiB9IGZyb20gJy4uL3NoYXJlZC9lbnYubGFtYmRhLXNoYXJlZCc7XG5pbXBvcnQgeyBFTlZfREVMRVRFX09CSkVDVF9EQVRBX0JVQ0tFVF9OQU1FIH0gZnJvbSAnLi9jb25zdGFudHMnO1xuXG5jb25zdCBzMyA9IG5ldyBBV1MuUzMoKTtcblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5TUVNFdmVudCkge1xuICBjb25zb2xlLmxvZyhKU09OLnN0cmluZ2lmeSh7IGV2ZW50IH0pKTtcblxuICBjb25zdCBidWNrZXQgPSByZXF1aXJlRW52KEVOVl9ERUxFVEVfT0JKRUNUX0RBVEFfQlVDS0VUX05BTUUpO1xuXG4gIGNvbnN0IHJlY29yZHMgPSBldmVudC5SZWNvcmRzID8/IFtdO1xuXG4gIGZvciAoY29uc3QgcmVjb3JkIG9mIHJlY29yZHMpIHtcbiAgICBjb25zdCBvYmplY3RLZXkgPSByZWNvcmQuYm9keTtcbiAgICBjb25zb2xlLmxvZyhgZGVsZXRpbmcgczM6Ly8ke2J1Y2tldH0vJHtvYmplY3RLZXl9YCk7XG4gICAgYXdhaXQgczMuZGVsZXRlT2JqZWN0KHsgQnVja2V0OiBidWNrZXQsIEtleTogb2JqZWN0S2V5IH0pLnByb21pc2UoKTtcbiAgfVxufSJdfQ==