import { PackageInfo } from '.';
export interface ICatalogClient {
    readonly packages: readonly PackageInfo[];
}
/**
 * A client for working with the catalog.
 */
export declare class CatalogClient implements ICatalogClient {
    /**
     * Creates a new client for accessing the catalog.
     */
    static newClient(): Promise<ICatalogClient>;
    private readonly s3;
    private readonly bucketName;
    private readonly objectKey;
    private _packages;
    private constructor();
    /**
     * Downloads the catalog object and stores it in memory.
     */
    private init;
    /**
     * Returns a copy of the catalog list.
     */
    get packages(): PackageInfo[];
}
