"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
// eslint-disable-next-line import/no-extraneous-dependencies
const aws_sdk_1 = require("aws-sdk");
// @ts-ignore
async function handler(event, context) {
    console.log(JSON.stringify(event));
    try {
        // each alarm notification should have only one record.
        if (event.Records.length !== 1) {
            throw new Error('Expecting a single record in SNS Event, found ' + event.Records.length);
        }
        const record = event.Records[0];
        if (!record.Sns || !record.Sns.Message) {
            throw new Error('No message found in the SNS Event.');
        }
        const message = JSON.parse(record.Sns.Message);
        const metrics = message.Trigger.Metrics;
        /**
         * The unhealthy fleet alarm is created using following 3 metrics:
         * 1. ASG desired capacity
         * 2. Unhealthy target count
         * 3. Expression to calculate percent
         * If these 3 metrics are not passed, throw an exception, something went wrong.
         */
        if (!metrics || metrics.length !== 3) {
            throw new Error('Exactly 3 metrics should be present in the alarm message');
        }
        // find the metric with the ASG dimension in it.
        const autoScalingGroupDimensions = metrics.filter((metric) => metric.Id === 'fleetCapacity')
            .map((metric) => {
            if (metric && metric.MetricStat && metric.MetricStat.Metric && metric.MetricStat.Metric.Dimensions) {
                return metric.MetricStat.Metric.Dimensions.filter((dimension) => dimension.name === 'AutoScalingGroupName');
            }
        });
        if (autoScalingGroupDimensions.length !== 1) {
            throw new Error(`There should be exactly one Metric with Id "fleetCapacity". Found ${autoScalingGroupDimensions.length}`);
        }
        if (autoScalingGroupDimensions[0].length !== 1) {
            throw new Error(`There should be exactly one dimension with name "AutoScalingGroupName". Found ${autoScalingGroupDimensions[0].length}`);
        }
        const dimensionName = autoScalingGroupDimensions[0][0].name;
        const dimensionValue = autoScalingGroupDimensions[0][0].value;
        console.info(`Found fleet: ${dimensionName} with fleetId: ${dimensionValue}`);
        // this is an ASG Target, we need to suspend its size
        const autoScaling = new aws_sdk_1.AutoScaling();
        await autoScaling.updateAutoScalingGroup({
            AutoScalingGroupName: dimensionValue,
            MaxSize: 0,
            MinSize: 0,
            DesiredCapacity: 0,
        }).promise().then((data) => {
            // successful response
            console.log(`Successfully suspended the fleet ${dimensionValue}: ${data}`);
        }).catch((err) => {
            // an error occurred
            throw new Error(`Exception while suspending fleet ${dimensionValue}: ${err}`);
        });
    }
    catch (e) {
        console.error(`ERROR: Exception while processing the event: ${e}`);
        return {
            status: 'ERROR',
            reason: e.message,
        };
    }
    return { status: 'OK' };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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