"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.implementsIMongoDbConfigureResource = exports.implementsIX509AuthenticatedUser = exports.implementsIConnectionOptions = void 0;
const secrets_manager_1 = require("../lib/secrets-manager");
function implementsIConnectionOptions(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!value.Hostname || typeof (value.Hostname) !== 'string') {
        return false;
    }
    if (!value.Port || typeof (value.Port) !== 'string') {
        return false;
    }
    const portNum = Number.parseInt(value.Port, 10);
    if (Number.isNaN(portNum) || portNum < 1 || portNum > 65535) {
        return false;
    }
    for (const key of ['Credentials', 'CaCertificate']) {
        if (!value[key] || typeof (value[key]) !== 'string') {
            return false;
        }
        if (!secrets_manager_1.isArn(value[key])) {
            return false;
        }
    }
    return true;
}
exports.implementsIConnectionOptions = implementsIConnectionOptions;
function implementsIX509AuthenticatedUser(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!value.Certificate || typeof (value.Certificate) !== 'string') {
        return false;
    }
    if (!secrets_manager_1.isArn(value.Certificate)) {
        return false;
    }
    if (!value.Roles || typeof (value.Roles) !== 'string') {
        return false;
    }
    try {
        JSON.parse(value.Roles);
    }
    catch (e) {
        return false;
    }
    return true;
}
exports.implementsIX509AuthenticatedUser = implementsIX509AuthenticatedUser;
function implementsIMongoDbConfigureResource(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!implementsIConnectionOptions(value.Connection)) {
        return false;
    }
    if (value.PasswordAuthUsers) {
        if (!Array.isArray(value.PasswordAuthUsers)) {
            return false;
        }
        for (const arn of value.PasswordAuthUsers) {
            if (!secrets_manager_1.isArn(arn)) {
                return false;
            }
        }
    }
    if (value.X509AuthUsers) {
        if (!Array.isArray(value.X509AuthUsers)) {
            return false;
        }
        for (const user of value.X509AuthUsers) {
            if (!implementsIX509AuthenticatedUser(user)) {
                return false;
            }
        }
    }
    return true;
}
exports.implementsIMongoDbConfigureResource = implementsIMongoDbConfigureResource;
//# sourceMappingURL=data:application/json;base64,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