/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { Construct } from 'constructs';
interface TagFields {
    /**
     * The name of the tag
     */
    readonly name: string;
    /**
     * The value of the tag
     */
    readonly value: string;
}
/**
 * Returns the fields to be used for tagging AWS resources for a given construct
 *
 * @param scope The construct instance whose underlying resources should be tagged
 */
export declare function tagFields<T extends Construct>(scope: T): TagFields;
/**
 * The RFDK version string as listed in `package.json`
 */
export declare const RFDK_VERSION: string;
/**
 * Tags all resources deployed by a construct with the RFDK version and the construct name separated by a colon (":")
 * delimiter.
 *
 * @param scope A construct instance to tag
 */
export declare function tagConstruct<T extends Construct>(scope: T): void;
export {};
