import { IFunction } from '@aws-cdk/aws-lambda';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface LambdaSubminuteProps {
    /**
     * The Lambda function that is going to be executed per time unit less than one minute.
     *
     * @stability stable
     */
    readonly targetFunction: IFunction;
    /**
     * A pattern you want this statemachine to be executed.
     *
     * @default cron(50/1 15-17 ? * * *) UTC+0 being run every minute starting from 15:00 PM to 17:00 PM.
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html
     * @stability stable
     */
    readonly cronjobExpression?: string;
    /**
     * How many times you intent to execute in a minute.
     *
     * @default 6
     * @stability stable
     */
    readonly frequency?: number;
    /**
     * Seconds for an interval, the product of `frequency` and `intervalTime` should be approximagely 1 minute.
     *
     * @default 10
     * @stability stable
     */
    readonly intervalTime?: number;
}
/**
 * @stability stable
 */
export declare class LambdaSubminute extends cdk.Construct {
    /**
     * The Lambda function that plays the role of the iterator.
     *
     * @stability stable
     */
    readonly iteratorFunction: IFunction;
    /**
     * The ARN of the state machine that executes the target Lambda function per time unit less than one minute.
     *
     * @stability stable
     */
    readonly stateMachineArn: string;
    /**
     * @stability stable
     */
    constructor(parent: cdk.Construct, name: string, props: LambdaSubminuteProps);
}
/**
 * @stability stable
 */
export interface IteratorLambdaProps {
    /**
     * The Lambda function that is going to be executed per time unit less than one minute.
     *
     * @stability stable
     */
    readonly targetFunction: IFunction;
}
/**
 * @stability stable
 */
export declare class IteratorLambda extends cdk.Construct {
    /**
     * A Lambda function that plays the role of the iterator.
     *
     * @stability stable
     */
    readonly function: IFunction;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: IteratorLambdaProps);
}
/**
 * @stability stable
 */
export interface SubminuteStateMachineProps {
    /**
     * the name of the state machine.
     *
     * @stability stable
     */
    readonly stateMachineName: string;
    /**
     * the Lambda function that executes your intention.
     *
     * @stability stable
     */
    readonly targetFunction: IFunction;
    /**
     * the iterator Lambda function for the target Lambda function.
     *
     * @stability stable
     */
    readonly iteratorFunction: IFunction;
    /**
     * Seconds for an interval, the product of `frequency` and `intervalTime` should be approximagely 1 minute.
     *
     * @default 10
     * @stability stable
     */
    readonly intervalTime: number;
    /**
     * How many times you intent to execute in a minute.
     *
     * @default 6
     * @stability stable
     */
    readonly frequency: number;
}
/**
 * @stability stable
 */
export declare class SubminuteStateMachine extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly stateMachine: sfn.StateMachine;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: SubminuteStateMachineProps);
    /**
     * Creates a state machine for breaking the limit of 1 minute with the CloudWatch Rules.
     *
     * @param iteratorFunction The iterator Lambda function for the target Labmda funciton.
     * @param intervalTime Seconds for an interval, the product of `frequency` and `intervalTime` should be approximagely 1 minute.
     * @param frequency How many times you intent to execute in a minute.
     * @returns THe job definition for the state machine.
     */
    private createJobDefinition;
    /**
     * Creates a role and corresponding policies for the subminute state machine.
     *
     * @param targetFunctionArn the ARN of the Lambda function that executes your intention.
     * @param iteratorFunctionArn the ARN of the iterator Lambda function for the target Lambda function.
     * @returns the role as the documentation indicates.
     */
    private _createWorkFlowRole;
}
