// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// SECDED encode code generated by
// util/design/secded_gen.py from util/design/data/secded_cfg.hjson

#ifndef OPENTITAN_HW_IP_PRIM_DV_PRIM_SECDED_SECDED_ENC_H_
#define OPENTITAN_HW_IP_PRIM_DV_PRIM_SECDED_SECDED_ENC_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus

// Integrity encode functions for varying bit widths matching the functionality
// of the RTL modules of the same name. Each takes an array of bytes in
// little-endian order and returns the calculated integrity bits.

uint8_t enc_secded_22_16(const uint8_t bytes[2]);
uint8_t enc_secded_28_22(const uint8_t bytes[3]);
uint8_t enc_secded_39_32(const uint8_t bytes[4]);
uint8_t enc_secded_64_57(const uint8_t bytes[8]);
uint8_t enc_secded_72_64(const uint8_t bytes[8]);
uint8_t enc_secded_inv_22_16(const uint8_t bytes[2]);
uint8_t enc_secded_inv_28_22(const uint8_t bytes[3]);
uint8_t enc_secded_inv_39_32(const uint8_t bytes[4]);
uint8_t enc_secded_inv_64_57(const uint8_t bytes[8]);
uint8_t enc_secded_inv_72_64(const uint8_t bytes[8]);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  // OPENTITAN_HW_IP_PRIM_DV_PRIM_SECDED_SECDED_ENC_H_
