# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ContainerCapabilities',
    'ContainerDevice',
    'ContainerHealthcheck',
    'ContainerHost',
    'ContainerLabel',
    'ContainerMount',
    'ContainerMountBindOptions',
    'ContainerMountTmpfsOptions',
    'ContainerMountVolumeOptions',
    'ContainerMountVolumeOptionsLabel',
    'ContainerNetworkData',
    'ContainerNetworksAdvanced',
    'ContainerPort',
    'ContainerUlimit',
    'ContainerUpload',
    'ContainerVolume',
    'NetworkIpamConfig',
    'NetworkLabel',
    'PluginGrantPermission',
    'RegistryImageBuild',
    'RegistryImageBuildAuthConfig',
    'RegistryImageBuildUlimit',
    'RemoteImageBuild',
    'SecretLabel',
    'ServiceAuth',
    'ServiceConvergeConfig',
    'ServiceEndpointSpec',
    'ServiceEndpointSpecPort',
    'ServiceLabel',
    'ServiceMode',
    'ServiceModeReplicated',
    'ServiceRollbackConfig',
    'ServiceTaskSpec',
    'ServiceTaskSpecContainerSpec',
    'ServiceTaskSpecContainerSpecConfig',
    'ServiceTaskSpecContainerSpecDnsConfig',
    'ServiceTaskSpecContainerSpecHealthcheck',
    'ServiceTaskSpecContainerSpecHost',
    'ServiceTaskSpecContainerSpecLabel',
    'ServiceTaskSpecContainerSpecMount',
    'ServiceTaskSpecContainerSpecMountBindOptions',
    'ServiceTaskSpecContainerSpecMountTmpfsOptions',
    'ServiceTaskSpecContainerSpecMountVolumeOptions',
    'ServiceTaskSpecContainerSpecMountVolumeOptionsLabel',
    'ServiceTaskSpecContainerSpecPrivileges',
    'ServiceTaskSpecContainerSpecPrivilegesCredentialSpec',
    'ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext',
    'ServiceTaskSpecContainerSpecSecret',
    'ServiceTaskSpecLogDriver',
    'ServiceTaskSpecPlacement',
    'ServiceTaskSpecPlacementPlatform',
    'ServiceTaskSpecResources',
    'ServiceTaskSpecResourcesLimits',
    'ServiceTaskSpecResourcesReservation',
    'ServiceTaskSpecResourcesReservationGenericResources',
    'ServiceTaskSpecRestartPolicy',
    'ServiceUpdateConfig',
    'VolumeLabel',
    'GetNetworkIpamConfigResult',
]

@pulumi.output_type
class ContainerCapabilities(dict):
    def __init__(__self__, *,
                 adds: Optional[Sequence[str]] = None,
                 drops: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] adds: List of linux capabilities to add.
        :param Sequence[str] drops: List of linux capabilities to drop.
        """
        if adds is not None:
            pulumi.set(__self__, "adds", adds)
        if drops is not None:
            pulumi.set(__self__, "drops", drops)

    @property
    @pulumi.getter
    def adds(self) -> Optional[Sequence[str]]:
        """
        List of linux capabilities to add.
        """
        return pulumi.get(self, "adds")

    @property
    @pulumi.getter
    def drops(self) -> Optional[Sequence[str]]:
        """
        List of linux capabilities to drop.
        """
        return pulumi.get(self, "drops")


@pulumi.output_type
class ContainerDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostPath":
            suggest = "host_path"
        elif key == "containerPath":
            suggest = "container_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_path: str,
                 container_path: Optional[str] = None,
                 permissions: Optional[str] = None):
        """
        :param str host_path: The path on the host where the device is located.
        :param str container_path: The path in the container where the device will be bound.
        :param str permissions: The cgroup permissions given to the container to access the device. Defaults to `rwm`.
        """
        pulumi.set(__self__, "host_path", host_path)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> str:
        """
        The path on the host where the device is located.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[str]:
        """
        The path in the container where the device will be bound.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[str]:
        """
        The cgroup permissions given to the container to access the device. Defaults to `rwm`.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class ContainerHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tests: Sequence[str],
                 interval: Optional[str] = None,
                 retries: Optional[int] = None,
                 start_period: Optional[str] = None,
                 timeout: Optional[str] = None):
        """
        :param Sequence[str] tests: Command to run to check health. For example, to run `curl -f localhost/health` set the command to be `["CMD", "curl", "-f", "localhost/health"]`.
        :param str interval: Time between running the check (ms|s|m|h). Defaults to `0s`.
        :param int retries: Consecutive failures needed to report unhealthy. Defaults to `0`.
        :param str start_period: Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        :param str timeout: Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        pulumi.set(__self__, "tests", tests)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def tests(self) -> Sequence[str]:
        """
        Command to run to check health. For example, to run `curl -f localhost/health` set the command to be `["CMD", "curl", "-f", "localhost/health"]`.
        """
        return pulumi.get(self, "tests")

    @property
    @pulumi.getter
    def interval(self) -> Optional[str]:
        """
        Time between running the check (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        """
        Consecutive failures needed to report unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[str]:
        """
        Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "start_period")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ContainerHost(dict):
    def __init__(__self__, *,
                 host: str,
                 ip: str):
        """
        :param str host: Hostname to add
        :param str ip: IP address this hostname should resolve to.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Hostname to add
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IP address this hostname should resolve to.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class ContainerLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindOptions":
            suggest = "bind_options"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "tmpfsOptions":
            suggest = "tmpfs_options"
        elif key == "volumeOptions":
            suggest = "volume_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target: str,
                 type: str,
                 bind_options: Optional['outputs.ContainerMountBindOptions'] = None,
                 read_only: Optional[bool] = None,
                 source: Optional[str] = None,
                 tmpfs_options: Optional['outputs.ContainerMountTmpfsOptions'] = None,
                 volume_options: Optional['outputs.ContainerMountVolumeOptions'] = None):
        """
        :param str target: Container path
        :param str type: The mount type
        :param 'ContainerMountBindOptionsArgs' bind_options: Optional configuration for the bind type.
        :param bool read_only: Whether the mount should be read-only.
        :param str source: Mount source (e.g. a volume name, a host path).
        :param 'ContainerMountTmpfsOptionsArgs' tmpfs_options: Optional configuration for the tmpfs type.
        :param 'ContainerMountVolumeOptionsArgs' volume_options: Optional configuration for the volume type.
        """
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if bind_options is not None:
            pulumi.set(__self__, "bind_options", bind_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tmpfs_options is not None:
            pulumi.set(__self__, "tmpfs_options", tmpfs_options)
        if volume_options is not None:
            pulumi.set(__self__, "volume_options", volume_options)

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Container path
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The mount type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bindOptions")
    def bind_options(self) -> Optional['outputs.ContainerMountBindOptions']:
        """
        Optional configuration for the bind type.
        """
        return pulumi.get(self, "bind_options")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        Whether the mount should be read-only.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Mount source (e.g. a volume name, a host path).
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="tmpfsOptions")
    def tmpfs_options(self) -> Optional['outputs.ContainerMountTmpfsOptions']:
        """
        Optional configuration for the tmpfs type.
        """
        return pulumi.get(self, "tmpfs_options")

    @property
    @pulumi.getter(name="volumeOptions")
    def volume_options(self) -> Optional['outputs.ContainerMountVolumeOptions']:
        """
        Optional configuration for the volume type.
        """
        return pulumi.get(self, "volume_options")


@pulumi.output_type
class ContainerMountBindOptions(dict):
    def __init__(__self__, *,
                 propagation: Optional[str] = None):
        if propagation is not None:
            pulumi.set(__self__, "propagation", propagation)

    @property
    @pulumi.getter
    def propagation(self) -> Optional[str]:
        return pulumi.get(self, "propagation")


@pulumi.output_type
class ContainerMountTmpfsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeBytes":
            suggest = "size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerMountTmpfsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerMountTmpfsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerMountTmpfsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[int] = None,
                 size_bytes: Optional[int] = None):
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @property
    @pulumi.getter
    def mode(self) -> Optional[int]:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[int]:
        return pulumi.get(self, "size_bytes")


@pulumi.output_type
class ContainerMountVolumeOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "driverOptions":
            suggest = "driver_options"
        elif key == "noCopy":
            suggest = "no_copy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerMountVolumeOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerMountVolumeOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerMountVolumeOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[str] = None,
                 driver_options: Optional[Mapping[str, str]] = None,
                 labels: Optional[Sequence['outputs.ContainerMountVolumeOptionsLabel']] = None,
                 no_copy: Optional[bool] = None):
        """
        :param Sequence['ContainerMountVolumeOptionsLabelArgs'] labels: User-defined key/value metadata
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_copy is not None:
            pulumi.set(__self__, "no_copy", no_copy)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[str]:
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "driver_options")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.ContainerMountVolumeOptionsLabel']]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="noCopy")
    def no_copy(self) -> Optional[bool]:
        return pulumi.get(self, "no_copy")


@pulumi.output_type
class ContainerMountVolumeOptionsLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerNetworkData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "globalIpv6Address":
            suggest = "global_ipv6_address"
        elif key == "globalIpv6PrefixLength":
            suggest = "global_ipv6_prefix_length"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipPrefixLength":
            suggest = "ip_prefix_length"
        elif key == "ipv6Gateway":
            suggest = "ipv6_gateway"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gateway: Optional[str] = None,
                 global_ipv6_address: Optional[str] = None,
                 global_ipv6_prefix_length: Optional[int] = None,
                 ip_address: Optional[str] = None,
                 ip_prefix_length: Optional[int] = None,
                 ipv6_gateway: Optional[str] = None,
                 network_name: Optional[str] = None):
        """
        :param str gateway: The network gateway of the container.
        :param str ip_address: The IP address of the container.
        :param int ip_prefix_length: The IP prefix length of the container.
        """
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if global_ipv6_address is not None:
            pulumi.set(__self__, "global_ipv6_address", global_ipv6_address)
        if global_ipv6_prefix_length is not None:
            pulumi.set(__self__, "global_ipv6_prefix_length", global_ipv6_prefix_length)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_prefix_length is not None:
            pulumi.set(__self__, "ip_prefix_length", ip_prefix_length)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if network_name is not None:
            pulumi.set(__self__, "network_name", network_name)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        The network gateway of the container.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="globalIpv6Address")
    def global_ipv6_address(self) -> Optional[str]:
        return pulumi.get(self, "global_ipv6_address")

    @property
    @pulumi.getter(name="globalIpv6PrefixLength")
    def global_ipv6_prefix_length(self) -> Optional[int]:
        return pulumi.get(self, "global_ipv6_prefix_length")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address of the container.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipPrefixLength")
    def ip_prefix_length(self) -> Optional[int]:
        """
        The IP prefix length of the container.
        """
        return pulumi.get(self, "ip_prefix_length")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[str]:
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> Optional[str]:
        return pulumi.get(self, "network_name")


@pulumi.output_type
class ContainerNetworksAdvanced(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv6Address":
            suggest = "ipv6_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworksAdvanced. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworksAdvanced.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworksAdvanced.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 aliases: Optional[Sequence[str]] = None,
                 ipv4_address: Optional[str] = None,
                 ipv6_address: Optional[str] = None):
        """
        :param str name: The name or id of the network to use. You can use `name` or `id` attribute from a `Network` resource.
        :param Sequence[str] aliases: The network aliases of the container in the specific network.
        :param str ipv4_address: The IPV4 address of the container in the specific network.
        :param str ipv6_address: The IPV6 address of the container in the specific network.
        """
        pulumi.set(__self__, "name", name)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name or id of the network to use. You can use `name` or `id` attribute from a `Network` resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[str]]:
        """
        The network aliases of the container in the specific network.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[str]:
        """
        The IPV4 address of the container in the specific network.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[str]:
        """
        The IPV6 address of the container in the specific network.
        """
        return pulumi.get(self, "ipv6_address")


@pulumi.output_type
class ContainerPort(dict):
    def __init__(__self__, *,
                 internal: int,
                 external: Optional[int] = None,
                 ip: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param int internal: Port within the container.
        :param int external: Port exposed out of the container. If not given a free random port `>= 32768` will be used.
        :param str ip: IP address/mask that can access this port. Defaults to `0.0.0.0`.
        :param str protocol: Protocol that can be used over this port. Defaults to `tcp`.
        """
        pulumi.set(__self__, "internal", internal)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def internal(self) -> int:
        """
        Port within the container.
        """
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter
    def external(self) -> Optional[int]:
        """
        Port exposed out of the container. If not given a free random port `>= 32768` will be used.
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        IP address/mask that can access this port. Defaults to `0.0.0.0`.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol that can be used over this port. Defaults to `tcp`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerUlimit(dict):
    def __init__(__self__, *,
                 hard: int,
                 name: str,
                 soft: int):
        """
        :param int hard: The hard limit
        :param str name: The name of the ulimit
        :param int soft: The soft limit
        """
        pulumi.set(__self__, "hard", hard)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft", soft)

    @property
    @pulumi.getter
    def hard(self) -> int:
        """
        The hard limit
        """
        return pulumi.get(self, "hard")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the ulimit
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def soft(self) -> int:
        """
        The soft limit
        """
        return pulumi.get(self, "soft")


@pulumi.output_type
class ContainerUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentBase64":
            suggest = "content_base64"
        elif key == "sourceHash":
            suggest = "source_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 content: Optional[str] = None,
                 content_base64: Optional[str] = None,
                 executable: Optional[bool] = None,
                 source: Optional[str] = None,
                 source_hash: Optional[str] = None):
        """
        :param str file: Path to the file in the container where is upload goes to
        :param str content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `content_base64` & `source`
        :param bool executable: If `true`, the file will be uploaded with user executable permission. Defaults to `false`.
        :param str source: A filename that references a file which will be uploaded as the object content. This allows for large file uploads that do not get stored in state. Conflicts with `content` & `content_base64`
        :param str source_hash: If using `source`, this will force an update if the file content has updated but the filename has not.
        """
        pulumi.set(__self__, "file", file)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        Path to the file in the container where is upload goes to
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `content_base64` & `source`
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[str]:
        return pulumi.get(self, "content_base64")

    @property
    @pulumi.getter
    def executable(self) -> Optional[bool]:
        """
        If `true`, the file will be uploaded with user executable permission. Defaults to `false`.
        """
        return pulumi.get(self, "executable")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        A filename that references a file which will be uploaded as the object content. This allows for large file uploads that do not get stored in state. Conflicts with `content` & `content_base64`
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[str]:
        """
        If using `source`, this will force an update if the file content has updated but the filename has not.
        """
        return pulumi.get(self, "source_hash")


@pulumi.output_type
class ContainerVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "fromContainer":
            suggest = "from_container"
        elif key == "hostPath":
            suggest = "host_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[str] = None,
                 from_container: Optional[str] = None,
                 host_path: Optional[str] = None,
                 read_only: Optional[bool] = None,
                 volume_name: Optional[str] = None):
        """
        :param str container_path: The path in the container where the volume will be mounted.
        :param str from_container: The container where the volume is coming from.
        :param str host_path: The path on the host where the volume is coming from.
        :param bool read_only: If `true`, this volume will be readonly. Defaults to `false`.
        :param str volume_name: The name of the docker volume which should be mounted.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if from_container is not None:
            pulumi.set(__self__, "from_container", from_container)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[str]:
        """
        The path in the container where the volume will be mounted.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="fromContainer")
    def from_container(self) -> Optional[str]:
        """
        The container where the volume is coming from.
        """
        return pulumi.get(self, "from_container")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[str]:
        """
        The path on the host where the volume is coming from.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        If `true`, this volume will be readonly. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[str]:
        """
        The name of the docker volume which should be mounted.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class NetworkIpamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auxAddress":
            suggest = "aux_address"
        elif key == "ipRange":
            suggest = "ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkIpamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkIpamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkIpamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aux_address: Optional[Mapping[str, Any]] = None,
                 gateway: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 subnet: Optional[str] = None):
        """
        :param Mapping[str, Any] aux_address: Auxiliary IPv4 or IPv6 addresses used by Network driver
        :param str gateway: The IP address of the gateway
        :param str ip_range: The ip range in CIDR form
        :param str subnet: The subnet in CIDR form
        """
        if aux_address is not None:
            pulumi.set(__self__, "aux_address", aux_address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> Optional[Mapping[str, Any]]:
        """
        Auxiliary IPv4 or IPv6 addresses used by Network driver
        """
        return pulumi.get(self, "aux_address")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        The IP address of the gateway
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        """
        The ip range in CIDR form
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        The subnet in CIDR form
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class NetworkLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PluginGrantPermission(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the permission
        :param Sequence[str] values: The value of the permission
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the permission
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value of the permission
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RegistryImageBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authConfigs":
            suggest = "auth_configs"
        elif key == "buildArgs":
            suggest = "build_args"
        elif key == "buildId":
            suggest = "build_id"
        elif key == "cacheFroms":
            suggest = "cache_froms"
        elif key == "cgroupParent":
            suggest = "cgroup_parent"
        elif key == "cpuPeriod":
            suggest = "cpu_period"
        elif key == "cpuQuota":
            suggest = "cpu_quota"
        elif key == "cpuSetCpus":
            suggest = "cpu_set_cpus"
        elif key == "cpuSetMems":
            suggest = "cpu_set_mems"
        elif key == "cpuShares":
            suggest = "cpu_shares"
        elif key == "extraHosts":
            suggest = "extra_hosts"
        elif key == "forceRemove":
            suggest = "force_remove"
        elif key == "memorySwap":
            suggest = "memory_swap"
        elif key == "networkMode":
            suggest = "network_mode"
        elif key == "noCache":
            suggest = "no_cache"
        elif key == "pullParent":
            suggest = "pull_parent"
        elif key == "remoteContext":
            suggest = "remote_context"
        elif key == "securityOpts":
            suggest = "security_opts"
        elif key == "sessionId":
            suggest = "session_id"
        elif key == "shmSize":
            suggest = "shm_size"
        elif key == "suppressOutput":
            suggest = "suppress_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryImageBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryImageBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryImageBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: str,
                 auth_configs: Optional[Sequence['outputs.RegistryImageBuildAuthConfig']] = None,
                 build_args: Optional[Mapping[str, str]] = None,
                 build_id: Optional[str] = None,
                 cache_froms: Optional[Sequence[str]] = None,
                 cgroup_parent: Optional[str] = None,
                 cpu_period: Optional[int] = None,
                 cpu_quota: Optional[int] = None,
                 cpu_set_cpus: Optional[str] = None,
                 cpu_set_mems: Optional[str] = None,
                 cpu_shares: Optional[int] = None,
                 dockerfile: Optional[str] = None,
                 extra_hosts: Optional[Sequence[str]] = None,
                 force_remove: Optional[bool] = None,
                 isolation: Optional[str] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 memory: Optional[int] = None,
                 memory_swap: Optional[int] = None,
                 network_mode: Optional[str] = None,
                 no_cache: Optional[bool] = None,
                 platform: Optional[str] = None,
                 pull_parent: Optional[bool] = None,
                 remote_context: Optional[str] = None,
                 remove: Optional[bool] = None,
                 security_opts: Optional[Sequence[str]] = None,
                 session_id: Optional[str] = None,
                 shm_size: Optional[int] = None,
                 squash: Optional[bool] = None,
                 suppress_output: Optional[bool] = None,
                 target: Optional[str] = None,
                 ulimits: Optional[Sequence['outputs.RegistryImageBuildUlimit']] = None,
                 version: Optional[str] = None):
        """
        :param str context: The absolute path to the context folder. You can use the helper function '${path.cwd}/context-dir'.
        :param Sequence['RegistryImageBuildAuthConfigArgs'] auth_configs: The configuration for the authentication
        :param Mapping[str, str] build_args: Pairs for build-time variables in the form TODO
        :param str build_id: BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        :param Sequence[str] cache_froms: Images to consider as cache sources
        :param str cgroup_parent: Optional parent cgroup for the container
        :param int cpu_period: The length of a CPU period in microseconds
        :param int cpu_quota: Microseconds of CPU time that the container can get in a CPU period
        :param str cpu_set_cpus: CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        :param str cpu_set_mems: MEMs in which to allow execution (`0-3`, `0`, `1`)
        :param int cpu_shares: CPU shares (relative weight)
        :param str dockerfile: Dockerfile file. Defaults to `Dockerfile`
        :param Sequence[str] extra_hosts: A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        :param bool force_remove: Always remove intermediate containers
        :param str isolation: Isolation represents the isolation technology of a container. The supported values are
        :param Mapping[str, str] labels: User-defined key/value metadata
        :param int memory: Set memory limit for build
        :param int memory_swap: Total memory (memory + swap), -1 to enable unlimited swap
        :param str network_mode: Set the networking mode for the RUN instructions during build
        :param bool no_cache: Do not use the cache when building the image
        :param str platform: Set platform if server is multi-platform capable
        :param bool pull_parent: Attempt to pull the image even if an older image exists locally
        :param str remote_context: A Git repository URI or HTTP/HTTPS context URI
        :param bool remove: Remove intermediate containers after a successful build (default behavior)
        :param Sequence[str] security_opts: The security options
        :param str session_id: Set an ID for the build session
        :param int shm_size: Size of /dev/shm in bytes. The size must be greater than 0
        :param bool squash: If true the new layers are squashed into a new image with a single new layer
        :param bool suppress_output: Suppress the build output and print image ID on success
        :param str target: Set the target build stage to build
        :param Sequence['RegistryImageBuildUlimitArgs'] ulimits: Configuration for ulimits
        :param str version: Version of the underlying builder to use
        """
        pulumi.set(__self__, "context", context)
        if auth_configs is not None:
            pulumi.set(__self__, "auth_configs", auth_configs)
        if build_args is not None:
            pulumi.set(__self__, "build_args", build_args)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if cache_froms is not None:
            pulumi.set(__self__, "cache_froms", cache_froms)
        if cgroup_parent is not None:
            pulumi.set(__self__, "cgroup_parent", cgroup_parent)
        if cpu_period is not None:
            pulumi.set(__self__, "cpu_period", cpu_period)
        if cpu_quota is not None:
            pulumi.set(__self__, "cpu_quota", cpu_quota)
        if cpu_set_cpus is not None:
            pulumi.set(__self__, "cpu_set_cpus", cpu_set_cpus)
        if cpu_set_mems is not None:
            pulumi.set(__self__, "cpu_set_mems", cpu_set_mems)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if force_remove is not None:
            pulumi.set(__self__, "force_remove", force_remove)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_swap is not None:
            pulumi.set(__self__, "memory_swap", memory_swap)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pull_parent is not None:
            pulumi.set(__self__, "pull_parent", pull_parent)
        if remote_context is not None:
            pulumi.set(__self__, "remote_context", remote_context)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if security_opts is not None:
            pulumi.set(__self__, "security_opts", security_opts)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)
        if squash is not None:
            pulumi.set(__self__, "squash", squash)
        if suppress_output is not None:
            pulumi.set(__self__, "suppress_output", suppress_output)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def context(self) -> str:
        """
        The absolute path to the context folder. You can use the helper function '${path.cwd}/context-dir'.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="authConfigs")
    def auth_configs(self) -> Optional[Sequence['outputs.RegistryImageBuildAuthConfig']]:
        """
        The configuration for the authentication
        """
        return pulumi.get(self, "auth_configs")

    @property
    @pulumi.getter(name="buildArgs")
    def build_args(self) -> Optional[Mapping[str, str]]:
        """
        Pairs for build-time variables in the form TODO
        """
        return pulumi.get(self, "build_args")

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[str]:
        """
        BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        """
        return pulumi.get(self, "build_id")

    @property
    @pulumi.getter(name="cacheFroms")
    def cache_froms(self) -> Optional[Sequence[str]]:
        """
        Images to consider as cache sources
        """
        return pulumi.get(self, "cache_froms")

    @property
    @pulumi.getter(name="cgroupParent")
    def cgroup_parent(self) -> Optional[str]:
        """
        Optional parent cgroup for the container
        """
        return pulumi.get(self, "cgroup_parent")

    @property
    @pulumi.getter(name="cpuPeriod")
    def cpu_period(self) -> Optional[int]:
        """
        The length of a CPU period in microseconds
        """
        return pulumi.get(self, "cpu_period")

    @property
    @pulumi.getter(name="cpuQuota")
    def cpu_quota(self) -> Optional[int]:
        """
        Microseconds of CPU time that the container can get in a CPU period
        """
        return pulumi.get(self, "cpu_quota")

    @property
    @pulumi.getter(name="cpuSetCpus")
    def cpu_set_cpus(self) -> Optional[str]:
        """
        CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_cpus")

    @property
    @pulumi.getter(name="cpuSetMems")
    def cpu_set_mems(self) -> Optional[str]:
        """
        MEMs in which to allow execution (`0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_mems")

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[int]:
        """
        CPU shares (relative weight)
        """
        return pulumi.get(self, "cpu_shares")

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[str]:
        """
        Dockerfile file. Defaults to `Dockerfile`
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[Sequence[str]]:
        """
        A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        """
        return pulumi.get(self, "extra_hosts")

    @property
    @pulumi.getter(name="forceRemove")
    def force_remove(self) -> Optional[bool]:
        """
        Always remove intermediate containers
        """
        return pulumi.get(self, "force_remove")

    @property
    @pulumi.getter
    def isolation(self) -> Optional[str]:
        """
        Isolation represents the isolation technology of a container. The supported values are
        """
        return pulumi.get(self, "isolation")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def memory(self) -> Optional[int]:
        """
        Set memory limit for build
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> Optional[int]:
        """
        Total memory (memory + swap), -1 to enable unlimited swap
        """
        return pulumi.get(self, "memory_swap")

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[str]:
        """
        Set the networking mode for the RUN instructions during build
        """
        return pulumi.get(self, "network_mode")

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[bool]:
        """
        Do not use the cache when building the image
        """
        return pulumi.get(self, "no_cache")

    @property
    @pulumi.getter
    def platform(self) -> Optional[str]:
        """
        Set platform if server is multi-platform capable
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="pullParent")
    def pull_parent(self) -> Optional[bool]:
        """
        Attempt to pull the image even if an older image exists locally
        """
        return pulumi.get(self, "pull_parent")

    @property
    @pulumi.getter(name="remoteContext")
    def remote_context(self) -> Optional[str]:
        """
        A Git repository URI or HTTP/HTTPS context URI
        """
        return pulumi.get(self, "remote_context")

    @property
    @pulumi.getter
    def remove(self) -> Optional[bool]:
        """
        Remove intermediate containers after a successful build (default behavior)
        """
        return pulumi.get(self, "remove")

    @property
    @pulumi.getter(name="securityOpts")
    def security_opts(self) -> Optional[Sequence[str]]:
        """
        The security options
        """
        return pulumi.get(self, "security_opts")

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[str]:
        """
        Set an ID for the build session
        """
        return pulumi.get(self, "session_id")

    @property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[int]:
        """
        Size of /dev/shm in bytes. The size must be greater than 0
        """
        return pulumi.get(self, "shm_size")

    @property
    @pulumi.getter
    def squash(self) -> Optional[bool]:
        """
        If true the new layers are squashed into a new image with a single new layer
        """
        return pulumi.get(self, "squash")

    @property
    @pulumi.getter(name="suppressOutput")
    def suppress_output(self) -> Optional[bool]:
        """
        Suppress the build output and print image ID on success
        """
        return pulumi.get(self, "suppress_output")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Set the target build stage to build
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.RegistryImageBuildUlimit']]:
        """
        Configuration for ulimits
        """
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the underlying builder to use
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RegistryImageBuildAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "identityToken":
            suggest = "identity_token"
        elif key == "registryToken":
            suggest = "registry_token"
        elif key == "serverAddress":
            suggest = "server_address"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryImageBuildAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryImageBuildAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryImageBuildAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 auth: Optional[str] = None,
                 email: Optional[str] = None,
                 identity_token: Optional[str] = None,
                 password: Optional[str] = None,
                 registry_token: Optional[str] = None,
                 server_address: Optional[str] = None,
                 user_name: Optional[str] = None):
        pulumi.set(__self__, "host_name", host_name)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if identity_token is not None:
            pulumi.set(__self__, "identity_token", identity_token)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if registry_token is not None:
            pulumi.set(__self__, "registry_token", registry_token)
        if server_address is not None:
            pulumi.set(__self__, "server_address", server_address)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def auth(self) -> Optional[str]:
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="identityToken")
    def identity_token(self) -> Optional[str]:
        return pulumi.get(self, "identity_token")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="registryToken")
    def registry_token(self) -> Optional[str]:
        return pulumi.get(self, "registry_token")

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> Optional[str]:
        return pulumi.get(self, "server_address")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class RegistryImageBuildUlimit(dict):
    def __init__(__self__, *,
                 hard: int,
                 name: str,
                 soft: int):
        """
        :param str name: The name of the Docker image.
        """
        pulumi.set(__self__, "hard", hard)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft", soft)

    @property
    @pulumi.getter
    def hard(self) -> int:
        return pulumi.get(self, "hard")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Docker image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def soft(self) -> int:
        return pulumi.get(self, "soft")


@pulumi.output_type
class RemoteImageBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildArg":
            suggest = "build_arg"
        elif key == "forceRemove":
            suggest = "force_remove"
        elif key == "noCache":
            suggest = "no_cache"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemoteImageBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemoteImageBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemoteImageBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 build_arg: Optional[Mapping[str, str]] = None,
                 dockerfile: Optional[str] = None,
                 force_remove: Optional[bool] = None,
                 label: Optional[Mapping[str, str]] = None,
                 no_cache: Optional[bool] = None,
                 remove: Optional[bool] = None,
                 tags: Optional[Sequence[str]] = None,
                 target: Optional[str] = None):
        """
        :param str path: Context path
        :param Mapping[str, str] build_arg: Set build-time variables
        :param str dockerfile: Name of the Dockerfile. Defaults to `Dockerfile`.
        :param bool force_remove: Always remove intermediate containers
        :param Mapping[str, str] label: Set metadata for an image
        :param bool no_cache: Do not use cache when building the image
        :param bool remove: Remove intermediate containers after a successful build. Defaults to  `true`.
        :param Sequence[str] tags: Name and optionally a tag in the 'name:tag' format
        :param str target: Set the target build stage to build
        """
        pulumi.set(__self__, "path", path)
        if build_arg is not None:
            pulumi.set(__self__, "build_arg", build_arg)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if force_remove is not None:
            pulumi.set(__self__, "force_remove", force_remove)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Context path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="buildArg")
    def build_arg(self) -> Optional[Mapping[str, str]]:
        """
        Set build-time variables
        """
        return pulumi.get(self, "build_arg")

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[str]:
        """
        Name of the Dockerfile. Defaults to `Dockerfile`.
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter(name="forceRemove")
    def force_remove(self) -> Optional[bool]:
        """
        Always remove intermediate containers
        """
        return pulumi.get(self, "force_remove")

    @property
    @pulumi.getter
    def label(self) -> Optional[Mapping[str, str]]:
        """
        Set metadata for an image
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[bool]:
        """
        Do not use cache when building the image
        """
        return pulumi.get(self, "no_cache")

    @property
    @pulumi.getter
    def remove(self) -> Optional[bool]:
        """
        Remove intermediate containers after a successful build. Defaults to  `true`.
        """
        return pulumi.get(self, "remove")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Name and optionally a tag in the 'name:tag' format
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Set the target build stage to build
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class SecretLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverAddress":
            suggest = "server_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_address: str,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str server_address: The address of the server for the authentication
        :param str password: The password
        :param str username: The username
        """
        pulumi.set(__self__, "server_address", server_address)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> str:
        """
        The address of the server for the authentication
        """
        return pulumi.get(self, "server_address")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceConvergeConfig(dict):
    def __init__(__self__, *,
                 delay: Optional[str] = None,
                 timeout: Optional[str] = None):
        """
        :param str delay: The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`.
        :param str timeout: The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def delay(self) -> Optional[str]:
        """
        The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ServiceEndpointSpec(dict):
    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 ports: Optional[Sequence['outputs.ServiceEndpointSpecPort']] = None):
        """
        :param str mode: The mode of resolution to use for internal load balancing between tasks
        :param Sequence['ServiceEndpointSpecPortArgs'] ports: List of exposed ports that this service is accessible on from the outside. Ports can only be provided if 'vip' resolution mode is used
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The mode of resolution to use for internal load balancing between tasks
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ServiceEndpointSpecPort']]:
        """
        List of exposed ports that this service is accessible on from the outside. Ports can only be provided if 'vip' resolution mode is used
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ServiceEndpointSpecPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPort":
            suggest = "target_port"
        elif key == "publishMode":
            suggest = "publish_mode"
        elif key == "publishedPort":
            suggest = "published_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointSpecPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointSpecPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointSpecPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_port: int,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None,
                 publish_mode: Optional[str] = None,
                 published_port: Optional[int] = None):
        """
        :param str name: Name of the service
        """
        pulumi.set(__self__, "target_port", target_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if publish_mode is not None:
            pulumi.set(__self__, "publish_mode", publish_mode)
        if published_port is not None:
            pulumi.set(__self__, "published_port", published_port)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the service
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publishMode")
    def publish_mode(self) -> Optional[str]:
        return pulumi.get(self, "publish_mode")

    @property
    @pulumi.getter(name="publishedPort")
    def published_port(self) -> Optional[int]:
        return pulumi.get(self, "published_port")


@pulumi.output_type
class ServiceLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "global":
            suggest = "global_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 global_: Optional[bool] = None,
                 replicated: Optional['outputs.ServiceModeReplicated'] = None):
        """
        :param bool global_: The global service mode. Defaults to `false`
        :param 'ServiceModeReplicatedArgs' replicated: The replicated service mode
        """
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if replicated is not None:
            pulumi.set(__self__, "replicated", replicated)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[bool]:
        """
        The global service mode. Defaults to `false`
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter
    def replicated(self) -> Optional['outputs.ServiceModeReplicated']:
        """
        The replicated service mode
        """
        return pulumi.get(self, "replicated")


@pulumi.output_type
class ServiceModeReplicated(dict):
    def __init__(__self__, *,
                 replicas: Optional[int] = None):
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        return pulumi.get(self, "replicas")


@pulumi.output_type
class ServiceRollbackConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureAction":
            suggest = "failure_action"
        elif key == "maxFailureRatio":
            suggest = "max_failure_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceRollbackConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceRollbackConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceRollbackConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay: Optional[str] = None,
                 failure_action: Optional[str] = None,
                 max_failure_ratio: Optional[str] = None,
                 monitor: Optional[str] = None,
                 order: Optional[str] = None,
                 parallelism: Optional[int] = None):
        """
        :param str delay: Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`.
        :param str failure_action: Action on rollback failure: pause | continue. Defaults to `pause`.
        :param str max_failure_ratio: Failure rate to tolerate during a rollback. Defaults to `0.0`.
        :param str monitor: Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        :param str order: Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        :param int parallelism: Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if max_failure_ratio is not None:
            pulumi.set(__self__, "max_failure_ratio", max_failure_ratio)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)

    @property
    @pulumi.getter
    def delay(self) -> Optional[str]:
        """
        Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[str]:
        """
        Action on rollback failure: pause | continue. Defaults to `pause`.
        """
        return pulumi.get(self, "failure_action")

    @property
    @pulumi.getter(name="maxFailureRatio")
    def max_failure_ratio(self) -> Optional[str]:
        """
        Failure rate to tolerate during a rollback. Defaults to `0.0`.
        """
        return pulumi.get(self, "max_failure_ratio")

    @property
    @pulumi.getter
    def monitor(self) -> Optional[str]:
        """
        Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        """
        Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[int]:
        """
        Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`
        """
        return pulumi.get(self, "parallelism")


@pulumi.output_type
class ServiceTaskSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerSpec":
            suggest = "container_spec"
        elif key == "forceUpdate":
            suggest = "force_update"
        elif key == "logDriver":
            suggest = "log_driver"
        elif key == "restartPolicy":
            suggest = "restart_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_spec: 'outputs.ServiceTaskSpecContainerSpec',
                 force_update: Optional[int] = None,
                 log_driver: Optional['outputs.ServiceTaskSpecLogDriver'] = None,
                 networks: Optional[Sequence[str]] = None,
                 placement: Optional['outputs.ServiceTaskSpecPlacement'] = None,
                 resources: Optional['outputs.ServiceTaskSpecResources'] = None,
                 restart_policy: Optional['outputs.ServiceTaskSpecRestartPolicy'] = None,
                 runtime: Optional[str] = None):
        """
        :param 'ServiceTaskSpecContainerSpecArgs' container_spec: The spec for each container
        :param int force_update: A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126).
        :param 'ServiceTaskSpecLogDriverArgs' log_driver: Specifies the log driver to use for tasks created from this spec. If not present, the default one for the swarm will be used, finally falling back to the engine default if not specified
        :param Sequence[str] networks: Ids of the networks in which the  container will be put in
        :param 'ServiceTaskSpecPlacementArgs' placement: The placement preferences
        :param 'ServiceTaskSpecResourcesArgs' resources: Resource requirements which apply to each individual container created as part of the service
        :param 'ServiceTaskSpecRestartPolicyArgs' restart_policy: Specification for the restart policy which applies to containers created as part of this service.
        :param str runtime: Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go).
        """
        pulumi.set(__self__, "container_spec", container_spec)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if log_driver is not None:
            pulumi.set(__self__, "log_driver", log_driver)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @property
    @pulumi.getter(name="containerSpec")
    def container_spec(self) -> 'outputs.ServiceTaskSpecContainerSpec':
        """
        The spec for each container
        """
        return pulumi.get(self, "container_spec")

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[int]:
        """
        A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126).
        """
        return pulumi.get(self, "force_update")

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> Optional['outputs.ServiceTaskSpecLogDriver']:
        """
        Specifies the log driver to use for tasks created from this spec. If not present, the default one for the swarm will be used, finally falling back to the engine default if not specified
        """
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter
    def networks(self) -> Optional[Sequence[str]]:
        """
        Ids of the networks in which the  container will be put in
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def placement(self) -> Optional['outputs.ServiceTaskSpecPlacement']:
        """
        The placement preferences
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ServiceTaskSpecResources']:
        """
        Resource requirements which apply to each individual container created as part of the service
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional['outputs.ServiceTaskSpecRestartPolicy']:
        """
        Specification for the restart policy which applies to containers created as part of this service.
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter
    def runtime(self) -> Optional[str]:
        """
        Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go).
        """
        return pulumi.get(self, "runtime")


@pulumi.output_type
class ServiceTaskSpecContainerSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsConfig":
            suggest = "dns_config"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "stopGracePeriod":
            suggest = "stop_grace_period"
        elif key == "stopSignal":
            suggest = "stop_signal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 configs: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecConfig']] = None,
                 dir: Optional[str] = None,
                 dns_config: Optional['outputs.ServiceTaskSpecContainerSpecDnsConfig'] = None,
                 env: Optional[Mapping[str, str]] = None,
                 groups: Optional[Sequence[str]] = None,
                 healthcheck: Optional['outputs.ServiceTaskSpecContainerSpecHealthcheck'] = None,
                 hostname: Optional[str] = None,
                 hosts: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecHost']] = None,
                 isolation: Optional[str] = None,
                 labels: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecLabel']] = None,
                 mounts: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMount']] = None,
                 privileges: Optional['outputs.ServiceTaskSpecContainerSpecPrivileges'] = None,
                 read_only: Optional[bool] = None,
                 secrets: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecSecret']] = None,
                 stop_grace_period: Optional[str] = None,
                 stop_signal: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param Sequence['ServiceTaskSpecContainerSpecLabelArgs'] labels: User-defined key/value metadata
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if stop_grace_period is not None:
            pulumi.set(__self__, "stop_grace_period", stop_grace_period)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def image(self) -> str:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecConfig']]:
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def dir(self) -> Optional[str]:
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional['outputs.ServiceTaskSpecContainerSpecDnsConfig']:
        return pulumi.get(self, "dns_config")

    @property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional['outputs.ServiceTaskSpecContainerSpecHealthcheck']:
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecHost']]:
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def isolation(self) -> Optional[str]:
        return pulumi.get(self, "isolation")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecLabel']]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def mounts(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMount']]:
        return pulumi.get(self, "mounts")

    @property
    @pulumi.getter
    def privileges(self) -> Optional['outputs.ServiceTaskSpecContainerSpecPrivileges']:
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecSecret']]:
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="stopGracePeriod")
    def stop_grace_period(self) -> Optional[str]:
        return pulumi.get(self, "stop_grace_period")

    @property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[str]:
        return pulumi.get(self, "stop_signal")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceTaskSpecContainerSpecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configId":
            suggest = "config_id"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "configName":
            suggest = "config_name"
        elif key == "fileGid":
            suggest = "file_gid"
        elif key == "fileMode":
            suggest = "file_mode"
        elif key == "fileUid":
            suggest = "file_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_id: str,
                 file_name: str,
                 config_name: Optional[str] = None,
                 file_gid: Optional[str] = None,
                 file_mode: Optional[int] = None,
                 file_uid: Optional[str] = None):
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "file_name", file_name)
        if config_name is not None:
            pulumi.set(__self__, "config_name", config_name)
        if file_gid is not None:
            pulumi.set(__self__, "file_gid", file_gid)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_uid is not None:
            pulumi.set(__self__, "file_uid", file_uid)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> str:
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="configName")
    def config_name(self) -> Optional[str]:
        return pulumi.get(self, "config_name")

    @property
    @pulumi.getter(name="fileGid")
    def file_gid(self) -> Optional[str]:
        return pulumi.get(self, "file_gid")

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[int]:
        return pulumi.get(self, "file_mode")

    @property
    @pulumi.getter(name="fileUid")
    def file_uid(self) -> Optional[str]:
        return pulumi.get(self, "file_uid")


@pulumi.output_type
class ServiceTaskSpecContainerSpecDnsConfig(dict):
    def __init__(__self__, *,
                 nameservers: Sequence[str],
                 options: Optional[Sequence[str]] = None,
                 searches: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "nameservers", nameservers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @property
    @pulumi.getter
    def nameservers(self) -> Sequence[str]:
        return pulumi.get(self, "nameservers")

    @property
    @pulumi.getter
    def options(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def searches(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "searches")


@pulumi.output_type
class ServiceTaskSpecContainerSpecHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tests: Sequence[str],
                 interval: Optional[str] = None,
                 retries: Optional[int] = None,
                 start_period: Optional[str] = None,
                 timeout: Optional[str] = None):
        pulumi.set(__self__, "tests", tests)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def tests(self) -> Sequence[str]:
        return pulumi.get(self, "tests")

    @property
    @pulumi.getter
    def interval(self) -> Optional[str]:
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[str]:
        return pulumi.get(self, "start_period")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ServiceTaskSpecContainerSpecHost(dict):
    def __init__(__self__, *,
                 host: str,
                 ip: str):
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")


@pulumi.output_type
class ServiceTaskSpecContainerSpecLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindOptions":
            suggest = "bind_options"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "tmpfsOptions":
            suggest = "tmpfs_options"
        elif key == "volumeOptions":
            suggest = "volume_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target: str,
                 type: str,
                 bind_options: Optional['outputs.ServiceTaskSpecContainerSpecMountBindOptions'] = None,
                 read_only: Optional[bool] = None,
                 source: Optional[str] = None,
                 tmpfs_options: Optional['outputs.ServiceTaskSpecContainerSpecMountTmpfsOptions'] = None,
                 volume_options: Optional['outputs.ServiceTaskSpecContainerSpecMountVolumeOptions'] = None):
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if bind_options is not None:
            pulumi.set(__self__, "bind_options", bind_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tmpfs_options is not None:
            pulumi.set(__self__, "tmpfs_options", tmpfs_options)
        if volume_options is not None:
            pulumi.set(__self__, "volume_options", volume_options)

    @property
    @pulumi.getter
    def target(self) -> str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bindOptions")
    def bind_options(self) -> Optional['outputs.ServiceTaskSpecContainerSpecMountBindOptions']:
        return pulumi.get(self, "bind_options")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="tmpfsOptions")
    def tmpfs_options(self) -> Optional['outputs.ServiceTaskSpecContainerSpecMountTmpfsOptions']:
        return pulumi.get(self, "tmpfs_options")

    @property
    @pulumi.getter(name="volumeOptions")
    def volume_options(self) -> Optional['outputs.ServiceTaskSpecContainerSpecMountVolumeOptions']:
        return pulumi.get(self, "volume_options")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountBindOptions(dict):
    def __init__(__self__, *,
                 propagation: Optional[str] = None):
        if propagation is not None:
            pulumi.set(__self__, "propagation", propagation)

    @property
    @pulumi.getter
    def propagation(self) -> Optional[str]:
        return pulumi.get(self, "propagation")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountTmpfsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeBytes":
            suggest = "size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecMountTmpfsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecMountTmpfsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecMountTmpfsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[int] = None,
                 size_bytes: Optional[int] = None):
        """
        :param int mode: Scheduling mode for the service
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @property
    @pulumi.getter
    def mode(self) -> Optional[int]:
        """
        Scheduling mode for the service
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[int]:
        return pulumi.get(self, "size_bytes")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountVolumeOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "driverOptions":
            suggest = "driver_options"
        elif key == "noCopy":
            suggest = "no_copy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecMountVolumeOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecMountVolumeOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecMountVolumeOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[str] = None,
                 driver_options: Optional[Mapping[str, str]] = None,
                 labels: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMountVolumeOptionsLabel']] = None,
                 no_copy: Optional[bool] = None):
        """
        :param Sequence['ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs'] labels: User-defined key/value metadata
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_copy is not None:
            pulumi.set(__self__, "no_copy", no_copy)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[str]:
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "driver_options")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMountVolumeOptionsLabel']]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="noCopy")
    def no_copy(self) -> Optional[bool]:
        return pulumi.get(self, "no_copy")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountVolumeOptionsLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTaskSpecContainerSpecPrivileges(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialSpec":
            suggest = "credential_spec"
        elif key == "seLinuxContext":
            suggest = "se_linux_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecPrivileges. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecPrivileges.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecPrivileges.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_spec: Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesCredentialSpec'] = None,
                 se_linux_context: Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext'] = None):
        if credential_spec is not None:
            pulumi.set(__self__, "credential_spec", credential_spec)
        if se_linux_context is not None:
            pulumi.set(__self__, "se_linux_context", se_linux_context)

    @property
    @pulumi.getter(name="credentialSpec")
    def credential_spec(self) -> Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesCredentialSpec']:
        return pulumi.get(self, "credential_spec")

    @property
    @pulumi.getter(name="seLinuxContext")
    def se_linux_context(self) -> Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext']:
        return pulumi.get(self, "se_linux_context")


@pulumi.output_type
class ServiceTaskSpecContainerSpecPrivilegesCredentialSpec(dict):
    def __init__(__self__, *,
                 file: Optional[str] = None,
                 registry: Optional[str] = None):
        if file is not None:
            pulumi.set(__self__, "file", file)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)

    @property
    @pulumi.getter
    def file(self) -> Optional[str]:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        return pulumi.get(self, "registry")


@pulumi.output_type
class ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext(dict):
    def __init__(__self__, *,
                 disable: Optional[bool] = None,
                 level: Optional[str] = None,
                 role: Optional[str] = None,
                 type: Optional[str] = None,
                 user: Optional[str] = None):
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def disable(self) -> Optional[bool]:
        return pulumi.get(self, "disable")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceTaskSpecContainerSpecSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "fileGid":
            suggest = "file_gid"
        elif key == "fileMode":
            suggest = "file_mode"
        elif key == "fileUid":
            suggest = "file_uid"
        elif key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_name: str,
                 secret_id: str,
                 file_gid: Optional[str] = None,
                 file_mode: Optional[int] = None,
                 file_uid: Optional[str] = None,
                 secret_name: Optional[str] = None):
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "secret_id", secret_id)
        if file_gid is not None:
            pulumi.set(__self__, "file_gid", file_gid)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_uid is not None:
            pulumi.set(__self__, "file_uid", file_uid)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="fileGid")
    def file_gid(self) -> Optional[str]:
        return pulumi.get(self, "file_gid")

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[int]:
        return pulumi.get(self, "file_mode")

    @property
    @pulumi.getter(name="fileUid")
    def file_uid(self) -> Optional[str]:
        return pulumi.get(self, "file_uid")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[str]:
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class ServiceTaskSpecLogDriver(dict):
    def __init__(__self__, *,
                 name: str,
                 options: Optional[Mapping[str, str]] = None):
        """
        :param str name: Name of the service
        """
        pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the service
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "options")


@pulumi.output_type
class ServiceTaskSpecPlacement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecPlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecPlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecPlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 constraints: Optional[Sequence[str]] = None,
                 max_replicas: Optional[int] = None,
                 platforms: Optional[Sequence['outputs.ServiceTaskSpecPlacementPlatform']] = None,
                 prefs: Optional[Sequence[str]] = None):
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if platforms is not None:
            pulumi.set(__self__, "platforms", platforms)
        if prefs is not None:
            pulumi.set(__self__, "prefs", prefs)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[int]:
        return pulumi.get(self, "max_replicas")

    @property
    @pulumi.getter
    def platforms(self) -> Optional[Sequence['outputs.ServiceTaskSpecPlacementPlatform']]:
        return pulumi.get(self, "platforms")

    @property
    @pulumi.getter
    def prefs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "prefs")


@pulumi.output_type
class ServiceTaskSpecPlacementPlatform(dict):
    def __init__(__self__, *,
                 architecture: str,
                 os: str):
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "os", os)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def os(self) -> str:
        return pulumi.get(self, "os")


@pulumi.output_type
class ServiceTaskSpecResources(dict):
    def __init__(__self__, *,
                 limits: Optional['outputs.ServiceTaskSpecResourcesLimits'] = None,
                 reservation: Optional['outputs.ServiceTaskSpecResourcesReservation'] = None):
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if reservation is not None:
            pulumi.set(__self__, "reservation", reservation)

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.ServiceTaskSpecResourcesLimits']:
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def reservation(self) -> Optional['outputs.ServiceTaskSpecResourcesReservation']:
        return pulumi.get(self, "reservation")


@pulumi.output_type
class ServiceTaskSpecResourcesLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryBytes":
            suggest = "memory_bytes"
        elif key == "nanoCpus":
            suggest = "nano_cpus"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecResourcesLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecResourcesLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecResourcesLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_bytes: Optional[int] = None,
                 nano_cpus: Optional[int] = None):
        if memory_bytes is not None:
            pulumi.set(__self__, "memory_bytes", memory_bytes)
        if nano_cpus is not None:
            pulumi.set(__self__, "nano_cpus", nano_cpus)

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> Optional[int]:
        return pulumi.get(self, "memory_bytes")

    @property
    @pulumi.getter(name="nanoCpus")
    def nano_cpus(self) -> Optional[int]:
        return pulumi.get(self, "nano_cpus")


@pulumi.output_type
class ServiceTaskSpecResourcesReservation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "genericResources":
            suggest = "generic_resources"
        elif key == "memoryBytes":
            suggest = "memory_bytes"
        elif key == "nanoCpus":
            suggest = "nano_cpus"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecResourcesReservation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecResourcesReservation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecResourcesReservation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generic_resources: Optional['outputs.ServiceTaskSpecResourcesReservationGenericResources'] = None,
                 memory_bytes: Optional[int] = None,
                 nano_cpus: Optional[int] = None):
        if generic_resources is not None:
            pulumi.set(__self__, "generic_resources", generic_resources)
        if memory_bytes is not None:
            pulumi.set(__self__, "memory_bytes", memory_bytes)
        if nano_cpus is not None:
            pulumi.set(__self__, "nano_cpus", nano_cpus)

    @property
    @pulumi.getter(name="genericResources")
    def generic_resources(self) -> Optional['outputs.ServiceTaskSpecResourcesReservationGenericResources']:
        return pulumi.get(self, "generic_resources")

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> Optional[int]:
        return pulumi.get(self, "memory_bytes")

    @property
    @pulumi.getter(name="nanoCpus")
    def nano_cpus(self) -> Optional[int]:
        return pulumi.get(self, "nano_cpus")


@pulumi.output_type
class ServiceTaskSpecResourcesReservationGenericResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discreteResourcesSpecs":
            suggest = "discrete_resources_specs"
        elif key == "namedResourcesSpecs":
            suggest = "named_resources_specs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecResourcesReservationGenericResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecResourcesReservationGenericResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecResourcesReservationGenericResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 discrete_resources_specs: Optional[Sequence[str]] = None,
                 named_resources_specs: Optional[Sequence[str]] = None):
        if discrete_resources_specs is not None:
            pulumi.set(__self__, "discrete_resources_specs", discrete_resources_specs)
        if named_resources_specs is not None:
            pulumi.set(__self__, "named_resources_specs", named_resources_specs)

    @property
    @pulumi.getter(name="discreteResourcesSpecs")
    def discrete_resources_specs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "discrete_resources_specs")

    @property
    @pulumi.getter(name="namedResourcesSpecs")
    def named_resources_specs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "named_resources_specs")


@pulumi.output_type
class ServiceTaskSpecRestartPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecRestartPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecRestartPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecRestartPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional[str] = None,
                 delay: Optional[str] = None,
                 max_attempts: Optional[int] = None,
                 window: Optional[str] = None):
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def delay(self) -> Optional[str]:
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[int]:
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def window(self) -> Optional[str]:
        return pulumi.get(self, "window")


@pulumi.output_type
class ServiceUpdateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureAction":
            suggest = "failure_action"
        elif key == "maxFailureRatio":
            suggest = "max_failure_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceUpdateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceUpdateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceUpdateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay: Optional[str] = None,
                 failure_action: Optional[str] = None,
                 max_failure_ratio: Optional[str] = None,
                 monitor: Optional[str] = None,
                 order: Optional[str] = None,
                 parallelism: Optional[int] = None):
        """
        :param str delay: Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`.
        :param str failure_action: Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`.
        :param str max_failure_ratio: Failure rate to tolerate during an update. Defaults to `0.0`.
        :param str monitor: Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        :param str order: Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        :param int parallelism: Maximum number of tasks to be updated in one iteration. Defaults to `1`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if max_failure_ratio is not None:
            pulumi.set(__self__, "max_failure_ratio", max_failure_ratio)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)

    @property
    @pulumi.getter
    def delay(self) -> Optional[str]:
        """
        Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[str]:
        """
        Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`.
        """
        return pulumi.get(self, "failure_action")

    @property
    @pulumi.getter(name="maxFailureRatio")
    def max_failure_ratio(self) -> Optional[str]:
        """
        Failure rate to tolerate during an update. Defaults to `0.0`.
        """
        return pulumi.get(self, "max_failure_ratio")

    @property
    @pulumi.getter
    def monitor(self) -> Optional[str]:
        """
        Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        """
        Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[int]:
        """
        Maximum number of tasks to be updated in one iteration. Defaults to `1`
        """
        return pulumi.get(self, "parallelism")


@pulumi.output_type
class VolumeLabel(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Name of the label
        :param str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNetworkIpamConfigResult(dict):
    def __init__(__self__, *,
                 aux_address: Optional[Mapping[str, Any]] = None,
                 gateway: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 subnet: Optional[str] = None):
        if aux_address is not None:
            pulumi.set(__self__, "aux_address", aux_address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "aux_address")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        return pulumi.get(self, "subnet")


