# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AbolishDataServiceApiRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, api_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.api_id = api_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AbolishDataServiceApiRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class AbolishDataServiceApiResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AbolishDataServiceApiResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AbolishDataServiceApiResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AbolishDataServiceApiResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AbolishDataServiceApiResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AbolishDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddProjectMemberToRoleRequest(TeaModel):
    def __init__(self, project_id=None, user_id=None, role_code=None, client_token=None):
        self.project_id = project_id  # type: long
        self.user_id = user_id  # type: str
        self.role_code = role_code  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddProjectMemberToRoleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AddProjectMemberToRoleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddProjectMemberToRoleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddProjectMemberToRoleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddProjectMemberToRoleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddProjectMemberToRoleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddProjectMemberToRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddToMetaCategoryRequest(TeaModel):
    def __init__(self, category_id=None, table_guid=None):
        self.category_id = category_id  # type: long
        self.table_guid = table_guid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddToMetaCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class AddToMetaCategoryResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddToMetaCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddToMetaCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: AddToMetaCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddToMetaCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddToMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApprovePermissionApplyOrderRequest(TeaModel):
    def __init__(self, flow_id=None, approve_comment=None, approve_action=None):
        self.flow_id = flow_id  # type: str
        self.approve_comment = approve_comment  # type: str
        self.approve_action = approve_action  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApprovePermissionApplyOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.approve_comment is not None:
            result['ApproveComment'] = self.approve_comment
        if self.approve_action is not None:
            result['ApproveAction'] = self.approve_action
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('ApproveComment') is not None:
            self.approve_comment = m.get('ApproveComment')
        if m.get('ApproveAction') is not None:
            self.approve_action = m.get('ApproveAction')
        return self


class ApprovePermissionApplyOrderResponseBody(TeaModel):
    def __init__(self, approve_success=None, request_id=None):
        self.approve_success = approve_success  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApprovePermissionApplyOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approve_success is not None:
            result['ApproveSuccess'] = self.approve_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApproveSuccess') is not None:
            self.approve_success = m.get('ApproveSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApprovePermissionApplyOrderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ApprovePermissionApplyOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApprovePermissionApplyOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApprovePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckEngineMetaPartitionRequest(TeaModel):
    def __init__(self, table_guid=None, partition=None, data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.partition = partition  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckEngineMetaPartitionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.partition is not None:
            result['Partition'] = self.partition
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Partition') is not None:
            self.partition = m.get('Partition')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckEngineMetaPartitionResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckEngineMetaPartitionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckEngineMetaPartitionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckEngineMetaPartitionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckEngineMetaPartitionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckEngineMetaPartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckEngineMetaTableRequest(TeaModel):
    def __init__(self, table_guid=None, data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckEngineMetaTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckEngineMetaTableResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckEngineMetaTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckEngineMetaTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckEngineMetaTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckEngineMetaTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckEngineMetaTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckFileDeploymentRequest(TeaModel):
    def __init__(self, checker_instance_id=None, status=None, check_detail_url=None):
        self.checker_instance_id = checker_instance_id  # type: str
        self.status = status  # type: str
        self.check_detail_url = check_detail_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckFileDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checker_instance_id is not None:
            result['CheckerInstanceId'] = self.checker_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.check_detail_url is not None:
            result['CheckDetailUrl'] = self.check_detail_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckerInstanceId') is not None:
            self.checker_instance_id = m.get('CheckerInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CheckDetailUrl') is not None:
            self.check_detail_url = m.get('CheckDetailUrl')
        return self


class CheckFileDeploymentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckFileDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckFileDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckFileDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckFileDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckFileDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaPartitionRequest(TeaModel):
    def __init__(self, table_guid=None, partition=None, cluster_id=None, database_name=None, table_name=None,
                 data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.partition = partition  # type: str
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckMetaPartitionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.partition is not None:
            result['Partition'] = self.partition
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Partition') is not None:
            self.partition = m.get('Partition')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckMetaPartitionResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckMetaPartitionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckMetaPartitionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckMetaPartitionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckMetaPartitionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaPartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaTableRequest(TeaModel):
    def __init__(self, table_guid=None, cluster_id=None, database_name=None, table_name=None, data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckMetaTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckMetaTableResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckMetaTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckMetaTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckMetaTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckMetaTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaTableTaskResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckMetaTableTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckMetaTableTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckMetaTableTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckMetaTableTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaTableTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBusinessRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, business_name=None, description=None, owner=None,
                 use_type=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.business_name = business_name  # type: str
        self.description = description  # type: str
        self.owner = owner  # type: str
        self.use_type = use_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBusinessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class CreateBusinessResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 business_id=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.business_id = business_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBusinessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class CreateBusinessResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateBusinessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateBusinessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConnectionRequest(TeaModel):
    def __init__(self, project_id=None, name=None, description=None, connection_type=None, sub_type=None,
                 env_type=None, content=None):
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.description = description  # type: str
        self.connection_type = connection_type  # type: str
        self.sub_type = sub_type  # type: str
        self.env_type = env_type  # type: int
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConnectionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateConnectionResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, success=None):
        self.http_status_code = http_status_code  # type: str
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConnectionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConnectionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateConnectionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateConnectionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagComplementRequest(TeaModel):
    def __init__(self, project_env=None, start_biz_date=None, name=None, root_node_id=None, include_node_ids=None,
                 exclude_node_ids=None, biz_begin_time=None, biz_end_time=None, parallelism=None, end_biz_date=None,
                 node_params=None):
        self.project_env = project_env  # type: str
        self.start_biz_date = start_biz_date  # type: str
        self.name = name  # type: str
        self.root_node_id = root_node_id  # type: long
        self.include_node_ids = include_node_ids  # type: str
        self.exclude_node_ids = exclude_node_ids  # type: str
        self.biz_begin_time = biz_begin_time  # type: str
        self.biz_end_time = biz_end_time  # type: str
        self.parallelism = parallelism  # type: bool
        self.end_biz_date = end_biz_date  # type: str
        self.node_params = node_params  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDagComplementRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.start_biz_date is not None:
            result['StartBizDate'] = self.start_biz_date
        if self.name is not None:
            result['Name'] = self.name
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.biz_begin_time is not None:
            result['BizBeginTime'] = self.biz_begin_time
        if self.biz_end_time is not None:
            result['BizEndTime'] = self.biz_end_time
        if self.parallelism is not None:
            result['Parallelism'] = self.parallelism
        if self.end_biz_date is not None:
            result['EndBizDate'] = self.end_biz_date
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('StartBizDate') is not None:
            self.start_biz_date = m.get('StartBizDate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('BizBeginTime') is not None:
            self.biz_begin_time = m.get('BizBeginTime')
        if m.get('BizEndTime') is not None:
            self.biz_end_time = m.get('BizEndTime')
        if m.get('Parallelism') is not None:
            self.parallelism = m.get('Parallelism')
        if m.get('EndBizDate') is not None:
            self.end_biz_date = m.get('EndBizDate')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        return self


class CreateDagComplementResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDagComplementResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateDagComplementResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDagComplementResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDagComplementResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDagComplementResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagTestRequest(TeaModel):
    def __init__(self, project_env=None, bizdate=None, name=None, node_id=None, node_params=None):
        self.project_env = project_env  # type: str
        self.bizdate = bizdate  # type: str
        self.name = name  # type: str
        self.node_id = node_id  # type: long
        self.node_params = node_params  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDagTestRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        return self


class CreateDagTestResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: long
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDagTestResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDagTestResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDagTestResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDagTestResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDagTestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, api_name=None, group_id=None, api_mode=None,
                 request_method=None, response_content_type=None, timeout=None, visible_range=None, protocols=None,
                 wizard_details=None, script_details=None, registration_details=None, api_path=None, api_description=None,
                 folder_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.api_name = api_name  # type: str
        self.group_id = group_id  # type: str
        self.api_mode = api_mode  # type: int
        self.request_method = request_method  # type: int
        self.response_content_type = response_content_type  # type: int
        self.timeout = timeout  # type: int
        self.visible_range = visible_range  # type: int
        self.protocols = protocols  # type: str
        self.wizard_details = wizard_details  # type: str
        self.script_details = script_details  # type: str
        self.registration_details = registration_details  # type: str
        self.api_path = api_path  # type: str
        self.api_description = api_description  # type: str
        self.folder_id = folder_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceApiRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.api_description is not None:
            result['ApiDescription'] = self.api_description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('WizardDetails') is not None:
            self.wizard_details = m.get('WizardDetails')
        if m.get('ScriptDetails') is not None:
            self.script_details = m.get('ScriptDetails')
        if m.get('RegistrationDetails') is not None:
            self.registration_details = m.get('RegistrationDetails')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('ApiDescription') is not None:
            self.api_description = m.get('ApiDescription')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class CreateDataServiceApiResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: long
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceApiResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataServiceApiResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDataServiceApiResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataServiceApiResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiAuthorityRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, api_id=None, authorized_project_id=None, end_time=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.api_id = api_id  # type: long
        self.authorized_project_id = authorized_project_id  # type: long
        self.end_time = end_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceApiAuthorityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class CreateDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceApiAuthorityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceApiAuthorityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDataServiceApiAuthorityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataServiceApiAuthorityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceFolderRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, folder_name=None, parent_id=None, group_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.folder_name = folder_name  # type: str
        self.parent_id = parent_id  # type: long
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceFolderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateDataServiceFolderResponseBody(TeaModel):
    def __init__(self, folder_id=None, request_id=None):
        self.folder_id = folder_id  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceFolderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceFolderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDataServiceFolderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataServiceFolderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceGroupRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, api_gateway_group_id=None, group_name=None,
                 description=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.api_gateway_group_id = api_gateway_group_id  # type: str
        self.group_name = group_name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateDataServiceGroupResponseBody(TeaModel):
    def __init__(self, group_id=None, request_id=None):
        self.group_id = group_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataServiceGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDataServiceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataServiceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataSourceRequest(TeaModel):
    def __init__(self, project_id=None, name=None, description=None, data_source_type=None, sub_type=None,
                 env_type=None, content=None):
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.description = description  # type: str
        self.data_source_type = data_source_type  # type: str
        self.sub_type = sub_type  # type: str
        self.env_type = env_type  # type: int
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateDataSourceResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, success=None):
        self.http_status_code = http_status_code  # type: str
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataSourceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDISyncTaskRequest(TeaModel):
    def __init__(self, project_id=None, task_type=None, task_content=None, task_param=None, task_name=None,
                 client_token=None):
        self.project_id = project_id  # type: long
        self.task_type = task_type  # type: str
        self.task_content = task_content  # type: str
        self.task_param = task_param  # type: str
        self.task_name = task_name  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDISyncTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateDISyncTaskResponseBodyData(TeaModel):
    def __init__(self, status=None, message=None, file_id=None):
        self.status = status  # type: str
        self.message = message  # type: str
        self.file_id = file_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDISyncTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class CreateDISyncTaskResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: CreateDISyncTaskResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDISyncTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDISyncTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDISyncTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDISyncTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileRequest(TeaModel):
    def __init__(self, file_folder_path=None, project_id=None, file_name=None, file_description=None,
                 file_type=None, owner=None, content=None, auto_rerun_times=None, auto_rerun_interval_millis=None,
                 rerun_mode=None, stop=None, para_value=None, start_effect_date=None, end_effect_date=None, cron_express=None,
                 cycle_type=None, dependent_type=None, dependent_node_id_list=None, input_list=None, project_identifier=None,
                 resource_group_identifier=None, resource_group_id=None, connection_name=None, auto_parsing=None, scheduler_type=None):
        self.file_folder_path = file_folder_path  # type: str
        self.project_id = project_id  # type: long
        self.file_name = file_name  # type: str
        self.file_description = file_description  # type: str
        self.file_type = file_type  # type: int
        self.owner = owner  # type: str
        self.content = content  # type: str
        self.auto_rerun_times = auto_rerun_times  # type: int
        self.auto_rerun_interval_millis = auto_rerun_interval_millis  # type: int
        self.rerun_mode = rerun_mode  # type: str
        self.stop = stop  # type: bool
        self.para_value = para_value  # type: str
        self.start_effect_date = start_effect_date  # type: long
        self.end_effect_date = end_effect_date  # type: long
        self.cron_express = cron_express  # type: str
        self.cycle_type = cycle_type  # type: str
        self.dependent_type = dependent_type  # type: str
        self.dependent_node_id_list = dependent_node_id_list  # type: str
        self.input_list = input_list  # type: str
        self.project_identifier = project_identifier  # type: str
        self.resource_group_identifier = resource_group_identifier  # type: str
        self.resource_group_id = resource_group_id  # type: long
        self.connection_name = connection_name  # type: str
        self.auto_parsing = auto_parsing  # type: bool
        self.scheduler_type = scheduler_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.content is not None:
            result['Content'] = self.content
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.stop is not None:
            result['Stop'] = self.stop
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.input_list is not None:
            result['InputList'] = self.input_list
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.resource_group_identifier is not None:
            result['ResourceGroupIdentifier'] = self.resource_group_identifier
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('InputList') is not None:
            self.input_list = m.get('InputList')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ResourceGroupIdentifier') is not None:
            self.resource_group_identifier = m.get('ResourceGroupIdentifier')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class CreateFileResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFolderRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, folder_path=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.folder_path = folder_path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFolderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        return self


class CreateFolderResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFolderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateFolderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateFolderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFolderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImportMigrationRequest(TeaModel):
    def __init__(self, project_id=None, name=None, package_type=None, package_file=None, resource_group_map=None,
                 workspace_map=None, calculate_engine_map=None, commit_rule=None, description=None):
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.package_type = package_type  # type: str
        self.package_file = package_file  # type: str
        self.resource_group_map = resource_group_map  # type: str
        self.workspace_map = workspace_map  # type: str
        self.calculate_engine_map = calculate_engine_map  # type: str
        self.commit_rule = commit_rule  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImportMigrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_file is not None:
            result['PackageFile'] = self.package_file
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageFile') is not None:
            self.package_file = m.get('PackageFile')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateImportMigrationAdvanceRequest(TeaModel):
    def __init__(self, package_file_object=None, project_id=None, name=None, package_type=None,
                 resource_group_map=None, workspace_map=None, calculate_engine_map=None, commit_rule=None, description=None):
        self.package_file_object = package_file_object  # type: READABLE
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.package_type = package_type  # type: str
        self.resource_group_map = resource_group_map  # type: str
        self.workspace_map = workspace_map  # type: str
        self.calculate_engine_map = calculate_engine_map  # type: str
        self.commit_rule = commit_rule  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.package_file_object, 'package_file_object')

    def to_map(self):
        _map = super(CreateImportMigrationAdvanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_file_object is not None:
            result['PackageFileObject'] = self.package_file_object
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PackageFileObject') is not None:
            self.package_file_object = m.get('PackageFileObject')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateImportMigrationResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: long
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImportMigrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateImportMigrationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateImportMigrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateImportMigrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateImportMigrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateManualDagRequest(TeaModel):
    def __init__(self, project_env=None, project_name=None, flow_name=None, biz_date=None, node_parameters=None,
                 dag_parameters=None, include_node_ids=None, exclude_node_ids=None):
        self.project_env = project_env  # type: str
        self.project_name = project_name  # type: str
        self.flow_name = flow_name  # type: str
        self.biz_date = biz_date  # type: str
        self.node_parameters = node_parameters  # type: str
        self.dag_parameters = dag_parameters  # type: str
        self.include_node_ids = include_node_ids  # type: str
        self.exclude_node_ids = exclude_node_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateManualDagRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.node_parameters is not None:
            result['NodeParameters'] = self.node_parameters
        if self.dag_parameters is not None:
            result['DagParameters'] = self.dag_parameters
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('NodeParameters') is not None:
            self.node_parameters = m.get('NodeParameters')
        if m.get('DagParameters') is not None:
            self.dag_parameters = m.get('DagParameters')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        return self


class CreateManualDagResponseBody(TeaModel):
    def __init__(self, dag_id=None, request_id=None):
        self.dag_id = dag_id  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateManualDagResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateManualDagResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateManualDagResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateManualDagResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateManualDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetaCategoryRequest(TeaModel):
    def __init__(self, name=None, comment=None, parent_id=None):
        self.name = name  # type: str
        self.comment = comment  # type: str
        self.parent_id = parent_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetaCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateMetaCategoryResponseBodyData(TeaModel):
    def __init__(self, category_id=None):
        self.category_id = category_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetaCategoryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class CreateMetaCategoryResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: CreateMetaCategoryResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateMetaCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = CreateMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateMetaCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateMetaCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMetaCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePermissionApplyOrderRequestApplyObjectColumnMetaList(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePermissionApplyOrderRequestApplyObjectColumnMetaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequestApplyObject(TeaModel):
    def __init__(self, actions=None, column_meta_list=None, name=None):
        self.actions = actions  # type: str
        self.column_meta_list = column_meta_list  # type: list[CreatePermissionApplyOrderRequestApplyObjectColumnMetaList]
        self.name = name  # type: str

    def validate(self):
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreatePermissionApplyOrderRequestApplyObject, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actions is not None:
            result['Actions'] = self.actions
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Actions') is not None:
            self.actions = m.get('Actions')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = CreatePermissionApplyOrderRequestApplyObjectColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequest(TeaModel):
    def __init__(self, apply_user_ids=None, deadline=None, apply_reason=None, max_compute_project_name=None,
                 workspace_id=None, order_type=None, engine_type=None, apply_object=None):
        self.apply_user_ids = apply_user_ids  # type: str
        self.deadline = deadline  # type: long
        self.apply_reason = apply_reason  # type: str
        self.max_compute_project_name = max_compute_project_name  # type: str
        self.workspace_id = workspace_id  # type: int
        self.order_type = order_type  # type: int
        self.engine_type = engine_type  # type: str
        self.apply_object = apply_object  # type: list[CreatePermissionApplyOrderRequestApplyObject]

    def validate(self):
        if self.apply_object:
            for k in self.apply_object:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreatePermissionApplyOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_user_ids is not None:
            result['ApplyUserIds'] = self.apply_user_ids
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.engine_type is not None:
            result['EngineType'] = self.engine_type
        result['ApplyObject'] = []
        if self.apply_object is not None:
            for k in self.apply_object:
                result['ApplyObject'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyUserIds') is not None:
            self.apply_user_ids = m.get('ApplyUserIds')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('EngineType') is not None:
            self.engine_type = m.get('EngineType')
        self.apply_object = []
        if m.get('ApplyObject') is not None:
            for k in m.get('ApplyObject'):
                temp_model = CreatePermissionApplyOrderRequestApplyObject()
                self.apply_object.append(temp_model.from_map(k))
        return self


class CreatePermissionApplyOrderResponseBody(TeaModel):
    def __init__(self, request_id=None, flow_id=None):
        self.request_id = request_id  # type: str
        self.flow_id = flow_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePermissionApplyOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class CreatePermissionApplyOrderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreatePermissionApplyOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreatePermissionApplyOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProjectMemberRequest(TeaModel):
    def __init__(self, project_id=None, user_id=None, client_token=None, role_code=None):
        self.project_id = project_id  # type: long
        self.user_id = user_id  # type: str
        self.client_token = client_token  # type: str
        self.role_code = role_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProjectMemberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        return self


class CreateProjectMemberResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProjectMemberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateProjectMemberResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateProjectMemberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProjectMemberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityEntityRequest(TeaModel):
    def __init__(self, project_name=None, table_name=None, env_type=None, match_expression=None, entity_level=None):
        self.project_name = project_name  # type: str
        self.table_name = table_name  # type: str
        self.env_type = env_type  # type: str
        self.match_expression = match_expression  # type: str
        self.entity_level = entity_level  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityEntityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.entity_level is not None:
            result['EntityLevel'] = self.entity_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('EntityLevel') is not None:
            self.entity_level = m.get('EntityLevel')
        return self


class CreateQualityEntityResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityEntityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateQualityEntityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateQualityEntityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateQualityEntityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityFollowerRequest(TeaModel):
    def __init__(self, project_name=None, follower=None, alarm_mode=None, entity_id=None):
        self.project_name = project_name  # type: str
        self.follower = follower  # type: str
        self.alarm_mode = alarm_mode  # type: int
        self.entity_id = entity_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityFollowerRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.follower is not None:
            result['Follower'] = self.follower
        if self.alarm_mode is not None:
            result['AlarmMode'] = self.alarm_mode
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Follower') is not None:
            self.follower = m.get('Follower')
        if m.get('AlarmMode') is not None:
            self.alarm_mode = m.get('AlarmMode')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class CreateQualityFollowerResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityFollowerResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityFollowerResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateQualityFollowerResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateQualityFollowerResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRelativeNodeRequest(TeaModel):
    def __init__(self, env_type=None, match_expression=None, node_id=None, project_id=None,
                 target_node_project_name=None, project_name=None, table_name=None, target_node_project_id=None):
        self.env_type = env_type  # type: str
        self.match_expression = match_expression  # type: str
        self.node_id = node_id  # type: long
        self.project_id = project_id  # type: long
        self.target_node_project_name = target_node_project_name  # type: str
        self.project_name = project_name  # type: str
        self.table_name = table_name  # type: str
        self.target_node_project_id = target_node_project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityRelativeNodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        return self


class CreateQualityRelativeNodeResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityRelativeNodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateQualityRelativeNodeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateQualityRelativeNodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateQualityRelativeNodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRuleRequest(TeaModel):
    def __init__(self, block_type=None, entity_id=None, comment=None, checker=None, expect_value=None, trend=None,
                 method_name=None, operator=None, project_name=None, property=None, property_type=None, rule_type=None,
                 where_condition=None, critical_threshold=None, warning_threshold=None, template_id=None, rule_name=None,
                 predict_type=None):
        self.block_type = block_type  # type: int
        self.entity_id = entity_id  # type: long
        self.comment = comment  # type: str
        self.checker = checker  # type: int
        self.expect_value = expect_value  # type: str
        self.trend = trend  # type: str
        self.method_name = method_name  # type: str
        self.operator = operator  # type: str
        self.project_name = project_name  # type: str
        self.property = property  # type: str
        self.property_type = property_type  # type: str
        self.rule_type = rule_type  # type: int
        self.where_condition = where_condition  # type: str
        self.critical_threshold = critical_threshold  # type: str
        self.warning_threshold = warning_threshold  # type: str
        self.template_id = template_id  # type: int
        self.rule_name = rule_name  # type: str
        self.predict_type = predict_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.checker is not None:
            result['Checker'] = self.checker
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.property is not None:
            result['Property'] = self.property
        if self.property_type is not None:
            result['PropertyType'] = self.property_type
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.predict_type is not None:
            result['PredictType'] = self.predict_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Checker') is not None:
            self.checker = m.get('Checker')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('PropertyType') is not None:
            self.property_type = m.get('PropertyType')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('PredictType') is not None:
            self.predict_type = m.get('PredictType')
        return self


class CreateQualityRuleResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateQualityRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateQualityRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRemindRequest(TeaModel):
    def __init__(self, remind_name=None, dnd_end=None, remind_unit=None, node_ids=None, baseline_ids=None,
                 project_id=None, biz_process_ids=None, remind_type=None, max_alert_times=None, alert_interval=None,
                 detail=None, alert_unit=None, alert_methods=None, alert_targets=None, robot_urls=None):
        self.remind_name = remind_name  # type: str
        self.dnd_end = dnd_end  # type: str
        self.remind_unit = remind_unit  # type: str
        self.node_ids = node_ids  # type: str
        self.baseline_ids = baseline_ids  # type: str
        self.project_id = project_id  # type: long
        self.biz_process_ids = biz_process_ids  # type: str
        self.remind_type = remind_type  # type: str
        self.max_alert_times = max_alert_times  # type: int
        self.alert_interval = alert_interval  # type: int
        self.detail = detail  # type: str
        self.alert_unit = alert_unit  # type: str
        self.alert_methods = alert_methods  # type: str
        self.alert_targets = alert_targets  # type: str
        self.robot_urls = robot_urls  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRemindRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.dnd_end is not None:
            result['DndEnd'] = self.dnd_end
        if self.remind_unit is not None:
            result['RemindUnit'] = self.remind_unit
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        if self.baseline_ids is not None:
            result['BaselineIds'] = self.baseline_ids
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.biz_process_ids is not None:
            result['BizProcessIds'] = self.biz_process_ids
        if self.remind_type is not None:
            result['RemindType'] = self.remind_type
        if self.max_alert_times is not None:
            result['MaxAlertTimes'] = self.max_alert_times
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.alert_unit is not None:
            result['AlertUnit'] = self.alert_unit
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_targets is not None:
            result['AlertTargets'] = self.alert_targets
        if self.robot_urls is not None:
            result['RobotUrls'] = self.robot_urls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('DndEnd') is not None:
            self.dnd_end = m.get('DndEnd')
        if m.get('RemindUnit') is not None:
            self.remind_unit = m.get('RemindUnit')
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        if m.get('BaselineIds') is not None:
            self.baseline_ids = m.get('BaselineIds')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BizProcessIds') is not None:
            self.biz_process_ids = m.get('BizProcessIds')
        if m.get('RemindType') is not None:
            self.remind_type = m.get('RemindType')
        if m.get('MaxAlertTimes') is not None:
            self.max_alert_times = m.get('MaxAlertTimes')
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('AlertUnit') is not None:
            self.alert_unit = m.get('AlertUnit')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertTargets') is not None:
            self.alert_targets = m.get('AlertTargets')
        if m.get('RobotUrls') is not None:
            self.robot_urls = m.get('RobotUrls')
        return self


class CreateRemindResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: long
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRemindResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateRemindResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateRemindResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRemindResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableRequestColumns(TeaModel):
    def __init__(self, column_name_cn=None, column_name=None, comment=None, column_type=None, seq_number=None,
                 length=None, is_partition_col=None):
        self.column_name_cn = column_name_cn  # type: str
        self.column_name = column_name  # type: str
        self.comment = comment  # type: str
        self.column_type = column_type  # type: str
        self.seq_number = seq_number  # type: int
        self.length = length  # type: int
        self.is_partition_col = is_partition_col  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTableRequestColumns, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name_cn is not None:
            result['ColumnNameCn'] = self.column_name_cn
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.seq_number is not None:
            result['SeqNumber'] = self.seq_number
        if self.length is not None:
            result['Length'] = self.length
        if self.is_partition_col is not None:
            result['IsPartitionCol'] = self.is_partition_col
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnNameCn') is not None:
            self.column_name_cn = m.get('ColumnNameCn')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('SeqNumber') is not None:
            self.seq_number = m.get('SeqNumber')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('IsPartitionCol') is not None:
            self.is_partition_col = m.get('IsPartitionCol')
        return self


class CreateTableRequestThemes(TeaModel):
    def __init__(self, theme_id=None, theme_level=None):
        self.theme_id = theme_id  # type: long
        self.theme_level = theme_level  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTableRequestThemes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.theme_level is not None:
            result['ThemeLevel'] = self.theme_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ThemeLevel') is not None:
            self.theme_level = m.get('ThemeLevel')
        return self


class CreateTableRequest(TeaModel):
    def __init__(self, is_view=None, visibility=None, life_cycle=None, category_id=None, logical_level_id=None,
                 physics_level_id=None, external_table_type=None, location=None, project_id=None, table_name=None, endpoint=None,
                 env_type=None, app_guid=None, comment=None, owner_id=None, has_part=None, client_token=None, columns=None,
                 themes=None):
        self.is_view = is_view  # type: int
        self.visibility = visibility  # type: int
        self.life_cycle = life_cycle  # type: int
        self.category_id = category_id  # type: long
        self.logical_level_id = logical_level_id  # type: long
        self.physics_level_id = physics_level_id  # type: long
        self.external_table_type = external_table_type  # type: str
        self.location = location  # type: str
        self.project_id = project_id  # type: long
        self.table_name = table_name  # type: str
        self.endpoint = endpoint  # type: str
        self.env_type = env_type  # type: int
        self.app_guid = app_guid  # type: str
        self.comment = comment  # type: str
        self.owner_id = owner_id  # type: str
        self.has_part = has_part  # type: int
        self.client_token = client_token  # type: str
        self.columns = columns  # type: list[CreateTableRequestColumns]
        self.themes = themes  # type: list[CreateTableRequestThemes]

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()
        if self.themes:
            for k in self.themes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.visibility is not None:
            result['Visibility'] = self.visibility
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.logical_level_id is not None:
            result['LogicalLevelId'] = self.logical_level_id
        if self.physics_level_id is not None:
            result['PhysicsLevelId'] = self.physics_level_id
        if self.external_table_type is not None:
            result['ExternalTableType'] = self.external_table_type
        if self.location is not None:
            result['Location'] = self.location
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.has_part is not None:
            result['HasPart'] = self.has_part
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        result['Themes'] = []
        if self.themes is not None:
            for k in self.themes:
                result['Themes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('Visibility') is not None:
            self.visibility = m.get('Visibility')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('LogicalLevelId') is not None:
            self.logical_level_id = m.get('LogicalLevelId')
        if m.get('PhysicsLevelId') is not None:
            self.physics_level_id = m.get('PhysicsLevelId')
        if m.get('ExternalTableType') is not None:
            self.external_table_type = m.get('ExternalTableType')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HasPart') is not None:
            self.has_part = m.get('HasPart')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = CreateTableRequestColumns()
                self.columns.append(temp_model.from_map(k))
        self.themes = []
        if m.get('Themes') is not None:
            for k in m.get('Themes'):
                temp_model = CreateTableRequestThemes()
                self.themes.append(temp_model.from_map(k))
        return self


class CreateTableResponseBodyTaskInfo(TeaModel):
    def __init__(self, status=None, next_task_id=None, task_id=None, content=None):
        self.status = status  # type: str
        self.next_task_id = next_task_id  # type: str
        self.task_id = task_id  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTableResponseBodyTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateTableResponseBody(TeaModel):
    def __init__(self, request_id=None, task_info=None):
        self.request_id = request_id  # type: str
        self.task_info = task_info  # type: CreateTableResponseBodyTaskInfo

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super(CreateTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableLevelRequest(TeaModel):
    def __init__(self, project_id=None, level_type=None, name=None, description=None):
        self.project_id = project_id  # type: long
        self.level_type = level_type  # type: int
        self.name = name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTableLevelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateTableLevelResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 level_id=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.level_id = level_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTableLevelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        return self


class CreateTableLevelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateTableLevelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTableLevelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableThemeRequest(TeaModel):
    def __init__(self, project_id=None, level=None, name=None, parent_id=None):
        self.project_id = project_id  # type: long
        self.level = level  # type: int
        self.name = name  # type: str
        self.parent_id = parent_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTableThemeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateTableThemeResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 theme_id=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.theme_id = theme_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTableThemeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class CreateTableThemeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateTableThemeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTableThemeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUdfFileRequest(TeaModel):
    def __init__(self, file_folder_path=None, project_id=None, file_name=None, function_type=None, class_name=None,
                 resources=None, udf_description=None, cmd_description=None, parameter_description=None, return_value=None,
                 example=None, project_identifier=None):
        self.file_folder_path = file_folder_path  # type: str
        self.project_id = project_id  # type: long
        self.file_name = file_name  # type: str
        self.function_type = function_type  # type: str
        self.class_name = class_name  # type: str
        self.resources = resources  # type: str
        self.udf_description = udf_description  # type: str
        self.cmd_description = cmd_description  # type: str
        self.parameter_description = parameter_description  # type: str
        self.return_value = return_value  # type: str
        self.example = example  # type: str
        self.project_identifier = project_identifier  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUdfFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.function_type is not None:
            result['FunctionType'] = self.function_type
        if self.class_name is not None:
            result['ClassName'] = self.class_name
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.udf_description is not None:
            result['UdfDescription'] = self.udf_description
        if self.cmd_description is not None:
            result['CmdDescription'] = self.cmd_description
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.return_value is not None:
            result['ReturnValue'] = self.return_value
        if self.example is not None:
            result['Example'] = self.example
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FunctionType') is not None:
            self.function_type = m.get('FunctionType')
        if m.get('ClassName') is not None:
            self.class_name = m.get('ClassName')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('UdfDescription') is not None:
            self.udf_description = m.get('UdfDescription')
        if m.get('CmdDescription') is not None:
            self.cmd_description = m.get('CmdDescription')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ReturnValue') is not None:
            self.return_value = m.get('ReturnValue')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class CreateUdfFileResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUdfFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateUdfFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateUdfFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUdfFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUdfFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateViewRequestViewColumn(TeaModel):
    def __init__(self, column_name=None, comment=None):
        self.column_name = column_name  # type: str
        self.comment = comment  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateViewRequestViewColumn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.comment is not None:
            result['Comment'] = self.comment
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        return self


class CreateViewRequest(TeaModel):
    def __init__(self, view_name=None, select_column=None, select_table_name=None, select_where=None,
                 select_sql=None, app_guid=None, comment=None, client_token=None, view_column=None):
        self.view_name = view_name  # type: str
        self.select_column = select_column  # type: str
        self.select_table_name = select_table_name  # type: str
        self.select_where = select_where  # type: str
        self.select_sql = select_sql  # type: str
        self.app_guid = app_guid  # type: str
        self.comment = comment  # type: str
        self.client_token = client_token  # type: str
        self.view_column = view_column  # type: list[CreateViewRequestViewColumn]

    def validate(self):
        if self.view_column:
            for k in self.view_column:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.view_name is not None:
            result['ViewName'] = self.view_name
        if self.select_column is not None:
            result['SelectColumn'] = self.select_column
        if self.select_table_name is not None:
            result['SelectTableName'] = self.select_table_name
        if self.select_where is not None:
            result['SelectWhere'] = self.select_where
        if self.select_sql is not None:
            result['SelectSQL'] = self.select_sql
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['ViewColumn'] = []
        if self.view_column is not None:
            for k in self.view_column:
                result['ViewColumn'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ViewName') is not None:
            self.view_name = m.get('ViewName')
        if m.get('SelectColumn') is not None:
            self.select_column = m.get('SelectColumn')
        if m.get('SelectTableName') is not None:
            self.select_table_name = m.get('SelectTableName')
        if m.get('SelectWhere') is not None:
            self.select_where = m.get('SelectWhere')
        if m.get('SelectSQL') is not None:
            self.select_sql = m.get('SelectSQL')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.view_column = []
        if m.get('ViewColumn') is not None:
            for k in m.get('ViewColumn'):
                temp_model = CreateViewRequestViewColumn()
                self.view_column.append(temp_model.from_map(k))
        return self


class CreateViewResponseBodyTaskInfo(TeaModel):
    def __init__(self, status=None, next_task_id=None, task_id=None, content=None):
        self.status = status  # type: str
        self.next_task_id = next_task_id  # type: str
        self.task_id = task_id  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateViewResponseBodyTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateViewResponseBody(TeaModel):
    def __init__(self, request_id=None, task_info=None):
        self.request_id = request_id  # type: str
        self.task_info = task_info  # type: CreateViewResponseBodyTaskInfo

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super(CreateViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateViewResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateViewResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBusinessRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, business_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.business_id = business_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBusinessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class DeleteBusinessResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBusinessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteBusinessResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteBusinessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBusinessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConnectionRequest(TeaModel):
    def __init__(self, connection_id=None):
        self.connection_id = connection_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConnectionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class DeleteConnectionResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, success=None):
        self.http_status_code = http_status_code  # type: str
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConnectionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConnectionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteConnectionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteConnectionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, api_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.api_id = api_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataServiceApiRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class DeleteDataServiceApiResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataServiceApiResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataServiceApiResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDataServiceApiResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDataServiceApiResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiAuthorityRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, api_id=None, authorized_project_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.api_id = api_id  # type: long
        self.authorized_project_id = authorized_project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataServiceApiAuthorityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        return self


class DeleteDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataServiceApiAuthorityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDataServiceApiAuthorityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDataServiceApiAuthorityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDataServiceApiAuthorityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None):
        self.data_source_id = data_source_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class DeleteDataSourceResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, success=None):
        self.http_status_code = http_status_code  # type: str
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDataSourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataSourceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDataSourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDISyncTaskRequest(TeaModel):
    def __init__(self, project_id=None, task_type=None, file_id=None):
        self.project_id = project_id  # type: long
        self.task_type = task_type  # type: str
        self.file_id = file_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDISyncTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDISyncTaskResponseBodyData(TeaModel):
    def __init__(self, status=None, message=None):
        self.status = status  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDISyncTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeleteDISyncTaskResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: DeleteDISyncTaskResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeleteDISyncTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DeleteDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteDISyncTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDISyncTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDISyncTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFileRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, file_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.file_id = file_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteFileResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFolderRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, folder_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.folder_id = folder_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFolderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class DeleteFolderResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFolderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFolderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFolderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFolderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFromMetaCategoryRequest(TeaModel):
    def __init__(self, category_id=None, table_guid=None):
        self.category_id = category_id  # type: long
        self.table_guid = table_guid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFromMetaCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class DeleteFromMetaCategoryResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFromMetaCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFromMetaCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteFromMetaCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFromMetaCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFromMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetaCategoryRequest(TeaModel):
    def __init__(self, category_id=None):
        self.category_id = category_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetaCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DeleteMetaCategoryResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetaCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetaCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteMetaCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMetaCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProjectMemberRequest(TeaModel):
    def __init__(self, project_id=None, user_id=None):
        self.project_id = project_id  # type: long
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProjectMemberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DeleteProjectMemberResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProjectMemberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteProjectMemberResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteProjectMemberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProjectMemberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityEntityRequest(TeaModel):
    def __init__(self, entity_id=None, project_name=None, env_type=None):
        self.entity_id = entity_id  # type: long
        self.project_name = project_name  # type: str
        self.env_type = env_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityEntityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class DeleteQualityEntityResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityEntityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeleteQualityEntityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteQualityEntityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteQualityEntityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityFollowerRequest(TeaModel):
    def __init__(self, project_name=None, follower_id=None):
        self.project_name = project_name  # type: str
        self.follower_id = follower_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityFollowerRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.follower_id is not None:
            result['FollowerId'] = self.follower_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('FollowerId') is not None:
            self.follower_id = m.get('FollowerId')
        return self


class DeleteQualityFollowerResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityFollowerResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityFollowerResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteQualityFollowerResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteQualityFollowerResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRelativeNodeRequest(TeaModel):
    def __init__(self, env_type=None, match_expression=None, node_id=None, project_id=None,
                 target_node_project_name=None, project_name=None, table_name=None, target_node_project_id=None):
        self.env_type = env_type  # type: str
        self.match_expression = match_expression  # type: str
        self.node_id = node_id  # type: long
        self.project_id = project_id  # type: long
        self.target_node_project_name = target_node_project_name  # type: str
        self.project_name = project_name  # type: str
        self.table_name = table_name  # type: str
        self.target_node_project_id = target_node_project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityRelativeNodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        return self


class DeleteQualityRelativeNodeResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityRelativeNodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeleteQualityRelativeNodeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteQualityRelativeNodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteQualityRelativeNodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRuleRequest(TeaModel):
    def __init__(self, project_name=None, rule_id=None):
        self.project_name = project_name  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteQualityRuleResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteQualityRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteQualityRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRemindRequest(TeaModel):
    def __init__(self, remind_id=None):
        self.remind_id = remind_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRemindRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class DeleteRemindResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRemindResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeleteRemindResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteRemindResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRemindResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableRequest(TeaModel):
    def __init__(self, project_id=None, table_name=None, env_type=None, app_guid=None):
        self.project_id = project_id  # type: long
        self.table_name = table_name  # type: str
        self.env_type = env_type  # type: int
        self.app_guid = app_guid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        return self


class DeleteTableResponseBodyTaskInfo(TeaModel):
    def __init__(self, status=None, next_task_id=None, task_id=None, content=None):
        self.status = status  # type: str
        self.next_task_id = next_task_id  # type: str
        self.task_id = task_id  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTableResponseBodyTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DeleteTableResponseBody(TeaModel):
    def __init__(self, request_id=None, task_info=None):
        self.request_id = request_id  # type: str
        self.task_info = task_info  # type: DeleteTableResponseBodyTaskInfo

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super(DeleteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class DeleteTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableLevelRequest(TeaModel):
    def __init__(self, level_id=None, project_id=None):
        self.level_id = level_id  # type: long
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTableLevelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableLevelResponseBody(TeaModel):
    def __init__(self, delete_result=None, request_id=None):
        self.delete_result = delete_result  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTableLevelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTableLevelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteTableLevelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTableLevelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableThemeRequest(TeaModel):
    def __init__(self, theme_id=None, project_id=None):
        self.theme_id = theme_id  # type: long
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTableThemeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableThemeResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 delete_result=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.delete_result = delete_result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTableThemeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        return self


class DeleteTableThemeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteTableThemeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTableThemeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteViewRequest(TeaModel):
    def __init__(self, view_name=None, app_guid=None):
        self.view_name = view_name  # type: str
        self.app_guid = app_guid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.view_name is not None:
            result['ViewName'] = self.view_name
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ViewName') is not None:
            self.view_name = m.get('ViewName')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        return self


class DeleteViewResponseBodyTaskInfo(TeaModel):
    def __init__(self, status=None, next_task_id=None, task_id=None, content=None):
        self.status = status  # type: str
        self.next_task_id = next_task_id  # type: str
        self.task_id = task_id  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteViewResponseBodyTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DeleteViewResponseBody(TeaModel):
    def __init__(self, request_id=None, task_info=None):
        self.request_id = request_id  # type: str
        self.task_info = task_info  # type: DeleteViewResponseBodyTaskInfo

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super(DeleteViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteViewResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class DeleteViewResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployDISyncTaskRequest(TeaModel):
    def __init__(self, project_id=None, task_type=None, file_id=None):
        self.project_id = project_id  # type: long
        self.task_type = task_type  # type: str
        self.file_id = file_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeployDISyncTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeployDISyncTaskResponseBodyData(TeaModel):
    def __init__(self, status=None, message=None):
        self.status = status  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeployDISyncTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeployDISyncTaskResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: DeployDISyncTaskResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeployDISyncTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DeployDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeployDISyncTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeployDISyncTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeployDISyncTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeployDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployFileRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, file_id=None, comment=None, node_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.file_id = file_id  # type: long
        self.comment = comment  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeployFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DeployFileResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, request_id=None, error_message=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeployFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeployFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeployFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeployFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeployFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DesensitizeDataRequest(TeaModel):
    def __init__(self, data=None, scene_code=None):
        self.data = data  # type: str
        self.scene_code = scene_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DesensitizeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.scene_code is not None:
            result['SceneCode'] = self.scene_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('SceneCode') is not None:
            self.scene_code = m.get('SceneCode')
        return self


class DesensitizeDataResponseBody(TeaModel):
    def __init__(self, desensitize_data=None, request_id=None):
        self.desensitize_data = desensitize_data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DesensitizeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desensitize_data is not None:
            result['DesensitizeData'] = self.desensitize_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DesensitizeData') is not None:
            self.desensitize_data = m.get('DesensitizeData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DesensitizeDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DesensitizeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DesensitizeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DesensitizeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EstablishRelationTableToBusinessRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, business_id=None, table_guid=None, folder_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.business_id = business_id  # type: str
        self.table_guid = table_guid  # type: str
        self.folder_id = folder_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EstablishRelationTableToBusinessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class EstablishRelationTableToBusinessResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EstablishRelationTableToBusinessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EstablishRelationTableToBusinessResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EstablishRelationTableToBusinessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EstablishRelationTableToBusinessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EstablishRelationTableToBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportConnectionsRequest(TeaModel):
    def __init__(self, project_id=None, name=None, data_source_type=None, sub_type=None, env_type=None,
                 page_size=None, page_number=None):
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.data_source_type = data_source_type  # type: str
        self.sub_type = sub_type  # type: str
        self.env_type = env_type  # type: int
        self.page_size = page_size  # type: int
        self.page_number = page_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportConnectionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ExportConnectionsResponseBodyDataDataSources(TeaModel):
    def __init__(self, status=None, project_id=None, sub_type=None, gmt_modified=None, env_type=None,
                 connect_status=None, sequence=None, description=None, data_source_type=None, gmt_create=None, default_engine=None,
                 shared=None, operator=None, name=None, content=None, id=None, binding_calc_engine_id=None, tenant_id=None):
        self.status = status  # type: int
        self.project_id = project_id  # type: int
        self.sub_type = sub_type  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.env_type = env_type  # type: int
        self.connect_status = connect_status  # type: int
        self.sequence = sequence  # type: int
        self.description = description  # type: str
        self.data_source_type = data_source_type  # type: str
        self.gmt_create = gmt_create  # type: str
        self.default_engine = default_engine  # type: bool
        self.shared = shared  # type: bool
        self.operator = operator  # type: str
        self.name = name  # type: str
        self.content = content  # type: str
        self.id = id  # type: int
        self.binding_calc_engine_id = binding_calc_engine_id  # type: int
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportConnectionsResponseBodyDataDataSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.name is not None:
            result['Name'] = self.name
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ExportConnectionsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, data_sources=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.data_sources = data_sources  # type: list[ExportConnectionsResponseBodyDataDataSources]

    def validate(self):
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ExportConnectionsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportConnectionsResponseBodyDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        return self


class ExportConnectionsResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ExportConnectionsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ExportConnectionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ExportConnectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ExportConnectionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ExportConnectionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExportConnectionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportDataSourcesRequest(TeaModel):
    def __init__(self, project_id=None, name=None, data_source_type=None, sub_type=None, env_type=None,
                 page_size=None, page_number=None):
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.data_source_type = data_source_type  # type: str
        self.sub_type = sub_type  # type: str
        self.env_type = env_type  # type: int
        self.page_size = page_size  # type: int
        self.page_number = page_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportDataSourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ExportDataSourcesResponseBodyDataDataSources(TeaModel):
    def __init__(self, status=None, project_id=None, sub_type=None, gmt_modified=None, env_type=None,
                 connect_status=None, sequence=None, description=None, data_source_type=None, gmt_create=None, default_engine=None,
                 shared=None, operator=None, name=None, content=None, id=None, binding_calc_engine_id=None, tenant_id=None):
        self.status = status  # type: int
        self.project_id = project_id  # type: int
        self.sub_type = sub_type  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.env_type = env_type  # type: int
        self.connect_status = connect_status  # type: int
        self.sequence = sequence  # type: int
        self.description = description  # type: str
        self.data_source_type = data_source_type  # type: str
        self.gmt_create = gmt_create  # type: str
        self.default_engine = default_engine  # type: bool
        self.shared = shared  # type: bool
        self.operator = operator  # type: str
        self.name = name  # type: str
        self.content = content  # type: str
        self.id = id  # type: int
        self.binding_calc_engine_id = binding_calc_engine_id  # type: int
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportDataSourcesResponseBodyDataDataSources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.name is not None:
            result['Name'] = self.name
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ExportDataSourcesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, data_sources=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.data_sources = data_sources  # type: list[ExportDataSourcesResponseBodyDataDataSources]

    def validate(self):
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ExportDataSourcesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportDataSourcesResponseBodyDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        return self


class ExportDataSourcesResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ExportDataSourcesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ExportDataSourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ExportDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ExportDataSourcesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ExportDataSourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExportDataSourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportDISyncTasksRequest(TeaModel):
    def __init__(self, project_id=None, task_type=None, task_param=None):
        self.project_id = project_id  # type: long
        self.task_type = task_type  # type: str
        self.task_param = task_param  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportDISyncTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        return self


class ExportDISyncTasksResponseBodyTaskDetail(TeaModel):
    def __init__(self, real_time_solution=None):
        self.real_time_solution = real_time_solution  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportDISyncTasksResponseBodyTaskDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.real_time_solution is not None:
            result['RealTimeSolution'] = self.real_time_solution
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RealTimeSolution') is not None:
            self.real_time_solution = m.get('RealTimeSolution')
        return self


class ExportDISyncTasksResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, task_detail=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.task_detail = task_detail  # type: ExportDISyncTasksResponseBodyTaskDetail

    def validate(self):
        if self.task_detail:
            self.task_detail.validate()

    def to_map(self):
        _map = super(ExportDISyncTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_detail is not None:
            result['TaskDetail'] = self.task_detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskDetail') is not None:
            temp_model = ExportDISyncTasksResponseBodyTaskDetail()
            self.task_detail = temp_model.from_map(m['TaskDetail'])
        return self


class ExportDISyncTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ExportDISyncTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExportDISyncTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportDISyncTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineConfigRequest(TeaModel):
    def __init__(self, baseline_id=None):
        self.baseline_id = baseline_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetBaselineConfigResponseBodyData(TeaModel):
    def __init__(self, hour_sla_detail=None, is_default=None, owner=None, project_id=None, priority=None,
                 sla_minu=None, sla_hour=None, baseline_id=None, baseline_name=None, hour_exp_detail=None, use_flag=None,
                 exp_hour=None, baseline_type=None, exp_minu=None):
        self.hour_sla_detail = hour_sla_detail  # type: str
        self.is_default = is_default  # type: bool
        self.owner = owner  # type: str
        self.project_id = project_id  # type: long
        self.priority = priority  # type: int
        self.sla_minu = sla_minu  # type: int
        self.sla_hour = sla_hour  # type: int
        self.baseline_id = baseline_id  # type: long
        self.baseline_name = baseline_name  # type: str
        self.hour_exp_detail = hour_exp_detail  # type: str
        self.use_flag = use_flag  # type: bool
        self.exp_hour = exp_hour  # type: int
        self.baseline_type = baseline_type  # type: str
        self.exp_minu = exp_minu  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineConfigResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        return self


class GetBaselineConfigResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetBaselineConfigResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetBaselineConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetBaselineConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetBaselineConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetBaselineConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetBaselineConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineKeyPathRequest(TeaModel):
    def __init__(self, baseline_id=None, bizdate=None, in_group_id=None):
        self.baseline_id = baseline_id  # type: long
        self.bizdate = bizdate  # type: str
        self.in_group_id = in_group_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineKeyPathRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineKeyPathResponseBodyDataRuns(TeaModel):
    def __init__(self, status=None, abs_time=None, begin_running_time=None, cyc_time=None, owner=None,
                 finish_time=None, project_id=None, begin_cast=None, instance_id=None, end_cast=None, begin_wait_res_time=None,
                 in_group_id=None, node_name=None, bizdate=None, begin_wait_time_time=None, node_id=None):
        self.status = status  # type: str
        self.abs_time = abs_time  # type: long
        self.begin_running_time = begin_running_time  # type: long
        self.cyc_time = cyc_time  # type: long
        self.owner = owner  # type: str
        self.finish_time = finish_time  # type: long
        self.project_id = project_id  # type: long
        self.begin_cast = begin_cast  # type: long
        self.instance_id = instance_id  # type: long
        self.end_cast = end_cast  # type: long
        self.begin_wait_res_time = begin_wait_res_time  # type: long
        self.in_group_id = in_group_id  # type: int
        self.node_name = node_name  # type: str
        self.bizdate = bizdate  # type: long
        self.begin_wait_time_time = begin_wait_time_time  # type: long
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineKeyPathResponseBodyDataRuns, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.abs_time is not None:
            result['AbsTime'] = self.abs_time
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.begin_cast is not None:
            result['BeginCast'] = self.begin_cast
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AbsTime') is not None:
            self.abs_time = m.get('AbsTime')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BeginCast') is not None:
            self.begin_cast = m.get('BeginCast')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetBaselineKeyPathResponseBodyDataTopics(TeaModel):
    def __init__(self, topic_name=None, instance_id=None, topic_id=None, add_time=None):
        self.topic_name = topic_name  # type: long
        self.instance_id = instance_id  # type: long
        self.topic_id = topic_id  # type: long
        self.add_time = add_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineKeyPathResponseBodyDataTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        return self


class GetBaselineKeyPathResponseBodyData(TeaModel):
    def __init__(self, owner=None, node_name=None, bizdate=None, project_id=None, instance_id=None, prg_type=None,
                 node_id=None, in_group_id=None, runs=None, topics=None):
        self.owner = owner  # type: str
        self.node_name = node_name  # type: str
        self.bizdate = bizdate  # type: long
        self.project_id = project_id  # type: long
        self.instance_id = instance_id  # type: long
        self.prg_type = prg_type  # type: int
        self.node_id = node_id  # type: long
        self.in_group_id = in_group_id  # type: int
        self.runs = runs  # type: list[GetBaselineKeyPathResponseBodyDataRuns]
        self.topics = topics  # type: list[GetBaselineKeyPathResponseBodyDataTopics]

    def validate(self):
        if self.runs:
            for k in self.runs:
                if k:
                    k.validate()
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetBaselineKeyPathResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        result['Runs'] = []
        if self.runs is not None:
            for k in self.runs:
                result['Runs'].append(k.to_map() if k else None)
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        self.runs = []
        if m.get('Runs') is not None:
            for k in m.get('Runs'):
                temp_model = GetBaselineKeyPathResponseBodyDataRuns()
                self.runs.append(temp_model.from_map(k))
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = GetBaselineKeyPathResponseBodyDataTopics()
                self.topics.append(temp_model.from_map(k))
        return self


class GetBaselineKeyPathResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: list[GetBaselineKeyPathResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetBaselineKeyPathResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetBaselineKeyPathResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetBaselineKeyPathResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetBaselineKeyPathResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetBaselineKeyPathResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineKeyPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineStatusRequest(TeaModel):
    def __init__(self, baseline_id=None, bizdate=None, in_group_id=None):
        self.baseline_id = baseline_id  # type: long
        self.bizdate = bizdate  # type: str
        self.in_group_id = in_group_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineStatusResponseBodyDataLastInstance(TeaModel):
    def __init__(self, status=None, owner=None, finish_time=None, node_name=None, project_id=None, instance_id=None,
                 end_cast=None, node_id=None):
        self.status = status  # type: str
        self.owner = owner  # type: str
        self.finish_time = finish_time  # type: long
        self.node_name = node_name  # type: str
        self.project_id = project_id  # type: long
        self.instance_id = instance_id  # type: long
        self.end_cast = end_cast  # type: long
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineStatusResponseBodyDataLastInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetBaselineStatusResponseBodyDataBlockInstance(TeaModel):
    def __init__(self, status=None, owner=None, finish_time=None, node_name=None, project_id=None, instance_id=None,
                 end_cast=None, node_id=None):
        self.status = status  # type: str
        self.owner = owner  # type: str
        self.finish_time = finish_time  # type: long
        self.node_name = node_name  # type: str
        self.project_id = project_id  # type: long
        self.instance_id = instance_id  # type: long
        self.end_cast = end_cast  # type: long
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBaselineStatusResponseBodyDataBlockInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetBaselineStatusResponseBodyData(TeaModel):
    def __init__(self, status=None, owner=None, finish_time=None, project_id=None, priority=None, end_cast=None,
                 in_group_id=None, baseline_name=None, baseline_id=None, finish_status=None, bizdate=None, buffer=None,
                 sla_time=None, exp_time=None, last_instance=None, block_instance=None):
        self.status = status  # type: str
        self.owner = owner  # type: str
        self.finish_time = finish_time  # type: long
        self.project_id = project_id  # type: long
        self.priority = priority  # type: int
        self.end_cast = end_cast  # type: long
        self.in_group_id = in_group_id  # type: int
        self.baseline_name = baseline_name  # type: str
        self.baseline_id = baseline_id  # type: long
        self.finish_status = finish_status  # type: str
        self.bizdate = bizdate  # type: long
        self.buffer = buffer  # type: float
        self.sla_time = sla_time  # type: long
        self.exp_time = exp_time  # type: long
        self.last_instance = last_instance  # type: GetBaselineStatusResponseBodyDataLastInstance
        self.block_instance = block_instance  # type: GetBaselineStatusResponseBodyDataBlockInstance

    def validate(self):
        if self.last_instance:
            self.last_instance.validate()
        if self.block_instance:
            self.block_instance.validate()

    def to_map(self):
        _map = super(GetBaselineStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.sla_time is not None:
            result['SlaTime'] = self.sla_time
        if self.exp_time is not None:
            result['ExpTime'] = self.exp_time
        if self.last_instance is not None:
            result['LastInstance'] = self.last_instance.to_map()
        if self.block_instance is not None:
            result['BlockInstance'] = self.block_instance.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('SlaTime') is not None:
            self.sla_time = m.get('SlaTime')
        if m.get('ExpTime') is not None:
            self.exp_time = m.get('ExpTime')
        if m.get('LastInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataLastInstance()
            self.last_instance = temp_model.from_map(m['LastInstance'])
        if m.get('BlockInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataBlockInstance()
            self.block_instance = temp_model.from_map(m['BlockInstance'])
        return self


class GetBaselineStatusResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetBaselineStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetBaselineStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetBaselineStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetBaselineStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetBaselineStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetBaselineStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBusinessRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, business_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.business_id = business_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBusinessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class GetBusinessResponseBodyData(TeaModel):
    def __init__(self, owner=None, description=None, project_id=None, business_id=None, business_name=None,
                 use_type=None):
        self.owner = owner  # type: str
        self.description = description  # type: str
        self.project_id = project_id  # type: str
        self.business_id = business_id  # type: long
        self.business_name = business_name  # type: str
        self.use_type = use_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBusinessResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.description is not None:
            result['Description'] = self.description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetBusinessResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetBusinessResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetBusinessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetBusinessResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetBusinessResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetBusinessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetBusinessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConnectionMetaRequest(TeaModel):
    def __init__(self, project_id=None, datasource_name=None, page_number=None, page_size=None, env_type=None):
        self.project_id = project_id  # type: long
        self.datasource_name = datasource_name  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.env_type = env_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetConnectionMetaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class GetConnectionMetaResponseBodyData(TeaModel):
    def __init__(self, meta=None):
        self.meta = meta  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetConnectionMetaResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.meta is not None:
            result['Meta'] = self.meta
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        return self


class GetConnectionMetaResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: GetConnectionMetaResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetConnectionMetaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetConnectionMetaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetConnectionMetaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetConnectionMetaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetConnectionMetaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConnectionMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDagRequest(TeaModel):
    def __init__(self, dag_id=None, project_env=None):
        self.dag_id = dag_id  # type: long
        self.project_env = project_env  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDagRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetDagResponseBodyData(TeaModel):
    def __init__(self, type=None, status=None, finish_time=None, create_time=None, project_id=None, dag_id=None,
                 gmtdate=None, start_time=None, create_user=None, bizdate=None, name=None, modify_time=None):
        self.type = type  # type: str
        self.status = status  # type: str
        self.finish_time = finish_time  # type: long
        self.create_time = create_time  # type: long
        self.project_id = project_id  # type: long
        self.dag_id = dag_id  # type: long
        self.gmtdate = gmtdate  # type: long
        self.start_time = start_time  # type: long
        self.create_user = create_user  # type: str
        self.bizdate = bizdate  # type: long
        self.name = name  # type: str
        self.modify_time = modify_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDagResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.gmtdate is not None:
            result['Gmtdate'] = self.gmtdate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('Gmtdate') is not None:
            self.gmtdate = m.get('Gmtdate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetDagResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetDagResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDagResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDagResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDagResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDagResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDagResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApiRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, api_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.api_id = api_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(self, error_message=None, error_code=None, error_solution=None):
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.error_solution = error_solution  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(self, column_name=None, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, parameter_data_type=None, example_value=None,
                 is_required_parameter=None):
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(self, service_host=None, service_content_type=None, service_path=None,
                 successful_result_sample=None, failed_result_sample=None, service_request_body_description=None,
                 registration_error_codes=None, registration_request_parameters=None):
        self.service_host = service_host  # type: str
        self.service_content_type = service_content_type  # type: int
        self.service_path = service_path  # type: str
        self.successful_result_sample = successful_result_sample  # type: str
        self.failed_result_sample = failed_result_sample  # type: str
        self.service_request_body_description = service_request_body_description  # type: str
        self.registration_error_codes = registration_error_codes  # type: list[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes]
        self.registration_request_parameters = registration_request_parameters  # type: list[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters]

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataRegistrationDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(self, column_name=None, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, parameter_data_type=None, example_value=None,
                 is_required_parameter=None):
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(self, parameter_description=None, column_name=None, parameter_name=None, parameter_data_type=None,
                 example_value=None):
        self.parameter_description = parameter_description  # type: str
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(self, table_name=None, connection_id=None):
        self.table_name = table_name  # type: str
        self.connection_id = connection_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServiceApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(self, script=None, is_paged_response=None, script_request_parameters=None,
                 script_response_parameters=None, script_connection=None):
        self.script = script  # type: str
        self.is_paged_response = is_paged_response  # type: bool
        self.script_request_parameters = script_request_parameters  # type: list[GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters]
        self.script_response_parameters = script_response_parameters  # type: list[GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters]
        self.script_connection = script_connection  # type: GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection

    def validate(self):
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()
        if self.script_connection:
            self.script_connection.validate()

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataScriptDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script is not None:
            result['Script'] = self.script
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(self, column_name=None, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, parameter_data_type=None, example_value=None,
                 is_required_parameter=None):
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(self, parameter_description=None, column_name=None, parameter_name=None, parameter_data_type=None,
                 example_value=None):
        self.parameter_description = parameter_description  # type: str
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(self, table_name=None, connection_id=None):
        self.table_name = table_name  # type: str
        self.connection_id = connection_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServiceApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(self, is_paged_response=None, wizard_request_parameters=None, wizard_response_parameters=None,
                 wizard_connection=None):
        self.is_paged_response = is_paged_response  # type: bool
        self.wizard_request_parameters = wizard_request_parameters  # type: list[GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters]
        self.wizard_response_parameters = wizard_response_parameters  # type: list[GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters]
        self.wizard_connection = wizard_connection  # type: GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection

    def validate(self):
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()
        if self.wizard_connection:
            self.wizard_connection.validate()

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyDataWizardDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        return self


class GetDataServiceApiResponseBodyData(TeaModel):
    def __init__(self, timeout=None, status=None, api_id=None, api_mode=None, project_id=None,
                 response_content_type=None, creator_id=None, visible_range=None, modified_time=None, operator_id=None, group_id=None,
                 description=None, folder_id=None, request_method=None, created_time=None, api_name=None, tenant_id=None,
                 api_path=None, protocols=None, registration_details=None, script_details=None, wizard_details=None):
        self.timeout = timeout  # type: int
        self.status = status  # type: int
        self.api_id = api_id  # type: long
        self.api_mode = api_mode  # type: int
        self.project_id = project_id  # type: long
        self.response_content_type = response_content_type  # type: int
        self.creator_id = creator_id  # type: str
        self.visible_range = visible_range  # type: int
        self.modified_time = modified_time  # type: str
        self.operator_id = operator_id  # type: str
        self.group_id = group_id  # type: str
        self.description = description  # type: str
        self.folder_id = folder_id  # type: long
        self.request_method = request_method  # type: int
        self.created_time = created_time  # type: str
        self.api_name = api_name  # type: str
        self.tenant_id = tenant_id  # type: long
        self.api_path = api_path  # type: str
        self.protocols = protocols  # type: list[int]
        self.registration_details = registration_details  # type: GetDataServiceApiResponseBodyDataRegistrationDetails
        self.script_details = script_details  # type: GetDataServiceApiResponseBodyDataScriptDetails
        self.wizard_details = wizard_details  # type: GetDataServiceApiResponseBodyDataWizardDetails

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super(GetDataServiceApiResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.status is not None:
            result['Status'] = self.status
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServiceApiResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetDataServiceApiResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataServiceApiResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetDataServiceApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataServiceApiResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDataServiceApiResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataServiceApiResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApplicationRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, application_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.application_id = application_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApplicationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetDataServiceApplicationResponseBodyData(TeaModel):
    def __init__(self, application_code=None, application_key=None, application_secret=None, project_id=None,
                 application_name=None, application_id=None):
        self.application_code = application_code  # type: str
        self.application_key = application_key  # type: str
        self.application_secret = application_secret  # type: str
        self.project_id = project_id  # type: long
        self.application_name = application_name  # type: str
        self.application_id = application_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceApplicationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_code is not None:
            result['ApplicationCode'] = self.application_code
        if self.application_key is not None:
            result['ApplicationKey'] = self.application_key
        if self.application_secret is not None:
            result['ApplicationSecret'] = self.application_secret
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplicationCode') is not None:
            self.application_code = m.get('ApplicationCode')
        if m.get('ApplicationKey') is not None:
            self.application_key = m.get('ApplicationKey')
        if m.get('ApplicationSecret') is not None:
            self.application_secret = m.get('ApplicationSecret')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetDataServiceApplicationResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetDataServiceApplicationResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataServiceApplicationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetDataServiceApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataServiceApplicationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDataServiceApplicationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataServiceApplicationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceFolderRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, folder_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.folder_id = folder_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceFolderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class GetDataServiceFolderResponseBodyFolder(TeaModel):
    def __init__(self, parent_id=None, modified_time=None, group_id=None, folder_id=None, project_id=None,
                 folder_name=None, created_time=None, tenant_id=None):
        self.parent_id = parent_id  # type: long
        self.modified_time = modified_time  # type: str
        self.group_id = group_id  # type: str
        self.folder_id = folder_id  # type: long
        self.project_id = project_id  # type: long
        self.folder_name = folder_name  # type: str
        self.created_time = created_time  # type: str
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceFolderResponseBodyFolder, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceFolderResponseBody(TeaModel):
    def __init__(self, request_id=None, folder=None):
        self.request_id = request_id  # type: str
        self.folder = folder  # type: GetDataServiceFolderResponseBodyFolder

    def validate(self):
        if self.folder:
            self.folder.validate()

    def to_map(self):
        _map = super(GetDataServiceFolderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.folder is not None:
            result['Folder'] = self.folder.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Folder') is not None:
            temp_model = GetDataServiceFolderResponseBodyFolder()
            self.folder = temp_model.from_map(m['Folder'])
        return self


class GetDataServiceFolderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDataServiceFolderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataServiceFolderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceGroupRequest(TeaModel):
    def __init__(self, tenant_id=None, project_id=None, group_id=None):
        self.tenant_id = tenant_id  # type: long
        self.project_id = project_id  # type: long
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class GetDataServiceGroupResponseBodyGroup(TeaModel):
    def __init__(self, modified_time=None, description=None, group_name=None, group_id=None, project_id=None,
                 api_gateway_group_id=None, creator_id=None, created_time=None, tenant_id=None):
        self.modified_time = modified_time  # type: str
        self.description = description  # type: str
        self.group_name = group_name  # type: str
        self.group_id = group_id  # type: str
        self.project_id = project_id  # type: long
        self.api_gateway_group_id = api_gateway_group_id  # type: str
        self.creator_id = creator_id  # type: str
        self.created_time = created_time  # type: str
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServiceGroupResponseBodyGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, group=None):
        self.request_id = request_id  # type: str
        self.group = group  # type: GetDataServiceGroupResponseBodyGroup

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super(GetDataServiceGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.group is not None:
            result['Group'] = self.group.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Group') is not None:
            temp_model = GetDataServiceGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        return self


class GetDataServiceGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDataServiceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataServiceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServicePublishedApiRequest(TeaModel):
    def __init__(self, project_id=None, tenant_id=None, api_id=None):
        self.project_id = project_id  # type: long
        self.tenant_id = tenant_id  # type: long
        self.api_id = api_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(self, error_message=None, error_code=None, error_solution=None):
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.error_solution = error_solution  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(self, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, example_value=None, parameter_data_type=None,
                 is_required_parameter=None):
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.example_value = example_value  # type: str
        self.parameter_data_type = parameter_data_type  # type: int
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(self, service_host=None, service_content_type=None, service_path=None,
                 successful_result_sample=None, failed_result_sample=None, service_request_body_description=None,
                 registration_error_codes=None, registration_request_parameters=None):
        self.service_host = service_host  # type: str
        self.service_content_type = service_content_type  # type: int
        self.service_path = service_path  # type: str
        self.successful_result_sample = successful_result_sample  # type: str
        self.failed_result_sample = failed_result_sample  # type: str
        self.service_request_body_description = service_request_body_description  # type: str
        self.registration_error_codes = registration_error_codes  # type: list[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes]
        self.registration_request_parameters = registration_request_parameters  # type: list[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters]

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataRegistrationDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes(TeaModel):
    def __init__(self, error_message=None, error_code=None, error_solution=None):
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.error_solution = error_solution  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(self, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, example_value=None, parameter_data_type=None,
                 is_required_parameter=None):
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.example_value = example_value  # type: str
        self.parameter_data_type = parameter_data_type  # type: int
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(self, parameter_description=None, parameter_name=None, example_value=None,
                 parameter_data_type=None):
        self.parameter_description = parameter_description  # type: str
        self.parameter_name = parameter_name  # type: str
        self.example_value = example_value  # type: str
        self.parameter_data_type = parameter_data_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(self, table_name=None, connection_id=None):
        self.table_name = table_name  # type: str
        self.connection_id = connection_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(self, is_paged_response=None, successful_result_sample=None, failed_result_sample=None,
                 script=None, script_error_codes=None, script_request_parameters=None, script_response_parameters=None,
                 script_connection=None):
        self.is_paged_response = is_paged_response  # type: bool
        self.successful_result_sample = successful_result_sample  # type: str
        self.failed_result_sample = failed_result_sample  # type: str
        self.script = script  # type: str
        self.script_error_codes = script_error_codes  # type: list[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes]
        self.script_request_parameters = script_request_parameters  # type: list[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters]
        self.script_response_parameters = script_response_parameters  # type: list[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters]
        self.script_connection = script_connection  # type: GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection

    def validate(self):
        if self.script_error_codes:
            for k in self.script_error_codes:
                if k:
                    k.validate()
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()
        if self.script_connection:
            self.script_connection.validate()

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataScriptDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.script is not None:
            result['Script'] = self.script
        result['ScriptErrorCodes'] = []
        if self.script_error_codes is not None:
            for k in self.script_error_codes:
                result['ScriptErrorCodes'].append(k.to_map() if k else None)
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        self.script_error_codes = []
        if m.get('ScriptErrorCodes') is not None:
            for k in m.get('ScriptErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes()
                self.script_error_codes.append(temp_model.from_map(k))
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes(TeaModel):
    def __init__(self, error_message=None, error_code=None, error_solution=None):
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.error_solution = error_solution  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(self, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, example_value=None, parameter_data_type=None,
                 is_required_parameter=None):
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.example_value = example_value  # type: str
        self.parameter_data_type = parameter_data_type  # type: int
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(self, parameter_description=None, parameter_name=None, example_value=None,
                 parameter_data_type=None):
        self.parameter_description = parameter_description  # type: str
        self.parameter_name = parameter_name  # type: str
        self.example_value = example_value  # type: str
        self.parameter_data_type = parameter_data_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(self, table_name=None, connection_id=None):
        self.table_name = table_name  # type: str
        self.connection_id = connection_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(self, is_paged_response=None, successful_result_sample=None, failed_result_sample=None,
                 wizard_error_codes=None, wizard_request_parameters=None, wizard_response_parameters=None, wizard_connection=None):
        self.is_paged_response = is_paged_response  # type: bool
        self.successful_result_sample = successful_result_sample  # type: str
        self.failed_result_sample = failed_result_sample  # type: str
        self.wizard_error_codes = wizard_error_codes  # type: list[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes]
        self.wizard_request_parameters = wizard_request_parameters  # type: list[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters]
        self.wizard_response_parameters = wizard_response_parameters  # type: list[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters]
        self.wizard_connection = wizard_connection  # type: GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection

    def validate(self):
        if self.wizard_error_codes:
            for k in self.wizard_error_codes:
                if k:
                    k.validate()
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()
        if self.wizard_connection:
            self.wizard_connection.validate()

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyDataWizardDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        result['WizardErrorCodes'] = []
        if self.wizard_error_codes is not None:
            for k in self.wizard_error_codes:
                result['WizardErrorCodes'].append(k.to_map() if k else None)
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        self.wizard_error_codes = []
        if m.get('WizardErrorCodes') is not None:
            for k in m.get('WizardErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes()
                self.wizard_error_codes.append(temp_model.from_map(k))
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        return self


class GetDataServicePublishedApiResponseBodyData(TeaModel):
    def __init__(self, timeout=None, status=None, api_id=None, api_mode=None, project_id=None,
                 response_content_type=None, creator_id=None, visible_range=None, modified_time=None, operator_id=None, group_id=None,
                 description=None, request_method=None, created_time=None, api_name=None, tenant_id=None, api_path=None,
                 protocols=None, registration_details=None, script_details=None, wizard_details=None):
        self.timeout = timeout  # type: int
        self.status = status  # type: int
        self.api_id = api_id  # type: long
        self.api_mode = api_mode  # type: int
        self.project_id = project_id  # type: long
        self.response_content_type = response_content_type  # type: int
        self.creator_id = creator_id  # type: str
        self.visible_range = visible_range  # type: int
        self.modified_time = modified_time  # type: str
        self.operator_id = operator_id  # type: str
        self.group_id = group_id  # type: str
        self.description = description  # type: str
        self.request_method = request_method  # type: int
        self.created_time = created_time  # type: str
        self.api_name = api_name  # type: str
        self.tenant_id = tenant_id  # type: long
        self.api_path = api_path  # type: str
        self.protocols = protocols  # type: list[int]
        self.registration_details = registration_details  # type: GetDataServicePublishedApiResponseBodyDataRegistrationDetails
        self.script_details = script_details  # type: GetDataServicePublishedApiResponseBodyDataScriptDetails
        self.wizard_details = wizard_details  # type: GetDataServicePublishedApiResponseBodyDataWizardDetails

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.status is not None:
            result['Status'] = self.status
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.description is not None:
            result['Description'] = self.description
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServicePublishedApiResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetDataServicePublishedApiResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataServicePublishedApiResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDataServicePublishedApiResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataServicePublishedApiResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServicePublishedApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataSourceMetaRequest(TeaModel):
    def __init__(self, project_id=None, datasource_name=None, page_number=None, page_size=None, env_type=None):
        self.project_id = project_id  # type: long
        self.datasource_name = datasource_name  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.env_type = env_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataSourceMetaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class GetDataSourceMetaResponseBodyData(TeaModel):
    def __init__(self, status=None, message=None, meta=None):
        self.status = status  # type: str
        self.message = message  # type: str
        self.meta = meta  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataSourceMetaResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        if self.meta is not None:
            result['Meta'] = self.meta
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        return self


class GetDataSourceMetaResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: GetDataSourceMetaResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataSourceMetaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDataSourceMetaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataSourceMetaResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDataSourceMetaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataSourceMetaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataSourceMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDDLJobStatusRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDDLJobStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponseBodyData(TeaModel):
    def __init__(self, status=None, next_task_id=None, task_id=None, content=None):
        self.status = status  # type: str
        self.next_task_id = next_task_id  # type: str
        self.task_id = task_id  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDDLJobStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class GetDDLJobStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        self.request_id = request_id  # type: str
        self.data = data  # type: GetDDLJobStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDDLJobStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDDLJobStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDDLJobStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDDLJobStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDDLJobStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDDLJobStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeploymentRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, deployment_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.deployment_id = deployment_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetDeploymentResponseBodyDataDeployment(TeaModel):
    def __init__(self, status=None, error_message=None, from_environment=None, to_environment=None,
                 create_time=None, handler_id=None, creator_id=None, execute_time=None, name=None):
        self.status = status  # type: int
        self.error_message = error_message  # type: str
        self.from_environment = from_environment  # type: int
        self.to_environment = to_environment  # type: int
        self.create_time = create_time  # type: long
        self.handler_id = handler_id  # type: str
        self.creator_id = creator_id  # type: str
        self.execute_time = execute_time  # type: long
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeploymentResponseBodyDataDeployment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.from_environment is not None:
            result['FromEnvironment'] = self.from_environment
        if self.to_environment is not None:
            result['ToEnvironment'] = self.to_environment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FromEnvironment') is not None:
            self.from_environment = m.get('FromEnvironment')
        if m.get('ToEnvironment') is not None:
            self.to_environment = m.get('ToEnvironment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetDeploymentResponseBodyData(TeaModel):
    def __init__(self, deployment=None):
        self.deployment = deployment  # type: GetDeploymentResponseBodyDataDeployment

    def validate(self):
        if self.deployment:
            self.deployment.validate()

    def to_map(self):
        _map = super(GetDeploymentResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment is not None:
            result['Deployment'] = self.deployment.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Deployment') is not None:
            temp_model = GetDeploymentResponseBodyDataDeployment()
            self.deployment = temp_model.from_map(m['Deployment'])
        return self


class GetDeploymentResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetDeploymentResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncInstanceInfoRequest(TeaModel):
    def __init__(self, project_id=None, task_type=None, file_id=None):
        self.project_id = project_id  # type: long
        self.task_type = task_type  # type: str
        self.file_id = file_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDISyncInstanceInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class GetDISyncInstanceInfoResponseBodyData(TeaModel):
    def __init__(self, status=None, message=None, name=None):
        self.status = status  # type: str
        self.message = message  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDISyncInstanceInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetDISyncInstanceInfoResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: GetDISyncInstanceInfoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDISyncInstanceInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDISyncInstanceInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDISyncInstanceInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDISyncInstanceInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDISyncInstanceInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncInstanceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncTaskRequest(TeaModel):
    def __init__(self, project_id=None, task_type=None, file_id=None):
        self.project_id = project_id  # type: long
        self.task_type = task_type  # type: str
        self.file_id = file_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDISyncTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class GetDISyncTaskResponseBodyData(TeaModel):
    def __init__(self, code=None, status=None, message=None):
        self.code = code  # type: str
        self.status = status  # type: str
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDISyncTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class GetDISyncTaskResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: GetDISyncTaskResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDISyncTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDISyncTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDISyncTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDISyncTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, file_id=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.file_id = file_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class GetFileResponseBodyDataFile(TeaModel):
    def __init__(self, commit_status=None, auto_parsing=None, owner=None, create_time=None, file_type=None,
                 current_version=None, biz_id=None, last_edit_user=None, file_name=None, connection_name=None, use_type=None,
                 file_folder_id=None, parent_id=None, create_user=None, is_max_compute=None, business_id=None,
                 file_description=None, deleted_status=None, last_edit_time=None, content=None, node_id=None):
        self.commit_status = commit_status  # type: int
        self.auto_parsing = auto_parsing  # type: bool
        self.owner = owner  # type: str
        self.create_time = create_time  # type: long
        self.file_type = file_type  # type: int
        self.current_version = current_version  # type: int
        self.biz_id = biz_id  # type: long
        self.last_edit_user = last_edit_user  # type: str
        self.file_name = file_name  # type: str
        self.connection_name = connection_name  # type: str
        self.use_type = use_type  # type: str
        self.file_folder_id = file_folder_id  # type: str
        self.parent_id = parent_id  # type: long
        self.create_user = create_user  # type: str
        self.is_max_compute = is_max_compute  # type: bool
        self.business_id = business_id  # type: long
        self.file_description = file_description  # type: str
        self.deleted_status = deleted_status  # type: str
        self.last_edit_time = last_edit_time  # type: long
        self.content = content  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileResponseBodyDataFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commit_status is not None:
            result['CommitStatus'] = self.commit_status
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.last_edit_user is not None:
            result['LastEditUser'] = self.last_edit_user
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        if self.file_folder_id is not None:
            result['FileFolderId'] = self.file_folder_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.is_max_compute is not None:
            result['IsMaxCompute'] = self.is_max_compute
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.deleted_status is not None:
            result['DeletedStatus'] = self.deleted_status
        if self.last_edit_time is not None:
            result['LastEditTime'] = self.last_edit_time
        if self.content is not None:
            result['Content'] = self.content
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommitStatus') is not None:
            self.commit_status = m.get('CommitStatus')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('LastEditUser') is not None:
            self.last_edit_user = m.get('LastEditUser')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        if m.get('FileFolderId') is not None:
            self.file_folder_id = m.get('FileFolderId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('IsMaxCompute') is not None:
            self.is_max_compute = m.get('IsMaxCompute')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('DeletedStatus') is not None:
            self.deleted_status = m.get('DeletedStatus')
        if m.get('LastEditTime') is not None:
            self.last_edit_time = m.get('LastEditTime')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetFileResponseBodyDataNodeConfigurationInputList(TeaModel):
    def __init__(self, input=None, parse_type=None):
        self.input = input  # type: str
        self.parse_type = parse_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileResponseBodyDataNodeConfigurationInputList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.parse_type is not None:
            result['ParseType'] = self.parse_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('ParseType') is not None:
            self.parse_type = m.get('ParseType')
        return self


class GetFileResponseBodyDataNodeConfigurationOutputList(TeaModel):
    def __init__(self, ref_table_name=None, output=None):
        self.ref_table_name = ref_table_name  # type: str
        self.output = output  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileResponseBodyDataNodeConfigurationOutputList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ref_table_name is not None:
            result['RefTableName'] = self.ref_table_name
        if self.output is not None:
            result['Output'] = self.output
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RefTableName') is not None:
            self.ref_table_name = m.get('RefTableName')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        return self


class GetFileResponseBodyDataNodeConfiguration(TeaModel):
    def __init__(self, rerun_mode=None, scheduler_type=None, stop=None, para_value=None, start_effect_date=None,
                 end_effect_date=None, cycle_type=None, dependent_node_id_list=None, resource_group_id=None, dependent_type=None,
                 auto_rerun_times=None, auto_rerun_interval_millis=None, cron_express=None, input_list=None, output_list=None):
        self.rerun_mode = rerun_mode  # type: str
        self.scheduler_type = scheduler_type  # type: str
        self.stop = stop  # type: bool
        self.para_value = para_value  # type: str
        self.start_effect_date = start_effect_date  # type: long
        self.end_effect_date = end_effect_date  # type: long
        self.cycle_type = cycle_type  # type: str
        self.dependent_node_id_list = dependent_node_id_list  # type: str
        self.resource_group_id = resource_group_id  # type: long
        self.dependent_type = dependent_type  # type: str
        self.auto_rerun_times = auto_rerun_times  # type: int
        self.auto_rerun_interval_millis = auto_rerun_interval_millis  # type: int
        self.cron_express = cron_express  # type: str
        self.input_list = input_list  # type: list[GetFileResponseBodyDataNodeConfigurationInputList]
        self.output_list = output_list  # type: list[GetFileResponseBodyDataNodeConfigurationOutputList]

    def validate(self):
        if self.input_list:
            for k in self.input_list:
                if k:
                    k.validate()
        if self.output_list:
            for k in self.output_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetFileResponseBodyDataNodeConfiguration, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.stop is not None:
            result['Stop'] = self.stop
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        result['InputList'] = []
        if self.input_list is not None:
            for k in self.input_list:
                result['InputList'].append(k.to_map() if k else None)
        result['OutputList'] = []
        if self.output_list is not None:
            for k in self.output_list:
                result['OutputList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        self.input_list = []
        if m.get('InputList') is not None:
            for k in m.get('InputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationInputList()
                self.input_list.append(temp_model.from_map(k))
        self.output_list = []
        if m.get('OutputList') is not None:
            for k in m.get('OutputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationOutputList()
                self.output_list.append(temp_model.from_map(k))
        return self


class GetFileResponseBodyData(TeaModel):
    def __init__(self, file=None, node_configuration=None):
        self.file = file  # type: GetFileResponseBodyDataFile
        self.node_configuration = node_configuration  # type: GetFileResponseBodyDataNodeConfiguration

    def validate(self):
        if self.file:
            self.file.validate()
        if self.node_configuration:
            self.node_configuration.validate()

    def to_map(self):
        _map = super(GetFileResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.node_configuration is not None:
            result['NodeConfiguration'] = self.node_configuration.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('File') is not None:
            temp_model = GetFileResponseBodyDataFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('NodeConfiguration') is not None:
            temp_model = GetFileResponseBodyDataNodeConfiguration()
            self.node_configuration = temp_model.from_map(m['NodeConfiguration'])
        return self


class GetFileResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetFileResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileTypeStatisticRequest(TeaModel):
    def __init__(self, project_id=None, project_env=None):
        self.project_id = project_id  # type: long
        self.project_env = project_env  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileTypeStatisticRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetFileTypeStatisticResponseBodyProgramTypeAndCounts(TeaModel):
    def __init__(self, count=None, program_type=None):
        self.count = count  # type: int
        self.program_type = program_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileTypeStatisticResponseBodyProgramTypeAndCounts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        return self


class GetFileTypeStatisticResponseBody(TeaModel):
    def __init__(self, request_id=None, program_type_and_counts=None):
        self.request_id = request_id  # type: str
        self.program_type_and_counts = program_type_and_counts  # type: list[GetFileTypeStatisticResponseBodyProgramTypeAndCounts]

    def validate(self):
        if self.program_type_and_counts:
            for k in self.program_type_and_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetFileTypeStatisticResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ProgramTypeAndCounts'] = []
        if self.program_type_and_counts is not None:
            for k in self.program_type_and_counts:
                result['ProgramTypeAndCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.program_type_and_counts = []
        if m.get('ProgramTypeAndCounts') is not None:
            for k in m.get('ProgramTypeAndCounts'):
                temp_model = GetFileTypeStatisticResponseBodyProgramTypeAndCounts()
                self.program_type_and_counts.append(temp_model.from_map(k))
        return self


class GetFileTypeStatisticResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetFileTypeStatisticResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetFileTypeStatisticResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileTypeStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileVersionRequest(TeaModel):
    def __init__(self, file_id=None, project_id=None, project_identifier=None, file_version=None):
        self.file_id = file_id  # type: long
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.file_version = file_version  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        return self


class GetFileVersionResponseBodyData(TeaModel):
    def __init__(self, file_content=None, is_current_prod=None, status=None, node_content=None, commit_user=None,
                 comment=None, file_property_content=None, file_name=None, use_type=None, change_type=None,
                 file_version=None, commit_time=None, node_id=None):
        self.file_content = file_content  # type: str
        self.is_current_prod = is_current_prod  # type: bool
        self.status = status  # type: str
        self.node_content = node_content  # type: str
        self.commit_user = commit_user  # type: str
        self.comment = comment  # type: str
        self.file_property_content = file_property_content  # type: str
        self.file_name = file_name  # type: str
        self.use_type = use_type  # type: str
        self.change_type = change_type  # type: str
        self.file_version = file_version  # type: int
        self.commit_time = commit_time  # type: long
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFileVersionResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_content is not None:
            result['FileContent'] = self.file_content
        if self.is_current_prod is not None:
            result['IsCurrentProd'] = self.is_current_prod
        if self.status is not None:
            result['Status'] = self.status
        if self.node_content is not None:
            result['NodeContent'] = self.node_content
        if self.commit_user is not None:
            result['CommitUser'] = self.commit_user
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.commit_time is not None:
            result['CommitTime'] = self.commit_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileContent') is not None:
            self.file_content = m.get('FileContent')
        if m.get('IsCurrentProd') is not None:
            self.is_current_prod = m.get('IsCurrentProd')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NodeContent') is not None:
            self.node_content = m.get('NodeContent')
        if m.get('CommitUser') is not None:
            self.commit_user = m.get('CommitUser')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FilePropertyContent') is not None:
            self.file_property_content = m.get('FilePropertyContent')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('CommitTime') is not None:
            self.commit_time = m.get('CommitTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetFileVersionResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetFileVersionResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetFileVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetFileVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetFileVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetFileVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetFileVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFolderRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, folder_id=None, folder_path=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.folder_id = folder_id  # type: str
        self.folder_path = folder_path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFolderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        return self


class GetFolderResponseBodyData(TeaModel):
    def __init__(self, folder_path=None, folder_id=None):
        self.folder_path = folder_path  # type: str
        self.folder_id = folder_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetFolderResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class GetFolderResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetFolderResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetFolderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetFolderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetFolderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetFolderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetFolderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, project_env=None):
        self.instance_id = instance_id  # type: long
        self.project_env = project_env  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceResponseBodyData(TeaModel):
    def __init__(self, status=None, cyc_time=None, begin_running_time=None, finish_time=None, create_time=None,
                 dag_id=None, priority=None, task_type=None, param_values=None, connection=None, baseline_id=None,
                 dqc_type=None, dag_type=None, task_rerun_time=None, modify_time=None, repeatability=None,
                 repeat_interval=None, instance_id=None, begin_wait_res_time=None, related_flow_id=None, bizdate=None,
                 node_name=None, begin_wait_time_time=None, dqc_description=None, node_id=None):
        self.status = status  # type: str
        self.cyc_time = cyc_time  # type: long
        self.begin_running_time = begin_running_time  # type: long
        self.finish_time = finish_time  # type: long
        self.create_time = create_time  # type: long
        self.dag_id = dag_id  # type: long
        self.priority = priority  # type: int
        self.task_type = task_type  # type: str
        self.param_values = param_values  # type: str
        self.connection = connection  # type: str
        self.baseline_id = baseline_id  # type: long
        self.dqc_type = dqc_type  # type: int
        self.dag_type = dag_type  # type: str
        self.task_rerun_time = task_rerun_time  # type: int
        self.modify_time = modify_time  # type: long
        self.repeatability = repeatability  # type: bool
        self.repeat_interval = repeat_interval  # type: long
        self.instance_id = instance_id  # type: long
        self.begin_wait_res_time = begin_wait_res_time  # type: long
        self.related_flow_id = related_flow_id  # type: long
        self.bizdate = bizdate  # type: long
        self.node_name = node_name  # type: str
        self.begin_wait_time_time = begin_wait_time_time  # type: long
        self.dqc_description = dqc_description  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.task_rerun_time is not None:
            result['TaskRerunTime'] = self.task_rerun_time
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('TaskRerunTime') is not None:
            self.task_rerun_time = m.get('TaskRerunTime')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetInstanceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceConsumeTimeRankRequest(TeaModel):
    def __init__(self, project_id=None, bizdate=None):
        self.project_id = project_id  # type: long
        self.bizdate = bizdate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceConsumeTimeRankRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank(TeaModel):
    def __init__(self, owner=None, node_name=None, bizdate=None, instance_id=None, prg_type=None, node_id=None,
                 consumed=None):
        self.owner = owner  # type: str
        self.node_name = node_name  # type: str
        self.bizdate = bizdate  # type: long
        self.instance_id = instance_id  # type: long
        self.prg_type = prg_type  # type: int
        self.node_id = node_id  # type: long
        self.consumed = consumed  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.consumed is not None:
            result['Consumed'] = self.consumed
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Consumed') is not None:
            self.consumed = m.get('Consumed')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank(TeaModel):
    def __init__(self, update_time=None, consume_time_rank=None):
        self.update_time = update_time  # type: long
        self.consume_time_rank = consume_time_rank  # type: list[GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank]

    def validate(self):
        if self.consume_time_rank:
            for k in self.consume_time_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ConsumeTimeRank'] = []
        if self.consume_time_rank is not None:
            for k in self.consume_time_rank:
                result['ConsumeTimeRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.consume_time_rank = []
        if m.get('ConsumeTimeRank') is not None:
            for k in m.get('ConsumeTimeRank'):
                temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank()
                self.consume_time_rank.append(temp_model.from_map(k))
        return self


class GetInstanceConsumeTimeRankResponseBody(TeaModel):
    def __init__(self, request_id=None, instance_consume_time_rank=None):
        self.request_id = request_id  # type: str
        self.instance_consume_time_rank = instance_consume_time_rank  # type: GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank

    def validate(self):
        if self.instance_consume_time_rank:
            self.instance_consume_time_rank.validate()

    def to_map(self):
        _map = super(GetInstanceConsumeTimeRankResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_consume_time_rank is not None:
            result['InstanceConsumeTimeRank'] = self.instance_consume_time_rank.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceConsumeTimeRank') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank()
            self.instance_consume_time_rank = temp_model.from_map(m['InstanceConsumeTimeRank'])
        return self


class GetInstanceConsumeTimeRankResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceConsumeTimeRankResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceConsumeTimeRankResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceCountTrendRequest(TeaModel):
    def __init__(self, project_id=None, begin_date=None, end_date=None):
        self.project_id = project_id  # type: long
        self.begin_date = begin_date  # type: str
        self.end_date = end_date  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceCountTrendRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetInstanceCountTrendResponseBodyInstanceCounts(TeaModel):
    def __init__(self, date=None, count=None):
        self.date = date  # type: long
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceCountTrendResponseBodyInstanceCounts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetInstanceCountTrendResponseBody(TeaModel):
    def __init__(self, request_id=None, instance_counts=None):
        self.request_id = request_id  # type: str
        self.instance_counts = instance_counts  # type: list[GetInstanceCountTrendResponseBodyInstanceCounts]

    def validate(self):
        if self.instance_counts:
            for k in self.instance_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceCountTrendResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['InstanceCounts'] = []
        if self.instance_counts is not None:
            for k in self.instance_counts:
                result['InstanceCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instance_counts = []
        if m.get('InstanceCounts') is not None:
            for k in m.get('InstanceCounts'):
                temp_model = GetInstanceCountTrendResponseBodyInstanceCounts()
                self.instance_counts.append(temp_model.from_map(k))
        return self


class GetInstanceCountTrendResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceCountTrendResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceCountTrendResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceCountTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceErrorRankRequest(TeaModel):
    def __init__(self, project_id=None):
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceErrorRankRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank(TeaModel):
    def __init__(self, owner=None, node_name=None, project_id=None, node_id=None, count=None, prg_type=None):
        self.owner = owner  # type: str
        self.node_name = node_name  # type: str
        self.project_id = project_id  # type: long
        self.node_id = node_id  # type: long
        self.count = count  # type: int
        self.prg_type = prg_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.count is not None:
            result['Count'] = self.count
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRank(TeaModel):
    def __init__(self, update_time=None, error_rank=None):
        self.update_time = update_time  # type: long
        self.error_rank = error_rank  # type: list[GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank]

    def validate(self):
        if self.error_rank:
            for k in self.error_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceErrorRankResponseBodyInstanceErrorRank, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ErrorRank'] = []
        if self.error_rank is not None:
            for k in self.error_rank:
                result['ErrorRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.error_rank = []
        if m.get('ErrorRank') is not None:
            for k in m.get('ErrorRank'):
                temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank()
                self.error_rank.append(temp_model.from_map(k))
        return self


class GetInstanceErrorRankResponseBody(TeaModel):
    def __init__(self, request_id=None, instance_error_rank=None):
        self.request_id = request_id  # type: str
        self.instance_error_rank = instance_error_rank  # type: GetInstanceErrorRankResponseBodyInstanceErrorRank

    def validate(self):
        if self.instance_error_rank:
            self.instance_error_rank.validate()

    def to_map(self):
        _map = super(GetInstanceErrorRankResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_error_rank is not None:
            result['InstanceErrorRank'] = self.instance_error_rank.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceErrorRank') is not None:
            temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRank()
            self.instance_error_rank = temp_model.from_map(m['InstanceErrorRank'])
        return self


class GetInstanceErrorRankResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceErrorRankResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceErrorRankResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceErrorRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceLogRequest(TeaModel):
    def __init__(self, instance_id=None, project_env=None):
        self.instance_id = instance_id  # type: long
        self.project_env = project_env  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceLogResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, error_code=None,
                 success=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceLogResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusCountRequest(TeaModel):
    def __init__(self, project_id=None, project_env=None, biz_date=None):
        self.project_id = project_id  # type: long
        self.project_env = project_env  # type: str
        self.biz_date = biz_date  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceStatusCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        return self


class GetInstanceStatusCountResponseBodyStatusCount(TeaModel):
    def __init__(self, failure_count=None, wait_time_count=None, running_count=None, success_count=None,
                 total_count=None, not_run_count=None, wait_res_count=None):
        self.failure_count = failure_count  # type: int
        self.wait_time_count = wait_time_count  # type: int
        self.running_count = running_count  # type: int
        self.success_count = success_count  # type: int
        self.total_count = total_count  # type: int
        self.not_run_count = not_run_count  # type: int
        self.wait_res_count = wait_res_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceStatusCountResponseBodyStatusCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        return self


class GetInstanceStatusCountResponseBody(TeaModel):
    def __init__(self, request_id=None, status_count=None):
        self.request_id = request_id  # type: str
        self.status_count = status_count  # type: GetInstanceStatusCountResponseBodyStatusCount

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super(GetInstanceStatusCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusCountResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusCountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceStatusCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceStatusCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusStatisticRequest(TeaModel):
    def __init__(self, project_id=None, project_env=None, biz_date=None):
        self.project_id = project_id  # type: long
        self.project_env = project_env  # type: str
        self.biz_date = biz_date  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceStatusStatisticRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        return self


class GetInstanceStatusStatisticResponseBodyStatusCount(TeaModel):
    def __init__(self, failure_count=None, wait_time_count=None, running_count=None, success_count=None,
                 total_count=None, not_run_count=None, wait_res_count=None):
        self.failure_count = failure_count  # type: int
        self.wait_time_count = wait_time_count  # type: int
        self.running_count = running_count  # type: int
        self.success_count = success_count  # type: int
        self.total_count = total_count  # type: int
        self.not_run_count = not_run_count  # type: int
        self.wait_res_count = wait_res_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceStatusStatisticResponseBodyStatusCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        return self


class GetInstanceStatusStatisticResponseBody(TeaModel):
    def __init__(self, request_id=None, status_count=None):
        self.request_id = request_id  # type: str
        self.status_count = status_count  # type: GetInstanceStatusStatisticResponseBodyStatusCount

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super(GetInstanceStatusStatisticResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusStatisticResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusStatisticResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetInstanceStatusStatisticResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceStatusStatisticResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetManualDagInstancesRequest(TeaModel):
    def __init__(self, project_env=None, project_name=None, dag_id=None):
        self.project_env = project_env  # type: str
        self.project_name = project_name  # type: str
        self.dag_id = dag_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetManualDagInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        return self


class GetManualDagInstancesResponseBodyInstances(TeaModel):
    def __init__(self, status=None, begin_running_time=None, biz_date=None, cyc_time=None, finish_time=None,
                 create_time=None, dag_id=None, instance_id=None, begin_wait_res_time=None, task_type=None, param_values=None,
                 dag_type=None, node_name=None, begin_wait_time_time=None, node_id=None, modify_time=None):
        self.status = status  # type: str
        self.begin_running_time = begin_running_time  # type: long
        self.biz_date = biz_date  # type: long
        self.cyc_time = cyc_time  # type: long
        self.finish_time = finish_time  # type: long
        self.create_time = create_time  # type: long
        self.dag_id = dag_id  # type: long
        self.instance_id = instance_id  # type: long
        self.begin_wait_res_time = begin_wait_res_time  # type: long
        self.task_type = task_type  # type: str
        self.param_values = param_values  # type: str
        self.dag_type = dag_type  # type: str
        self.node_name = node_name  # type: str
        self.begin_wait_time_time = begin_wait_time_time  # type: long
        self.node_id = node_id  # type: long
        self.modify_time = modify_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetManualDagInstancesResponseBodyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetManualDagInstancesResponseBody(TeaModel):
    def __init__(self, request_id=None, instances=None):
        self.request_id = request_id  # type: str
        self.instances = instances  # type: list[GetManualDagInstancesResponseBodyInstances]

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetManualDagInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = GetManualDagInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        return self


class GetManualDagInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetManualDagInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetManualDagInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetManualDagInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaCategoryRequest(TeaModel):
    def __init__(self, parent_category_id=None, page_num=None, page_size=None):
        self.parent_category_id = parent_category_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMetaCategoryResponseBodyDataDataEntityList(TeaModel):
    def __init__(self, depth=None, comment=None, modified_time=None, create_time=None, category_id=None,
                 last_operator_id=None, name=None, parent_category_id=None, owner_id=None):
        self.depth = depth  # type: int
        self.comment = comment  # type: str
        self.modified_time = modified_time  # type: long
        self.create_time = create_time  # type: long
        self.category_id = category_id  # type: long
        self.last_operator_id = last_operator_id  # type: str
        self.name = name  # type: str
        self.parent_category_id = parent_category_id  # type: long
        self.owner_id = owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaCategoryResponseBodyDataDataEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depth is not None:
            result['Depth'] = self.depth
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.last_operator_id is not None:
            result['LastOperatorId'] = self.last_operator_id
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Depth') is not None:
            self.depth = m.get('Depth')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('LastOperatorId') is not None:
            self.last_operator_id = m.get('LastOperatorId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class GetMetaCategoryResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, total_count=None, data_entity_list=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.data_entity_list = data_entity_list  # type: list[GetMetaCategoryResponseBodyDataDataEntityList]

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaCategoryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaCategoryResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaCategoryResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaCategoryResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaColumnLineageRequest(TeaModel):
    def __init__(self, column_guid=None, direction=None, page_num=None, page_size=None, cluster_id=None,
                 database_name=None, table_name=None, column_name=None, data_source_type=None):
        self.column_guid = column_guid  # type: str
        self.direction = direction  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.column_name = column_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaColumnLineageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaColumnLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(self, column_guid=None, column_name=None, table_name=None, database_name=None, cluster_id=None):
        self.column_guid = column_guid  # type: str
        self.column_name = column_name  # type: str
        self.table_name = table_name  # type: str
        self.database_name = database_name  # type: str
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaColumnLineageResponseBodyDataDataEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class GetMetaColumnLineageResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, total_count=None, data_entity_list=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.data_entity_list = data_entity_list  # type: list[GetMetaColumnLineageResponseBodyDataDataEntityList]

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaColumnLineageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaColumnLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaColumnLineageResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaColumnLineageResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaColumnLineageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaColumnLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaColumnLineageResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaColumnLineageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaColumnLineageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaColumnLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBInfoRequest(TeaModel):
    def __init__(self, app_guid=None, cluster_id=None, database_name=None, data_source_type=None):
        self.app_guid = app_guid  # type: str
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaDBInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaDBInfoResponseBodyData(TeaModel):
    def __init__(self, type=None, comment=None, create_time=None, project_id=None, project_name=None, app_guid=None,
                 owner_name=None, owner_id=None, env_type=None, project_name_cn=None, endpoint=None, cluster_biz_id=None,
                 name=None, location=None, tenant_id=None, modify_time=None):
        self.type = type  # type: str
        self.comment = comment  # type: str
        self.create_time = create_time  # type: long
        self.project_id = project_id  # type: long
        self.project_name = project_name  # type: str
        self.app_guid = app_guid  # type: str
        self.owner_name = owner_name  # type: str
        self.owner_id = owner_id  # type: str
        self.env_type = env_type  # type: int
        self.project_name_cn = project_name_cn  # type: str
        self.endpoint = endpoint  # type: str
        self.cluster_biz_id = cluster_biz_id  # type: str
        self.name = name  # type: str
        self.location = location  # type: str
        self.tenant_id = tenant_id  # type: long
        self.modify_time = modify_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaDBInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_name_cn is not None:
            result['ProjectNameCn'] = self.project_name_cn
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.name is not None:
            result['Name'] = self.name
        if self.location is not None:
            result['Location'] = self.location
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectNameCn') is not None:
            self.project_name_cn = m.get('ProjectNameCn')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetMetaDBInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        self.request_id = request_id  # type: str
        self.data = data  # type: GetMetaDBInfoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaDBInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetMetaDBInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaDBInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaDBInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaDBInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaDBInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBTableListRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, app_guid=None, cluster_id=None, database_name=None,
                 data_source_type=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.app_guid = app_guid  # type: str
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaDBTableListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaDBTableListResponseBodyDataTableEntityList(TeaModel):
    def __init__(self, table_name=None, table_guid=None, database_name=None):
        self.table_name = table_name  # type: str
        self.table_guid = table_guid  # type: str
        self.database_name = database_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaDBTableListResponseBodyDataTableEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        return self


class GetMetaDBTableListResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, table_entity_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.table_entity_list = table_entity_list  # type: list[GetMetaDBTableListResponseBodyDataTableEntityList]

    def validate(self):
        if self.table_entity_list:
            for k in self.table_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaDBTableListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TableEntityList'] = []
        if self.table_entity_list is not None:
            for k in self.table_entity_list:
                result['TableEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.table_entity_list = []
        if m.get('TableEntityList') is not None:
            for k in m.get('TableEntityList'):
                temp_model = GetMetaDBTableListResponseBodyDataTableEntityList()
                self.table_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaDBTableListResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None):
        self.request_id = request_id  # type: str
        self.data = data  # type: GetMetaDBTableListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaDBTableListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetMetaDBTableListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaDBTableListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaDBTableListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaDBTableListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaDBTableListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableBasicInfoRequest(TeaModel):
    def __init__(self, table_guid=None, cluster_id=None, database_name=None, table_name=None, data_source_type=None,
                 extension=None):
        self.table_guid = table_guid  # type: str
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.data_source_type = data_source_type  # type: str
        self.extension = extension  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableBasicInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class GetMetaTableBasicInfoResponseBodyData(TeaModel):
    def __init__(self, table_name=None, favorite_count=None, comment=None, column_count=None, create_time=None,
                 project_id=None, owner_id=None, env_type=None, database_name=None, is_visible=None, table_guid=None,
                 read_count=None, cluster_id=None, is_partition_table=None, is_view=None, life_cycle=None, project_name=None,
                 view_count=None, last_access_time=None, data_size=None, last_modify_time=None, last_ddl_time=None,
                 partition_keys=None, location=None, caption=None, tenant_id=None):
        self.table_name = table_name  # type: str
        self.favorite_count = favorite_count  # type: long
        self.comment = comment  # type: str
        self.column_count = column_count  # type: int
        self.create_time = create_time  # type: long
        self.project_id = project_id  # type: long
        self.owner_id = owner_id  # type: str
        self.env_type = env_type  # type: int
        self.database_name = database_name  # type: str
        self.is_visible = is_visible  # type: int
        self.table_guid = table_guid  # type: str
        self.read_count = read_count  # type: long
        self.cluster_id = cluster_id  # type: str
        self.is_partition_table = is_partition_table  # type: bool
        self.is_view = is_view  # type: bool
        self.life_cycle = life_cycle  # type: int
        self.project_name = project_name  # type: str
        self.view_count = view_count  # type: long
        self.last_access_time = last_access_time  # type: long
        self.data_size = data_size  # type: long
        self.last_modify_time = last_modify_time  # type: long
        self.last_ddl_time = last_ddl_time  # type: long
        self.partition_keys = partition_keys  # type: str
        self.location = location  # type: str
        self.caption = caption  # type: str
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableBasicInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.favorite_count is not None:
            result['FavoriteCount'] = self.favorite_count
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.read_count is not None:
            result['ReadCount'] = self.read_count
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.is_partition_table is not None:
            result['IsPartitionTable'] = self.is_partition_table
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.view_count is not None:
            result['ViewCount'] = self.view_count
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.location is not None:
            result['Location'] = self.location
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('FavoriteCount') is not None:
            self.favorite_count = m.get('FavoriteCount')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ReadCount') is not None:
            self.read_count = m.get('ReadCount')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('IsPartitionTable') is not None:
            self.is_partition_table = m.get('IsPartitionTable')
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ViewCount') is not None:
            self.view_count = m.get('ViewCount')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetMetaTableBasicInfoResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableBasicInfoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableBasicInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableBasicInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableBasicInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableBasicInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableBasicInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableBasicInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableChangeLogRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, table_guid=None, change_type=None, object_type=None,
                 start_date=None, end_date=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.table_guid = table_guid  # type: str
        self.change_type = change_type  # type: str
        self.object_type = object_type  # type: str
        self.start_date = start_date  # type: str
        self.end_date = end_date  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableChangeLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetMetaTableChangeLogResponseBodyDataDataEntityList(TeaModel):
    def __init__(self, object_type=None, modified_time=None, create_time=None, change_content=None, operator=None,
                 change_type=None):
        self.object_type = object_type  # type: str
        self.modified_time = modified_time  # type: long
        self.create_time = create_time  # type: long
        self.change_content = change_content  # type: str
        self.operator = operator  # type: str
        self.change_type = change_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableChangeLogResponseBodyDataDataEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.change_content is not None:
            result['ChangeContent'] = self.change_content
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChangeContent') is not None:
            self.change_content = m.get('ChangeContent')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        return self


class GetMetaTableChangeLogResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, data_entity_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.data_entity_list = data_entity_list  # type: list[GetMetaTableChangeLogResponseBodyDataDataEntityList]

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaTableChangeLogResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableChangeLogResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableChangeLogResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableChangeLogResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableChangeLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableChangeLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableChangeLogResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableChangeLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableChangeLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableChangeLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableColumnRequest(TeaModel):
    def __init__(self, table_guid=None, page_num=None, page_size=None, cluster_id=None, database_name=None,
                 table_name=None, data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableColumnRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableColumnResponseBodyDataColumnList(TeaModel):
    def __init__(self, column_guid=None, column_name=None, is_partition_column=None, comment=None, column_type=None,
                 is_primary_key=None, position=None, caption=None, is_foreign_key=None):
        self.column_guid = column_guid  # type: str
        self.column_name = column_name  # type: str
        self.is_partition_column = is_partition_column  # type: bool
        self.comment = comment  # type: str
        self.column_type = column_type  # type: str
        self.is_primary_key = is_primary_key  # type: bool
        self.position = position  # type: int
        self.caption = caption  # type: str
        self.is_foreign_key = is_foreign_key  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableColumnResponseBodyDataColumnList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        return self


class GetMetaTableColumnResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, total_count=None, column_list=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.column_list = column_list  # type: list[GetMetaTableColumnResponseBodyDataColumnList]

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaTableColumnResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableColumnResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        return self


class GetMetaTableColumnResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableColumnResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableColumnResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableColumnResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableColumnResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableColumnResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableColumnResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableColumnResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableFullInfoRequest(TeaModel):
    def __init__(self, table_guid=None, page_num=None, page_size=None, cluster_id=None, database_name=None,
                 table_name=None, data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableFullInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableFullInfoResponseBodyDataColumnList(TeaModel):
    def __init__(self, column_name=None, column_guid=None, is_partition_column=None, comment=None, column_type=None,
                 is_primary_key=None, position=None, caption=None, is_foreign_key=None):
        self.column_name = column_name  # type: str
        self.column_guid = column_guid  # type: str
        self.is_partition_column = is_partition_column  # type: bool
        self.comment = comment  # type: str
        self.column_type = column_type  # type: str
        self.is_primary_key = is_primary_key  # type: bool
        self.position = position  # type: int
        self.caption = caption  # type: str
        self.is_foreign_key = is_foreign_key  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableFullInfoResponseBodyDataColumnList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        return self


class GetMetaTableFullInfoResponseBodyData(TeaModel):
    def __init__(self, table_name=None, comment=None, life_cycle=None, create_time=None, project_name=None,
                 project_id=None, owner_id=None, env_type=None, last_access_time=None, data_size=None, last_modify_time=None,
                 database_name=None, is_visible=None, total_column_count=None, table_guid=None, partition_keys=None,
                 last_ddl_time=None, location=None, cluster_id=None, tenant_id=None, column_list=None):
        self.table_name = table_name  # type: str
        self.comment = comment  # type: str
        self.life_cycle = life_cycle  # type: int
        self.create_time = create_time  # type: long
        self.project_name = project_name  # type: str
        self.project_id = project_id  # type: long
        self.owner_id = owner_id  # type: str
        self.env_type = env_type  # type: int
        self.last_access_time = last_access_time  # type: long
        self.data_size = data_size  # type: long
        self.last_modify_time = last_modify_time  # type: long
        self.database_name = database_name  # type: str
        self.is_visible = is_visible  # type: int
        self.total_column_count = total_column_count  # type: long
        self.table_guid = table_guid  # type: str
        self.partition_keys = partition_keys  # type: str
        self.last_ddl_time = last_ddl_time  # type: long
        self.location = location  # type: str
        self.cluster_id = cluster_id  # type: str
        self.tenant_id = tenant_id  # type: long
        self.column_list = column_list  # type: list[GetMetaTableFullInfoResponseBodyDataColumnList]

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaTableFullInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.total_column_count is not None:
            result['TotalColumnCount'] = self.total_column_count
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.location is not None:
            result['Location'] = self.location
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('TotalColumnCount') is not None:
            self.total_column_count = m.get('TotalColumnCount')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableFullInfoResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        return self


class GetMetaTableFullInfoResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableFullInfoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableFullInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableFullInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableFullInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableFullInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableFullInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableFullInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableIntroWikiRequest(TeaModel):
    def __init__(self, table_guid=None, wiki_version=None):
        self.table_guid = table_guid  # type: str
        self.wiki_version = wiki_version  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableIntroWikiRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.wiki_version is not None:
            result['WikiVersion'] = self.wiki_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('WikiVersion') is not None:
            self.wiki_version = m.get('WikiVersion')
        return self


class GetMetaTableIntroWikiResponseBodyData(TeaModel):
    def __init__(self, modified_time=None, version=None, create_time=None, creator_name=None, content=None,
                 creator=None):
        self.modified_time = modified_time  # type: long
        self.version = version  # type: long
        self.create_time = create_time  # type: long
        self.creator_name = creator_name  # type: str
        self.content = content  # type: str
        self.creator = creator  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableIntroWikiResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.version is not None:
            result['Version'] = self.version
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.content is not None:
            result['Content'] = self.content
        if self.creator is not None:
            result['Creator'] = self.creator
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        return self


class GetMetaTableIntroWikiResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableIntroWikiResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableIntroWikiResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableIntroWikiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableIntroWikiResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableIntroWikiResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableIntroWikiResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableIntroWikiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableLineageRequest(TeaModel):
    def __init__(self, table_guid=None, direction=None, next_primary_key=None, page_size=None, cluster_id=None,
                 database_name=None, table_name=None, data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.direction = direction  # type: str
        self.next_primary_key = next_primary_key  # type: str
        self.page_size = page_size  # type: int
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableLineageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(self, table_name=None, table_guid=None):
        self.table_name = table_name  # type: str
        self.table_guid = table_guid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableLineageResponseBodyDataDataEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTableLineageResponseBodyData(TeaModel):
    def __init__(self, next_primary_key=None, has_next=None, data_entity_list=None):
        self.next_primary_key = next_primary_key  # type: str
        self.has_next = has_next  # type: bool
        self.data_entity_list = data_entity_list  # type: list[GetMetaTableLineageResponseBodyDataDataEntityList]

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaTableLineageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableLineageResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableLineageResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableLineageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableLineageResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableLineageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableLineageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableListByCategoryRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, category_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.category_id = category_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableListByCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class GetMetaTableListByCategoryResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, table_guid_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.table_guid_list = table_guid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableListByCategoryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.table_guid_list is not None:
            result['TableGuidList'] = self.table_guid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TableGuidList') is not None:
            self.table_guid_list = m.get('TableGuidList')
        return self


class GetMetaTableListByCategoryResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableListByCategoryResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableListByCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableListByCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableListByCategoryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableListByCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableListByCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableListByCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableOutputRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, table_guid=None, start_date=None, end_date=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.table_guid = table_guid  # type: str
        self.start_date = start_date  # type: str
        self.end_date = end_date  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableOutputRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetMetaTableOutputResponseBodyDataDataEntityList(TeaModel):
    def __init__(self, end_time=None, task_instance_id=None, start_time=None, project_id=None, wait_time=None,
                 table_guid=None, task_id=None):
        self.end_time = end_time  # type: str
        self.task_instance_id = task_instance_id  # type: long
        self.start_time = start_time  # type: str
        self.project_id = project_id  # type: long
        self.wait_time = wait_time  # type: str
        self.table_guid = table_guid  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableOutputResponseBodyDataDataEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.task_instance_id is not None:
            result['TaskInstanceId'] = self.task_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TaskInstanceId') is not None:
            self.task_instance_id = m.get('TaskInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetMetaTableOutputResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, data_entity_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.data_entity_list = data_entity_list  # type: list[GetMetaTableOutputResponseBodyDataDataEntityList]

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaTableOutputResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableOutputResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableOutputResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTableOutputResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTableOutputResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableOutputResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableOutputResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableOutputResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableOutputResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTablePartitionRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, table_guid=None, cluster_id=None, database_name=None,
                 table_name=None, data_source_type=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.table_guid = table_guid  # type: str
        self.cluster_id = cluster_id  # type: str
        self.database_name = database_name  # type: str
        self.table_name = table_name  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTablePartitionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTablePartitionResponseBodyDataDataEntityList(TeaModel):
    def __init__(self, partition_path=None, data_size=None, partition_name=None, comment=None, modified_time=None,
                 create_time=None, record_count=None, partition_type=None, partition_guid=None, partition_location=None,
                 table_guid=None):
        self.partition_path = partition_path  # type: str
        self.data_size = data_size  # type: long
        self.partition_name = partition_name  # type: str
        self.comment = comment  # type: str
        self.modified_time = modified_time  # type: long
        self.create_time = create_time  # type: long
        self.record_count = record_count  # type: long
        self.partition_type = partition_type  # type: str
        self.partition_guid = partition_guid  # type: str
        self.partition_location = partition_location  # type: str
        self.table_guid = table_guid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTablePartitionResponseBodyDataDataEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.partition_path is not None:
            result['PartitionPath'] = self.partition_path
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.partition_name is not None:
            result['PartitionName'] = self.partition_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.partition_guid is not None:
            result['PartitionGuid'] = self.partition_guid
        if self.partition_location is not None:
            result['PartitionLocation'] = self.partition_location
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PartitionPath') is not None:
            self.partition_path = m.get('PartitionPath')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('PartitionName') is not None:
            self.partition_name = m.get('PartitionName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('PartitionGuid') is not None:
            self.partition_guid = m.get('PartitionGuid')
        if m.get('PartitionLocation') is not None:
            self.partition_location = m.get('PartitionLocation')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTablePartitionResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, data_entity_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: long
        self.data_entity_list = data_entity_list  # type: list[GetMetaTablePartitionResponseBodyDataDataEntityList]

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaTablePartitionResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTablePartitionResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTablePartitionResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: GetMetaTablePartitionResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMetaTablePartitionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTablePartitionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTablePartitionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTablePartitionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTablePartitionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTablePartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableThemeLevelRequest(TeaModel):
    def __init__(self, table_guid=None, data_source_type=None):
        self.table_guid = table_guid  # type: str
        self.data_source_type = data_source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableThemeLevelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableThemeLevelResponseBodyEntityTheme(TeaModel):
    def __init__(self, parent_id=None, name=None, theme_id=None, level=None):
        self.parent_id = parent_id  # type: long
        self.name = name  # type: str
        self.theme_id = theme_id  # type: long
        self.level = level  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableThemeLevelResponseBodyEntityTheme, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.name is not None:
            result['Name'] = self.name
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class GetMetaTableThemeLevelResponseBodyEntityLevel(TeaModel):
    def __init__(self, type=None, description=None, name=None, level_id=None):
        self.type = type  # type: int
        self.description = description  # type: str
        self.name = name  # type: str
        self.level_id = level_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMetaTableThemeLevelResponseBodyEntityLevel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        return self


class GetMetaTableThemeLevelResponseBodyEntity(TeaModel):
    def __init__(self, theme=None, level=None):
        self.theme = theme  # type: list[GetMetaTableThemeLevelResponseBodyEntityTheme]
        self.level = level  # type: list[GetMetaTableThemeLevelResponseBodyEntityLevel]

    def validate(self):
        if self.theme:
            for k in self.theme:
                if k:
                    k.validate()
        if self.level:
            for k in self.level:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMetaTableThemeLevelResponseBodyEntity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Theme'] = []
        if self.theme is not None:
            for k in self.theme:
                result['Theme'].append(k.to_map() if k else None)
        result['Level'] = []
        if self.level is not None:
            for k in self.level:
                result['Level'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.theme = []
        if m.get('Theme') is not None:
            for k in m.get('Theme'):
                temp_model = GetMetaTableThemeLevelResponseBodyEntityTheme()
                self.theme.append(temp_model.from_map(k))
        self.level = []
        if m.get('Level') is not None:
            for k in m.get('Level'):
                temp_model = GetMetaTableThemeLevelResponseBodyEntityLevel()
                self.level.append(temp_model.from_map(k))
        return self


class GetMetaTableThemeLevelResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, success=None, error_code=None,
                 entity=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.entity = entity  # type: GetMetaTableThemeLevelResponseBodyEntity

    def validate(self):
        if self.entity:
            self.entity.validate()

    def to_map(self):
        _map = super(GetMetaTableThemeLevelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.entity is not None:
            result['Entity'] = self.entity.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Entity') is not None:
            temp_model = GetMetaTableThemeLevelResponseBodyEntity()
            self.entity = temp_model.from_map(m['Entity'])
        return self


class GetMetaTableThemeLevelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMetaTableThemeLevelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMetaTableThemeLevelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableThemeLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMigrationProcessRequest(TeaModel):
    def __init__(self, project_id=None, migration_id=None):
        self.project_id = project_id  # type: long
        self.migration_id = migration_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMigrationProcessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.migration_id is not None:
            result['MigrationId'] = self.migration_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('MigrationId') is not None:
            self.migration_id = m.get('MigrationId')
        return self


class GetMigrationProcessResponseBodyData(TeaModel):
    def __init__(self, task_status=None, task_name=None):
        self.task_status = task_status  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMigrationProcessResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetMigrationProcessResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: list[GetMigrationProcessResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMigrationProcessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetMigrationProcessResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetMigrationProcessResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetMigrationProcessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMigrationProcessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMigrationProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeRequest(TeaModel):
    def __init__(self, node_id=None, project_env=None):
        self.node_id = node_id  # type: long
        self.project_env = project_env  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeResponseBodyData(TeaModel):
    def __init__(self, scheduler_type=None, repeat_interval=None, repeatability=None, project_id=None,
                 program_type=None, priority=None, owner_id=None, connection=None, param_values=None, related_flow_id=None,
                 dqc_type=None, baseline_id=None, description=None, node_name=None, res_group_name=None,
                 dqc_description=None, cron_express=None, node_id=None):
        self.scheduler_type = scheduler_type  # type: str
        self.repeat_interval = repeat_interval  # type: long
        self.repeatability = repeatability  # type: str
        self.project_id = project_id  # type: long
        self.program_type = program_type  # type: str
        self.priority = priority  # type: int
        self.owner_id = owner_id  # type: str
        self.connection = connection  # type: str
        self.param_values = param_values  # type: str
        self.related_flow_id = related_flow_id  # type: long
        self.dqc_type = dqc_type  # type: int
        self.baseline_id = baseline_id  # type: long
        self.description = description  # type: str
        self.node_name = node_name  # type: str
        self.res_group_name = res_group_name  # type: str
        self.dqc_description = dqc_description  # type: str
        self.cron_express = cron_express  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.description is not None:
            result['Description'] = self.description
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.res_group_name is not None:
            result['ResGroupName'] = self.res_group_name
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ResGroupName') is not None:
            self.res_group_name = m.get('ResGroupName')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetNodeResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetNodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetNodeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeChildrenRequest(TeaModel):
    def __init__(self, project_env=None, node_id=None):
        self.project_env = project_env  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeChildrenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeChildrenResponseBodyDataNodes(TeaModel):
    def __init__(self, scheduler_type=None, baseline_id=None, repeatability=None, node_name=None, project_id=None,
                 program_type=None, priority=None, owner_id=None, cron_express=None, node_id=None):
        self.scheduler_type = scheduler_type  # type: str
        self.baseline_id = baseline_id  # type: long
        self.repeatability = repeatability  # type: bool
        self.node_name = node_name  # type: str
        self.project_id = project_id  # type: long
        self.program_type = program_type  # type: str
        self.priority = priority  # type: int
        self.owner_id = owner_id  # type: str
        self.cron_express = cron_express  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeChildrenResponseBodyDataNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeChildrenResponseBodyData(TeaModel):
    def __init__(self, nodes=None):
        self.nodes = nodes  # type: list[GetNodeChildrenResponseBodyDataNodes]

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetNodeChildrenResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeChildrenResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeChildrenResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetNodeChildrenResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetNodeChildrenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetNodeChildrenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeChildrenResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNodeChildrenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNodeChildrenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeChildrenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeCodeRequest(TeaModel):
    def __init__(self, node_id=None, project_env=None):
        self.node_id = node_id  # type: long
        self.project_env = project_env  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeCodeResponseBody(TeaModel):
    def __init__(self, http_status_code=None, data=None, error_message=None, request_id=None, success=None,
                 error_code=None):
        self.http_status_code = http_status_code  # type: int
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeCodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class GetNodeCodeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNodeCodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNodeCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeOnBaselineRequest(TeaModel):
    def __init__(self, baseline_id=None):
        self.baseline_id = baseline_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeOnBaselineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetNodeOnBaselineResponseBodyData(TeaModel):
    def __init__(self, owner=None, node_name=None, node_id=None, project_id=None):
        self.owner = owner  # type: str
        self.node_name = node_name  # type: str
        self.node_id = node_id  # type: long
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeOnBaselineResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetNodeOnBaselineResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: str
        self.data = data  # type: list[GetNodeOnBaselineResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetNodeOnBaselineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetNodeOnBaselineResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetNodeOnBaselineResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNodeOnBaselineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNodeOnBaselineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeOnBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeParentsRequest(TeaModel):
    def __init__(self, project_env=None, node_id=None):
        self.project_env = project_env  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeParentsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeParentsResponseBodyDataNodes(TeaModel):
    def __init__(self, scheduler_type=None, baseline_id=None, repeatability=None, node_name=None, project_id=None,
                 program_type=None, priority=None, owner_id=None, cron_express=None, node_id=None):
        self.scheduler_type = scheduler_type  # type: str
        self.baseline_id = baseline_id  # type: long
        self.repeatability = repeatability  # type: bool
        self.node_name = node_name  # type: str
        self.project_id = project_id  # type: long
        self.program_type = program_type  # type: str
        self.priority = priority  # type: int
        self.owner_id = owner_id  # type: str
        self.cron_express = cron_express  # type: str
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeParentsResponseBodyDataNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeParentsResponseBodyData(TeaModel):
    def __init__(self, nodes=None):
        self.nodes = nodes  # type: list[GetNodeParentsResponseBodyDataNodes]

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetNodeParentsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeParentsResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeParentsResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetNodeParentsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetNodeParentsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetNodeParentsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeParentsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNodeParentsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNodeParentsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeParentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeTypeListInfoRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, page_number=None, page_size=None, keyword=None,
                 locale=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.keyword = keyword  # type: str
        self.locale = locale  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeTypeListInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.locale is not None:
            result['Locale'] = self.locale
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        return self


class GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo(TeaModel):
    def __init__(self, node_type_name=None, node_type=None):
        self.node_type_name = node_type_name  # type: str
        self.node_type = node_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_type_name is not None:
            result['NodeTypeName'] = self.node_type_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeTypeName') is not None:
            self.node_type_name = m.get('NodeTypeName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class GetNodeTypeListInfoResponseBodyNodeTypeInfoList(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, node_type_info=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.node_type_info = node_type_info  # type: list[GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo]

    def validate(self):
        if self.node_type_info:
            for k in self.node_type_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetNodeTypeListInfoResponseBodyNodeTypeInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['NodeTypeInfo'] = []
        if self.node_type_info is not None:
            for k in self.node_type_info:
                result['NodeTypeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.node_type_info = []
        if m.get('NodeTypeInfo') is not None:
            for k in m.get('NodeTypeInfo'):
                temp_model = GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo()
                self.node_type_info.append(temp_model.from_map(k))
        return self


class GetNodeTypeListInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, node_type_info_list=None):
        self.request_id = request_id  # type: str
        self.node_type_info_list = node_type_info_list  # type: GetNodeTypeListInfoResponseBodyNodeTypeInfoList

    def validate(self):
        if self.node_type_info_list:
            self.node_type_info_list.validate()

    def to_map(self):
        _map = super(GetNodeTypeListInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.node_type_info_list is not None:
            result['NodeTypeInfoList'] = self.node_type_info_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NodeTypeInfoList') is not None:
            temp_model = GetNodeTypeListInfoResponseBodyNodeTypeInfoList()
            self.node_type_info_list = temp_model.from_map(m['NodeTypeInfoList'])
        return self


class GetNodeTypeListInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNodeTypeListInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNodeTypeListInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeTypeListInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpRiskDataRequest(TeaModel):
    def __init__(self, page_size=None, page_no=None, name=None, date=None, risk_type=None):
        self.page_size = page_size  # type: int
        self.page_no = page_no  # type: int
        self.name = name  # type: str
        self.date = date  # type: str
        self.risk_type = risk_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOpRiskDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.name is not None:
            result['Name'] = self.name
        if self.date is not None:
            result['Date'] = self.date
        if self.risk_type is not None:
            result['RiskType'] = self.risk_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('RiskType') is not None:
            self.risk_type = m.get('RiskType')
        return self


class GetOpRiskDataResponseBody(TeaModel):
    def __init__(self, risk_data=None, request_id=None):
        self.risk_data = risk_data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOpRiskDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_data is not None:
            result['RiskData'] = self.risk_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RiskData') is not None:
            self.risk_data = m.get('RiskData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOpRiskDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetOpRiskDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetOpRiskDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOpRiskDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpSensitiveDataRequest(TeaModel):
    def __init__(self, name=None, page_size=None, page_no=None, date=None, op_type=None):
        self.name = name  # type: str
        self.page_size = page_size  # type: int
        self.page_no = page_no  # type: int
        self.date = date  # type: str
        self.op_type = op_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOpSensitiveDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.date is not None:
            result['Date'] = self.date
        if self.op_type is not None:
            result['OpType'] = self.op_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('OpType') is not None:
            self.op_type = m.get('OpType')
        return self


class GetOpSensitiveDataResponseBody(TeaModel):
    def __init__(self, op_sensitive_data=None, request_id=None):
        self.op_sensitive_data = op_sensitive_data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOpSensitiveDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.op_sensitive_data is not None:
            result['OpSensitiveData'] = self.op_sensitive_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OpSensitiveData') is not None:
            self.op_sensitive_data = m.get('OpSensitiveData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOpSensitiveDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetOpSensitiveDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetOpSensitiveDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOpSensitiveDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPermissionApplyOrderDetailRequest(TeaModel):
    def __init__(self, flow_id=None):
        self.flow_id = flow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList(TeaModel):
    def __init__(self, base_id=None):
        self.base_id = base_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_id is not None:
            result['BaseId'] = self.base_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaseId') is not None:
            self.base_id = m.get('BaseId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList(TeaModel):
    def __init__(self, grantee_type=None, grantee_type_sub=None, grantee_name=None, grantee_id=None):
        self.grantee_type = grantee_type  # type: int
        self.grantee_type_sub = grantee_type_sub  # type: int
        self.grantee_name = grantee_name  # type: str
        self.grantee_id = grantee_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grantee_type is not None:
            result['GranteeType'] = self.grantee_type
        if self.grantee_type_sub is not None:
            result['GranteeTypeSub'] = self.grantee_type_sub
        if self.grantee_name is not None:
            result['GranteeName'] = self.grantee_name
        if self.grantee_id is not None:
            result['GranteeId'] = self.grantee_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GranteeType') is not None:
            self.grantee_type = m.get('GranteeType')
        if m.get('GranteeTypeSub') is not None:
            self.grantee_type_sub = m.get('GranteeTypeSub')
        if m.get('GranteeName') is not None:
            self.grantee_name = m.get('GranteeName')
        if m.get('GranteeId') is not None:
            self.grantee_id = m.get('GranteeId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList(TeaModel):
    def __init__(self, column_name=None, column_comment=None):
        self.column_name = column_name  # type: str
        self.column_comment = column_comment  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_comment is not None:
            result['ColumnComment'] = self.column_comment
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnComment') is not None:
            self.column_comment = m.get('ColumnComment')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList(TeaModel):
    def __init__(self, object_name=None, column_meta_list=None):
        self.object_name = object_name  # type: str
        self.column_meta_list = column_meta_list  # type: list[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList]

    def validate(self):
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_name is not None:
            result['ObjectName'] = self.object_name
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ObjectName') is not None:
            self.object_name = m.get('ObjectName')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta(TeaModel):
    def __init__(self, max_compute_project_name=None, workspace_id=None, object_meta_list=None):
        self.max_compute_project_name = max_compute_project_name  # type: str
        self.workspace_id = workspace_id  # type: int
        self.object_meta_list = object_meta_list  # type: list[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList]

    def validate(self):
        if self.object_meta_list:
            for k in self.object_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        result['ObjectMetaList'] = []
        if self.object_meta_list is not None:
            for k in self.object_meta_list:
                result['ObjectMetaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        self.object_meta_list = []
        if m.get('ObjectMetaList') is not None:
            for k in m.get('ObjectMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList()
                self.object_meta_list.append(temp_model.from_map(k))
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent(TeaModel):
    def __init__(self, apply_reason=None, deadline=None, order_type=None, project_meta=None):
        self.apply_reason = apply_reason  # type: str
        self.deadline = deadline  # type: long
        self.order_type = order_type  # type: int
        self.project_meta = project_meta  # type: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta

    def validate(self):
        if self.project_meta:
            self.project_meta.validate()

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.project_meta is not None:
            result['ProjectMeta'] = self.project_meta.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('ProjectMeta') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta()
            self.project_meta = temp_model.from_map(m['ProjectMeta'])
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail(TeaModel):
    def __init__(self, apply_base_id=None, apply_timestamp=None, flow_id=None, flow_status=None,
                 approve_account_list=None, grantee_object_list=None, approve_content=None):
        self.apply_base_id = apply_base_id  # type: str
        self.apply_timestamp = apply_timestamp  # type: long
        self.flow_id = flow_id  # type: str
        self.flow_status = flow_status  # type: int
        self.approve_account_list = approve_account_list  # type: list[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList]
        self.grantee_object_list = grantee_object_list  # type: list[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList]
        self.approve_content = approve_content  # type: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent

    def validate(self):
        if self.approve_account_list:
            for k in self.approve_account_list:
                if k:
                    k.validate()
        if self.grantee_object_list:
            for k in self.grantee_object_list:
                if k:
                    k.validate()
        if self.approve_content:
            self.approve_content.validate()

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_base_id is not None:
            result['ApplyBaseId'] = self.apply_base_id
        if self.apply_timestamp is not None:
            result['ApplyTimestamp'] = self.apply_timestamp
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_status is not None:
            result['FlowStatus'] = self.flow_status
        result['ApproveAccountList'] = []
        if self.approve_account_list is not None:
            for k in self.approve_account_list:
                result['ApproveAccountList'].append(k.to_map() if k else None)
        result['GranteeObjectList'] = []
        if self.grantee_object_list is not None:
            for k in self.grantee_object_list:
                result['GranteeObjectList'].append(k.to_map() if k else None)
        if self.approve_content is not None:
            result['ApproveContent'] = self.approve_content.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyBaseId') is not None:
            self.apply_base_id = m.get('ApplyBaseId')
        if m.get('ApplyTimestamp') is not None:
            self.apply_timestamp = m.get('ApplyTimestamp')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowStatus') is not None:
            self.flow_status = m.get('FlowStatus')
        self.approve_account_list = []
        if m.get('ApproveAccountList') is not None:
            for k in m.get('ApproveAccountList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList()
                self.approve_account_list.append(temp_model.from_map(k))
        self.grantee_object_list = []
        if m.get('GranteeObjectList') is not None:
            for k in m.get('GranteeObjectList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList()
                self.grantee_object_list.append(temp_model.from_map(k))
        if m.get('ApproveContent') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent()
            self.approve_content = temp_model.from_map(m['ApproveContent'])
        return self


class GetPermissionApplyOrderDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, apply_order_detail=None):
        self.request_id = request_id  # type: str
        self.apply_order_detail = apply_order_detail  # type: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail

    def validate(self):
        if self.apply_order_detail:
            self.apply_order_detail.validate()

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.apply_order_detail is not None:
            result['ApplyOrderDetail'] = self.apply_order_detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ApplyOrderDetail') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail()
            self.apply_order_detail = temp_model.from_map(m['ApplyOrderDetail'])
        return self


class GetPermissionApplyOrderDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetPermissionApplyOrderDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPermissionApplyOrderDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectRequest(TeaModel):
    def __init__(self, project_id=None):
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectResponseBodyData(TeaModel):
    def __init__(self, status=None, max_flow_node=None, project_id=None, is_allow_download=None, project_mode=None,
                 gmt_modified=None, prod_storage_quota=None, project_description=None, development_type=None,
                 table_privacy_mode=None, default_di_resource_group_identifier=None, scheduler_max_retry_times=None,
                 protected_mode=None, scheduler_retry_interval=None, appkey=None, dev_storage_quota=None, resident_area=None,
                 is_default=None, destination=None, project_name=None, project_identifier=None, disable_development=None,
                 project_owner_base_id=None, base_project=None, use_proxy_odps_account=None, gmt_create=None, tenant_id=None,
                 env_types=None):
        self.status = status  # type: int
        self.max_flow_node = max_flow_node  # type: int
        self.project_id = project_id  # type: int
        self.is_allow_download = is_allow_download  # type: int
        self.project_mode = project_mode  # type: int
        self.gmt_modified = gmt_modified  # type: str
        self.prod_storage_quota = prod_storage_quota  # type: str
        self.project_description = project_description  # type: str
        self.development_type = development_type  # type: int
        self.table_privacy_mode = table_privacy_mode  # type: int
        self.default_di_resource_group_identifier = default_di_resource_group_identifier  # type: str
        self.scheduler_max_retry_times = scheduler_max_retry_times  # type: int
        self.protected_mode = protected_mode  # type: int
        self.scheduler_retry_interval = scheduler_retry_interval  # type: int
        self.appkey = appkey  # type: str
        self.dev_storage_quota = dev_storage_quota  # type: str
        self.resident_area = resident_area  # type: str
        self.is_default = is_default  # type: int
        self.destination = destination  # type: int
        self.project_name = project_name  # type: str
        self.project_identifier = project_identifier  # type: str
        self.disable_development = disable_development  # type: bool
        self.project_owner_base_id = project_owner_base_id  # type: str
        self.base_project = base_project  # type: bool
        self.use_proxy_odps_account = use_proxy_odps_account  # type: bool
        self.gmt_create = gmt_create  # type: str
        self.tenant_id = tenant_id  # type: long
        self.env_types = env_types  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProjectResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.max_flow_node is not None:
            result['MaxFlowNode'] = self.max_flow_node
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.prod_storage_quota is not None:
            result['ProdStorageQuota'] = self.prod_storage_quota
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.table_privacy_mode is not None:
            result['TablePrivacyMode'] = self.table_privacy_mode
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.appkey is not None:
            result['Appkey'] = self.appkey
        if self.dev_storage_quota is not None:
            result['DevStorageQuota'] = self.dev_storage_quota
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.disable_development is not None:
            result['DisableDevelopment'] = self.disable_development
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.base_project is not None:
            result['BaseProject'] = self.base_project
        if self.use_proxy_odps_account is not None:
            result['UseProxyOdpsAccount'] = self.use_proxy_odps_account
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('MaxFlowNode') is not None:
            self.max_flow_node = m.get('MaxFlowNode')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ProdStorageQuota') is not None:
            self.prod_storage_quota = m.get('ProdStorageQuota')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('TablePrivacyMode') is not None:
            self.table_privacy_mode = m.get('TablePrivacyMode')
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('Appkey') is not None:
            self.appkey = m.get('Appkey')
        if m.get('DevStorageQuota') is not None:
            self.dev_storage_quota = m.get('DevStorageQuota')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('DisableDevelopment') is not None:
            self.disable_development = m.get('DisableDevelopment')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('BaseProject') is not None:
            self.base_project = m.get('BaseProject')
        if m.get('UseProxyOdpsAccount') is not None:
            self.use_proxy_odps_account = m.get('UseProxyOdpsAccount')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        return self


class GetProjectResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetProjectResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetProjectResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetProjectResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectDetailRequest(TeaModel):
    def __init__(self, project_id=None):
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProjectDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectDetailResponseBodyData(TeaModel):
    def __init__(self, status=None, resident_area=None, project_id=None, project_identifier=None, project_name=None,
                 is_allow_download=None, project_mode=None, project_description=None, gmt_modified=None, project_owner_base_id=None,
                 development_type=None, default_di_resource_group_identifier=None, gmt_create=None, scheduler_max_retry_times=None,
                 protected_mode=None, tenant_id=None, scheduler_retry_interval=None, env_types=None):
        self.status = status  # type: int
        self.resident_area = resident_area  # type: str
        self.project_id = project_id  # type: int
        self.project_identifier = project_identifier  # type: str
        self.project_name = project_name  # type: str
        self.is_allow_download = is_allow_download  # type: int
        self.project_mode = project_mode  # type: int
        self.project_description = project_description  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.project_owner_base_id = project_owner_base_id  # type: str
        self.development_type = development_type  # type: int
        self.default_di_resource_group_identifier = default_di_resource_group_identifier  # type: str
        self.gmt_create = gmt_create  # type: str
        self.scheduler_max_retry_times = scheduler_max_retry_times  # type: int
        self.protected_mode = protected_mode  # type: int
        self.tenant_id = tenant_id  # type: long
        self.scheduler_retry_interval = scheduler_retry_interval  # type: int
        self.env_types = env_types  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetProjectDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        return self


class GetProjectDetailResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetProjectDetailResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetProjectDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetProjectDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetProjectDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetProjectDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetProjectDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetProjectDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityEntityRequest(TeaModel):
    def __init__(self, project_name=None, table_name=None, env_type=None, match_expression=None):
        self.project_name = project_name  # type: str
        self.table_name = table_name  # type: str
        self.env_type = env_type  # type: str
        self.match_expression = match_expression  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityEntityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        return self


class GetQualityEntityResponseBodyData(TeaModel):
    def __init__(self, relative_node=None, on_duty_account_name=None, task=None, table_name=None, followers=None,
                 on_duty=None, match_expression=None, create_time=None, project_name=None, has_relative_node=None,
                 env_type=None, entity_level=None, modify_user=None, sql=None, id=None, modify_time=None):
        self.relative_node = relative_node  # type: str
        self.on_duty_account_name = on_duty_account_name  # type: str
        self.task = task  # type: int
        self.table_name = table_name  # type: str
        self.followers = followers  # type: str
        self.on_duty = on_duty  # type: str
        self.match_expression = match_expression  # type: str
        self.create_time = create_time  # type: long
        self.project_name = project_name  # type: str
        self.has_relative_node = has_relative_node  # type: bool
        self.env_type = env_type  # type: str
        self.entity_level = entity_level  # type: int
        self.modify_user = modify_user  # type: str
        self.sql = sql  # type: int
        self.id = id  # type: long
        self.modify_time = modify_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityEntityResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relative_node is not None:
            result['RelativeNode'] = self.relative_node
        if self.on_duty_account_name is not None:
            result['OnDutyAccountName'] = self.on_duty_account_name
        if self.task is not None:
            result['Task'] = self.task
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.followers is not None:
            result['Followers'] = self.followers
        if self.on_duty is not None:
            result['OnDuty'] = self.on_duty
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.has_relative_node is not None:
            result['HasRelativeNode'] = self.has_relative_node
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.entity_level is not None:
            result['EntityLevel'] = self.entity_level
        if self.modify_user is not None:
            result['ModifyUser'] = self.modify_user
        if self.sql is not None:
            result['Sql'] = self.sql
        if self.id is not None:
            result['Id'] = self.id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RelativeNode') is not None:
            self.relative_node = m.get('RelativeNode')
        if m.get('OnDutyAccountName') is not None:
            self.on_duty_account_name = m.get('OnDutyAccountName')
        if m.get('Task') is not None:
            self.task = m.get('Task')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Followers') is not None:
            self.followers = m.get('Followers')
        if m.get('OnDuty') is not None:
            self.on_duty = m.get('OnDuty')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('HasRelativeNode') is not None:
            self.has_relative_node = m.get('HasRelativeNode')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('EntityLevel') is not None:
            self.entity_level = m.get('EntityLevel')
        if m.get('ModifyUser') is not None:
            self.modify_user = m.get('ModifyUser')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetQualityEntityResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: list[GetQualityEntityResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetQualityEntityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityEntityResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetQualityEntityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetQualityEntityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityEntityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityFollowerRequest(TeaModel):
    def __init__(self, project_name=None, entity_id=None):
        self.project_name = project_name  # type: str
        self.entity_id = entity_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityFollowerRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class GetQualityFollowerResponseBodyData(TeaModel):
    def __init__(self, follower_account_name=None, table_name=None, alarm_mode=None, entity_id=None,
                 project_name=None, id=None, follower=None):
        self.follower_account_name = follower_account_name  # type: str
        self.table_name = table_name  # type: str
        self.alarm_mode = alarm_mode  # type: int
        self.entity_id = entity_id  # type: str
        self.project_name = project_name  # type: str
        self.id = id  # type: long
        self.follower = follower  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityFollowerResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.follower_account_name is not None:
            result['FollowerAccountName'] = self.follower_account_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.alarm_mode is not None:
            result['AlarmMode'] = self.alarm_mode
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.id is not None:
            result['Id'] = self.id
        if self.follower is not None:
            result['Follower'] = self.follower
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FollowerAccountName') is not None:
            self.follower_account_name = m.get('FollowerAccountName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('AlarmMode') is not None:
            self.alarm_mode = m.get('AlarmMode')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Follower') is not None:
            self.follower = m.get('Follower')
        return self


class GetQualityFollowerResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: list[GetQualityFollowerResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetQualityFollowerResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityFollowerResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetQualityFollowerResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetQualityFollowerResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityFollowerResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleRequest(TeaModel):
    def __init__(self, rule_id=None, project_name=None):
        self.rule_id = rule_id  # type: long
        self.project_name = project_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class GetQualityRuleResponseBodyData(TeaModel):
    def __init__(self, block_type=None, on_duty_account_name=None, warning_threshold=None, property=None,
                 rule_type=None, comment=None, on_duty=None, checker=None, fix_check=None, method_id=None,
                 critical_threshold=None, predict_type=None, template_name=None, checker_name=None, rule_name=None, method_name=None,
                 entity_id=None, where_condition=None, operator=None, expect_value=None, trend=None, template_id=None, id=None):
        self.block_type = block_type  # type: int
        self.on_duty_account_name = on_duty_account_name  # type: str
        self.warning_threshold = warning_threshold  # type: str
        self.property = property  # type: str
        self.rule_type = rule_type  # type: int
        self.comment = comment  # type: str
        self.on_duty = on_duty  # type: str
        self.checker = checker  # type: int
        self.fix_check = fix_check  # type: bool
        self.method_id = method_id  # type: int
        self.critical_threshold = critical_threshold  # type: str
        self.predict_type = predict_type  # type: int
        self.template_name = template_name  # type: str
        self.checker_name = checker_name  # type: str
        self.rule_name = rule_name  # type: str
        self.method_name = method_name  # type: str
        self.entity_id = entity_id  # type: long
        self.where_condition = where_condition  # type: str
        self.operator = operator  # type: str
        self.expect_value = expect_value  # type: str
        self.trend = trend  # type: str
        self.template_id = template_id  # type: int
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.on_duty_account_name is not None:
            result['OnDutyAccountName'] = self.on_duty_account_name
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.property is not None:
            result['Property'] = self.property
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.on_duty is not None:
            result['OnDuty'] = self.on_duty
        if self.checker is not None:
            result['Checker'] = self.checker
        if self.fix_check is not None:
            result['FixCheck'] = self.fix_check
        if self.method_id is not None:
            result['MethodId'] = self.method_id
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.predict_type is not None:
            result['PredictType'] = self.predict_type
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.checker_name is not None:
            result['CheckerName'] = self.checker_name
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('OnDutyAccountName') is not None:
            self.on_duty_account_name = m.get('OnDutyAccountName')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OnDuty') is not None:
            self.on_duty = m.get('OnDuty')
        if m.get('Checker') is not None:
            self.checker = m.get('Checker')
        if m.get('FixCheck') is not None:
            self.fix_check = m.get('FixCheck')
        if m.get('MethodId') is not None:
            self.method_id = m.get('MethodId')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('PredictType') is not None:
            self.predict_type = m.get('PredictType')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('CheckerName') is not None:
            self.checker_name = m.get('CheckerName')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetQualityRuleResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetQualityRuleResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetQualityRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetQualityRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetQualityRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetQualityRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRemindRequest(TeaModel):
    def __init__(self, remind_id=None):
        self.remind_id = remind_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRemindRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class GetRemindResponseBodyDataRobots(TeaModel):
    def __init__(self, web_url=None, at_all=None):
        self.web_url = web_url  # type: str
        self.at_all = at_all  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRemindResponseBodyDataRobots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.web_url is not None:
            result['WebUrl'] = self.web_url
        if self.at_all is not None:
            result['AtAll'] = self.at_all
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WebUrl') is not None:
            self.web_url = m.get('WebUrl')
        if m.get('AtAll') is not None:
            self.at_all = m.get('AtAll')
        return self


class GetRemindResponseBodyDataNodes(TeaModel):
    def __init__(self, owner=None, node_name=None, node_id=None, project_id=None):
        self.owner = owner  # type: str
        self.node_name = node_name  # type: str
        self.node_id = node_id  # type: long
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRemindResponseBodyDataNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetRemindResponseBodyDataBaselines(TeaModel):
    def __init__(self, baseline_name=None, baseline_id=None):
        self.baseline_name = baseline_name  # type: str
        self.baseline_id = baseline_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRemindResponseBodyDataBaselines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetRemindResponseBodyDataProjects(TeaModel):
    def __init__(self, project_id=None):
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRemindResponseBodyDataProjects, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetRemindResponseBodyDataBizProcesses(TeaModel):
    def __init__(self, biz_process_name=None, biz_id=None):
        self.biz_process_name = biz_process_name  # type: str
        self.biz_id = biz_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRemindResponseBodyDataBizProcesses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_process_name is not None:
            result['BizProcessName'] = self.biz_process_name
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizProcessName') is not None:
            self.biz_process_name = m.get('BizProcessName')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        return self


class GetRemindResponseBodyData(TeaModel):
    def __init__(self, max_alert_times=None, remind_unit=None, alert_interval=None, useflag=None, founder=None,
                 remind_id=None, dnd_end=None, remind_type=None, alert_unit=None, dnd_start=None, remind_name=None,
                 detail=None, robots=None, nodes=None, baselines=None, projects=None, biz_processes=None,
                 alert_targets=None, alert_methods=None):
        self.max_alert_times = max_alert_times  # type: int
        self.remind_unit = remind_unit  # type: str
        self.alert_interval = alert_interval  # type: int
        self.useflag = useflag  # type: bool
        self.founder = founder  # type: str
        self.remind_id = remind_id  # type: long
        self.dnd_end = dnd_end  # type: str
        self.remind_type = remind_type  # type: str
        self.alert_unit = alert_unit  # type: str
        self.dnd_start = dnd_start  # type: str
        self.remind_name = remind_name  # type: str
        self.detail = detail  # type: str
        self.robots = robots  # type: list[GetRemindResponseBodyDataRobots]
        self.nodes = nodes  # type: list[GetRemindResponseBodyDataNodes]
        self.baselines = baselines  # type: list[GetRemindResponseBodyDataBaselines]
        self.projects = projects  # type: list[GetRemindResponseBodyDataProjects]
        self.biz_processes = biz_processes  # type: list[GetRemindResponseBodyDataBizProcesses]
        self.alert_targets = alert_targets  # type: list[str]
        self.alert_methods = alert_methods  # type: list[str]

    def validate(self):
        if self.robots:
            for k in self.robots:
                if k:
                    k.validate()
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        if self.baselines:
            for k in self.baselines:
                if k:
                    k.validate()
        if self.projects:
            for k in self.projects:
                if k:
                    k.validate()
        if self.biz_processes:
            for k in self.biz_processes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetRemindResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_alert_times is not None:
            result['MaxAlertTimes'] = self.max_alert_times
        if self.remind_unit is not None:
            result['RemindUnit'] = self.remind_unit
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.useflag is not None:
            result['Useflag'] = self.useflag
        if self.founder is not None:
            result['Founder'] = self.founder
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.dnd_end is not None:
            result['DndEnd'] = self.dnd_end
        if self.remind_type is not None:
            result['RemindType'] = self.remind_type
        if self.alert_unit is not None:
            result['AlertUnit'] = self.alert_unit
        if self.dnd_start is not None:
            result['DndStart'] = self.dnd_start
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.detail is not None:
            result['Detail'] = self.detail
        result['Robots'] = []
        if self.robots is not None:
            for k in self.robots:
                result['Robots'].append(k.to_map() if k else None)
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        result['Baselines'] = []
        if self.baselines is not None:
            for k in self.baselines:
                result['Baselines'].append(k.to_map() if k else None)
        result['Projects'] = []
        if self.projects is not None:
            for k in self.projects:
                result['Projects'].append(k.to_map() if k else None)
        result['BizProcesses'] = []
        if self.biz_processes is not None:
            for k in self.biz_processes:
                result['BizProcesses'].append(k.to_map() if k else None)
        if self.alert_targets is not None:
            result['AlertTargets'] = self.alert_targets
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxAlertTimes') is not None:
            self.max_alert_times = m.get('MaxAlertTimes')
        if m.get('RemindUnit') is not None:
            self.remind_unit = m.get('RemindUnit')
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('Useflag') is not None:
            self.useflag = m.get('Useflag')
        if m.get('Founder') is not None:
            self.founder = m.get('Founder')
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('DndEnd') is not None:
            self.dnd_end = m.get('DndEnd')
        if m.get('RemindType') is not None:
            self.remind_type = m.get('RemindType')
        if m.get('AlertUnit') is not None:
            self.alert_unit = m.get('AlertUnit')
        if m.get('DndStart') is not None:
            self.dnd_start = m.get('DndStart')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        self.robots = []
        if m.get('Robots') is not None:
            for k in m.get('Robots'):
                temp_model = GetRemindResponseBodyDataRobots()
                self.robots.append(temp_model.from_map(k))
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetRemindResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        self.baselines = []
        if m.get('Baselines') is not None:
            for k in m.get('Baselines'):
                temp_model = GetRemindResponseBodyDataBaselines()
                self.baselines.append(temp_model.from_map(k))
        self.projects = []
        if m.get('Projects') is not None:
            for k in m.get('Projects'):
                temp_model = GetRemindResponseBodyDataProjects()
                self.projects.append(temp_model.from_map(k))
        self.biz_processes = []
        if m.get('BizProcesses') is not None:
            for k in m.get('BizProcesses'):
                temp_model = GetRemindResponseBodyDataBizProcesses()
                self.biz_processes.append(temp_model.from_map(k))
        if m.get('AlertTargets') is not None:
            self.alert_targets = m.get('AlertTargets')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        return self


class GetRemindResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetRemindResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRemindResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetRemindResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetRemindResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetRemindResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRemindResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSensitiveDataRequest(TeaModel):
    def __init__(self, page_size=None, page_no=None, name=None):
        self.page_size = page_size  # type: int
        self.page_no = page_no  # type: int
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSensitiveDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetSensitiveDataResponseBody(TeaModel):
    def __init__(self, sensitive_data=None, request_id=None):
        self.sensitive_data = sensitive_data  # type: dict[str, any]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSensitiveDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sensitive_data is not None:
            result['SensitiveData'] = self.sensitive_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SensitiveData') is not None:
            self.sensitive_data = m.get('SensitiveData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetSensitiveDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetSensitiveDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSensitiveDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSensitiveDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSuccessInstanceTrendRequest(TeaModel):
    def __init__(self, project_id=None):
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSuccessInstanceTrendRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend(TeaModel):
    def __init__(self, time_point=None, count=None):
        self.time_point = time_point  # type: str
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend(TeaModel):
    def __init__(self, time_point=None, count=None):
        self.time_point = time_point  # type: str
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend(TeaModel):
    def __init__(self, time_point=None, count=None):
        self.time_point = time_point  # type: str
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrend(TeaModel):
    def __init__(self, today_trend=None, yesterday_trend=None, avg_trend=None):
        self.today_trend = today_trend  # type: list[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend]
        self.yesterday_trend = yesterday_trend  # type: list[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend]
        self.avg_trend = avg_trend  # type: list[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend]

    def validate(self):
        if self.today_trend:
            for k in self.today_trend:
                if k:
                    k.validate()
        if self.yesterday_trend:
            for k in self.yesterday_trend:
                if k:
                    k.validate()
        if self.avg_trend:
            for k in self.avg_trend:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSuccessInstanceTrendResponseBodyInstanceStatusTrend, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TodayTrend'] = []
        if self.today_trend is not None:
            for k in self.today_trend:
                result['TodayTrend'].append(k.to_map() if k else None)
        result['YesterdayTrend'] = []
        if self.yesterday_trend is not None:
            for k in self.yesterday_trend:
                result['YesterdayTrend'].append(k.to_map() if k else None)
        result['AvgTrend'] = []
        if self.avg_trend is not None:
            for k in self.avg_trend:
                result['AvgTrend'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.today_trend = []
        if m.get('TodayTrend') is not None:
            for k in m.get('TodayTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend()
                self.today_trend.append(temp_model.from_map(k))
        self.yesterday_trend = []
        if m.get('YesterdayTrend') is not None:
            for k in m.get('YesterdayTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend()
                self.yesterday_trend.append(temp_model.from_map(k))
        self.avg_trend = []
        if m.get('AvgTrend') is not None:
            for k in m.get('AvgTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend()
                self.avg_trend.append(temp_model.from_map(k))
        return self


class GetSuccessInstanceTrendResponseBody(TeaModel):
    def __init__(self, request_id=None, instance_status_trend=None):
        self.request_id = request_id  # type: str
        self.instance_status_trend = instance_status_trend  # type: GetSuccessInstanceTrendResponseBodyInstanceStatusTrend

    def validate(self):
        if self.instance_status_trend:
            self.instance_status_trend.validate()

    def to_map(self):
        _map = super(GetSuccessInstanceTrendResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_status_trend is not None:
            result['InstanceStatusTrend'] = self.instance_status_trend.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceStatusTrend') is not None:
            temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrend()
            self.instance_status_trend = temp_model.from_map(m['InstanceStatusTrend'])
        return self


class GetSuccessInstanceTrendResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetSuccessInstanceTrendResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSuccessInstanceTrendResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSuccessInstanceTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicRequest(TeaModel):
    def __init__(self, topic_id=None):
        self.topic_id = topic_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTopicRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicResponseBodyData(TeaModel):
    def __init__(self, owner=None, topic_name=None, baseline_status=None, project_id=None, next_alert_time=None,
                 instance_id=None, fix_time=None, baseline_in_group_id=None, baseline_buffer=None, topic_type=None,
                 topic_status=None, happen_time=None, deal_time=None, deal_user=None, baseline_name=None, baseline_id=None,
                 node_name=None, alert_time=None, buffer=None, assigner=None, topic_id=None, add_time=None, node_id=None):
        self.owner = owner  # type: str
        self.topic_name = topic_name  # type: str
        self.baseline_status = baseline_status  # type: str
        self.project_id = project_id  # type: long
        self.next_alert_time = next_alert_time  # type: long
        self.instance_id = instance_id  # type: long
        self.fix_time = fix_time  # type: long
        self.baseline_in_group_id = baseline_in_group_id  # type: int
        self.baseline_buffer = baseline_buffer  # type: long
        self.topic_type = topic_type  # type: str
        self.topic_status = topic_status  # type: str
        self.happen_time = happen_time  # type: long
        self.deal_time = deal_time  # type: long
        self.deal_user = deal_user  # type: str
        self.baseline_name = baseline_name  # type: str
        self.baseline_id = baseline_id  # type: long
        self.node_name = node_name  # type: str
        self.alert_time = alert_time  # type: long
        self.buffer = buffer  # type: long
        self.assigner = assigner  # type: str
        self.topic_id = topic_id  # type: long
        self.add_time = add_time  # type: long
        self.node_id = node_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTopicResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.baseline_status is not None:
            result['BaselineStatus'] = self.baseline_status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.next_alert_time is not None:
            result['NextAlertTime'] = self.next_alert_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.fix_time is not None:
            result['FixTime'] = self.fix_time
        if self.baseline_in_group_id is not None:
            result['BaselineInGroupId'] = self.baseline_in_group_id
        if self.baseline_buffer is not None:
            result['BaselineBuffer'] = self.baseline_buffer
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        if self.happen_time is not None:
            result['HappenTime'] = self.happen_time
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_user is not None:
            result['DealUser'] = self.deal_user
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.assigner is not None:
            result['Assigner'] = self.assigner
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('BaselineStatus') is not None:
            self.baseline_status = m.get('BaselineStatus')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('NextAlertTime') is not None:
            self.next_alert_time = m.get('NextAlertTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('FixTime') is not None:
            self.fix_time = m.get('FixTime')
        if m.get('BaselineInGroupId') is not None:
            self.baseline_in_group_id = m.get('BaselineInGroupId')
        if m.get('BaselineBuffer') is not None:
            self.baseline_buffer = m.get('BaselineBuffer')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        if m.get('HappenTime') is not None:
            self.happen_time = m.get('HappenTime')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealUser') is not None:
            self.deal_user = m.get('DealUser')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('Assigner') is not None:
            self.assigner = m.get('Assigner')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetTopicResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetTopicResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetTopicResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetTopicResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetTopicResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetTopicResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTopicResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicInfluenceRequest(TeaModel):
    def __init__(self, topic_id=None):
        self.topic_id = topic_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTopicInfluenceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicInfluenceResponseBodyDataInfluences(TeaModel):
    def __init__(self, status=None, owner=None, baseline_name=None, baseline_id=None, bizdate=None, buffer=None,
                 project_id=None, priority=None, in_group_id=None):
        self.status = status  # type: str
        self.owner = owner  # type: str
        self.baseline_name = baseline_name  # type: str
        self.baseline_id = baseline_id  # type: long
        self.bizdate = bizdate  # type: long
        self.buffer = buffer  # type: long
        self.project_id = project_id  # type: long
        self.priority = priority  # type: int
        self.in_group_id = in_group_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTopicInfluenceResponseBodyDataInfluences, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetTopicInfluenceResponseBodyData(TeaModel):
    def __init__(self, topic_id=None, influences=None):
        self.topic_id = topic_id  # type: long
        self.influences = influences  # type: list[GetTopicInfluenceResponseBodyDataInfluences]

    def validate(self):
        if self.influences:
            for k in self.influences:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTopicInfluenceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        result['Influences'] = []
        if self.influences is not None:
            for k in self.influences:
                result['Influences'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        self.influences = []
        if m.get('Influences') is not None:
            for k in m.get('Influences'):
                temp_model = GetTopicInfluenceResponseBodyDataInfluences()
                self.influences.append(temp_model.from_map(k))
        return self


class GetTopicInfluenceResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetTopicInfluenceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetTopicInfluenceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetTopicInfluenceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetTopicInfluenceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetTopicInfluenceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTopicInfluenceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTopicInfluenceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportConnectionsRequest(TeaModel):
    def __init__(self, project_id=None, connections=None):
        self.project_id = project_id  # type: long
        self.connections = connections  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportConnectionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.connections is not None:
            result['Connections'] = self.connections
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Connections') is not None:
            self.connections = m.get('Connections')
        return self


class ImportConnectionsResponseBodyData(TeaModel):
    def __init__(self, status=None, message=None):
        self.status = status  # type: bool
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportConnectionsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ImportConnectionsResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: ImportConnectionsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ImportConnectionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ImportConnectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportConnectionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ImportConnectionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportConnectionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportDataSourcesRequest(TeaModel):
    def __init__(self, project_id=None, data_sources=None):
        self.project_id = project_id  # type: long
        self.data_sources = data_sources  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportDataSourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.data_sources is not None:
            result['DataSources'] = self.data_sources
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DataSources') is not None:
            self.data_sources = m.get('DataSources')
        return self


class ImportDataSourcesResponseBodyData(TeaModel):
    def __init__(self, status=None, message=None):
        self.status = status  # type: bool
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportDataSourcesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ImportDataSourcesResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, data=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.data = data  # type: ImportDataSourcesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ImportDataSourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ImportDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportDataSourcesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ImportDataSourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportDataSourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportDISyncTasksRequest(TeaModel):
    def __init__(self, project_id=None, task_type=None, task_content=None, task_param=None):
        self.project_id = project_id  # type: long
        self.task_type = task_type  # type: str
        self.task_content = task_content  # type: str
        self.task_param = task_param  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportDISyncTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        return self


class ImportDISyncTasksResponseBodyTaskInfo(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportDISyncTasksResponseBodyTaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ImportDISyncTasksResponseBody(TeaModel):
    def __init__(self, success=None, request_id=None, task_info=None):
        self.success = success  # type: bool
        self.request_id = request_id  # type: str
        self.task_info = task_info  # type: ImportDISyncTasksResponseBodyTaskInfo

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super(ImportDISyncTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = ImportDISyncTasksResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class ImportDISyncTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ImportDISyncTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportDISyncTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportDISyncTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlertMessagesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, begin_time=None, end_time=None, remind_id=None,
                 alert_methods=None, alert_user=None, alert_rule_types=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.begin_time = begin_time  # type: str
        self.end_time = end_time  # type: str
        self.remind_id = remind_id  # type: long
        self.alert_methods = alert_methods  # type: str
        self.alert_user = alert_user  # type: str
        self.alert_rule_types = alert_rule_types  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertMessagesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.alert_rule_types is not None:
            result['AlertRuleTypes'] = self.alert_rule_types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('AlertRuleTypes') is not None:
            self.alert_rule_types = m.get('AlertRuleTypes')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesInstances(TeaModel):
    def __init__(self, status=None, instance_id=None, node_name=None, node_id=None, project_id=None):
        self.status = status  # type: str
        self.instance_id = instance_id  # type: long
        self.node_name = node_name  # type: str
        self.node_id = node_id  # type: long
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertMessagesResponseBodyDataAlertMessagesInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesTopics(TeaModel):
    def __init__(self, topic_name=None, instance_id=None, topic_id=None, topic_owner=None, node_id=None,
                 topic_status=None):
        self.topic_name = topic_name  # type: str
        self.instance_id = instance_id  # type: long
        self.topic_id = topic_id  # type: long
        self.topic_owner = topic_owner  # type: str
        self.node_id = node_id  # type: long
        self.topic_status = topic_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertMessagesResponseBodyDataAlertMessagesTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_owner is not None:
            result['TopicOwner'] = self.topic_owner
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicOwner') is not None:
            self.topic_owner = m.get('TopicOwner')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesNodes(TeaModel):
    def __init__(self, owner=None, node_name=None, node_id=None, project_id=None):
        self.owner = owner  # type: str
        self.node_name = node_name  # type: str
        self.node_id = node_id  # type: long
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertMessagesResponseBodyDataAlertMessagesNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert(TeaModel):
    def __init__(self, status=None, baseline_owner=None, baseline_id=None, baseline_name=None, bizdate=None,
                 project_id=None, in_group_id=None):
        self.status = status  # type: str
        self.baseline_owner = baseline_owner  # type: str
        self.baseline_id = baseline_id  # type: long
        self.baseline_name = baseline_name  # type: str
        self.bizdate = bizdate  # type: long
        self.project_id = project_id  # type: long
        self.in_group_id = in_group_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.baseline_owner is not None:
            result['BaselineOwner'] = self.baseline_owner
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BaselineOwner') is not None:
            self.baseline_owner = m.get('BaselineOwner')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessages(TeaModel):
    def __init__(self, remind_id=None, alert_message_status=None, alert_user=None, alert_time=None,
                 alert_method=None, source=None, content=None, remind_name=None, alert_id=None, instances=None, topics=None,
                 nodes=None, sla_alert=None):
        self.remind_id = remind_id  # type: long
        self.alert_message_status = alert_message_status  # type: str
        self.alert_user = alert_user  # type: str
        self.alert_time = alert_time  # type: long
        self.alert_method = alert_method  # type: str
        self.source = source  # type: str
        self.content = content  # type: str
        self.remind_name = remind_name  # type: str
        self.alert_id = alert_id  # type: long
        self.instances = instances  # type: list[ListAlertMessagesResponseBodyDataAlertMessagesInstances]
        self.topics = topics  # type: list[ListAlertMessagesResponseBodyDataAlertMessagesTopics]
        self.nodes = nodes  # type: list[ListAlertMessagesResponseBodyDataAlertMessagesNodes]
        self.sla_alert = sla_alert  # type: ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        if self.sla_alert:
            self.sla_alert.validate()

    def to_map(self):
        _map = super(ListAlertMessagesResponseBodyDataAlertMessages, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.alert_message_status is not None:
            result['AlertMessageStatus'] = self.alert_message_status
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.alert_method is not None:
            result['AlertMethod'] = self.alert_method
        if self.source is not None:
            result['Source'] = self.source
        if self.content is not None:
            result['Content'] = self.content
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.sla_alert is not None:
            result['SlaAlert'] = self.sla_alert.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('AlertMessageStatus') is not None:
            self.alert_message_status = m.get('AlertMessageStatus')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('AlertMethod') is not None:
            self.alert_method = m.get('AlertMethod')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesInstances()
                self.instances.append(temp_model.from_map(k))
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesTopics()
                self.topics.append(temp_model.from_map(k))
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('SlaAlert') is not None:
            temp_model = ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert()
            self.sla_alert = temp_model.from_map(m['SlaAlert'])
        return self


class ListAlertMessagesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, alert_messages=None):
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.total_count = total_count  # type: str
        self.alert_messages = alert_messages  # type: list[ListAlertMessagesResponseBodyDataAlertMessages]

    def validate(self):
        if self.alert_messages:
            for k in self.alert_messages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAlertMessagesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['AlertMessages'] = []
        if self.alert_messages is not None:
            for k in self.alert_messages:
                result['AlertMessages'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.alert_messages = []
        if m.get('AlertMessages') is not None:
            for k in m.get('AlertMessages'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessages()
                self.alert_messages.append(temp_model.from_map(k))
        return self


class ListAlertMessagesResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListAlertMessagesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListAlertMessagesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListAlertMessagesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListAlertMessagesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListAlertMessagesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAlertMessagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAlertMessagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBaselineConfigsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, owner=None, project_id=None, priority=None, useflag=None,
                 baseline_types=None, search_text=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.owner = owner  # type: str
        self.project_id = project_id  # type: long
        self.priority = priority  # type: str
        self.useflag = useflag  # type: bool
        self.baseline_types = baseline_types  # type: str
        self.search_text = search_text  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBaselineConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.useflag is not None:
            result['Useflag'] = self.useflag
        if self.baseline_types is not None:
            result['BaselineTypes'] = self.baseline_types
        if self.search_text is not None:
            result['SearchText'] = self.search_text
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Useflag') is not None:
            self.useflag = m.get('Useflag')
        if m.get('BaselineTypes') is not None:
            self.baseline_types = m.get('BaselineTypes')
        if m.get('SearchText') is not None:
            self.search_text = m.get('SearchText')
        return self


class ListBaselineConfigsResponseBodyDataBaselines(TeaModel):
    def __init__(self, hour_sla_detail=None, is_default=None, owner=None, project_id=None, priority=None,
                 sla_minu=None, sla_hour=None, baseline_id=None, baseline_name=None, hour_exp_detail=None, use_flag=None,
                 exp_hour=None, baseline_type=None, exp_minu=None):
        self.hour_sla_detail = hour_sla_detail  # type: str
        self.is_default = is_default  # type: bool
        self.owner = owner  # type: str
        self.project_id = project_id  # type: long
        self.priority = priority  # type: int
        self.sla_minu = sla_minu  # type: int
        self.sla_hour = sla_hour  # type: int
        self.baseline_id = baseline_id  # type: long
        self.baseline_name = baseline_name  # type: str
        self.hour_exp_detail = hour_exp_detail  # type: str
        self.use_flag = use_flag  # type: bool
        self.exp_hour = exp_hour  # type: int
        self.baseline_type = baseline_type  # type: str
        self.exp_minu = exp_minu  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBaselineConfigsResponseBodyDataBaselines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        return self


class ListBaselineConfigsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, baselines=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.baselines = baselines  # type: list[ListBaselineConfigsResponseBodyDataBaselines]

    def validate(self):
        if self.baselines:
            for k in self.baselines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBaselineConfigsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Baselines'] = []
        if self.baselines is not None:
            for k in self.baselines:
                result['Baselines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.baselines = []
        if m.get('Baselines') is not None:
            for k in m.get('Baselines'):
                temp_model = ListBaselineConfigsResponseBodyDataBaselines()
                self.baselines.append(temp_model.from_map(k))
        return self


class ListBaselineConfigsResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListBaselineConfigsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListBaselineConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListBaselineConfigsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListBaselineConfigsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListBaselineConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBaselineConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBaselineConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBaselineStatusesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, bizdate=None, priority=None, search_text=None, owner=None,
                 topic_id=None, finish_status=None, status=None, baseline_types=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.bizdate = bizdate  # type: str
        self.priority = priority  # type: str
        self.search_text = search_text  # type: str
        self.owner = owner  # type: str
        self.topic_id = topic_id  # type: long
        self.finish_status = finish_status  # type: str
        self.status = status  # type: str
        self.baseline_types = baseline_types  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBaselineStatusesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.search_text is not None:
            result['SearchText'] = self.search_text
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.status is not None:
            result['Status'] = self.status
        if self.baseline_types is not None:
            result['BaselineTypes'] = self.baseline_types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SearchText') is not None:
            self.search_text = m.get('SearchText')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BaselineTypes') is not None:
            self.baseline_types = m.get('BaselineTypes')
        return self


class ListBaselineStatusesResponseBodyDataBaselineStatuses(TeaModel):
    def __init__(self, status=None, owner=None, finish_time=None, project_id=None, priority=None, end_cast=None,
                 in_group_id=None, baseline_name=None, baseline_id=None, finish_status=None, bizdate=None, buffer=None,
                 sla_time=None, exp_time=None):
        self.status = status  # type: str
        self.owner = owner  # type: str
        self.finish_time = finish_time  # type: long
        self.project_id = project_id  # type: long
        self.priority = priority  # type: int
        self.end_cast = end_cast  # type: long
        self.in_group_id = in_group_id  # type: int
        self.baseline_name = baseline_name  # type: str
        self.baseline_id = baseline_id  # type: long
        self.finish_status = finish_status  # type: str
        self.bizdate = bizdate  # type: long
        self.buffer = buffer  # type: long
        self.sla_time = sla_time  # type: long
        self.exp_time = exp_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBaselineStatusesResponseBodyDataBaselineStatuses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.sla_time is not None:
            result['SlaTime'] = self.sla_time
        if self.exp_time is not None:
            result['ExpTime'] = self.exp_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('SlaTime') is not None:
            self.sla_time = m.get('SlaTime')
        if m.get('ExpTime') is not None:
            self.exp_time = m.get('ExpTime')
        return self


class ListBaselineStatusesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, baseline_statuses=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.baseline_statuses = baseline_statuses  # type: list[ListBaselineStatusesResponseBodyDataBaselineStatuses]

    def validate(self):
        if self.baseline_statuses:
            for k in self.baseline_statuses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBaselineStatusesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['BaselineStatuses'] = []
        if self.baseline_statuses is not None:
            for k in self.baseline_statuses:
                result['BaselineStatuses'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.baseline_statuses = []
        if m.get('BaselineStatuses') is not None:
            for k in m.get('BaselineStatuses'):
                temp_model = ListBaselineStatusesResponseBodyDataBaselineStatuses()
                self.baseline_statuses.append(temp_model.from_map(k))
        return self


class ListBaselineStatusesResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListBaselineStatusesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListBaselineStatusesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListBaselineStatusesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListBaselineStatusesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListBaselineStatusesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBaselineStatusesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBaselineStatusesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBusinessRequest(TeaModel):
    def __init__(self, project_id=None, project_identifier=None, page_number=None, page_size=None, keyword=None):
        self.project_id = project_id  # type: long
        self.project_identifier = project_identifier  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.keyword = keyword  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBusinessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        return self


class ListBusinessResponseBodyDataBusiness(TeaModel):
    def __init__(self, owner=None, description=None, project_id=None, business_id=None, business_name=None,
                 use_type=None):
        self.owner = owner  # type: str
        self.description = description  # type: str
        self.project_id = project_id  # type: long
        self.business_id = business_id  # type: long
        self.business_name = business_name  # type: str
        self.use_type = use_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBusinessResponseBodyDataBusiness, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.description is not None:
            result['Description'] = self.description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class ListBusinessResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, business=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.business = business  # type: list[ListBusinessResponseBodyDataBusiness]

    def validate(self):
        if self.business:
            for k in self.business:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBusinessResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Business'] = []
        if self.business is not None:
            for k in self.business:
                result['Business'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.business = []
        if m.get('Business') is not None:
            for k in m.get('Business'):
                temp_model = ListBusinessResponseBodyDataBusiness()
                self.business.append(temp_model.from_map(k))
        return self


class ListBusinessResponseBody(TeaModel):
    def __init__(self, http_status_code=None, error_message=None, request_id=None, error_code=None, success=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.error_code = error_code  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListBusinessResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListBusinessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListBusinessResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListBusinessResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListBusinessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBusinessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCalcEnginesRequest(TeaModel):
    def __init__(self, project_id=None, name=None, calc_engine_type=None, env_type=None, page_size=None,
                 page_number=None):
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.calc_engine_type = calc_engine_type  # type: str
        self.env_type = env_type  # type: str
        self.page_size = page_size  # type: int
        self.page_number = page_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCalcEnginesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListCalcEnginesResponseBodyDataCalcEngines(TeaModel):
    def __init__(self, binding_project_name=None, is_default=None, engine_id=None, dw_region=None,
                 task_auth_type=None, calc_engine_type=None, engine_info=None, env_type=None, region=None, gmt_create=None,
                 binding_project_id=None, name=None, tenant_id=None):
        self.binding_project_name = binding_project_name  # type: str
        self.is_default = is_default  # type: bool
        self.engine_id = engine_id  # type: int
        self.dw_region = dw_region  # type: str
        self.task_auth_type = task_auth_type  # type: str
        self.calc_engine_type = calc_engine_type  # type: str
        self.engine_info = engine_info  # type: dict[str, any]
        self.env_type = env_type  # type: str
        self.region = region  # type: str
        self.gmt_create = gmt_create  # type: str
        self.binding_project_id = binding_project_id  # type: int
        self.name = name  # type: str
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCalcEnginesResponseBodyDataCalcEngines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binding_project_name is not None:
            result['BindingProjectName'] = self.binding_project_name
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.engine_id is not None:
            result['EngineId'] = self.engine_id
        if self.dw_region is not None:
            result['DwRegion'] = self.dw_region
        if self.task_auth_type is not None:
            result['TaskAuthType'] = self.task_auth_type
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.engine_info is not None:
            result['EngineInfo'] = self.engine_info
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.region is not None:
            result['Region'] = self.region
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.binding_project_id is not None:
            result['BindingProjectId'] = self.binding_project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindingProjectName') is not None:
            self.binding_project_name = m.get('BindingProjectName')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('EngineId') is not None:
            self.engine_id = m.get('EngineId')
        if m.get('DwRegion') is not None:
            self.dw_region = m.get('DwRegion')
        if m.get('TaskAuthType') is not None:
            self.task_auth_type = m.get('TaskAuthType')
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('EngineInfo') is not None:
            self.engine_info = m.get('EngineInfo')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('BindingProjectId') is not None:
            self.binding_project_id = m.get('BindingProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListCalcEnginesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, calc_engines=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.calc_engines = calc_engines  # type: list[ListCalcEnginesResponseBodyDataCalcEngines]

    def validate(self):
        if self.calc_engines:
            for k in self.calc_engines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCalcEnginesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['CalcEngines'] = []
        if self.calc_engines is not None:
            for k in self.calc_engines:
                result['CalcEngines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.calc_engines = []
        if m.get('CalcEngines') is not None:
            for k in m.get('CalcEngines'):
                temp_model = ListCalcEnginesResponseBodyDataCalcEngines()
                self.calc_engines.append(temp_model.from_map(k))
        return self


class ListCalcEnginesResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListCalcEnginesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCalcEnginesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListCalcEnginesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListCalcEnginesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListCalcEnginesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCalcEnginesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCalcEnginesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConnectionsRequest(TeaModel):
    def __init__(self, project_id=None, name=None, connection_type=None, sub_type=None, status=None, env_type=None,
                 page_size=None, page_number=None):
        self.project_id = project_id  # type: long
        self.name = name  # type: str
        self.connection_type = connection_type  # type: str
        self.sub_type = sub_type  # type: str
        self.status = status  # type: str
        self.env_type = env_type  # type: int
        self.page_size = page_size  # type: int
        self.page_number = page_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConnectionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.status is not None:
            result['Status'] = self.status
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListConnectionsResponseBodyDataConnections(TeaModel):
    def __init__(self, status=None, connection_type=None, project_id=None, sub_type=None, gmt_modified=None,
                 env_type=None, connect_status=None, sequence=None, description=None, gmt_create=None, default_engine=None,
                 shared=None, operator=None, name=None, content=None, id=None, binding_calc_engine_id=None, tenant_id=None):
        self.status = status  # type: int
        self.connection_type = connection_type  # type: str
        self.project_id = project_id  # type: int
        self.sub_type = sub_type  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.env_type = env_type  # type: int
        self.connect_status = connect_status  # type: int
        self.sequence = sequence  # type: int
        self.description = description  # type: str
        self.gmt_create = gmt_create  # type: str
        self.default_engine = default_engine  # type: bool
        self.shared = shared  # type: bool
        self.operator = operator  # type: str
        self.name = name  # type: str
        self.content = content  # type: str
        self.id = id  # type: int
        self.binding_calc_engine_id = binding_calc_engine_id  # type: int
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConnectionsResponseBodyDataConnections, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.name is not None:
            result['Name'] = self.name
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListConnectionsResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, connections=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.connections = connections  # type: list[ListConnectionsResponseBodyDataConnections]

    def validate(self):
        if self.connections:
            for k in self.connections:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListConnectionsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Connections'] = []
        if self.connections is not None:
            for k in self.connections:
                result['Connections'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.connections = []
        if m.get('Connections') is not None:
            for k in m.get('Connections'):
                temp_model = ListConnectionsResponseBodyDataConnections()
                self.connections.append(temp_model.from_map(k))
        return self


class ListConnectionsResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, success=None, data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListConnectionsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListConnectionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListConnectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListConnectionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListConnectionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListConnectionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDataServiceApiAuthoritiesRequest(TeaModel):
    def __init__(self, project_id=None, page_number=None, page_size=None, tenant_id=None, api_name_keyword=None):
        self.project_id = project_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.tenant_id = tenant_id  # type: long
        self.api_name_keyword = api_name_keyword  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApiAuthoritiesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_name_keyword is not None:
            result['ApiNameKeyword'] = self.api_name_keyword
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiNameKeyword') is not None:
            self.api_name_keyword = m.get('ApiNameKeyword')
        return self


class ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords(TeaModel):
    def __init__(self, end_time=None, creator_id=None, created_time=None, project_id=None):
        self.end_time = end_time  # type: str
        self.creator_id = creator_id  # type: str
        self.created_time = created_time  # type: str
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList(TeaModel):
    def __init__(self, api_status=None, api_id=None, modified_time=None, group_id=None, project_id=None,
                 creator_id=None, created_time=None, api_name=None, tenant_id=None, api_path=None, authorization_records=None):
        self.api_status = api_status  # type: int
        self.api_id = api_id  # type: long
        self.modified_time = modified_time  # type: str
        self.group_id = group_id  # type: str
        self.project_id = project_id  # type: long
        self.creator_id = creator_id  # type: str
        self.created_time = created_time  # type: str
        self.api_name = api_name  # type: str
        self.tenant_id = tenant_id  # type: long
        self.api_path = api_path  # type: str
        self.authorization_records = authorization_records  # type: list[ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords]

    def validate(self):
        if self.authorization_records:
            for k in self.authorization_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_status is not None:
            result['ApiStatus'] = self.api_status
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        result['AuthorizationRecords'] = []
        if self.authorization_records is not None:
            for k in self.authorization_records:
                result['AuthorizationRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiStatus') is not None:
            self.api_status = m.get('ApiStatus')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        self.authorization_records = []
        if m.get('AuthorizationRecords') is not None:
            for k in m.get('AuthorizationRecords'):
                temp_model = ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords()
                self.authorization_records.append(temp_model.from_map(k))
        return self


class ListDataServiceApiAuthoritiesResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, api_authorization_list=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.api_authorization_list = api_authorization_list  # type: list[ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList]

    def validate(self):
        if self.api_authorization_list:
            for k in self.api_authorization_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDataServiceApiAuthoritiesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ApiAuthorizationList'] = []
        if self.api_authorization_list is not None:
            for k in self.api_authorization_list:
                result['ApiAuthorizationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.api_authorization_list = []
        if m.get('ApiAuthorizationList') is not None:
            for k in m.get('ApiAuthorizationList'):
                temp_model = ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList()
                self.api_authorization_list.append(temp_model.from_map(k))
        return self


class ListDataServiceApiAuthoritiesResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: ListDataServiceApiAuthoritiesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDataServiceApiAuthoritiesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = ListDataServiceApiAuthoritiesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDataServiceApiAuthoritiesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDataServiceApiAuthoritiesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDataServiceApiAuthoritiesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDataServiceApiAuthoritiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDataServiceApisRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, project_id=None, tenant_id=None, api_name_keyword=None,
                 api_path_keyword=None, creator_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.project_id = project_id  # type: long
        self.tenant_id = tenant_id  # type: long
        self.api_name_keyword = api_name_keyword  # type: str
        self.api_path_keyword = api_path_keyword  # type: str
        self.creator_id = creator_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_name_keyword is not None:
            result['ApiNameKeyword'] = self.api_name_keyword
        if self.api_path_keyword is not None:
            result['ApiPathKeyword'] = self.api_path_keyword
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiNameKeyword') is not None:
            self.api_name_keyword = m.get('ApiNameKeyword')
        if m.get('ApiPathKeyword') is not None:
            self.api_path_keyword = m.get('ApiPathKeyword')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(self, error_message=None, error_code=None, error_solution=None):
        self.error_message = error_message  # type: str
        self.error_code = error_code  # type: str
        self.error_solution = error_solution  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(self, column_name=None, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, parameter_data_type=None, example_value=None,
                 is_required_parameter=None):
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetails(TeaModel):
    def __init__(self, service_host=None, service_content_type=None, service_path=None,
                 successful_result_sample=None, failed_result_sample=None, service_request_body_description=None,
                 registration_error_codes=None, registration_request_parameters=None):
        self.service_host = service_host  # type: str
        self.service_content_type = service_content_type  # type: int
        self.service_path = service_path  # type: str
        self.successful_result_sample = successful_result_sample  # type: str
        self.failed_result_sample = failed_result_sample  # type: str
        self.service_request_body_description = service_request_body_description  # type: str
        self.registration_error_codes = registration_error_codes  # type: list[ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes]
        self.registration_request_parameters = registration_request_parameters  # type: list[ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters]

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisRegistrationDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(self, column_name=None, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, parameter_data_type=None, example_value=None,
                 is_required_parameter=None):
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(self, parameter_description=None, column_name=None, parameter_name=None, parameter_data_type=None,
                 example_value=None):
        self.parameter_description = parameter_description  # type: str
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection(TeaModel):
    def __init__(self, table_name=None, connection_id=None):
        self.table_name = table_name  # type: str
        self.connection_id = connection_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetails(TeaModel):
    def __init__(self, script=None, is_paged_response=None, script_request_parameters=None,
                 script_response_parameters=None, script_connection=None):
        self.script = script  # type: str
        self.is_paged_response = is_paged_response  # type: bool
        self.script_request_parameters = script_request_parameters  # type: list[ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters]
        self.script_response_parameters = script_response_parameters  # type: list[ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters]
        self.script_connection = script_connection  # type: ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection

    def validate(self):
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()
        if self.script_connection:
            self.script_connection.validate()

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisScriptDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script is not None:
            result['Script'] = self.script
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('ScriptConnection') is not None:
            temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(self, column_name=None, parameter_name=None, parameter_position=None, parameter_description=None,
                 default_value=None, parameter_operator=None, parameter_data_type=None, example_value=None,
                 is_required_parameter=None):
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_position = parameter_position  # type: int
        self.parameter_description = parameter_description  # type: str
        self.default_value = default_value  # type: str
        self.parameter_operator = parameter_operator  # type: int
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str
        self.is_required_parameter = is_required_parameter  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisWizardDetailsWizardRequestParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(self, parameter_description=None, column_name=None, parameter_name=None, parameter_data_type=None,
                 example_value=None):
        self.parameter_description = parameter_description  # type: str
        self.column_name = column_name  # type: str
        self.parameter_name = parameter_name  # type: str
        self.parameter_data_type = parameter_data_type  # type: int
        self.example_value = example_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisWizardDetailsWizardResponseParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardConnection(TeaModel):
    def __init__(self, table_name=None, connection_id=None):
        self.table_name = table_name  # type: str
        self.connection_id = connection_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisWizardDetailsWizardConnection, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetails(TeaModel):
    def __init__(self, is_paged_response=None, wizard_request_parameters=None, wizard_response_parameters=None,
                 wizard_connection=None):
        self.is_paged_response = is_paged_response  # type: bool
        self.wizard_request_parameters = wizard_request_parameters  # type: list[ListDataServiceApisResponseBodyDataApisWizardDetailsWizardRequestParameters]
        self.wizard_response_parameters = wizard_response_parameters  # type: list[ListDataServiceApisResponseBodyDataApisWizardDetailsWizardResponseParameters]
        self.wizard_connection = wizard_connection  # type: ListDataServiceApisResponseBodyDataApisWizardDetailsWizardConnection

    def validate(self):
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()
        if self.wizard_connection:
            self.wizard_connection.validate()

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApisWizardDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        if m.get('WizardConnection') is not None:
            temp_model = ListDataServiceApisResponseBodyDataApisWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        return self


class ListDataServiceApisResponseBodyDataApis(TeaModel):
    def __init__(self, timeout=None, status=None, api_id=None, api_mode=None, project_id=None,
                 response_content_type=None, creator_id=None, visible_range=None, modified_time=None, operator_id=None, group_id=None,
                 description=None, folder_id=None, request_method=None, created_time=None, api_name=None, tenant_id=None,
                 api_path=None, protocols=None, registration_details=None, script_details=None, wizard_details=None):
        self.timeout = timeout  # type: int
        self.status = status  # type: int
        self.api_id = api_id  # type: long
        self.api_mode = api_mode  # type: int
        self.project_id = project_id  # type: long
        self.response_content_type = response_content_type  # type: int
        self.creator_id = creator_id  # type: str
        self.visible_range = visible_range  # type: int
        self.modified_time = modified_time  # type: str
        self.operator_id = operator_id  # type: str
        self.group_id = group_id  # type: str
        self.description = description  # type: str
        self.folder_id = folder_id  # type: long
        self.request_method = request_method  # type: int
        self.created_time = created_time  # type: str
        self.api_name = api_name  # type: str
        self.tenant_id = tenant_id  # type: long
        self.api_path = api_path  # type: str
        self.protocols = protocols  # type: list[int]
        self.registration_details = registration_details  # type: ListDataServiceApisResponseBodyDataApisRegistrationDetails
        self.script_details = script_details  # type: ListDataServiceApisResponseBodyDataApisScriptDetails
        self.wizard_details = wizard_details  # type: ListDataServiceApisResponseBodyDataApisWizardDetails

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyDataApis, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.status is not None:
            result['Status'] = self.status
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = ListDataServiceApisResponseBodyDataApisRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('ScriptDetails') is not None:
            temp_model = ListDataServiceApisResponseBodyDataApisScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('WizardDetails') is not None:
            temp_model = ListDataServiceApisResponseBodyDataApisWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class ListDataServiceApisResponseBodyData(TeaModel):
    def __init__(self, page_number=None, page_size=None, total_count=None, apis=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int
        self.apis = apis  # type: list[ListDataServiceApisResponseBodyDataApis]

    def validate(self):
        if self.apis:
            for k in self.apis:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDataServiceApisResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Apis'] = []
        if self.apis is not None:
            for k in self.apis:
                result['Apis'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.apis = []
        if m.get('Apis') is not None:
            for k in m.get('Apis'):
                temp_model = ListDataServiceApisResponseBodyDataApis()
                self.apis.append(temp_model.from_map(k))
        return self


class ListDataServiceApisResponseBody(TeaModel):
    def __init__(self, http_status_code=None, request_id=None, error_message=None, success=None, error_code=None,
                 data=None):
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.error_message = error_message  # type: str
        self.success = success  # type: bool
        self.error_code = error_code  # type: str
        self.data = data  # type: ListDataServiceApisResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDataServiceApisResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = ListDataServiceApisResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDataServiceApisResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDataServiceApisResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDataServiceApisResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDataServiceApisResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDataServiceApplicationsRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, project_id_list=None, tenant_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.project_id_list = project_id_list  # type: str
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApplicationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id_list is not None:
            result['ProjectIdList'] = self.project_id_list
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectIdList') is not None:
            self.project_id_list = m.get('ProjectIdList')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListDataServiceApplicationsResponseBodyDataApplications(TeaModel):
    def __init__(self, application_name=None, application_id=None, project_id=None):
        self.application_name = application_name  # type: str
        self.application_id = application_id  # type: long
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDataServiceApplicationsResponseBodyDataApplications, self).to_map()
        if _map is not None:
            return _