"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PerformanceInsightRetention = exports.SnapshotCredentials = exports.Credentials = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Username and password combination
 */
class Credentials {
    /**
     * Creates Credentials with a password generated and stored in Secrets Manager.
     */
    static fromGeneratedSecret(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_CredentialsBaseOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedSecret);
            }
            throw error;
        }
        return {
            ...options,
            username,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials from a password
     *
     * Do not put passwords in your CDK code directly.
     */
    static fromPassword(username, password) {
        return {
            username,
            password,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials for the given username, and optional password and key.
     * If no password is provided, one will be generated and stored in Secrets Manager.
     */
    static fromUsername(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_CredentialsFromUsernameOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUsername);
            }
            throw error;
        }
        return {
            ...options,
            username,
        };
    }
    /**
     * Creates Credentials from an existing Secrets Manager ``Secret`` (or ``DatabaseSecret``)
     *
     * The Secret must be a JSON string with a ``username`` and ``password`` field:
     * ```
     * {
     *   ...
     *   "username": <required: username>,
     *   "password": <required: password>,
     * }
     * ```
     *
     * @param secret The secret where the credentials are stored
     * @param username The username defined in the secret. If specified the username
     *   will be referenced as a string and not a dynamic reference to the username
     *   field in the secret. This allows to replace the secret without replacing the
     *   instance or cluster.
     */
    static fromSecret(secret, username) {
        return {
            username: username !== null && username !== void 0 ? username : secret.secretValueFromJson('username').unsafeUnwrap(),
            password: secret.secretValueFromJson('password'),
            encryptionKey: secret.encryptionKey,
            secret,
        };
    }
}
exports.Credentials = Credentials;
_a = JSII_RTTI_SYMBOL_1;
Credentials[_a] = { fqn: "@aws-cdk/aws-rds.Credentials", version: "1.157.0" };
/**
 * Credentials to update the password for a ``DatabaseInstanceFromSnapshot``.
 */
class SnapshotCredentials {
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * The new credentials are stored in Secrets Manager.
     *
     * Note - The username must match the existing master username of the snapshot.
     */
    static fromGeneratedSecret(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedSecret);
            }
            throw error;
        }
        return {
            ...options,
            generatePassword: true,
            replaceOnPasswordCriteriaChanges: true,
            username,
        };
    }
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     *
     * Note - The username must match the existing master username of the snapshot.
     *
     * NOTE: use `fromGeneratedSecret()` for new Clusters and Instances.
     */
    static fromGeneratedPassword(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedPassword);
            }
            throw error;
        }
        return {
            ...options,
            generatePassword: true,
            username,
        };
    }
    /**
     * Update the snapshot login with an existing password.
     */
    static fromPassword(password) {
        return { generatePassword: false, password };
    }
    /**
     * Update the snapshot login with an existing password from a Secret.
     *
     * The Secret must be a JSON string with a ``password`` field:
     * ```
     * {
     *   ...
     *   "password": <required: password>,
     * }
     * ```
     */
    static fromSecret(secret) {
        return {
            generatePassword: false,
            password: secret.secretValueFromJson('password'),
            secret,
        };
    }
}
exports.SnapshotCredentials = SnapshotCredentials;
_b = JSII_RTTI_SYMBOL_1;
SnapshotCredentials[_b] = { fqn: "@aws-cdk/aws-rds.SnapshotCredentials", version: "1.157.0" };
/**
 * The retention period for Performance Insight.
 */
var PerformanceInsightRetention;
(function (PerformanceInsightRetention) {
    /**
     * Default retention period of 7 days.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["DEFAULT"] = 7] = "DEFAULT";
    /**
     * Long term retention period of 2 years.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["LONG_TERM"] = 731] = "LONG_TERM";
})(PerformanceInsightRetention = exports.PerformanceInsightRetention || (exports.PerformanceInsightRetention = {}));
//# sourceMappingURL=data:application/json;base64,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