"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Endpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * Connection endpoint of a database cluster or instance
 *
 * Consists of a combination of hostname and port.
 */
class Endpoint {
    constructor(address, port) {
        this.hostname = address;
        this.port = port;
        const portDesc = core_1.Token.isUnresolved(port) ? core_1.Token.asString(port) : port;
        this.socketAddress = `${address}:${portDesc}`;
    }
}
exports.Endpoint = Endpoint;
_a = JSII_RTTI_SYMBOL_1;
Endpoint[_a] = { fqn: "@aws-cdk/aws-rds.Endpoint", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbmRwb2ludC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHdDQUFzQztBQUV0Qzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFRO0lBZ0JuQixZQUFZLE9BQWUsRUFBRSxJQUFZO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLFlBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFlBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUN4RSxJQUFJLENBQUMsYUFBYSxHQUFHLEdBQUcsT0FBTyxJQUFJLFFBQVEsRUFBRSxDQUFDO0tBQy9DOztBQXRCSCw0QkF1QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUb2tlbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIENvbm5lY3Rpb24gZW5kcG9pbnQgb2YgYSBkYXRhYmFzZSBjbHVzdGVyIG9yIGluc3RhbmNlXG4gKlxuICogQ29uc2lzdHMgb2YgYSBjb21iaW5hdGlvbiBvZiBob3N0bmFtZSBhbmQgcG9ydC5cbiAqL1xuZXhwb3J0IGNsYXNzIEVuZHBvaW50IHtcbiAgLyoqXG4gICAqIFRoZSBob3N0bmFtZSBvZiB0aGUgZW5kcG9pbnRcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBob3N0bmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcG9ydCBvZiB0aGUgZW5kcG9pbnRcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBwb3J0OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBjb21iaW5hdGlvbiBvZiBcIkhPU1ROQU1FOlBPUlRcIiBmb3IgdGhpcyBlbmRwb2ludFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHNvY2tldEFkZHJlc3M6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihhZGRyZXNzOiBzdHJpbmcsIHBvcnQ6IG51bWJlcikge1xuICAgIHRoaXMuaG9zdG5hbWUgPSBhZGRyZXNzO1xuICAgIHRoaXMucG9ydCA9IHBvcnQ7XG5cbiAgICBjb25zdCBwb3J0RGVzYyA9IFRva2VuLmlzVW5yZXNvbHZlZChwb3J0KSA/IFRva2VuLmFzU3RyaW5nKHBvcnQpIDogcG9ydDtcbiAgICB0aGlzLnNvY2tldEFkZHJlc3MgPSBgJHthZGRyZXNzfToke3BvcnREZXNjfWA7XG4gIH1cbn1cbiJdfQ==