# mypy-boto3-apigatewayv2

[![PyPI - mypy-boto3-apigatewayv2](https://img.shields.io/pypi/v/mypy-boto3-apigatewayv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigatewayv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-apigatewayv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigatewayv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ApiGatewayV2 1.13.11](https://boto3.amazonaws.com/v1/documentation/api/1.13.11/reference/services/apigatewayv2.html#ApiGatewayV2) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-apigatewayv2](#mypy-boto3-apigatewayv2)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ApiGatewayV2` service.

```bash
python -m pip install boto3-stubs[apigatewayv2]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import apigatewayv2
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_apigatewayv2 as apigatewayv2

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("apigatewayv2")
client: apigatewayv2.ApiGatewayV2Client = boto3.client("apigatewayv2")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: apigatewayv2.ApiGatewayV2Client = session.client("apigatewayv2")


# Paginators need type annotation on creation
get_apis_paginator: apigatewayv2.GetApisPaginator = client.get_paginator("get_apis")
get_authorizers_paginator: apigatewayv2.GetAuthorizersPaginator = client.get_paginator("get_authorizers")
get_deployments_paginator: apigatewayv2.GetDeploymentsPaginator = client.get_paginator("get_deployments")
get_domain_names_paginator: apigatewayv2.GetDomainNamesPaginator = client.get_paginator("get_domain_names")
get_integration_responses_paginator: apigatewayv2.GetIntegrationResponsesPaginator = client.get_paginator("get_integration_responses")
get_integrations_paginator: apigatewayv2.GetIntegrationsPaginator = client.get_paginator("get_integrations")
get_models_paginator: apigatewayv2.GetModelsPaginator = client.get_paginator("get_models")
get_route_responses_paginator: apigatewayv2.GetRouteResponsesPaginator = client.get_paginator("get_route_responses")
get_routes_paginator: apigatewayv2.GetRoutesPaginator = client.get_paginator("get_routes")
get_stages_paginator: apigatewayv2.GetStagesPaginator = client.get_paginator("get_stages")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.