"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
// import { Asset } from '@aws-cdk/aws-s3-assets';
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-kinesisstream-gluejob';
const fieldSchema = [{
        name: "id",
        type: "int",
        comment: "Identifier for the record"
    }, {
        name: "name",
        type: "string",
        comment: "The name of the record"
    }, {
        name: "type",
        type: "string",
        comment: "The type of the record"
    }, {
        name: "numericvalue",
        type: "int",
        comment: "Some value associated with the record"
    }];
new lib_1.KinesisstreamsToGluejob(stack, 'test-kinesisstreams-lambda', {
    glueJobProps: {
        command: {
            name: 'gluestreaming',
            pythonVersion: '3',
            scriptLocation: 's3://fakelocation/fakefile.py'
            // Our version of cdk-integ crashes when misinterpreting the bucket name
            // After we refresh cdk-integ we should try this code again
            // scriptLocation: new Asset(stack, 'ScriptLocation', {
            //   path: `${__dirname}/transform.py`
            // }).assetPath
        }
    },
    fieldSchema
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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