"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const path = require("path");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-kinesisstream-gluejob';
const fieldSchema = [{
        name: "id",
        type: "int",
        comment: "Identifier for the record"
    }, {
        name: "name",
        type: "string",
        comment: "The name of the record"
    }, {
        name: "type",
        type: "string",
        comment: "The type of the record"
    }, {
        name: "numericvalue",
        type: "int",
        comment: "Some value associated with the record"
    }];
new lib_1.KinesisstreamsToGluejob(stack, 'test-kinesisstreams-lambda', {
    glueJobProps: {
        command: {
            name: 'gluestreaming',
            pythonVersion: '3'
        }
    },
    fieldSchema,
    etlCodeAsset: new aws_s3_assets_1.Asset(stack, 'ETL', {
        path: path.join(__dirname, 'fakefile.py')
    })
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY29kZS1hc3NldC1qb2IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5jb2RlLWFzc2V0LWpvYi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7O0FBRUgsVUFBVTtBQUNWLDZCQUE2QjtBQUU3Qix3Q0FBMkM7QUFDM0MsZ0NBQWlEO0FBQ2pELHlEQUF3RTtBQUN4RSwwREFBK0M7QUFFL0MsUUFBUTtBQUNSLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsR0FBRyxFQUFFLDZCQUFzQixDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7QUFDakUsS0FBSyxDQUFDLGVBQWUsQ0FBQyxXQUFXLEdBQUcsZ0RBQWdELENBQUM7QUFFckYsTUFBTSxXQUFXLEdBQStCLENBQUM7UUFDL0MsSUFBSSxFQUFFLElBQUk7UUFDVixJQUFJLEVBQUUsS0FBSztRQUNYLE9BQU8sRUFBRSwyQkFBMkI7S0FDckMsRUFBRTtRQUNELElBQUksRUFBRSxNQUFNO1FBQ1osSUFBSSxFQUFFLFFBQVE7UUFDZCxPQUFPLEVBQUUsd0JBQXdCO0tBQ2xDLEVBQUU7UUFDRCxJQUFJLEVBQUUsTUFBTTtRQUNaLElBQUksRUFBRSxRQUFRO1FBQ2QsT0FBTyxFQUFFLHdCQUF3QjtLQUNsQyxFQUFFO1FBQ0QsSUFBSSxFQUFFLGNBQWM7UUFDcEIsSUFBSSxFQUFFLEtBQUs7UUFDWCxPQUFPLEVBQUUsdUNBQXVDO0tBQ2pELENBQUMsQ0FBQztBQUVILElBQUksNkJBQXVCLENBQUMsS0FBSyxFQUFFLDRCQUE0QixFQUFFO0lBQy9ELFlBQVksRUFBRTtRQUNaLE9BQU8sRUFBRTtZQUNQLElBQUksRUFBRSxlQUFlO1lBQ3JCLGFBQWEsRUFBRSxHQUFHO1NBQ25CO0tBQ0Y7SUFDRCxXQUFXO0lBQ1gsWUFBWSxFQUFFLElBQUkscUJBQUssQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFO1FBQ3BDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxhQUFhLENBQUM7S0FDMUMsQ0FBQztDQUNILENBQUMsQ0FBQztBQUVILFFBQVE7QUFDUixHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMiBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbi8vIEltcG9ydHNcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCB7IENmblRhYmxlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWdsdWUnO1xuaW1wb3J0IHsgQXBwLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgS2luZXNpc3N0cmVhbXNUb0dsdWVqb2IgfSBmcm9tICcuLi9saWInO1xuaW1wb3J0IHsgZ2VuZXJhdGVJbnRlZ1N0YWNrTmFtZSB9IGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5pbXBvcnQgeyBBc3NldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zMy1hc3NldHMnO1xuXG4vLyBTZXR1cFxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBnZW5lcmF0ZUludGVnU3RhY2tOYW1lKF9fZmlsZW5hbWUpKTtcbnN0YWNrLnRlbXBsYXRlT3B0aW9ucy5kZXNjcmlwdGlvbiA9ICdJbnRlZ3JhdGlvbiBUZXN0IGZvciBhd3Mta2luZXNpc3N0cmVhbS1nbHVlam9iJztcblxuY29uc3QgZmllbGRTY2hlbWE6IENmblRhYmxlLkNvbHVtblByb3BlcnR5IFtdID0gW3tcbiAgbmFtZTogXCJpZFwiLFxuICB0eXBlOiBcImludFwiLFxuICBjb21tZW50OiBcIklkZW50aWZpZXIgZm9yIHRoZSByZWNvcmRcIlxufSwge1xuICBuYW1lOiBcIm5hbWVcIixcbiAgdHlwZTogXCJzdHJpbmdcIixcbiAgY29tbWVudDogXCJUaGUgbmFtZSBvZiB0aGUgcmVjb3JkXCJcbn0sIHtcbiAgbmFtZTogXCJ0eXBlXCIsXG4gIHR5cGU6IFwic3RyaW5nXCIsXG4gIGNvbW1lbnQ6IFwiVGhlIHR5cGUgb2YgdGhlIHJlY29yZFwiXG59LCB7XG4gIG5hbWU6IFwibnVtZXJpY3ZhbHVlXCIsXG4gIHR5cGU6IFwiaW50XCIsXG4gIGNvbW1lbnQ6IFwiU29tZSB2YWx1ZSBhc3NvY2lhdGVkIHdpdGggdGhlIHJlY29yZFwiXG59XTtcblxubmV3IEtpbmVzaXNzdHJlYW1zVG9HbHVlam9iKHN0YWNrLCAndGVzdC1raW5lc2lzc3RyZWFtcy1sYW1iZGEnLCB7XG4gIGdsdWVKb2JQcm9wczoge1xuICAgIGNvbW1hbmQ6IHtcbiAgICAgIG5hbWU6ICdnbHVlc3RyZWFtaW5nJyxcbiAgICAgIHB5dGhvblZlcnNpb246ICczJ1xuICAgIH1cbiAgfSxcbiAgZmllbGRTY2hlbWEsXG4gIGV0bENvZGVBc3NldDogbmV3IEFzc2V0KHN0YWNrLCAnRVRMJywge1xuICAgIHBhdGg6IHBhdGguam9pbihfX2Rpcm5hbWUsICdmYWtlZmlsZS5weScpXG4gIH0pXG59KTtcblxuLy8gU3ludGhcbmFwcC5zeW50aCgpOyJdfQ==