# mypy-boto3-license-manager

[![PyPI - mypy-boto3-license-manager](https://img.shields.io/pypi/v/mypy-boto3-license-manager.svg?color=blue)](https://pypi.org/project/mypy-boto3-license-manager)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-license-manager.svg?color=blue)](https://pypi.org/project/mypy-boto3-license-manager)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.LicenseManager 1.12.17](https://boto3.amazonaws.com/v1/documentation/api/1.12.17/reference/services/license-manager.html#LicenseManager) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-license-manager](#mypy-boto3-license-manager)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `LicenseManager` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-license-manager]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import license_manager
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_license_manager as license_manager

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("license-manager")
client: license_manager.LicenseManagerClient = boto3.client("license-manager")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: license_manager.LicenseManagerClient = session.client("license-manager")


# Paginators need type annotation on creation
list_associations_for_license_configuration_paginator: license_manager.ListAssociationsForLicenseConfigurationPaginator = client.get_paginator("list_associations_for_license_configuration")
list_license_configurations_paginator: license_manager.ListLicenseConfigurationsPaginator = client.get_paginator("list_license_configurations")
list_license_specifications_for_resource_paginator: license_manager.ListLicenseSpecificationsForResourcePaginator = client.get_paginator("list_license_specifications_for_resource")
list_resource_inventory_paginator: license_manager.ListResourceInventoryPaginator = client.get_paginator("list_resource_inventory")
list_usage_for_license_configuration_paginator: license_manager.ListUsageForLicenseConfigurationPaginator = client.get_paginator("list_usage_for_license_configuration")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.