import json
import uuid
from datetime import datetime

SQLS = [
    "WITH RECURSIVE typeinfo_tree ( oid, ns, name, kind, BASETYPE, elemtype, elemdelim, range_subtype, attrtypoids, attrnames, depth ) AS ( SELECT ti.oid, ti.ns, ti.name, ti.kind, ti.basetype, ti.elemtype, ti.elemdelim, ti.range_subtype, ti.attrtypoids, ti.attrnames, 0 FROM ( SELECT t.oid AS oid, ns.nspname AS ns, t.typname AS name, t.typtype AS kind, ( CASE WHEN t.typtype = 'd' THEN ( WITH RECURSIVE typebases ( oid, depth ) AS ( SELECT t2.typbasetype AS oid, 0 AS depth FROM pg_type t2 WHERE t2.oid = t.oid UNION ALL SELECT t2.typbasetype AS oid, tb.depth + 1 AS depth FROM pg_type t2, typebases tb WHERE tb.oid = t2.oid AND t2.typbasetype != 0 ) SELECT oid FROM typebases ORDER BY depth DESC LIMIT 1) ELSE NULL END) AS basetype, t.typelem AS elemtype, elem_t.typdelim AS elemdelim, range_t.rngsubtype AS range_subtype, ( CASE WHEN t.typtype = 'c' THEN ( SELECT array_agg(ia.atttypid ORDER BY ia.attnum) FROM pg_attribute ia INNER JOIN pg_class c ON (ia.attrelid = c.oid) WHERE ia.attnum > 0 AND NOT ia.attisdropped AND c.reltype = t.oid) ELSE NULL END) AS attrtypoids, ( CASE WHEN t.typtype = 'c' THEN ( SELECT array_agg(ia.attname::text ORDER BY ia.attnum) FROM pg_attribute ia INNER JOIN pg_class c ON (ia.attrelid = c.oid) WHERE ia.attnum > 0 AND NOT ia.attisdropped AND c.reltype = t.oid) ELSE NULL END) AS attrnames FROM pg_catalog.pg_type AS t INNER JOIN pg_catalog.pg_namespace ns ON (ns.oid = t.typnamespace) LEFT JOIN pg_type elem_t ON (t.typlen = - 1 AND t.typelem != 0 AND t.typelem = elem_t.oid) LEFT JOIN pg_range range_t ON (t.oid = range_t.rngtypid)) AS ti WHERE ti.oid = ANY ('{1015}'::oid[]) UNION ALL SELECT ti.oid, ti.ns, ti.name, ti.kind, ti.basetype, ti.elemtype, ti.elemdelim, ti.range_subtype, ti.attrtypoids, ti.attrnames, tt.depth + 1 FROM ( SELECT t.oid AS oid, ns.nspname AS ns, t.typname AS name, t.typtype AS kind, ( CASE WHEN t.typtype = 'd' THEN ( WITH RECURSIVE typebases ( oid, depth ) AS ( SELECT t2.typbasetype AS oid, 0 AS depth FROM pg_type t2 WHERE t2.oid = t.oid UNION ALL SELECT t2.typbasetype AS oid, tb.depth + 1 AS depth FROM pg_type t2, typebases tb WHERE tb.oid = t2.oid AND t2.typbasetype != 0 ) SELECT oid FROM typebases ORDER BY depth DESC LIMIT 1) ELSE NULL END) AS basetype, t.typelem AS elemtype, elem_t.typdelim AS elemdelim, range_t.rngsubtype AS range_subtype, ( CASE WHEN t.typtype = 'c' THEN ( SELECT array_agg(ia.atttypid ORDER BY ia.attnum) FROM pg_attribute ia INNER JOIN pg_class c ON (ia.attrelid = c.oid) WHERE ia.attnum > 0 AND NOT ia.attisdropped AND c.reltype = t.oid) ELSE NULL END) AS attrtypoids, ( CASE WHEN t.typtype = 'c' THEN ( SELECT array_agg(ia.attname::text ORDER BY ia.attnum) FROM pg_attribute ia INNER JOIN pg_class c ON (ia.attrelid = c.oid) WHERE ia.attnum > 0 AND NOT ia.attisdropped AND c.reltype = t.oid) ELSE NULL END) AS attrnames FROM pg_catalog.pg_type AS t INNER JOIN pg_catalog.pg_namespace ns ON (ns.oid = t.typnamespace) LEFT JOIN pg_type elem_t ON (t.typlen = - 1 AND t.typelem != 0 AND t.typelem = elem_t.oid) LEFT JOIN pg_range range_t ON (t.oid = range_t.rngtypid)) ti, typeinfo_tree tt WHERE (tt.elemtype IS NOT NULL AND ti.oid = tt.elemtype) OR (tt.attrtypoids IS NOT NULL AND ti.oid = ANY (tt.attrtypoids)) OR (tt.range_subtype IS NOT NULL AND ti.oid = tt.range_subtype)) SELECT DISTINCT *, BASETYPE::regtype::text AS basetype_name, elemtype::regtype::text AS elemtype_name, range_subtype::regtype::text AS range_subtype_name FROM typeinfo_tree ORDER BY depth DESC;",
    "SELECT anon_1.permission_entity, anon_1.permission_entity_uuid, array_agg(DISTINCT CASE WHEN (anon_1.usage_status = 'used'::varchar) THEN anon_1.service END) AS used_service, array_agg(DISTINCT CASE WHEN (anon_1.usage_status = 'unused'::varchar) THEN anon_1.service END) AS unused_service, array_agg(DISTINCT CASE WHEN (anon_1.usage_status = 'used'::varchar) THEN anon_1.permission END) AS used_permission, array_agg(DISTINCT CASE WHEN (anon_1.usage_status = 'unused'::varchar) THEN anon_1.permission END) AS unused_permission FROM ( SELECT anon_2.permission_id AS permission, anon_2.permission_entity_uuid AS permission_entity_uuid, anon_2.permission_entity AS permission_entity, CASE WHEN (anon_3.permission_id IS NULL) THEN 'unused'::varchar ELSE 'used'::varchar END AS usage_status, public.iam_actions.service AS service FROM ( SELECT demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid AS permission_entity_uuid, 'Role'::varchar AS permission_entity, demo.role_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.permission_id AS permission_id FROM demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36 JOIN demo.role_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36 ON demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid = demo.role_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.uuid WHERE demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_type = 'User'::varchar AND demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = 'e78c9c33-259d-5f62-9e07-0b671dd19b42'::varchar) AS anon_2 LEFT OUTER JOIN ( SELECT demo.resource_access__3d757285_f270_42fc_a12d_2c03489fff36.permission_id AS permission_id FROM demo.resource_access__3d757285_f270_42fc_a12d_2c03489fff36 WHERE demo.resource_access__3d757285_f270_42fc_a12d_2c03489fff36.origin_requester_uuid = 'e78c9c33-259d-5f62-9e07-0b671dd19b42'::varchar) AS anon_3 ON anon_2.permission_id = anon_3.permission_id JOIN public.iam_actions ON anon_2.permission_id = public.iam_actions.permission_id UNION SELECT anon_4.permission_id AS permission, anon_4.permission_entity_uuid AS permission_entity_uuid, anon_4.permission_entity AS permission_entity, CASE WHEN (anon_5.permission_id IS NULL) THEN 'unused'::varchar ELSE 'used'::varchar END AS usage_status, public.iam_actions.service AS service FROM ( SELECT demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.policy_uuid AS permission_entity_uuid, 'Policy'::varchar AS permission_entity, demo.policy_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.permission_id AS permission_id FROM demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36 JOIN demo.policy_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36 ON demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.policy_uuid = demo.policy_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.uuid WHERE demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.entity_type = 'User'::varchar AND demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = 'e78c9c33-259d-5f62-9e07-0b671dd19b42'::varchar AND demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.is_permission_boundary = FALSE) AS anon_4 LEFT OUTER JOIN ( SELECT demo.resource_access__3d757285_f270_42fc_a12d_2c03489fff36.permission_id AS permission_id FROM demo.resource_access__3d757285_f270_42fc_a12d_2c03489fff36 WHERE demo.resource_access__3d757285_f270_42fc_a12d_2c03489fff36.requester_uuid = 'e78c9c33-259d-5f62-9e07-0b671dd19b42'::varchar) AS anon_5 ON anon_4.permission_id = anon_5.permission_id JOIN public.iam_actions ON anon_4.permission_id = public.iam_actions.permission_id) AS anon_1 GROUP BY anon_1.permission_entity, anon_1.permission_entity_uuid;",
    "WITH cte AS ( SELECT public.iam_actions.permission_id AS permission_id FROM public.iam_actions JOIN demo.resource__3d757285_f270_42fc_a12d_2c03489fff36 ON lower(demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.service) = lower(public.iam_actions.service) WHERE demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.uuid = 'dae96d25-5594-5f43-b818-baf3945ff062'::varchar ) SELECT DISTINCT anon_1.policy_uuid AS uuid, 'Policy'::varchar AS permission_entity FROM ( SELECT demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.policy_uuid AS policy_uuid, demo.policy_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.permission_id AS permission_id FROM demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36 JOIN demo.policy_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36 ON demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.policy_uuid = demo.policy_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.uuid WHERE demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = 'b9960ffb-41d3-5b03-abff-5f20e015b99f'::varchar) AS anon_1 JOIN cte ON cte.permission_id = anon_1.permission_id UNION SELECT DISTINCT anon_2.role_uuid AS uuid, 'Role'::varchar AS permission_entity FROM ( SELECT demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid AS role_uuid, demo.role_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.permission_id AS permission_id FROM demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36 JOIN demo.role_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36 ON demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid = demo.role_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.uuid WHERE demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = 'b9960ffb-41d3-5b03-abff-5f20e015b99f'::varchar) AS anon_2 JOIN cte ON cte.permission_id = anon_2.permission_id;",
    "SELECT demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.policy_uuid, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.directly_attached_entity_uuid, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.is_permission_boundary, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.is_attached_directly, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.entity_type, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.directly_attached_entity_type, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.is_inline, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.used_permissions, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.unused_permissions, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.used_permission_count, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.unused_permission_count, demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.condition_id FROM demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36 WHERE demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.policy_uuid = '19f4ef64-0364-58b7-b918-c9c98a1793ca'::varchar AND demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = 'f0930638-d833-5fcb-a9d6-947c5e8928b9'::varchar AND demo.policy_attachment__3d757285_f270_42fc_a12d_2c03489fff36.is_permission_boundary = FALSE;",
    "SELECT demo.resource_policies__3d757285_f270_42fc_a12d_2c03489fff36.uuid, demo.resource_policies__3d757285_f270_42fc_a12d_2c03489fff36.cloud_account_id, demo.resource_policies__3d757285_f270_42fc_a12d_2c03489fff36.policy FROM demo.resource_policies__3d757285_f270_42fc_a12d_2c03489fff36 WHERE demo.resource_policies__3d757285_f270_42fc_a12d_2c03489fff36.uuid = '92d91b08-6731-5cd2-8613-975f688d55fe'::varchar AND demo.resource_policies__3d757285_f270_42fc_a12d_2c03489fff36.cloud_account_id = '207707207483'::varchar;",
    "SELECT demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_type, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.trusted_entities, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.used_permissions, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.unused_permissions, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.used_permission_count, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.unused_permission_count, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.condition_id FROM demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36 WHERE demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid = '0044c13d-4acf-5c70-9c41-cf142e12e480'::varchar AND demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = 'ab5fa6fd-d863-50ca-9cf9-4b47d632834e'::varchar;"
    "SELECT DISTINCT oid, xmin FROM pg_catalog.pg_namespace WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_type WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_class WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_proc WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_operator WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_constraint WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_collation WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_rewrite WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_trigger WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_am WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_foreign_data_wrapper WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_foreign_server WHERE oid IN (78379) UNION SELECT DISTINCT oid, xmin FROM pg_catalog.pg_extension WHERE oid IN (78379) /* union select distinct oid, xmin from pg_catalog.pg_user_mapping where oid in (78379) */ ;",
    "SELECT demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid AS uuid, 'Role' AS resource_type, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.used_permission_count, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.unused_permission_count, demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.cloud_name AS name, demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.cloud_id AS id, demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.arn, demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.region, demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.service, demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.resource_sub_type, demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.cloud_account_id, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.unused_permissions, demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.used_permissions FROM demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36 JOIN demo.resource__3d757285_f270_42fc_a12d_2c03489fff36 ON demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid = demo.resource__3d757285_f270_42fc_a12d_2c03489fff36.uuid WHERE demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = '847e63d7-6b5a-5f01-88dc-cd36952c6b44'::varchar;",
    r"""UPDATE demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36 SET used_permissions='[]'::varchar, unused_permissions='["cloudwatch:describeanomalydetectors:read", "trustedadvisor:describenotificationpreferences:read", "iam:getuser:read", "datapipeline:getpipelinedefinition:read", "robomaker:describedeploymentjob:read", "ses:getidentitypolicies:read", "elasticloadbalancing:describelistenercertificates:read", "ssm:describedocument:read", "codecommit:getrepositorytriggers:read", "codedeploy:batchgetdeploymentinstances:read", "elasticloadbalancing:describetargethealth:read", "elasticloadbalancing:describetargetgroups:read", "cognito-idp:describeuserpool:read", "iam:getservicelinkedroledeletionstatus:read", "xray:getencryptionconfig:read", "quicksight:describefolderresolvedpermissions:read", "comprehend:listdominantlanguagedetectionjobs:read", "greengrass:listfunctiondefinitionversions:list", "iam:listinstanceprofiletags:list", "firehose:listdeliverystreams:list", "directconnect:describeconnections:read", "sagemaker:listmodelbiasjobdefinitions:list", "ec2:describespotfleetrequesthistory:list", "sagemaker:describecoderepository:read", "ec2:describelaunchtemplateversions:list", "ssm:describeassociation:read", "ssm:describeparameters:list", "events:describeeventbus:read", "organizations:describecreateaccountstatus:read", "sagemaker:listappimageconfigs:list", "sqs:listdeadlettersourcequeues:read", "sso:listaccountassignments:list", "greengrass:listinstalledcomponents:list", "appsync:listdatasources:list", "ec2:describeprincipalidformat:list", "s3:getmetricsconfiguration:read", "ec2:describeimportsnapshottasks:list", "iam:listmfadevices:list", "ec2:getmanagedprefixlistassociations:read", "redshift:describedefaultclusterparameters:read", "elasticache:describeenginedefaultparameters:list", "servicequotas:getrequestedservicequotachange:read", "sagemaker:describemonitoringschedule:read", "es:describedomains:list", "directconnect:describerouterconfiguration:read", "iot:describedetectmitigationactionstask:read", "ecs:listtasks:list", "greengrass:listfunctiondefinitions:list", "iot:describecertificate:read", "sso:listpermissionsetsprovisionedtoaccount:list", "events:describeapidestination:read", "securityhub:getinvitationscount:read", "guardduty:listinvitations:list", "chime:listaccounts:list", "firehose:listtagsfordeliverystream:list", "iot:listtopicruledestinations:list", "iam:listopenidconnectproviders:list", "s3:getbucketpolicy:read", "chime:listbots:list", "sso:listapplicationinstancecertificates:read", "iam:getaccesskeylastused:read", "workspaces:describeconnectionaliaspermissions:read", "inspector:listassessmenttargets:list", "s3:getobjectversionforreplication:read", "workspaces:describeworkspacebundles:list", "rds:describedbinstances:list", "iam:getsshpublickey:read", "route53:listtrafficpolicyinstancesbypolicy:list", "organizations:createaccount:write", "appmesh:listmeshes:list", "route53:gettrafficpolicyinstancecount:read", "redshift:describeorderableclusteroptions:read", "guardduty:getinvitationscount:read", "ram:listresourcesharepermissions:list", "ssm:describepatchproperties:list", "config:getaggregateconformancepackcompliancesummary:read", "config:getcompliancesummarybyconfigrule:read", "route53resolver:getresolverconfig:read", "cloudfront:getresponseheaderspolicy:read", "guardduty:listdetectors:list", "elasticbeanstalk:describeapplicationversions:list", "events:testeventpattern:read", "s3:listbucketmultipartuploads:list", "iot:listnamedshadowsforthing:list", "codedeploy:getdeploymentgroup:list", "cloudfront:getoriginrequestpolicyconfig:read", "redshift:describesnapshotschedules:read", "iam:getloginprofile:list", "securityhub:getcontrolfindingsummary:read", "es:describedomainautotunes:read", "events:listrules:list", "trustedadvisor:describeorganization:read", "quicksight:listingestions:list", "eks:listclusters:list", "mediastore:getcontainerpolicy:read", "organizations:listaccounts:list", "glue:getdatacatalogencryptionsettings:read", "rds:describerecommendationgroups:read", "rds:describereserveddbinstancesofferings:list", "appsync:listapikeys:list", "chime:listmeetingevents:list", "sts:assumerole:write", "budgets:modifybudget:write", "s3:listmultipartuploadparts:list", "greengrass:listgroups:list", "redshift:describetable:read", "iam:listrolepolicies:list", "appsync:listgraphqlapis:list", "eks:describecluster:read", "iam:updatesamlprovider:write", "cloud9:describeenvironmentstatus:read", "route53:listtrafficpolicyinstancesbyhostedzone:list", "inspector:listassessmenttemplates:list", "license-manager:listreceivedlicenses:list", "ec2:describespotdatafeedsubscription:list", "logs:getqueryresults:read", "schemas:listschemas:list", "ec2:describenetworkinterfaces:list", "rds:describereserveddbinstances:list", "serverlessrepo:listapplicationdependencies:list", "config:listaggregatediscoveredresources:list", "globalaccelerator:describecustomroutinglistener:read", "organizations:describeorganization:read", "quicksight:describetemplatealias:read", "ec2:describevpngateways:list", "transfer:describeexecution:read", "iam:getservicelastaccesseddetailswithentities:read", "sagemaker:describetrial:read", "elasticmapreduce:describeeditor:read", "sagemaker:listexperiments:list", "logs:filterlogevents:read", "sagemaker:listlabelingjobs:list", "ec2:describeaddresses:list", "ec2:describeinstancestatus:list", "route53:gethealthcheckcount:list", "quicksight:describeingestion:read", "cloudfront:getfieldlevelencryptionprofileconfig:read", "ec2:describetransitgatewayconnects:list", "config:getresourceconfighistory:read", "datasync:listtagsforresource:read", "es:describeinboundconnections:list", "cloudfront:listfunctions:list", "cognito-idp:listuserimportjobs:list", "config:describependingaggregationrequests:list", "iot:listpolicies:list", "waf:getrule:read", "sagemaker:describeinferencerecommendationsjob:read", "route53:getreusabledelegationsetlimit:read", "iam:listaccountaliases:list", "redshift:describeloggingstatus:read", "robomaker:listsupportedavailabilityzones:list", "s3:getbucketacl:read", "config:describeaggregatecompliancebyconfigrules:read", "greengrass:listgroupversions:list", "ecs:listcontainerinstances:list", "s3:listbucketversions:list", "sagemaker:listdomains:list", "ec2:describevpcclassiclink:list", "codepipeline:getpipeline:read", "quicksight:listtemplateversions:list", "iot:describeindex:read", "ce:gettags:read", "storagegateway:describestorediscsivolumes:read", "cloudwatch:getmetricstream:read", "mq:describeuser:read", "cloudsearch:describeserviceaccesspolicies:read", "rds:describeglobalclusters:list", "iam:deletepolicyversion:permissions management", "organizations:listawsserviceaccessfororganization:list", "sqs:listqueues:read", "clouddirectory:listdirectories:list", "cloudtrail:listpublickeys:read", "iot:describemanagedjobtemplate:read", "ecs:describetasksets:read", "iot:describefleetmetric:read", "quicksight:listnamespaces:list", "ec2:describelaunchtemplates:list", "route53:listtagsforresources:read", "sagemaker:listendpoints:list", "ec2:describeimportimagetasks:list", "codedeploy:batchgetdeploymenttargets:read", "appsync:listresolversbyfunction:list", "redshift:describenodeconfigurationoptions:list", "sagemaker:describehumanloop:read", "ecs:listservices:list", "directconnect:describedirectconnectgatewayattachments:read", "iot:listotaupdates:list", "robomaker:describeworldexportjob:read", "ec2:describehostreservations:list", "access-analyzer:listtagsforresource:read", "s3:listallmybuckets:list", "greengrass:listconnectordefinitionversions:list", "codecommit:listbranches:list", "dynamodb:describecontinuousbackups:read", "kinesis:describestream:read", "iot:listthingtypes:list", "sagemaker:describedataqualityjobdefinition:read", "iam:deleterolepolicy:permissions management", "ec2:describetrunkinterfaceassociations:list", "route53:getdnssec:read", "codestar:listteammembers:list", "config:listtagsforresource:read", "comprehend:describeentitiesdetectionjob:read", "iot:listtopicrules:list", "cloudhsm:listhsms:list", "iot:describetunnel:read", "codepipeline:getpipelinestate:read", "inspector:gettelemetrymetadata:read", "mediaconnect:describeflow:read", "inspector:listexclusions:list", "sagemaker:listprocessingjobs:list", "chime:listproxysessions:list", "schemas:listschemaversions:list", "sagemaker:listworkteams:list", "cloudwatch:getmetricwidgetimage:read", "sagemaker:listprojects:list", "dms:describereplicationtaskassessmentruns:read", "iam:getgroup:read", "route53resolver:getresolverrulepolicy:read", "glue:getdatabases:read", "sagemaker:listcontexts:list", "lambda:getfunctioncodesigningconfig:read", "cloudformation:describestackresources:read", "ssm:describemaintenancewindowsfortarget:list", "detective:listmembers:list", "elasticbeanstalk:listtagsforresource:read", "mq:describebroker:read", "license-manager:listlicensespecificationsforresource:list", "tag:untagresources:tagging", "shield:describeprotection:read", "autoscaling:describeloadbalancers:list", "appsync:listtagsforresource:read", "translate:listterminologies:list", "network-firewall:listfirewalls:list", "config:describeaggregationauthorizations:list", "iam:simulateprincipalpolicy:read", "codedeploy:getdeploymenttarget:read", "robomaker:listrobotapplications:list", "robomaker:listrobots:list", "mq:describebrokerenginetypes:read", "ec2:describenetworkacls:list", "secretsmanager:getresourcepolicy:read", "codedeploy:listtagsforresource:list", "rekognition:listdatasetlabels:read", "cloudfront:getkeygroup:read", "route53resolver:getresolverendpoint:read", "s3:getobjecttagging:read", "ssm:describemaintenancewindowexecutiontaskinvocations:list", "chime:listphonenumberorders:list", "robomaker:listsimulationapplications:list", "ec2:createflowlogs:write", "mediaconnect:listtagsforresource:read", "sns:listsubscriptions:list", "iam:simulatecustompolicy:read", "batch:describejobdefinitions:read", "s3:putbucketacl:permissions management", "lambda:getaccountsettings:read", "comprehend:describepiientitiesdetectionjob:read", "codedeploy:batchgetapplications:read", "rds:describecustomavailabilityzones:list", "iot:listjobexecutionsforthing:list", "ec2:describereservedinstanceslistings:list", "iam:getuserpolicy:read", "cognito-idp:describeresourceserver:read", "serverlessrepo:getapplicationpolicy:read", "organizations:listroots:list", "iot:listjobs:list", "elasticfilesystem:describefilesystempolicy:read", "redshift:describeclusters:list", "sagemaker:describefeaturegroup:read", "route53:listgeolocations:read", "logs:describedestinations:list", "ec2:gettransitgatewaymulticastdomainassociations:list", "es:describeinstancetypelimits:list", "cloudformation:describestackevents:read", "guardduty:listfindings:list", "ec2:describevpcs:list", "sagemaker:describesubscribedworkteam:read", "cloudwatch:describealarms:read", "iam:getcontextkeysforcustompolicy:read", "s3:getbucketownershipcontrols:read", "rds:removetagsfromresource:tagging", "cloudfront:getpublickey:read", "rds:describedblogfiles:list", "ec2:describesnapshotattribute:list", "ec2:gettransitgatewayattachmentpropagations:list", "sagemaker:listpipelines:list", "chime:listaccountusagereportdata:list", "ec2:describetransitgatewayroutetables:list", "codedeploy:listgithubaccounttokennames:list", "sagemaker:describeautomljob:read", "quicksight:listiampolicyassignmentsforuser:list", "cloudwatch:describealarmhistory:read", "ec2:describenetworkinsightsaccessscopeanalyses:list", "ssm:describeautomationexecutions:read", "ssm:describeinventorydeletions:read", "dms:describereplicationtasks:read", "iot:describeprovisioningtemplate:read", "lambda:listversionsbyfunction:list", "greengrass:listsubscriptiondefinitions:list", "rds:describevaliddbinstancemodifications:list", "iam:detachgrouppolicy:permissions management", "codebuild:listprojects:list", "route53:gethostedzonecount:list", "globalaccelerator:describeacceleratorattributes:read", "iam:listgroups:list", "es:describeelasticsearchdomainconfig:read", "s3:getbucketversioning:read", "application-autoscaling:describescheduledactions:read", "elasticmapreduce:describerepository:read", "iot:describeprovisioningtemplateversion:read", "events:describerule:read", "iam:createrole:write", "chime:listappinstanceadmins:list", "logs:getlogevents:read", "elasticloadbalancing:describeloadbalancerpolicytypes:read", "config:getstoredquery:read", "autoscaling:describelifecyclehooktypes:list", "datasync:describelocations3:read", "iot:describeauditsuppression:read", "config:describeaggregatecompliancebyconformancepacks:read", "iot:listprincipalthings:list", "redshift:describesnapshotcopygrants:read", "rds:listtagsforresource:read", "iot:describedimension:read", "codedeploy:batchgetdeploymentgroups:read", "ec2:describereservedinstances:list", "config:describeconfigurationaggregatorsourcesstatus:read", "securityhub:getinsightresults:read", "cloudfront:liststreamingdistributions:list", "datapipeline:validatepipelinedefinition:read", "quicksight:listanalyses:list", "ses:listverifiedemailaddresses:read", "sns:listtopics:list", "rds:describedbclusterbacktracks:list", "savingsplans:describesavingsplansofferings:read", "organizations:inviteaccounttoorganization:write", "route53resolver:getresolverquerylogconfigassociation:read", "ssm:getparameters:read", "dynamodb:describetimetolive:read", "iot:describedefaultauthorizer:read", "cloudtrail:describetrails:read", "schemas:describecodebinding:read", "iam:deleterole:write", "comprehend:describekeyphrasesdetectionjob:read", "iot:describething:read", "cloudwatch:describeinsightrules:read", "iot:describeauditmitigationactionstask:read", "es:describeoutboundconnections:list", "xray:getsamplingtargets:read", "sns:listtagsforresource:read", "sagemaker:listassociations:list", "iam:getgrouppolicy:read", "ec2:createtags:tagging", "support:describetrustedadvisorcheckrefreshstatuses:read", "ec2:gettransitgatewayprefixlistreferences:list", "kms:describecustomkeystores:read", "kms:listresourcetags:list", "logs:listlogdeliveries:list", "rds:describeeventcategories:list", "cognito-idp:describeidentityprovider:read", "route53:listtrafficpolicyversions:list", "codepipeline:getpipelineexecution:read", "sagemaker:describelineagegroup:read", "sagemaker:describeworkteam:read", "ec2:describevolumeattribute:list", "rds:addtagstoresource:tagging", "iot:listauditmitigationactionstasks:list", "elasticfilesystem:describemounttargets:read", "autoscaling-plans:describescalingplans:read", "cognito-idp:describeuserpoolclient:read", "quicksight:describethemepermissions:read", "ec2:describesecuritygroups:list", "sagemaker:listflowdefinitions:list", "organizations:listcreateaccountstatus:list", "cloudfront:getfieldlevelencryptionconfig:read", "sagemaker:describedevice:read", "shield:describesubscription:read", "rds:describerecommendations:read", "cloudfront:getrealtimelogconfig:read", "iot:describedomainconfiguration:read", "route53:listtrafficpolicyinstances:read", "athena:listtagsforresource:read", "ec2:describevolumes:list", "iot:listtargetsforsecurityprofile:list", "elasticbeanstalk:describeconfigurationsettings:read", "quicksight:listusers:list", "sagemaker:listcandidatesforautomljob:list", "s3:getbucketpublicaccessblock:read", "securityhub:getadministratoraccount:read", "sagemaker:listdevices:list", "iam:listsshpublickeys:list", "inspector:describecrossaccountaccessrole:read", "ec2:describetags:read", "securityhub:listinvitations:list", "kms:listaliases:list", "iam:listgrouppolicies:list", "robomaker:describefleet:read", "redshift:describeclustersubnetgroups:read", "chime:listdelegates:list", "codecommit:listassociatedapprovalruletemplatesforrepository:list", "robomaker:listtagsforresource:list", "xray:getgroups:read", "globalaccelerator:describeendpointgroup:read", "route53resolver:getresolverquerylogconfig:read", "s3:getlifecycleconfiguration:read", "quicksight:describefolder:read", "rds:describedbproxytargetgroups:list", "iam:deleteaccountpasswordpolicy:permissions management", "route53resolver:getresolverrule:read", "iam:updateroledescription:write", "s3:putbucketversioning:write", "ec2:describefpgaimageattribute:list", "sagemaker:listactions:list", "config:describecompliancebyresource:read", "storagegateway:describeworkingstorage:read", "directconnect:describevirtualinterfaces:read", "organizations:describeorganizationalunit:read", "quicksight:listtemplatealiases:list", "config:getdiscoveredresourcecounts:read", "iam:getaccountsummary:list", "sagemaker:describeprocessingjob:read", "transfer:describeworkflow:read", "codecommit:listpullrequests:list", "globalaccelerator:listcustomroutingportmappings:list", "events:listconnections:list", "lambda:getfunctionconcurrency:read", "datasync:listagents:list", "quicksight:describedatasource:read", "elasticmapreduce:describenotebookexecution:read", "iam:updategroup:write", "chime:listmeetings:list", "iam:listservicespecificcredentials:list", "iam:listuserpolicies:list", "sagemaker:describealgorithm:read", "iot:listmitigationactions:list", "s3:getmultiregionaccesspointpolicy:read", "access-analyzer:listfindings:read", "iam:getorganizationsaccessreport:read", "sagemaker:describeartifact:read", "sagemaker:listnotebookinstancelifecycleconfigs:list", "robomaker:describeworldgenerationjob:read", "iot:describejob:read", "waf:listrulegroups:list", "datasync:describetask:read", "comprehend:describedocumentclassificationjob:read", "organizations:listpoliciesfortarget:list", "appmesh:listtagsforresource:list", "quicksight:listiampolicyassignments:list", "dms:describeeventsubscriptions:read", "organizations:listdelegatedadministrators:list", "route53:listhostedzonesbyvpc:list", "comprehend:describetopicsdetectionjob:read", "es:describeinboundcrossclustersearchconnections:list", "access-analyzer:getanalyzedresource:read", "cloudtrail:geteventselectors:read", "transfer:listusers:list", "ses:getidentityverificationattributes:read", "sagemaker:listalgorithms:list", "storagegateway:describetaperecoverypoints:read", "elasticache:describeevents:list", "iot:describeauditfinding:read", "organizations:createorganizationalunit:write", "elasticloadbalancing:describeloadbalancers:list", "xray:getgroup:read", "route53:listtagsforresource:read", "redshift:describereservednodeofferings:read", "cloudwatch:listtagsforresource:list", "elasticmapreduce:describecluster:read", "iot:listdimensions:list", "kinesis:describelimits:read", "route53:getcheckeripranges:list", "route53:gethealthcheckstatus:list", "lambda:getlayerversionpolicy:read", "guardduty:getmembers:read", "sagemaker:describemodelpackage:read", "iot:describerolealias:read", "events:describereplay:read", "lambda:listfunctions:list", "comprehend:listpiientitiesdetectionjobs:read", "iot:getpolicyversion:read", "ec2:describefleets:list", "comprehend:listdocumentclassifiers:read", "trustedadvisor:describeaccountaccess:read", "ec2:describeclassiclinkinstances:list", "sso:listapplications:list", "route53:gethostedzone:list", "kms:listgrants:list", "events:listrulenamesbytarget:list", "s3:putobjecttagging:tagging", "kms:getpublickey:read", "eks:listnodegroups:list", "ec2:describeinternetgateways:list", "chime:listmeetingtags:list", "directconnect:describeconnectionsoninterconnect:read", "elasticbeanstalk:describeconfigurationoptions:read", "datasync:listtaskexecutions:list", "cloudfront:getmonitoringsubscription:read", "opsworks-cm:describeservers:list", "servicequotas:getservicequota:read", "quicksight:listthemeversions:list", "comprehend:describesentimentdetectionjob:read", "events:describearchive:read", "ec2:describescheduledinstances:read", "ec2:describefastlaunchimages:read", "inspector:listeventsubscriptions:list", "cloud9:describeenvironmentmemberships:read", "guardduty:getmasteraccount:read", "iot:describeaccountauditconfiguration:read", "workspaces:describeworkspacesnapshots:list", "route53resolver:listtagsforresource:read", "appsync:listresolvers:list", "acm:listtagsforcertificate:read", "config:describecompliancebyconfigrule:read", "sagemaker:describeimage:read", "codestar:listprojects:list", "inspector:describeexclusions:read", "guardduty:listthreatintelsets:list", "appmesh:describevirtualrouter:read", "globalaccelerator:describecustomroutingendpointgroup:read", "cognito-idp:listusers:list", "ec2:describenetworkinterfaceattribute:list", "redshift:describehsmclientcertificates:read", "iot:describejobexecution:read", "config:getorganizationconformancepackdetailedstatus:read", "sso:listdirectoryassociations:read", "codedeploy:batchgetonpremisesinstances:read", "robomaker:listsimulationjobs:list", "storagegateway:listautomatictapecreationpolicies:list", "cloudwatch:listmetrics:list", "iot:listtargetsforpolicy:list", "sagemaker:listnotebookinstances:list", "es:describereservedelasticsearchinstances:list", "iam:deleteuserpolicy:permissions management", "transfer:listworkflows:list", "logs:getloggroupfields:read", "autoscaling:describescalingactivities:list", "quicksight:describeiprestriction:read", "ec2:describeclientvpnroutes:list", "robomaker:listworlds:list", "ram:listprincipals:list", "fsx:describebackups:read", "iam:getaccountpasswordpolicy:read", "cloudwatch:listmetricstreams:list", "ec2:describeipamscopes:list", "ec2:describeregions:list", "redshift:describeeventcategories:read", "fsx:describevolumes:read", "ssm:describedocumentpermission:read", "s3:getinventoryconfiguration:read", "appmesh:describevirtualgateway:read", "quicksight:describegroup:read", "ec2:describevpcendpointconnections:list", "comprehend:listtagsforresource:read", "ec2:describevolumesmodifications:read", "guardduty:listorganizationadminaccounts:list", "redshift:describetablerestorestatus:read", "schemas:listtagsforresource:list", "ec2:describekeypairs:list", "mediaconnect:listflows:list", "waf-regional:listratebasedrules:list", "storagegateway:listtapes:list", "chime:listsupportedphonenumbercountries:list", "lambda:getfunctionconfiguration:read", "waf-regional:listrulegroups:list", "license-manager:listdistributedgrants:list", "chime:listchannelmoderators:list", "iot:listthinggroupsforthing:list", "config:getaggregateresourceconfig:read", "ec2:describemovingaddresses:list", "transfer:listtagsforresource:read", "cloudformation:describestackset:read", "iot:listcertificates:list", "shield:describeprotectiongroup:read", "ssm:describeassociationexecutions:read", "codestar:describeproject:read", "iot:describecustommetric:read", "comprehend:describedominantlanguagedetectionjob:read", "sagemaker:listtags:list", "config:describeretentionconfigurations:list", "ec2:describeidentityidformat:list", "elasticloadbalancing:describeloadbalancerpolicies:read", "ec2:describenetworkinsightspaths:list", "organizations:listpolicies:list", "logs:describemetricfilters:list", "rekognition:describestreamprocessor:read", "ec2:describevpcendpointconnectionnotifications:list", "config:describeorganizationconformancepackstatuses:read", "iot:listdetectmitigationactionstasks:list", "guardduty:getthreatintelset:read", "guardduty:listpublishingdestinations:list", "ec2:describebundletasks:list", "robomaker:describeworldtemplate:read", "elasticmapreduce:describestep:read", "mediaconnect:describereservation:read", "sagemaker:describecompilationjob:read", "directconnect:describedirectconnectgatewayassociations:read", "quicksight:describetheme:read", "cloudfront:listfieldlevelencryptionprofiles:list", "greengrass:listcoredefinitions:list", "ssm:describeinstanceinformation:read", "cognito-sync:listdatasets:list", "datasync:describelocationfsxwindows:read", "ec2:describeclientvpntargetnetworks:list", "inspector:describerulespackages:read", "iam:updateuser:write", "ec2:describescheduledinstanceavailability:read", "storagegateway:describecachediscsivolumes:read", "rds:describedbsecuritygroups:list", "greengrass:listloggerdefinitions:list", "ec2:describeclientvpnendpoints:list", "securityhub:listfindingaggregators:list", "iam:getservicelastaccesseddetails:read", "directconnect:describehostedconnections:read", "iot:listaudittasks:list", "securityhub:describeproducts:read", "cloudfront:listinvalidations:list", "athena:listtablemetadata:read", "s3:getbucketlocation:read", "cloudfront:listdistributionsbylambdafunction:list", "ssm:describepatchgroupstate:list", "license-manager:listreceivedgrants:list", "ce:getdimensionvalues:read", "redshift:describeclusterdbrevisions:list", "datapipeline:queryobjects:read", "config:listdiscoveredresources:list", "elasticmapreduce:listsecurityconfigurations:list", "budgets:viewbudget:read", "shield:listprotectiongroups:list", "tag:gettagvalues:read", "s3:getobjectlegalhold:read", "comprehend:listdocumentclassificationjobs:read", "xray:getsamplingrules:read", "iot:listoutgoingcertificates:list", "rekognition:describeprojectversions:read", "greengrass:listloggerdefinitionversions:list", "iam:listopenidconnectprovidertags:list", "chime:listsipmediaapplications:list", "quicksight:describedatasetpermissions:permissions management", "iam:listpolicytags:list", "sso:listprofiles:list", "ec2:describehostreservationofferings:list", "securityhub:getfindings:read", "config:describeconfigurationrecorderstatus:read", "ec2:describereservedinstancesofferings:list", "chime:listmediacapturepipelines:list", "dms:describereplicationtaskassessmentresults:read", "iot:listthinggroups:list", "rds:describedbproxytargets:list", "comprehend:listentityrecognizers:read", "cloud9:describesshremote:read", "ec2:describeipv6pools:list", "organizations:listorganizationalunitsforparent:list", "codedeploy:listdeployments:list", "iam:listinstanceprofiles:list", "globalaccelerator:listcustomroutingaccelerators:list", "rds:downloaddblogfileportion:read", "chime:listusers:list", "savingsplans:describesavingsplanrates:read", "sagemaker:describeimageversion:read", "ec2:describepublicipv4pools:list", "comprehend:listentitiesdetectionjobs:read", "guardduty:getfindings:read", "sagemaker:listmonitoringschedules:list", "iot:describeauthorizer:read", "sagemaker:describedomain:read", "route53resolver:listresolverendpointipaddresses:list", "redshift:describeevents:list", "s3:getbucketobjectlockconfiguration:read", "iam:attachrolepolicy:permissions management", "ec2:describevpcendpointserviceconfigurations:list", "codedeploy:listdeploymentinstances:list", "iam:taguser:tagging", "iot:listthingprincipals:list", "sagemaker:describenotebookinstancelifecycleconfig:read", "codestar:describeuserprofile:read", "kms:decrypt:write", "cloudformation:describestackdriftdetectionstatus:read", "workspaces:describeclientproperties:list", "mq:listconfigurations:list", "cloudfront:getpublickeyconfig:read", "sagemaker:describepipeline:read", "iot:listsecurityprofiles:list", "quicksight:describecustompermissions:write", "iam:createpolicy:permissions management", "iot:listauditsuppressions:list", "ec2:describecapacityreservationfleets:list", "comprehend:describeresourcepolicy:read", "iam:listroles:list", "route53resolver:listresolverruleassociations:list", "dms:describeconnections:read", "route53:listresourcerecordsets:list", "ssm:describeopsitems:read", "logs:describelogstreams:list", "workspaces:describeaccountmodifications:read", "waf-regional:listwebacls:list", "ec2:describevpcendpoints:list", "iot:listretainedmessages:list", "sagemaker:listfeaturegroups:list", "cloudwatch:getinsightrulereport:read", "ecr:getrepositorypolicy:read", "license-manager:listlicenseversions:list", "sagemaker:describemodel:read", "dms:describeevents:read", "globalaccelerator:describeaccelerator:read", "serverlessrepo:listapplications:list", "lambda:listlayers:list", "iot:listjobexecutionsforjob:list", "logs:listtagsloggroup:list", "sagemaker:listworkforces:list", "elasticbeanstalk:describeenvironmentresources:read", "tag:getresources:read", "iam:listsamlproviders:list", "sagemaker:listimages:list", "route53resolver:listresolverdnssecconfigs:list", "license-manager:listtagsforresource:read", "kms:getkeypolicy:read", "cloudfront:getcachepolicy:read", "route53:gethostedzonelimit:read", "schemas:listdiscoverers:list", "iot:listviolationevents:list", "s3:getbuckettagging:read", "organizations:describepolicy:read", "elasticache:describereservedcachenodesofferings:list", "servicequotas:getservicequotaincreaserequestfromtemplate:read", "route53:getgeolocation:list", "cloudfront:listresponseheaderspolicies:list", "iot:listprincipalpolicies:list", "chime:listphonenumbers:list", "kms:getparametersforimport:read", "sagemaker:listautomljobs:list", "ses:getidentitydkimattributes:read", "ec2:describevpcclassiclinkdnssupport:list", "autoscaling:describeadjustmenttypes:list", "codecommit:listapprovalruletemplates:list", "glue:getdevendpoints:read", "route53resolver:listresolverquerylogconfigassociations:list", "autoscaling:describeinstancerefreshes:list", "greengrass:listcomponentversions:list", "sagemaker:listimageversions:list", "mq:listtags:list", "codedeploy:listdeploymentconfigs:list", "s3:getobjectacl:read", "quicksight:describedataset:read", "s3:getstoragelensconfigurationtagging:read", "globalaccelerator:listlisteners:list", "kinesis:describestreamsummary:read", "application-autoscaling:describescalingpolicies:read", "ec2:describevpcpeeringconnections:list", "directconnect:describeinterconnects:read", "elasticmapreduce:describereleaselabel:read", "cognito-idp:listusersingroup:list", "sso:listaccountassignmentcreationstatus:list", "elasticmapreduce:listinstances:read", "rds:describedbclustersnapshots:list", "rds:describeenginedefaultparameters:list", "chime:listcdrbucket:list", "organizations:listdelegatedservicesforaccount:list", "ssm:describeeffectivepatchesforpatchbaseline:read", "redshift:describedatasharesforconsumer:read", "shield:describeattack:read", "ec2:describeavailabilityzones:list", "iam:tagrole:tagging", "lambda:listeventsourcemappings:list", "route53resolver:listfirewallrulegroupassociations:list", "waf:getwebacl:read", "config:describeconformancepacks:list", "ec2:describeaccountattributes:list", "elasticache:describecacheclusters:list", "es:listdomainnames:list", "ecs:describeclusters:read", "kms:listretirablegrants:list", "codecommit:batchgetrepositories:read", "datasync:describetaskexecution:read", "translate:listparalleldata:list", "datasync:describelocationobjectstorage:read", "cloudfront:listkeygroups:list", "route53:listhealthchecks:read", "autoscaling:describemetriccollectiontypes:list", "cloudformation:liststacksets:list", "elasticfilesystem:describemounttargetsecuritygroups:read", "rds:describedbclusterendpoints:list", "gamelift:listfleets:list", "events:listeventsources:list", "dynamodb:describeglobaltable:read", "ec2:gettransitgatewayroutetablepropagations:list", "ecr-public:describeimagetags:list", "cur:describereportdefinitions:read", "elasticbeanstalk:describeinstanceshealth:read", "ec2:describeinstanceattribute:list", "ec2:describespotinstancerequests:list", "globalaccelerator:describecustomroutingaccelerator:read", "sns:gettopicattributes:read", "rekognition:listtagsforresource:read", "servicequotas:listservices:read", "rds:describedbengineversions:list", "servicequotas:listservicequotas:read", "chime:listsiprules:list", "elasticloadbalancing:describeinstancehealth:read", "dax:describeclusters:list", "iot:listattachedpolicies:list", "ec2:describeroutetables:list", "cloudfront:listtagsforresource:read", "schemas:describediscoverer:read", "greengrass:listgroupcertificateauthorities:list", "quicksight:describeiampolicyassignment:read", "es:describereservedinstances:list", "athena:listdatabases:list", "iot:describemitigationaction:read", "config:describeremediationconfigurations:list", "quicksight:listgroupmemberships:list", "shield:describeattackstatistics:read", "redshift:describeclusterparametergroups:read", "chime:listroommemberships:list", "waf:listtagsforresource:read", "sagemaker:listpipelineexecutionsteps:list", "greengrass:listeffectivedeployments:list", "iam:generateservicelastaccesseddetails:read", "appmesh:listvirtualnodes:list", "ecr-public:getrepositorypolicy:read", "sagemaker:listuserprofiles:list", "cognito-sync:describedataset:read", "securityhub:describeactiontargets:read", "inspector:previewagents:read", "support:describetrustedadvisorchecks:read", "ec2:deletetags:tagging", "iot:listfleetmetrics:list", "lambda:listlayerversions:list", "es:describereservedinstanceofferings:list", "iam:addusertogroup:write", "dms:describereplicationtaskindividualassessments:read", "dax:describeparametergroups:list", "workspaces:describeconnectionaliases:read", "quicksight:describeaccountcustomization:read", "securityhub:listmembers:list", "iot:describethingregistrationtask:read", "wafv2:listavailablemanagedrulegroups:list", "sagemaker:describetrialcomponent:read", "tag:getcompliancesummary:read", "waf-regional:getrule:read", "redshift:describeaccountattributes:read", "ssm:describeautomationstepexecutions:read", "iot:listdetectmitigationactionsexecutions:list", "redshift:describedatasharesforproducer:read", "dax:describeparameters:read", "config:getaggregatecompliancedetailsbyconfigrule:read", "rds:describeinstallationmedia:list", "chime:listappinstanceuserendpoints:list", "sagemaker:describemodelqualityjobdefinition:read", "quicksight:listdashboards:list", "codecommit:listrepositories:list", "appmesh:listvirtualrouters:list", "config:describeconfigruleevaluationstatus:read", "comprehend:listtopicsdetectionjobs:read", "ec2:describetrafficmirrorfilters:list", "servicequotas:listservicequotaincreaserequestsintemplate:read", "comprehend:listdocumentclassifiersummaries:read", "route53resolver:listfirewalldomainlists:list", "dms:describerefreshschemasstatus:read", "waf-regional:getwebacl:read", "securityhub:describestandards:read", "ssm:listdocumentversions:list", "mq:listconfigurationrevisions:list", "route53:listhostedzones:list", "config:describeconfigurationaggregators:list", "cloudfront:listfieldlevelencryptionconfigs:list", "ec2:gettransitgatewayroutetableassociations:list", "ecs:describecontainerinstances:read", "cloudfront:listrealtimelogconfigs:list", "route53resolver:listfirewallrules:list", "access-analyzer:getfinding:read", "cognito-idp:listuserpoolclients:list", "s3:getobjectversiontagging:read", "iam:detachuserpolicy:permissions management", "codedeploy:batchgetapplicationrevisions:read", "ssm:describeassociationexecutiontargets:read", "securityhub:getusage:read", "fsx:describesnapshots:read", "config:liststoredqueries:list", "elasticloadbalancing:describeaccountlimits:read", "inspector:getexclusionspreview:read", "autoscaling:describeloadbalancertargetgroups:list", "sagemaker:describeaction:read", "comprehend:describeendpoint:read", "directconnect:describeinterconnectloa:read", "rds:describeaccountattributes:list", "config:describeorganizationconfigrulestatuses:read", "dms:listtagsforresource:read", "s3:getreplicationconfiguration:read", "iot:listsecurityprofilesfortarget:list", "cloudtrail:lookupevents:read", "kinesis:liststreamconsumers:list", "config:describeorganizationconfigrules:list", "sagemaker:listmodelpackagegroups:list", "wafv2:listwebacls:list", "config:describeconformancepackcompliance:read", "elasticbeanstalk:describeapplications:list", "codestar:listuserprofiles:list", "transfer:describeaccess:read", "s3:getbucketpolicystatus:read", "datasync:listlocations:list", "detective:listgraphs:list", "cloudformation:liststackinstances:list", "greengrass:listconnectordefinitions:list", "iot:describethingtype:read", "serverlessrepo:listapplicationversions:list", "iot:listthingsinthinggroup:list", "iam:deletegrouppolicy:permissions management", "transfer:describeserver:read", "acm:listcertificates:list", "ssm:listresourcedatasync:list", "cloudfront:listoriginrequestpolicies:list", "trustedadvisor:describeaccount:read", "iam:untaguser:tagging", "storagegateway:listvolumeinitiators:list", "codepipeline:listpipelines:list", "iot:listmanagedjobtemplates:list", "es:listtags:read", "quicksight:listusergroups:list", "storagegateway:describevtldevices:read", "ec2:describecustomergateways:list", "ec2:describetrafficmirrortargets:list", "lambda:listfunctioneventinvokeconfigs:list", "glacier:getvaultaccesspolicy:read", "access-analyzer:getanalyzer:read", "globalaccelerator:listcustomroutingportmappingsbydestination:list", "iam:putrolepermissionsboundary:permissions management", "sso:describepermissionspolicies:read", "iot:listscheduledaudits:list", "iam:setdefaultpolicyversion:permissions management", "route53resolver:getresolverruleassociation:read", "cloudtrail:listtags:read", "events:listeventbuses:list", "iot:describecacertificate:read", "workspaces:describeworkspaceimages:list", "cloudwatch:describealarmsformetric:read", "rekognition:liststreamprocessors:list", "ssm:listresourcecompliancesummaries:list", "dms:describeapplicableindividualassessments:read", "config:getcompliancedetailsbyconfigrule:read", "route53:listtrafficpolicies:list", "athena:listqueryexecutions:read", "dax:describesubnetgroups:list", "iot:liststreams:list", "cognito-sync:listidentitypoolusage:read", "secretsmanager:listsecrets:list", "sagemaker:describemodelexplainabilityjobdefinition:read", "cognito-idp:listuserpools:list", "redshift:describesavedqueries:read", "cloud9:listenvironments:read", "codestar:listtagsforproject:list", "schemas:describeschema:read", "appmesh:listvirtualservices:list", "quicksight:listdatasets:list", "iot:describeaudittask:read", "es:describeelasticsearchinstancetypelimits:list", "events:listtagsforresource:list", "codedeploy:getdeploymentinstance:list", "datasync:listtasks:list", "iot:listindices:list", "iam:listpoliciesgrantingserviceaccess:list", "route53:getqueryloggingconfig:read", "appsync:listfunctions:list", "rekognition:listdatasetentries:read", "greengrass:listdevicedefinitionversions:list", "elasticbeanstalk:describeenvironmentmanagedactionhistory:read", "storagegateway:describetapes:read", "route53resolver:listfirewalldomains:list", "ssm:listassociationversions:list", "codedeploy:listapplications:list", "quicksight:describedashboardpermissions:read", "cloudfront:listdistributionsbycachepolicyid:list", "iot:listtagsforresource:read", "greengrass:listtagsforresource:read", "organizations:describehandshake:read", "sagemaker:listmodelmetadata:list", "redshift:describeusagelimits:read", "rekognition:listcollections:read", "ec2:describeexporttasks:list", "acm-pca:listpermissions:read", "cloudwatch:listdashboards:list", "storagegateway:listgateways:list", "codedeploy:batchgetdeployments:read", "route53resolver:getresolverdnssecconfig:read", "cloudfront:listconflictingaliases:list", "mq:listusers:list", "lightsail:getloadbalancers:read", "elasticloadbalancing:describeloadbalancerattributes:read", "sso:listpermissionsets:list", "transfer:listservers:list", "ecr-public:getregistrycatalogdata:read", "ecr:describeimagescanfindings:read", "codecommit:listrepositoriesforapprovalruletemplate:list", "appsync:listdomainnames:list", "ec2:describemanagedprefixlists:list", "codedeploy:getapplicationrevision:list", "sagemaker:listedgepackagingjobs:list", "logs:getlogrecord:read", "directconnect:describecustomermetadata:read", "ecr-public:describeimages:read", "ec2:describelocalgatewayvirtualinterfacegroups:list", "route53resolver:getfirewallrulegroupassociation:read", "guardduty:describepublishingdestination:read", "guardduty:getfindingsstatistics:read", "ssm:listcomplianceitems:list", "s3:getaccesspointconfigurationforobjectlambda:read", "dms:describeendpoints:read", "ecs:describeservices:read", "ses:listidentities:list", "iam:listattacheduserpolicies:list", "elasticmapreduce:listclusters:list", "access-analyzer:getarchiverule:read", "dax:describedefaultparameters:list", "robomaker:listworldtemplates:list", "cloud9:describeenvironments:read", "iam:deleteuserpermissionsboundary:permissions management", "access-analyzer:listanalyzedresources:read", "sagemaker:describenotebookinstance:read", "iam:deleterolepermissionsboundary:permissions management", "codepipeline:getjobdetails:read", "batch:describecomputeenvironments:read", "cloudfront:listdistributionsbywebaclid:list", "ec2:describevpcendpointservices:list", "config:getconformancepackcompliancedetails:read", "fsx:listtagsforresource:read", "route53:gettrafficpolicyinstance:read", "s3:getaccelerateconfiguration:read", "comprehend:listendpoints:read", "cloudformation:liststacks:list", "servicequotas:listrequestedservicequotachangehistorybyquota:read", "sagemaker:listtrainingjobsforhyperparametertuningjob:list", "quicksight:listdashboardversions:list", "chime:listchannelmembershipsforappinstanceuser:list", "ecs:listtaskdefinitions:list", "iam:createuser:write", "s3:getmultiregionaccesspointpolicystatus:read", "iam:getaccountauthorizationdetails:read", "mq:describebrokerinstanceoptions:read", "cloudformation:gettemplate:read", "es:describereservedelasticsearchinstanceofferings:list", "organizations:listtargetsforpolicy:list", "sagemaker:listtrials:list", "athena:listdatacatalogs:list", "rds:describeeventsubscriptions:list", "guardduty:listfilters:list", "wafv2:listipsets:list", "dms:describeschemas:read", "ecr:describeimages:list", "dms:describereplicationinstancetasklogs:read", "savingsplans:listtagsforresource:list", "ec2:describelocalgatewayroutetablepermissions:list", "globalaccelerator:listaccelerators:list", "quicksight:describethemealias:read", "route53:listvpcassociationauthorizations:list", "eks:describenodegroup:read", "organizations:describeeffectivepolicy:read", "ec2:describevpcendpointservicepermissions:list", "quicksight:listtagsforresource:read", "ec2:describecapacityreservations:list", "dynamodb:listtagsofresource:read", "dynamodb:listtables:list", "xray:listtagsforresource:list", "ec2:describecarriergateways:list", "securityhub:getfreetrialenddate:read", "ram:listresourcetypes:list", "shield:listresourcesinprotectiongroup:list", "ec2:describetransitgatewayattachments:list", "config:getaggregatediscoveredresourcecounts:read", "sagemaker:describecontext:read", "trustedadvisor:describechecks:read", "redshift:describeclusterparameters:read", "elasticache:describesnapshots:list", "securityhub:describeorganizationconfiguration:read", "ec2:describevolumestatus:list", "translate:listtexttranslationjobs:list", "es:describeelasticsearchdomains:list", "iam:detachrolepolicy:permissions management", "apigateway:get:read", "securityhub:getadhocinsightresults:read", "acm:describecertificate:read", "ec2:describespotfleetrequests:list", "shield:listattacks:list", "autoscaling:describeautoscalingnotificationtypes:list", "mediaconnect:listentitlements:list", "tag:startreportcreation:write", "chime:listattendeetags:list", "storagegateway:describecache:read", "cloudfront:getfieldlevelencryptionprofile:read", "elasticbeanstalk:describeplatformversion:read", "athena:listnamedqueries:list", "cloudfront:getinvalidation:read", "dax:describeevents:list", "route53resolver:getfirewalldomainlist:read", "codedeploy:listonpremisesinstances:list", "ecr-public:describerepositories:list", "route53:gettrafficpolicy:read", "codedeploy:getonpremisesinstance:list", "ssm:getparametersbypath:read", "lambda:listfunctionsbycodesigningconfig:list", "dms:describereplicationinstances:read", "waf:listwebacls:list", "chime:listcallingregions:list", "robomaker:describesimulationapplication:read", "fsx:describedatarepositoryassociations:read", "redshift:describequery:read", "redshift:describetags:read", "sagemaker:listendpointconfigs:list", "ssm:listcompliancesummaries:list", "ec2:describelocalgatewayroutetablevirtualinterfacegroupassociations:list", "ec2:describesecuritygroupreferences:list", "ec2:describeelasticgpus:read", "autoscaling:describepolicies:list", "cloudfront:getresponseheaderspolicyconfig:read", "comprehend:describeentityrecognizer:read", "config:describeconfigrules:list", "events:listpartnereventsources:list", "sagemaker:listinferencerecommendationsjobs:list", "iot:listauditmitigationactionsexecutions:list", "cloudformation:describestackresourcedrifts:read", "cloudtrail:listtrails:list", "sso:listpermissionsetprovisioningstatus:list", "elasticbeanstalk:describeenvironments:list", "mediaconnect:listofferings:list", "quicksight:describetemplatepermissions:read", "inspector:describefindings:read", "quicksight:describefolderpermissions:read", "globalaccelerator:listtagsforresource:read", "iam:putuserpermissionsboundary:permissions management", "tag:gettagkeys:read", "logs:describeresourcepolicies:list", "glacier:describevault:read", "rds:describeorderabledbinstanceoptions:list", "s3:listaccesspoints:list", "iam:listservercertificatetags:list", "sdb:domainmetadata:read", "cloudfront:getcachepolicyconfig:read", "route53resolver:listresolverrules:list", "sagemaker:describeexperiment:read", "es:describedomain:read", "sagemaker:listpipelineparametersforexecution:list", "elasticmapreduce:describestudio:read", "dms:describeendpointtypes:read", "shield:describeemergencycontactsettings:read", "es:listelasticsearchversions:list", "workspaces:describeworkspacesconnectionstatus:read", "ssm:listassociations:list", "ec2:describeexportimagetasks:list", "ssm:describemaintenancewindowtasks:list", "iam:untagrole:tagging", "iam:getrole:read", "ec2:describeimages:list", "sagemaker:describepipelineexecution:read", "iam:listusertags:list", "elasticbeanstalk:describeenvironmenthealth:read", "ecs:describecapacityproviders:read", "directconnect:describelags:read", "wafv2:listtagsforresource:read", "redshift:describestorage:read", "greengrass:listdevicedefinitions:list", "chime:listappinstances:list", "autoscaling:describescalingprocesstypes:list", "s3:getjobtagging:read", "redshift:describereservednodes:read", "inspector:getassessmentreport:read", "glue:getcrawlers:read", "cloudfront:getoriginrequestpolicy:read", "dax:listtags:read", "rds:describeexporttasks:list", "inspector:describeassessmentruns:read", "ssm:listinventoryentries:list", "logs:describequeries:list", "servicequotas:listawsdefaultservicequotas:read", "codecommit:listtagsforresource:list", "ec2:describeimageattribute:list", "inspector:listfindings:list", "s3:getstoragelensconfiguration:read", "ec2:describeegressonlyinternetgateways:list", "codedeploy:getapplication:list", "elasticache:describecacheengineversions:list", "sagemaker:describepipelinedefinitionforexecution:read", "iot:listthings:list", "securityhub:listtagsforresource:read", "cloudfront:listdistributionsbyoriginrequestpolicyid:list", "iam:attachgrouppolicy:permissions management", "chime:listattendees:list", "cloudformation:describestackresource:read", "dynamodb:describetable:read", "ec2:describenetworkinsightsanalyses:list", "s3:getbucketnotification:read", "fsx:describedatarepositorytasks:read", "quicksight:listfoldermembers:read", "workspaces:describetags:read", "config:describeremediationexecutionstatus:read", "iot:listrolealiases:list", "guardduty:getmemberdetectors:read", "autoscaling:describeterminationpolicytypes:list", "s3:listjobs:list", "ec2:stopinstances:write", "robomaker:listworldgenerationjobs:list", "sagemaker:listcoderepositories:list", "ec2:describeipams:list", "elasticache:describecachesecuritygroups:list", "config:deliverconfigsnapshot:read", "cloudfront:getcloudfrontoriginaccessidentity:read", "appmesh:describevirtualservice:read", "ecs:listaccountsettings:read", "rds:describecertificates:list", "sso:listtagsforresource:read", "cloudwatch:getdashboard:read", "greengrass:listsubscriptiondefinitionversions:list", "organizations:describeaccount:read", "ram:listpendinginvitationresources:read", "storagegateway:describeuploadbuffer:read", "mediaconnect:describeoffering:read", "states:liststatemachines:list", "sdb:listdomains:list", "es:describepackages:read", "robomaker:describerobotapplication:read", "redshift:describeresize:read", "datapipeline:describeobjects:read", "chime:listdomains:list", "iot:listauthorizers:list", "sagemaker:describeapp:read", "elasticmapreduce:getblockpublicaccessconfiguration:read", "ec2:describeidformat:list", "iot:listauditfindings:list", "ssm:describeinstanceassociationsstatus:read", "events:listtargetsbyrule:list", "iam:getinstanceprofile:read", "rds:describedbsnapshotattributes:list", "s3:liststoragelensconfigurations:list", "cloudtrail:gettrail:read", "robomaker:listdeploymentjobs:list", "firehose:describedeliverystream:read", "kinesis:liststreams:list", "sagemaker:listdataqualityjobdefinitions:list", "cloudfront:listdistributionsbyrealtimelogconfig:list", "iam:deletepolicy:permissions management", "sagemaker:listmonitoringexecutions:list", "glue:getjobs:read", "rds:describedbparameters:list", "sagemaker:describemodelpackagegroup:read", "sagemaker:listpipelineexecutions:list", "events:listpartnereventsourceaccounts:list", "dynamodb:listbackups:list", "ec2:describeipampools:list", "iam:listroletags:list", "sagemaker:listmodels:list", "ssm:listopsmetadata:list", "chime:listdirectories:list", "iot:listcertificatesbyca:list", "chime:listvoiceconnectors:list", "sagemaker:listapps:list", "sagemaker:listtrainingjobs:list", "ecs:describetaskdefinition:read", "lightsail:getinstances:read", "sns:listsubscriptionsbytopic:list", "iam:createpolicyversion:permissions management", "sagemaker:listdevicefleets:list", "datapipeline:listpipelines:list", "cognito-idp:describeuserimportjob:read", "rekognition:describeprojects:read", "rds:describedbproxyendpoints:list", "schemas:describeregistry:read", "logs:describesubscriptionfilters:list", "waf:getrulegroup:read", "logs:describeloggroups:list", "ec2:describefpgaimages:list", "servicequotas:listtagsforresource:read", "ecr:listimages:list", "iot:listpolicyversions:list", "sagemaker:describedevicefleet:read", "storagegateway:listtapepools:list", "license-manager:listlicenseconversiontasks:list", "robomaker:listsimulationjobbatches:list", "sagemaker:listhumanloops:list", "wafv2:listloggingconfigurations:list", "elasticache:describecachesubnetgroups:list", "trustedadvisor:describecheckitems:read", "s3:getbucketwebsite:read", "ram:listpermissionversions:list", "ecr:getlifecyclepolicy:read", "ec2:describeinstanceeventwindows:list", "iam:attachuserpolicy:permissions management", "redshift:describehsmconfigurations:read", "cloudformation:describestacks:list", "opsworks:describestacks:list", "quicksight:listcustompermissions:write", "support:describetrustedadvisorchecksummaries:read", "wafv2:listrulegroups:list", "config:describedeliverychannelstatus:read", "datapipeline:describepipelines:list", "directconnect:describeconnectionloa:read", "cloudfront:getstreamingdistributionconfig:read", "autoscaling:describetags:read", "appmesh:listroutes:list", "snowball:listjobs:list", "elasticbeanstalk:describeenvironmentmanagedactions:read", "sagemaker:listmodelqualityjobdefinitions:list", "s3:getbucketrequestpayment:read", "ec2:describeplacementgroups:list", "datasync:describeagent:read", "securityhub:getfindingaggregator:read", "chime:listchannelbans:list", "rekognition:describedataset:read", "ec2:describeinstancecreditspecifications:list", "route53domains:listdomains:list", "sagemaker:describetrainingjob:read", "route53resolver:listfirewallrulegroups:list", "ec2:describelocalgatewayroutetablevpcassociations:list", "ec2:describeaggregateidformat:list", "cloudwatch:getmetricstatistics:read", "iam:removeuserfromgroup:write", "redshift:describeeventsubscriptions:read", "iam:listinstanceprofilesforrole:list", "sagemaker:listsubscribedworkteams:list", "organizations:listchildren:list", "rds:describedbsnapshots:list", "route53resolver:getfirewallrulegrouppolicy:read", "workspaces:describeaccount:read", "storagegateway:describebandwidthratelimit:read", "ec2:describebyoipcidrs:list", "iam:putgrouppolicy:permissions management", "datasync:describelocationefs:read", "athena:getworkgroup:read", "workspaces:describeworkspaces:list", "quicksight:listthemes:list", "organizations:listhandshakesforaccount:list", "greengrass:listclientdevicesassociatedwithcoredevice:list", "cloudfront:listcachepolicies:list", "organizations:listtagsforresource:list", "cloudhsm:listlunaclients:list", "events:describeconnection:read", "sagemaker:listhyperparametertuningjobs:list", "lambda:getfunction:read", "config:describedeliverychannels:list", "ecs:listtagsforresource:read", "iam:listattachedgrouppolicies:list", "waf-regional:listtagsforresource:read", "greengrass:listresourcedefinitions:list", "dms:describereplicationsubnetgroups:read", "ec2:describeprefixlists:list", "config:describeconfigurationrecorders:list", "iam:listusers:list", "comprehend:describedocumentclassifier:read", "rds:describedbinstanceautomatedbackups:list", "appmesh:describevirtualnode:read", "iot:listcacertificates:list", "trustedadvisor:describeservicemetadata:read", "comprehend:listentityrecognizersummaries:read", "lambda:listprovisionedconcurrencyconfigs:list", "elasticache:describeglobalreplicationgroups:list", "ssm:listcommands:read", "chime:listrooms:list", "waf-regional:listrules:list", "trustedadvisor:describereports:read", "iot:listthingregistrationtaskreports:list", "iam:listpolicyversions:list", "storagegateway:listlocaldisks:list", "sagemaker:listlabelingjobsforworkteam:list", "ssm:describeactivations:read", "sagemaker:describelabelingjob:read", "cloudformation:describestackinstance:read", "ec2:describevpnconnections:read", "rds:describeevents:list", "machinelearning:describemlmodels:list", "ec2:describetransitgatewaymulticastdomains:list", "iot:listprovisioningtemplateversions:list", "sagemaker:listmodelpackages:list", "datasync:describelocationsmb:read", "greengrass:listdeployments:list", "iot:listcustommetrics:list", "elasticache:describecacheparameters:list", "chime:listchannelmessages:read", "events:describeeventsource:read", "chime:listmeetingsreportdata:list", "dms:describetablestatistics:read", "route53resolver:getfirewallrulegroup:read", "cloudtrail:gettrailstatus:read", "globalaccelerator:describelistener:read", "autoscaling:describeaccountlimits:list", "cloudformation:liststackresources:list", "iam:getrolepolicy:read", "rds:describeenginedefaultclusterparameters:list", "ssm:describepatchgroups:list", "s3:getobjectversion:read", "sso:listinstances:list", "application-autoscaling:describescalabletargets:read", "cloudfront:listdistributionsbykeygroup:list", "cognito-identity:listidentitypools:list", "ds:describedirectories:list", "elasticache:describereplicationgroups:list", "cloudfront:getfunction:read", "guardduty:getipset:read", "ec2:describeinstances:list", "iot:getpolicy:read", "lambda:getpolicy:read", "sagemaker:describeedgepackagingjob:read", "route53resolver:getresolverquerylogconfigpolicy:read", "es:describeelasticsearchdomain:read", "iot:describestream:read", "iam:putuserpolicy:permissions management", "transfer:describeuser:read", "ec2:revokesecuritygroupingress:write", "autoscaling:describeautoscalinggroups:list", "ec2:describeclientvpnauthorizationrules:list", "license-manager:listlicensemanagerreportgenerators:list", "fms:listcompliancestatus:list", "cloudfront:getdistributionconfig:read", "ec2:describehosts:list", "appsync:listtypes:list", "guardduty:listmembers:list", "events:listarchives:list", "iot:describeendpoint:read", "rds:describedbsubnetgroups:list", "iam:putrolepolicy:permissions management", "autoscaling:describeautoscalinginstances:list", "iot:listjobtemplates:list", "ec2:describetransitgateways:list", "cognito-idp:listresourceservers:list", "es:describeoutboundcrossclustersearchconnections:list", "snowball:listclusters:list", "savingsplans:describesavingsplans:read", "guardduty:listipsets:list", "chime:listvoiceconnectorgroups:list", "codecommit:getobjectidentifier:read", "dynamodb:listglobaltables:list", "iot:describethinggroup:read", "ssm:listdocumentmetadatahistory:list", "servicequotas:listrequestedservicequotachangehistory:read", "s3:getmultiregionaccesspoint:read", "route53resolver:listresolverconfigs:list", "detective:getgraphingeststate:read", "globalaccelerator:listcustomroutinglisteners:list", "shield:listprotections:list", "ec2:deletenetworkaclentry:write", "iam:updateassumerolepolicy:permissions management", "redshift:describeclustersecuritygroups:read", "cloudfront:listpublickeys:list", "lambda:listcodesigningconfigs:list", "iot:describesecurityprofile:read", "access-analyzer:listanalyzers:list", "s3:getobjectversiontorrent:read", "appmesh:listgatewayroutes:list", "events:describepartnereventsource:read", "redshift:describeclustersnapshots:read", "elasticmapreduce:describesecurityconfiguration:read", "route53resolver:getfirewallconfig:read", "s3:getstoragelensdashboard:read", "route53:gethealthcheck:read", "license-manager:listresourceinventory:list", "globalaccelerator:describecustomroutingacceleratorattributes:read", "route53resolver:listresolverendpoints:list", "cognito-sync:describeidentitypoolusage:read", "securityhub:describestandardscontrols:read", "dms:describeorderablereplicationinstances:read", "elasticmapreduce:describejobflows:read", "cloudfront:getstreamingdistribution:read", "ecr:listtagsforresource:read", "route53:listreusabledelegationsets:read", "ssm:describeeffectiveinstanceassociations:read", "chime:listapikeys:list", "iam:deleteuser:write", "iam:getopenidconnectprovider:read", "ec2:describelocalgatewayroutetables:list", "organizations:listaccountsforparent:list", "cloudformation:getstackpolicy:read", "ec2:getmanagedprefixlistentries:read", "tag:describereportcreation:read", "sagemaker:describeproject:read", "s3:getaccountpublicaccessblock:read", "iot:listbillinggroups:list", "directconnect:describevirtualgateways:read", "wafv2:getwebacl:read", "ssm:describemaintenancewindows:list", "iam:creategroup:write", "ssm:describeinstancepatches:read", "cloudfront:listcloudfrontoriginaccessidentities:list", "es:listelasticsearchinstancetypedetails:list", "appmesh:describeroute:read", "securityhub:getenabledstandards:list", "iam:listsigningcertificates:list", "iam:generatecredentialreport:read", "events:listapidestinations:list", "rds:describeoptiongroupoptions:list", "ec2:describetrafficmirrorsessions:list", "config:describeconformancepackstatus:read", "ssm:listtagsforresource:read", "iot:listprovisioningtemplates:list", "fsx:describeassociatedfilegateways:read", "ec2:describespotfleetinstances:list", "license-manager:listassociationsforlicenseconfiguration:list", "storagegateway:listtagsforresource:list", "chime:listtagsforresource:read", "ssm:describemaintenancewindowtargets:list", "config:getaggregateconfigrulecompliancesummary:read", "config:batchgetaggregateresourceconfig:read", "access-analyzer:listarchiverules:list", "ec2:describefleethistory:list", "quicksight:describeanalysis:read", "iot:listthingregistrationtasks:list", "s3:deleteobjecttagging:tagging", "redshift:describeauthenticationprofiles:read", "s3:getaccesspointforobjectlambda:read", "ecr-public:describeregistries:list", "quicksight:listtemplates:list", "ec2:describeaddressesattribute:list", "ec2:describelocalgateways:list", "ssm:describeinstancepatchstates:read", "license-manager:listlicenses:read", "support:describetrustedadvisorcheckresult:read", "chime:listappinstanceusers:list", "quicksight:describedatasourcepermissions:permissions management", "trustedadvisor:describecheckrefreshstatuses:read", "config:getconformancepackcompliancesummary:read", "sso:listapplicationinstances:list", "s3:getanalyticsconfiguration:read", "ec2:describeconversiontasks:list", "codedeploy:listapplicationrevisions:list", "greengrass:listcoredevices:list", "storagegateway:listvolumerecoverypoints:list", "ce:getreservationutilization:read", "comprehend:listkeyphrasesdetectionjobs:read", "ssm:describemaintenancewindowschedule:list", "quicksight:describenamespace:read", "ec2:describenetworkinterfacepermissions:list", "guardduty:getusagestatistics:read", "route53:getaccountlimit:read", "cognito-idp:listidentityproviders:list", "cognito-idp:listgroups:list", "guardduty:listtagsforresource:read", "organizations:leaveorganization:write", "sagemaker:describehumantaskui:read", "logs:getlogdelivery:read", "securityhub:listenabledproductsforimport:list", "config:getorganizationconfigruledetailedstatus:read", "kinesisanalytics:listapplications:list", "ec2:describeinstancetypeofferings:list", "storagegateway:describenfsfileshares:read", "autoscaling:describelaunchconfigurations:list", "greengrass:listresourcedefinitionversions:list", "route53:getreusabledelegationset:list", "cognito-sync:describeidentityusage:read", "iam:listaccesskeys:list", "workspaces:describeipgroups:read", "mediastore:listcontainers:list", "ec2:describereservedinstancesmodifications:list", "workspaces:describeworkspaceimagepermissions:read", "ssm:describedocumentparameters:read", "config:describeremediationexceptions:list", "cloudfront:getcloudfrontoriginaccessidentityconfig:read", "transfer:listaccesses:read", "sagemaker:listlineagegroups:list", "codedeploy:listdeploymenttargets:list", "s3:getaccesspoint:read", "tag:tagresources:tagging", "kms:describekey:read", "sqs:getqueueattributes:read", "cloudwatch:getmetricdata:read", "ecs:listattributes:list", "iam:listvirtualmfadevices:list", "autoscaling:describelifecyclehooks:list", "iam:listgroupsforuser:list", "waf-regional:listresourcesforwebacl:list", "athena:listworkgroups:list", "rds:describependingmaintenanceactions:list", "transfer:listexecutions:read", "ec2:describeinstanceeventnotificationattributes:list", "greengrass:listcoredefinitionversions:list", "robomaker:describerobot:read", "guardduty:getfilter:read", "waf:getratebasedrule:read", "codedeploy:getdeployment:list", "ec2:describeclientvpnconnections:list", "s3:getaccesspointpolicyforobjectlambda:read", "elasticache:describecacheparametergroups:list", "route53domains:listtagsfordomain:read", "ram:listresources:list", "directconnect:describedirectconnectgateways:read", "route53domains:listoperations:list", "iot:listactiveviolations:list", "elasticache:describeusergroups:list", "rekognition:listfaces:read", "events:listreplays:list", "ssm:listdocuments:list", "cognito-idp:describeriskconfiguration:read", "route53resolver:listresolverquerylogconfigs:list", "workdocs:describeresourcepermissions:list", "rekognition:describecollection:read", "elasticloadbalancing:describelisteners:read", "iam:updaterole:write", "s3:listaccesspointsforobjectlambda:list", "cloudfront:getkeygroupconfig:read", "ec2:describestalesecuritygroups:list", "dms:describeendpointsettings:read", "ec2:describevpcattribute:list", "ec2:describereplacerootvolumetasks:list", "iam:deletegroup:write", "sso:listaccountsforprovisionedpermissionset:list", "rds:describedbproxies:list", "sagemaker:listmodelexplainabilityjobdefinitions:list", "mq:listbrokers:list", "storagegateway:listfileshares:list", "cloudformation:describestacksetoperation:read", "quicksight:describedashboard:read", "dms:describeeventcategories:read", "ecs:listclusters:list", "inspector:describeresourcegroups:read", "quicksight:listgroups:list", "cloud9:describeec2remote:read", "inspector:describeassessmenttargets:read", "lambda:listtags:read", "elasticloadbalancing:describesslpolicies:read", "iam:listmfadevicetags:list", "ec2:describenatgateways:list", "globalaccelerator:listbyoipcidrs:list", "redshift:describeclustertracks:list", "ec2:describesnapshots:list", "ssm:describesessions:list", "chime:listgroups:list", "dms:describecertificates:read", "ec2:describesnapshottierstatus:list", "sagemaker:listhumantaskuis:list", "fms:listpolicies:list", "securityhub:getmasteraccount:read", "kms:listkeys:list", "mq:describeconfiguration:read", "cloudfront:listdistributions:list", "sso:listmanagedpoliciesinpermissionset:list", "elasticbeanstalk:describeaccountattributes:read", "sso:listprofileassociations:read", "globalaccelerator:listendpointgroups:list", "sagemaker:describehyperparametertuningjob:read", "organizations:listparents:list", "ec2:describetransitgatewayconnectpeers:list", "rds:describedbclusterparameters:list", "iam:getpolicy:read", "elasticbeanstalk:describeevents:read", "ecs:listtaskdefinitionfamilies:list", "sagemaker:describeendpointconfig:read", "codedeploy:getdeploymentconfig:list", "codecommit:getbranch:read", "quicksight:describeaccountsettings:read", "iam:getpolicyversion:read", "waf:listrules:list", "comprehend:listeventsdetectionjobs:read", "iam:listservercertificates:list", "ssm:getautomationexecution:read", "ssm:describeinstancepatchstatesforpatchgroup:read", "inspector:describeassessmenttemplates:read", "ssm:describepatchbaselines:list", "quicksight:describeuser:read", "greengrass:listbulkdeployments:list", "securityhub:describehub:read", "chime:listchannelsassociatedwithchannelflow:list", "comprehend:describeeventsdetectionjob:read", "s3:getaccesspointpolicystatusforobjectlambda:read", "logs:describeexporttasks:list", "robomaker:listworldexportjobs:list", "chime:listchannelsmoderatedbyappinstanceuser:list", "elasticfilesystem:describefilesystems:list", "globalaccelerator:listcustomroutingendpointgroups:list", "codedeploy:listdeploymentgroups:list", "s3:getbucketlogging:read", "sagemaker:describeappimageconfig:read", "sso:listapplicationtemplates:list", "savingsplans:describesavingsplansofferingrates:read", "iam:getcontextkeysforprincipalpolicy:read", "iam:listentitiesforpolicy:list", "cloudhsm:listhapgs:list", "trustedadvisor:describeorganizationaccounts:read", "quicksight:listfolders:list", "appmesh:describegatewayroute:read", "cloudsearch:describedomainendpointoptions:read", "config:describeorganizationconformancepacks:list", "elasticache:describeupdateactions:list", "robomaker:listfleets:list", "s3:getobjectretention:read", "elasticloadbalancing:describetags:read", "cognito-sync:listrecords:read", "config:getcompliancesummarybyresourcetype:read", "iam:listattachedrolepolicies:list", "shield:listtagsforresource:read", "waf:listratebasedrules:list", "inspector:listassessmentruns:list", "fsx:describefilesystems:read", "sagemaker:describetransformjob:read", "storagegateway:listvolumes:list", "autoscaling:describescheduledactions:list", "autoscaling:describenotificationconfigurations:list", "ec2:describesecuritygrouprules:list", "inspector:listassessmentrunagents:list", "schemas:listregistries:list", "license-manager:listtokens:list", "ec2:describeflowlogs:list", "elasticloadbalancing:describetargetgroupattributes:read", "mediaconnect:listreservations:list", "cloudformation:liststacksetoperations:list", "elasticache:describereservedcachenodes:list", "rds:describeoptiongroups:list", "ce:getcostandusage:read", "chime:listchannelflows:list", "kinesis:listtagsforstream:read", "route53:getchange:list", "s3:listbucket:list", "elasticache:describeusers:list", "fsx:describefilesystemaliases:read", "kinesis:describestreamconsumer:read", "directconnect:describeloa:read", "cloudfront:listdistributionsbyresponseheaderspolicyid:list", "securityhub:getinsights:list", "application-autoscaling:describescalingactivities:read", "greengrass:listbulkdeploymentdetailedreports:read", "iam:getsamlprovider:read", "ram:listpermissions:list", "fsx:describestoragevirtualmachines:read", "directconnect:describedirectconnectgatewayassociationproposals:read", "codestar:listresources:list", "quicksight:describeemailcustomizationtemplate:read", "sqs:listqueuetags:read", "sagemaker:describeendpoint:read", "s3:getobjectversionacl:read", "sagemaker:describeuserprofile:read", "license-manager:listfailuresforlicenseconfigurationoperations:list", "waf-regional:getrulegroup:read", "ec2:describeinstancetypes:list", "ec2:describetransitgatewayvpcattachments:list", "iot:describejobtemplate:read", "sagemaker:describeworkforce:read", "guardduty:getdetector:read", "quicksight:describetemplate:read", "iam:listsamlprovidertags:list", "cognito-idp:describeuserpooldomain:read", "servicequotas:getawsdefaultservicequota:read", "ec2:describefastsnapshotrestores:read", "iot:listpolicyprincipals:list", "securityhub:getmembers:read", "shield:describedrtaccess:read", "appmesh:describemesh:read", "chime:listchannels:list", "secretsmanager:listsecretversionids:read", "iot:listdomainconfigurations:list", "elasticache:describeserviceupdates:list", "autoscaling:describewarmpool:list", "route53domains:getdomaindetail:read", "directconnect:describelocations:read", "cognito-idp:listtagsforresource:list", "logs:describequerydefinitions:list", "route53domains:getoperationdetail:read", "securityhub:listorganizationadminaccounts:list", "es:describedomainchangeprogress:read", "s3:listmultiregionaccesspoints:list", "securityhub:getinsightfindingtrend:read", "servicequotas:getassociationforservicequotatemplate:read", "storagegateway:describetapearchives:read", "iot:listv2logginglevels:list", "ssm:describemaintenancewindowexecutiontasks:list", "datasync:describelocationnfs:read", "kms:listkeypolicies:list", "route53:listqueryloggingconfigs:list", "es:describedomainconfig:read", "ec2:describestoreimagetasks:list", "route53:gethealthchecklastfailurereason:list", "lambda:listaliases:list", "sagemaker:listtransformjobs:list", "sagemaker:listcompilationjobs:list", "inspector:listtagsforresource:read", "cloudformation:liststacksetoperationresults:list", "sagemaker:listtrialcomponents:list", "cloudsearch:describedomains:list", "iot:describescheduledaudit:read", "s3:getaccesspointpolicystatus:read", "quicksight:describeanalysispermissions:read", "quicksight:listthemealiases:list", "redshift:describedatashares:read", "athena:listengineversions:read", "greengrass:listcomponents:list", "ec2:describefleetinstances:list", "license-manager:listusageforlicenseconfiguration:list", "ecr-public:getrepositorycatalogdata:read", "s3:getintelligenttieringconfiguration:read", "kms:getkeyrotationstatus:read", "robomaker:describesimulationjob:read", "codecommit:getrepository:read", "rds:describedbclusters:list", "route53resolver:listfirewallconfigs:list", "sagemaker:listartifacts:list", "iot:describebillinggroup:read", "storagegateway:describegatewayinformation:read", "inspector:listrulespackages:list", "cognito-idp:listdevices:list", "storagegateway:listfilesystemassociations:list", "sagemaker:describemodelbiasjobdefinition:read", "ssm:describemaintenancewindowexecutions:list", "redshift:describescheduledactions:read", "iam:getservercertificate:read", "s3:getencryptionconfiguration:read", "iot:listtunnels:list", "logs:testmetricfilter:read", "chime:listvoiceconnectorterminationcredentials:list", "config:getcompliancedetailsbyresource:read", "lambda:getfunctioneventinvokeconfig:read", "trustedadvisor:describechecksummaries:read", "elasticloadbalancing:describerules:read", "datapipeline:evaluateexpression:read", "s3:getobject:read", "glacier:listvaults:list", "elasticmapreduce:describepersistentappui:read", "rds:describedbparametergroups:list", "transfer:describesecuritypolicy:read", "cloudfront:getfieldlevelencryption:read", "ec2:describesubnets:list", "config:batchgetresourceconfig:read", "appmesh:listvirtualgateways:list", "license-manager:listlicenseconfigurations:read", "iot:describeeventconfigurations:read", "ecs:describetasks:read", "ec2:describelocalgatewayvirtualinterfaces:list", "robomaker:describeworld:read", "sagemaker:describeflowdefinition:read", "chime:listchannelmemberships:list", "directconnect:describetags:read", "wafv2:listresourcesforwebacl:list", "ssm:describeinstanceproperties:read", "comprehend:listsentimentdetectionjobs:read", "elasticache:listtagsforresource:read", "rds:describedbclusterparametergroups:list", "athena:listpreparedstatements:list", "storagegateway:describemaintenancestarttime:read", "sso:listaccountassignmentdeletionstatus:list", "ec2:describecoippools:list", "robomaker:describesimulationjobbatch:read", "secretsmanager:describesecret:read", "ec2:describespotpricehistory:list", "cloudfront:getdistribution:read", "mq:describeconfigurationrevision:read", "organizations:listhandshakesfororganization:list", "securityhub:listcontrolevaluationsummaries:read", "dms:describeaccountattributes:read", "dynamodb:liststreams:read", "gamelift:listbuilds:list", "securityhub:getfreetrialusage:read", "quicksight:listdatasources:list", "wafv2:listregexpatternsets:list", "s3:getaccesspointpolicy:read", "iam:getcredentialreport:read", "transfer:listsecuritypolicies:list", "iam:listpolicies:list", "ec2:describenetworkinsightsaccessscopes:list", "ec2:describeiaminstanceprofileassociations:list", "ec2:describetransitgatewaypeeringattachments:list", "ec2:describedhcpoptions:list", "rds:describesourceregions:list", "ecr:describerepositories:read", "iot:listthingsinbillinggroup:list", "redshift:describeclusterversions:read", "workspaces:describeworkspacedirectories:read", "waf-regional:getratebasedrule:read", "rds:describedbclustersnapshotattributes:list", "route53:listhostedzonesbyname:list", "ses:listidentitypolicies:list", "s3:getobjecttorrent:read", "ssm:describeavailablepatches:read", "storagegateway:describesnapshotschedule:read", "s3:getbucketcors:read"]'::varchar, used_permission_count='0'::integer, unused_permission_count='1865'::integer WHERE demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.role_uuid = '29cdb3c6-3ed8-5540-ac9c-835184f5a481'::varchar AND demo.role_can_assume__3d757285_f270_42fc_a12d_2c03489fff36.entity_uuid = '556f062a-5b45-55d2-8534-7a5418f799bf'::varchar;""",
    r"""SELECT relname FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = 'public' AND relname = 'iam_actions';""",
    r"""SELECT demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.uuid, demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.cloud_account_id, demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.resource_regex, demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.permission_id FROM demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36 WHERE demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.uuid = 'f0c5af4e-6a34-5bd2-9200-0537890d6a77'::varchar AND demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.cloud_account_id = '207707207483'::varchar AND demo.user_net_permissions__3d757285_f270_42fc_a12d_2c03489fff36.permission_id = 'sts:assumerole:write'::varchar;"""
]

def create_log_collector(sqls):

    for sql in sqls:
        data = {
            "logs": list(
                map(
                    lambda x: {
                        "_uuid": str(uuid.uuid1()),
                        "query": x,
                        "dbEngine": "postgres",
                        "date": datetime.utcnow().isoformat(),
                    },
                    [sql],
                ),
            ),
            "framework": "N/A",
            "path": "N/A",
            "operationType": "N/A",
            "requestDuration": 111,
            "requestStatus": "N/A",
        }

        with open('ariksa.log', "a", encoding="utf8") as file:
            file.write(json.dumps(data) + "\n")


create_log_collector(SQLS)
