"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCloudFrontWebDistributionForS3Props = exports.DefaultCloudFrontWebDistributionForApiGatewayProps = void 0;
const cloudfront = require("@aws-cdk/aws-cloudfront");
const cdk = require("@aws-cdk/core");
function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint, loggingBucket, setHttpSecurityHeaders, edgeLambda) {
    const apiEndPointUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split("://", apiEndPoint.url));
    const apiEndPointDomainName = cdk.Fn.select(0, cdk.Fn.split("/", apiEndPointUrlWithoutProtocol));
    if (setHttpSecurityHeaders) {
        return {
            originConfigs: [{
                    customOriginSource: {
                        domainName: apiEndPointDomainName
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                            lambdaFunctionAssociations: [
                                {
                                    eventType: cloudfront.LambdaEdgeEventType.ORIGIN_RESPONSE,
                                    lambdaFunction: edgeLambda
                                }
                            ]
                        }]
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
    else {
        return {
            originConfigs: [{
                    customOriginSource: {
                        domainName: apiEndPointDomainName
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                        }]
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
}
exports.DefaultCloudFrontWebDistributionForApiGatewayProps = DefaultCloudFrontWebDistributionForApiGatewayProps;
function DefaultCloudFrontWebDistributionForS3Props(sourceBucket, loggingBucket, _originAccessIdentity, setHttpSecurityHeaders, edgeLambda) {
    if (setHttpSecurityHeaders) {
        return {
            originConfigs: [{
                    s3OriginSource: {
                        s3BucketSource: sourceBucket,
                        originAccessIdentity: _originAccessIdentity
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                            lambdaFunctionAssociations: [
                                {
                                    eventType: cloudfront.LambdaEdgeEventType.ORIGIN_RESPONSE,
                                    lambdaFunction: edgeLambda
                                }
                            ]
                        }]
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
    else {
        return {
            originConfigs: [{
                    s3OriginSource: {
                        s3BucketSource: sourceBucket,
                        originAccessIdentity: _originAccessIdentity
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                        }]
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
}
exports.DefaultCloudFrontWebDistributionForS3Props = DefaultCloudFrontWebDistributionForS3Props;
//# sourceMappingURL=data:application/json;base64,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