# Generated by Django 3.2.9 on 2022-02-28 20:47

from django.db import migrations, models
import django.db.models.deletion


def migrate_from_bo_to_bctc(apps, schema_editor):
    print('')
    print('!!!WARNING!!!')
    print('Once this migration operation is complete, it is not recommended to revert it')

    BackupCommitTreeChange = apps.get_model('netbox_config_backup', 'BackupCommitTreeChange')
    BackupFile = apps.get_model('netbox_config_backup', 'BackupFile')
    bctcs = BackupCommitTreeChange.objects.all()
    for bctc in bctcs:
        if bctc.new:
            uuid, ftype = bctc.new.file.split('.')
        else:
            uuid, ftype = bctc.old.file.split('.')

        try:
            bf = BackupFile.objects.get(backup=bctc.commit.backup, type=ftype)
        except BackupFile.DoesNotExist:
            bf = BackupFile.objects.create(backup=bctc.commit.backup, type=ftype)

        bctc.backup = bctc.commit.backup
        bctc.file = bf

        bctc.save()


def migrate_from_bctc_to_bo(apps, schema_editor):
    print('')
    print('!!!!WARNING!!!')
    print('This migration operation may fail and leave your netbox_config_backup database in an onconsistent state')

    BackupCommitTreeChange = apps.get_model('netbox_config_backup', 'BackupCommitTreeChange')
    bctcs = BackupCommitTreeChange.objects.all()
    for bctc in bctcs:
        bctc.refresh_from_db()
        bctc.commit.refresh_from_db()

        bctc.commit.backup = bctc.backup
        bctc.commit.save()

        if bctc.new:
            bctc.new.refresh_from_db()
            bctc.new.type = f'{bctc.backup.uuid}.{bctc.file.type}'
            bctc.new.save()
        if bctc.old:
            bctc.old.refresh_from_db()
            bctc.old.file = f'{bctc.backup.uuid}.{bctc.file.type}'
            bctc.old.save()


class Migration(migrations.Migration):

    dependencies = [
        ('netbox_config_backup', '0008_backupjob_scheduled_nullable'),
    ]

    operations = [
        migrations.AlterField(
            model_name='backupobject',
            name='sha',
            field=models.CharField(max_length=64, unique=True),
        ),
        migrations.AlterUniqueTogether(
            name='backupobject',
            unique_together=set(),
        ),
        migrations.AlterField(
            model_name='backupcommit',
            name='time',
            field=models.DateTimeField(),
        ),
        migrations.CreateModel(
            name='BackupFile',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=10)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='backupfile',
            name='backup',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='files', to='netbox_config_backup.backup'),
        ),
        migrations.AlterUniqueTogether(
            name='backupfile',
            unique_together={('backup', 'type')},
        ),
        migrations.AddField(
            model_name='backupcommittreechange',
            name='backup',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='changes', to='netbox_config_backup.backup'),
        ),
        migrations.AddField(
            model_name='backupcommittreechange',
            name='file',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='changes', to='netbox_config_backup.backupfile'),
        ),
        migrations.AlterField(
            model_name='backupcommittreechange',
            name='new',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='changes', to='netbox_config_backup.backupobject'),
        ),
        migrations.RunPython(migrate_from_bo_to_bctc, migrate_from_bctc_to_bo),
        migrations.AlterField(
            model_name='backupcommittreechange',
            name='backup',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='changes', to='netbox_config_backup.backup'),
        ),
        migrations.AlterField(
            model_name='backupcommittreechange',
            name='file',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='changes', to='netbox_config_backup.backupfile'),
        ),
        migrations.RemoveField(
            model_name='backupobject',
            name='file',
        ),
        migrations.RemoveConstraint(
            model_name='backupcommit',
            name='backup_and_sha_not_null',
        ),
        migrations.RemoveField(
            model_name='backupcommit',
            name='backup',
        ),
    ]
