"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdatePipelineAction = void 0;
const codebuild = require("@aws-cdk/aws-codebuild");
const cpactions = require("@aws-cdk/aws-codepipeline-actions");
const iam = require("@aws-cdk/aws-iam");
const construct_internals_1 = require("../private/construct-internals");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Action to self-mutate the pipeline.
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 *
 * @experimental
 */
class UpdatePipelineAction extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const selfMutationProject = new codebuild.PipelineProject(this, 'SelfMutation', {
            projectName: props.projectName,
            environment: { buildImage: codebuild.LinuxBuildImage.STANDARD_4_0 },
            buildSpec: codebuild.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    install: {
                        commands: `npm install -g aws-cdk${installSuffix}`,
                    },
                    build: {
                        commands: [
                            // Cloud Assembly is in *current* directory.
                            `cdk -a ${construct_internals_1.embeddedAsmPath(scope)} deploy ${props.pipelineStackName} --require-approval=never --verbose`,
                        ],
                    },
                },
            }),
        });
        // allow the self-mutating project permissions to assume the bootstrap Action role
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['sts:AssumeRole'],
            resources: ['arn:*:iam::*:role/*-deploy-role-*', 'arn:*:iam::*:role/*-publishing-role-*'],
        }));
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['cloudformation:DescribeStacks'],
            resources: ['*'],
        }));
        // S3 checks for the presence of the ListBucket permission
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:ListBucket'],
            resources: ['*'],
        }));
        this.action = new cpactions.CodeBuildAction({
            actionName: 'SelfMutate',
            input: props.cloudAssemblyInput,
            project: selfMutationProject,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope, stage, options) {
        return this.action.bind(scope, stage, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name, target, options) {
        return this.action.onStateChange(name, target, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties() {
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
exports.UpdatePipelineAction = UpdatePipelineAction;
//# sourceMappingURL=data:application/json;base64,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