# mypy-boto3-license-manager

[![PyPI - mypy-boto3-license-manager](https://img.shields.io/pypi/v/mypy-boto3-license-manager.svg?color=blue)](https://pypi.org/project/mypy-boto3-license-manager)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-license-manager.svg?color=blue)](https://pypi.org/project/mypy-boto3-license-manager)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.LicenseManager 1.14.63](https://boto3.amazonaws.com/v1/documentation/api/1.14.63/reference/services/license-manager.html#LicenseManager) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-license-manager](#mypy-boto3-license-manager)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `LicenseManager` service.

```bash
python -m pip install boto3-stubs[license-manager]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[license-manager]` in your environment: `python -m pip install 'boto3-stubs[license-manager]'`

Both type checking and auto-complete should work for `LicenseManager` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[license-manager]` in your environment: `python -m pip install 'boto3-stubs[license-manager]'`

Both type checking and auto-complete should work for `LicenseManager` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[license-manager]` in your environment: `python -m pip install 'boto3-stubs[license-manager]'`
- Run `mypy` as usual

Type checking should work for `LicenseManager` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[license-manager]` in your environment: `python -m pip install 'boto3-stubs[license-manager]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `LicenseManager` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`LicenseManagerClient` provides annotations for `boto3.client("license-manager")`.

```python
import boto3

from mypy_boto3_license_manager import LicenseManagerClient

client: LicenseManagerClient = boto3.client("license-manager")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LicenseManagerClient = session.client("license-manager")
```

### Paginators annotations

`mypy_boto3_license_manager.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_license_manager import LicenseManagerClient
from mypy_boto3_license_manager.paginator import (
    ListAssociationsForLicenseConfigurationPaginator,
    ListLicenseConfigurationsPaginator,
    ListLicenseSpecificationsForResourcePaginator,
    ListResourceInventoryPaginator,
    ListUsageForLicenseConfigurationPaginator,
)

client: LicenseManagerClient = boto3.client("license-manager")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_associations_for_license_configuration_paginator: ListAssociationsForLicenseConfigurationPaginator = client.get_paginator("list_associations_for_license_configuration")
list_license_configurations_paginator: ListLicenseConfigurationsPaginator = client.get_paginator("list_license_configurations")
list_license_specifications_for_resource_paginator: ListLicenseSpecificationsForResourcePaginator = client.get_paginator("list_license_specifications_for_resource")
list_resource_inventory_paginator: ListResourceInventoryPaginator = client.get_paginator("list_resource_inventory")
list_usage_for_license_configuration_paginator: ListUsageForLicenseConfigurationPaginator = client.get_paginator("list_usage_for_license_configuration")
```







### Typed dictionations

`mypy_boto3_license_manager.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_license_manager.type_defs import (
    AutomatedDiscoveryInformationTypeDef,
    ConsumedLicenseSummaryTypeDef,
    CreateLicenseConfigurationResponseTypeDef,
    FilterTypeDef,
    GetLicenseConfigurationResponseTypeDef,
    GetServiceSettingsResponseTypeDef,
    InventoryFilterTypeDef,
    LicenseConfigurationAssociationTypeDef,
    LicenseConfigurationTypeDef,
    LicenseConfigurationUsageTypeDef,
    LicenseOperationFailureTypeDef,
    LicenseSpecificationTypeDef,
    ListAssociationsForLicenseConfigurationResponseTypeDef,
    ListFailuresForLicenseConfigurationOperationsResponseTypeDef,
    ListLicenseConfigurationsResponseTypeDef,
    ListLicenseSpecificationsForResourceResponseTypeDef,
    ListResourceInventoryResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUsageForLicenseConfigurationResponseTypeDef,
    ManagedResourceSummaryTypeDef,
    MetadataTypeDef,
    OrganizationConfigurationTypeDef,
    PaginatorConfigTypeDef,
    ProductInformationFilterTypeDef,
    ProductInformationTypeDef,
    ResourceInventoryTypeDef,
    TagTypeDef,
)

def get_structure() -> AutomatedDiscoveryInformationTypeDef:
    return {
      ...
    }
```
