# Simple SPI Tests

`spitest` is a trivial Python tool for interacting with the SPI device
code in the `hello_world` test program running on `top_earlgrey` on the
FPGA board.

The same FTDI interface is used for SPI as for JTAG, so this tool
cannot be used at the same time as an OpenOCD debugger. The
`top_earlgray_nexsysvideo` pin mux has been modified to use one of the
FTDI GPIOs to select between the two interfaces, so it is possible to
dynamically switch between the tools. This status bit is also
presented as `GPIO[16]` (which was previously unused).

The example commands assume `$REPO_TOP` is set to the toplevel directory
of the repo.

### Setup

If packages have not previously been installed you will need to set a
few things up. First use `apt` and `pip3` to install some required packages:

```console
$ sudo apt-get install libusb-1.0
$ pip3 install --user pyftdi
```

You also need the `udev` rules to be set correctly by following the
instructions for setting up the Xilinx tools.

### SPI/JTAG selection GPIO

The tool can be used to test the SPI/JTAG selection gpio. This is done
by providing the `--flippy` or `-f` argument which causes the
selection to be flipped 10 times with 2 second pauses between. The
`hello_world` program will see the bit flip and print a message.


```console
$ cd $REPO_TOP/util/simplespi
$ ./spitest.py -f
```


### SPI Protocol Test

The SPI protocol used in the test is a simple exchange of 4-byte
messages. When data is received from the SPI Device interface the
`hello_world` program will receive and print it out on the UART. The
first four bytes have their bottom bit inverted and are returned in
the next SPI transaction. If the sender is faster than the FPGA then
messages are aggregated in the receive buffer and will appear as a
single long message to `hello_world` which will only return a single
4-byte message.

A simple test should therefore just use 4 characters.


```console
$ cd $REPO_TOP/util/simplespi
$ ./spitest.py 1234
$ ./spitest.py 5678
```

Long messages will be padded to a multiple of 4 bytes before being
sent, and there may be some garbage return messages.

```console
$ cd $REPO_TOP/util/simplespi
$ ./spitest.py the quick brown fox jumps
```

Messages of any length (the length given is used even if not a
multiple of 4) may be generated by the tool. The message is formed
from repeating the ascii characters `0123456789abcdef` (to fill the
required length) and sent, and there may be some garbage return
messages.

```console
$ cd $REPO_TOP/util/simplespi
$ ./spitest.py -l 120
```
