---
title: "Website Privacy and Cookies Policy"
aliases:
  - /privacy/
---

We take the privacy of those who visit this website seriously and we aim to be
transparent about our processing of personal information. Accordingly, this
page explains the kinds of information we may collect about you, and the
reasons for collecting this information.

# General website information

If you use this website, we will make a record of the information your web
browser sends to us, typically identifying the type of browser you are using,
and your IP address. We record this information in order to understand the ways
in which people use our website; to detect bugs; and hostile access. We
routinely delete our server logs after 30 days, and the analytics data
associated with each user is only retained for 26 months after the last time
they visit the site.

We share this information only with our website hosting service Google Cloud,
and analytics provider Google Analytics, who are under an obligation not to use
your information for any other purpose.

# Cookies

To make this website work properly, we sometimes place small data files called
"cookies" on your device. Most big websites do this too.

# What are cookies?

A cookie is a small text file that a website (including this website) saves on
your computer or mobile device when you visit the site. It enables the website,
including plugins such as YouTube, to remember your actions and preferences
(such as login, language, font size and other display preferences) over a
period of time, so you don't have to keep re-entering them whenever you come
back to the site or browse from one page to another. It also enables us to
analyse how this website is being used.

# How do we use cookies?

The following table explains the cookies we use and why we use them.

| *Cookie* | *Expiration* | *Purpose* |
|----------|--------------|-----------|
| `_ga` | 2 years | Distinguishing users. |
| `_gid` | 24 hours | Distinguishing users. |
| `_gat_gtag_UA_151030466_1` | 1 minute | Limiting the rate at which data is reported. |
| `_gat_gtag_UA_151030466_2` | 1 minute | Limiting the rate at which data is reported. |
| `AMP_TOKEN` | At most 1 year | Distinguishing users. |

# How to control cookies

You can control and/or delete cookies as you wish - for details, see
[aboutcookies.org](https://aboutcookies.org). You can delete all cookies that
are already on your computer and you can set most browsers to prevent them from
being placed. If you do this, however, you may have to manually adjust some
preferences every time you visit a site and some services and functionalities
may not work.

# Emails

If you sign up to be on our mailing list via this website, we will ask you for
the following information:

  * Email address

Unless we are in direct correspondence with you - for example because you have
asked us specific questions about our products or services - we will only use
this information for the following purposes:

  * Promotional emails, for example:
    * Product updates and key milestones
    * Our presence at events & conferences (e.g. poster presentations, talks,
      booths, webinars, symposia etc.)
    * Our publications (e.g. journal papers, conference proceedings, magazine
      spreads etc.)
  * News and press releases
  * Outbound newsletters
  * Survey invitations

You may unsubscribe from our mailing lists at any time and any promotional
email we send you will contain an option to enable you to unsubscribe.

We will not allow any third parties to make use of your email information, but
we may use third party data processors, for example to automate our handling of
mailing lists. Any use we make of data processors will require them only to act
only on our instructions concerning your personal data.

# Lawful basis

It is lawful for us, under the General Data Protection Regulation (GDPR), to
process the information described in this notice because we have a

  * Legitimate interest in operating a website and using the information we
    collect for these purposes.
  * Where you have signed up to a mailing list, we have a legitimate interest
    in emailing you so long as you do not object to our doing so.

We do not believe the way in which we are processing them is likely to cause you any harm.

# Transfer of data outside the United Kingdom & Europe

We may use third party providers, such as [Google
Groups](https://groups.google.com/forum/#!overview) and
[zulipchat](https://zulipchat.com) to support various kinds of communication.
But in each case, your personal data will only be processed by them, if you
have yourself signed up to use them. If you do, each provider has their own
terms and privacy notices and you should refer to their privacy notices for
information on how your personal data is processed when using their services.

# Your rights

Under the General Data Protection Regulation you have a number of important
rights free of charge. In summary, those include rights to:

  * access to your personal information
  * require us to correct any mistakes in your information which we hold
  * require the erasure of personal information concerning you in certain
    situations
  * receive the personal information concerning you which you have provided to
    us, in a structured, commonly used and machine-readable format and have the
    right to transmit those data to a third party in certain situations
  * object at any time to processing of personal information concerning you for
    direct marketing
  * object to decisions being taken by automated means which produce legal
    effects concerning you or similarly significantly affect you
  * object in certain other situations to our continued processing of your
    personal information
  * otherwise restrict our processing of your personal information in certain
    circumstances

For further information on each of those rights, including the circumstances in
which they apply, see the [Guidance from the UK Information Commissioner's
Office (ICO) on individuals rights under the General Data Protection
Regulation](http://ico.org.uk/for-organisations/guide-to-the-general-data-protection-regulation-gdpr/individual-rights/).

If you would like to exercise any of those rights, please:

  * email us at [info@lowrisc.org](mailto:info@lowrisc.org)
  * write to us at lowRISC, 7 Hills Road, Cambridge, CB2 1GE, UK
  * let us have enough information to identify you (eg when you accessed the
    website and from what location)

If you would like to unsubscribe from any email newsletter you can also click
on the 'unsubscribe' button at the bottom of the email newsletter. It may take
up to seven days for this to take place.

The [General Data Protection
Regulation](http://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679&from=EN)
also gives you right to lodge a complaint with a supervisory authority, in
particular in the European Union (or European Economic Area) state where you
work, normally live or where any alleged infringement of data protection laws
occurred. The supervisory authority in the UK is the Information Commissioner
who may be contacted at
[https://ico.org.uk/make-a-complaint/your-personal-information-concerns/](https://ico.org.uk/make-a-complaint/your-personal-information-concerns/)
or telephone: 0303 123 1113

# Who we are

We are lowRISC Community Interest Company is a not-for-profit, private company
limited by guarantee, registered in England and Wales with Company number
09272283. Our registered office address is 4a Newmarket Road, Cambridge, CB5
8DT, UK.
