---
title: "Top Earlgrey"
---

## Specification

The specification of Earlgrey is located [here]({{< relref "doc" >}}).

## Tool: TopGen

Top Earlgrey is being generated by the integration tool, topgen
(`util/topgen.py`). Please do not revise `rtl/top_earlgrey.sv`, the crossbar
modules, and the interrupt controller directly. Those files are auto-generated
and sit in the repository for browsing purpose.

### How to create top module

Top module `rtl/top_earlgrey.sv` is created by `topgen.py`. Current top module
is created with below command.

```console
../../util/topgen.py -t data/top_earlgrey.hjson -o . -v
```

It generates files below:

- `rtl/top_earlgrey.sv`: Top module generated from the template
    `data/top_earlgrey.sv.tpl` with the configuration file
    `data/top_earlgrey.hjson`
- `rtl/xbar_main.sv` and `rtl/tl_main_pkg.sv`: Crossbar module. As of now,
    earlgrey has only one main crossbar. tlgen library is used to generate
    these files.
- `rtl/rv_plic*.sv` and `data/rv_plic.hjson`: Interrupt controller module.
    `hw/ip/rv_plic/util/reg_rv_plic.py` tool is used to create RV_PLIC having
    the number of interrupts specified in the hjson.

### Adding new blocks into top level
Modify `data/top_earlgrey.hjson` to include new module
- If new block has interrupts, also add to the `interrupt_module` definition

Modify `xbar_main.hjson` for the host / device connectivity

### Modify configurations

Main configuration for Top Earlgrey is in `data/top_earlgrey.hjson`. The users
need to specify the list of peripherals, memories, crossbars, and the interrupts
in the configuration file. The tool then reads relavant information from the
each peripheral blocks' configuration. For instance, if `uart` module is used,
the tool reads `hw/ip/uart/data/uart{_reg}.hjson` and parses the information such
as input/output, the size of its register space, and interrupts.

For the memories, the tool utilizes the `type` and instantiates relavant modules
including the converter from TL-UL interface to the native interfaces (SRAM,
ROM, eFlash). The user only needs to describe the base address and the memory
size.

The crossbar should be defined in the separate file. Please take a look at
`data/xbar_main.hjson` as an example. In the top configuration, it needs to
define the xbar and the clock, then the tool calls tlgen library to create the
crossbar design. Please remind that the instance name in the crossbar and that
in the module field should be matched for topgen to create fields that tlgen
uses.

### Modify the template

Main top template file is `data/top_earlgrey.sv.tpl`. In most cases, it isn't
require to modify the template file. For instance, to add new IP into the top,
the user just needs to add the IP to the `module` field and revise the crossbar
connections in the crossbar configuration.

There might be some cases that needs to revise the template. As of now, a few
modules are hard-coded such as RISC-V core and the debug module. If any of these
modules need to be revised or some new modules not matching to the
comportability spec, it needs to be manually instantiated in the template file.
