// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module sysrst_ctrl_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,
  // To HW
  output sysrst_ctrl_reg_pkg::sysrst_ctrl_reg2hw_t reg2hw, // Write
  input  sysrst_ctrl_reg_pkg::sysrst_ctrl_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import sysrst_ctrl_reg_pkg::* ;

  localparam int AW = 7;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  assign tl_reg_h2d = tl_i;
  assign tl_o_pre   = tl_reg_d2h;

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_qs;
  logic intr_state_wd;
  logic intr_state_we;
  logic intr_enable_qs;
  logic intr_enable_wd;
  logic intr_enable_we;
  logic intr_test_wd;
  logic intr_test_we;
  logic regwen_qs;
  logic regwen_wd;
  logic regwen_we;
  logic [15:0] ec_rst_ctl_qs;
  logic [15:0] ec_rst_ctl_wd;
  logic ec_rst_ctl_we;
  logic key_invert_ctl_key0_in_qs;
  logic key_invert_ctl_key0_in_wd;
  logic key_invert_ctl_key0_in_we;
  logic key_invert_ctl_key0_out_qs;
  logic key_invert_ctl_key0_out_wd;
  logic key_invert_ctl_key0_out_we;
  logic key_invert_ctl_key1_in_qs;
  logic key_invert_ctl_key1_in_wd;
  logic key_invert_ctl_key1_in_we;
  logic key_invert_ctl_key1_out_qs;
  logic key_invert_ctl_key1_out_wd;
  logic key_invert_ctl_key1_out_we;
  logic key_invert_ctl_key2_in_qs;
  logic key_invert_ctl_key2_in_wd;
  logic key_invert_ctl_key2_in_we;
  logic key_invert_ctl_key2_out_qs;
  logic key_invert_ctl_key2_out_wd;
  logic key_invert_ctl_key2_out_we;
  logic key_invert_ctl_pwrb_in_qs;
  logic key_invert_ctl_pwrb_in_wd;
  logic key_invert_ctl_pwrb_in_we;
  logic key_invert_ctl_pwrb_out_qs;
  logic key_invert_ctl_pwrb_out_wd;
  logic key_invert_ctl_pwrb_out_we;
  logic key_invert_ctl_ac_present_qs;
  logic key_invert_ctl_ac_present_wd;
  logic key_invert_ctl_ac_present_we;
  logic key_invert_ctl_bat_disable_qs;
  logic key_invert_ctl_bat_disable_wd;
  logic key_invert_ctl_bat_disable_we;
  logic pin_allowed_ctl_bat_disable_0_qs;
  logic pin_allowed_ctl_bat_disable_0_wd;
  logic pin_allowed_ctl_bat_disable_0_we;
  logic pin_allowed_ctl_ec_rst_l_0_qs;
  logic pin_allowed_ctl_ec_rst_l_0_wd;
  logic pin_allowed_ctl_ec_rst_l_0_we;
  logic pin_allowed_ctl_pwrb_out_0_qs;
  logic pin_allowed_ctl_pwrb_out_0_wd;
  logic pin_allowed_ctl_pwrb_out_0_we;
  logic pin_allowed_ctl_key0_out_0_qs;
  logic pin_allowed_ctl_key0_out_0_wd;
  logic pin_allowed_ctl_key0_out_0_we;
  logic pin_allowed_ctl_key1_out_0_qs;
  logic pin_allowed_ctl_key1_out_0_wd;
  logic pin_allowed_ctl_key1_out_0_we;
  logic pin_allowed_ctl_key2_out_0_qs;
  logic pin_allowed_ctl_key2_out_0_wd;
  logic pin_allowed_ctl_key2_out_0_we;
  logic pin_allowed_ctl_bat_disable_1_qs;
  logic pin_allowed_ctl_bat_disable_1_wd;
  logic pin_allowed_ctl_bat_disable_1_we;
  logic pin_allowed_ctl_ec_rst_l_1_qs;
  logic pin_allowed_ctl_ec_rst_l_1_wd;
  logic pin_allowed_ctl_ec_rst_l_1_we;
  logic pin_allowed_ctl_pwrb_out_1_qs;
  logic pin_allowed_ctl_pwrb_out_1_wd;
  logic pin_allowed_ctl_pwrb_out_1_we;
  logic pin_allowed_ctl_key0_out_1_qs;
  logic pin_allowed_ctl_key0_out_1_wd;
  logic pin_allowed_ctl_key0_out_1_we;
  logic pin_allowed_ctl_key1_out_1_qs;
  logic pin_allowed_ctl_key1_out_1_wd;
  logic pin_allowed_ctl_key1_out_1_we;
  logic pin_allowed_ctl_key2_out_1_qs;
  logic pin_allowed_ctl_key2_out_1_wd;
  logic pin_allowed_ctl_key2_out_1_we;
  logic pin_out_ctl_bat_disable_qs;
  logic pin_out_ctl_bat_disable_wd;
  logic pin_out_ctl_bat_disable_we;
  logic pin_out_ctl_ec_rst_l_qs;
  logic pin_out_ctl_ec_rst_l_wd;
  logic pin_out_ctl_ec_rst_l_we;
  logic pin_out_ctl_pwrb_out_qs;
  logic pin_out_ctl_pwrb_out_wd;
  logic pin_out_ctl_pwrb_out_we;
  logic pin_out_ctl_key0_out_qs;
  logic pin_out_ctl_key0_out_wd;
  logic pin_out_ctl_key0_out_we;
  logic pin_out_ctl_key1_out_qs;
  logic pin_out_ctl_key1_out_wd;
  logic pin_out_ctl_key1_out_we;
  logic pin_out_ctl_key2_out_qs;
  logic pin_out_ctl_key2_out_wd;
  logic pin_out_ctl_key2_out_we;
  logic pin_out_value_bat_disable_qs;
  logic pin_out_value_bat_disable_wd;
  logic pin_out_value_bat_disable_we;
  logic pin_out_value_ec_rst_l_qs;
  logic pin_out_value_ec_rst_l_wd;
  logic pin_out_value_ec_rst_l_we;
  logic pin_out_value_pwrb_out_qs;
  logic pin_out_value_pwrb_out_wd;
  logic pin_out_value_pwrb_out_we;
  logic pin_out_value_key0_out_qs;
  logic pin_out_value_key0_out_wd;
  logic pin_out_value_key0_out_we;
  logic pin_out_value_key1_out_qs;
  logic pin_out_value_key1_out_wd;
  logic pin_out_value_key1_out_we;
  logic pin_out_value_key2_out_qs;
  logic pin_out_value_key2_out_wd;
  logic pin_out_value_key2_out_we;
  logic pin_in_value_ac_present_qs;
  logic pin_in_value_ec_rst_l_qs;
  logic pin_in_value_pwrb_in_qs;
  logic pin_in_value_key0_in_qs;
  logic pin_in_value_key1_in_qs;
  logic pin_in_value_key2_in_qs;
  logic key_intr_ctl_pwrb_in_h2l_qs;
  logic key_intr_ctl_pwrb_in_h2l_wd;
  logic key_intr_ctl_pwrb_in_h2l_we;
  logic key_intr_ctl_key0_in_h2l_qs;
  logic key_intr_ctl_key0_in_h2l_wd;
  logic key_intr_ctl_key0_in_h2l_we;
  logic key_intr_ctl_key1_in_h2l_qs;
  logic key_intr_ctl_key1_in_h2l_wd;
  logic key_intr_ctl_key1_in_h2l_we;
  logic key_intr_ctl_key2_in_h2l_qs;
  logic key_intr_ctl_key2_in_h2l_wd;
  logic key_intr_ctl_key2_in_h2l_we;
  logic key_intr_ctl_ac_present_h2l_qs;
  logic key_intr_ctl_ac_present_h2l_wd;
  logic key_intr_ctl_ac_present_h2l_we;
  logic key_intr_ctl_ec_rst_l_h2l_qs;
  logic key_intr_ctl_ec_rst_l_h2l_wd;
  logic key_intr_ctl_ec_rst_l_h2l_we;
  logic key_intr_ctl_pwrb_in_l2h_qs;
  logic key_intr_ctl_pwrb_in_l2h_wd;
  logic key_intr_ctl_pwrb_in_l2h_we;
  logic key_intr_ctl_key0_in_l2h_qs;
  logic key_intr_ctl_key0_in_l2h_wd;
  logic key_intr_ctl_key0_in_l2h_we;
  logic key_intr_ctl_key1_in_l2h_qs;
  logic key_intr_ctl_key1_in_l2h_wd;
  logic key_intr_ctl_key1_in_l2h_we;
  logic key_intr_ctl_key2_in_l2h_qs;
  logic key_intr_ctl_key2_in_l2h_wd;
  logic key_intr_ctl_key2_in_l2h_we;
  logic key_intr_ctl_ac_present_l2h_qs;
  logic key_intr_ctl_ac_present_l2h_wd;
  logic key_intr_ctl_ac_present_l2h_we;
  logic key_intr_ctl_ec_rst_l_l2h_qs;
  logic key_intr_ctl_ec_rst_l_l2h_wd;
  logic key_intr_ctl_ec_rst_l_l2h_we;
  logic [15:0] key_intr_debounce_ctl_qs;
  logic [15:0] key_intr_debounce_ctl_wd;
  logic key_intr_debounce_ctl_we;
  logic [15:0] auto_block_debounce_ctl_debounce_timer_qs;
  logic [15:0] auto_block_debounce_ctl_debounce_timer_wd;
  logic auto_block_debounce_ctl_debounce_timer_we;
  logic auto_block_debounce_ctl_auto_block_enable_qs;
  logic auto_block_debounce_ctl_auto_block_enable_wd;
  logic auto_block_debounce_ctl_auto_block_enable_we;
  logic auto_block_out_ctl_key0_out_sel_qs;
  logic auto_block_out_ctl_key0_out_sel_wd;
  logic auto_block_out_ctl_key0_out_sel_we;
  logic auto_block_out_ctl_key1_out_sel_qs;
  logic auto_block_out_ctl_key1_out_sel_wd;
  logic auto_block_out_ctl_key1_out_sel_we;
  logic auto_block_out_ctl_key2_out_sel_qs;
  logic auto_block_out_ctl_key2_out_sel_wd;
  logic auto_block_out_ctl_key2_out_sel_we;
  logic auto_block_out_ctl_key0_out_value_qs;
  logic auto_block_out_ctl_key0_out_value_wd;
  logic auto_block_out_ctl_key0_out_value_we;
  logic auto_block_out_ctl_key1_out_value_qs;
  logic auto_block_out_ctl_key1_out_value_wd;
  logic auto_block_out_ctl_key1_out_value_we;
  logic auto_block_out_ctl_key2_out_value_qs;
  logic auto_block_out_ctl_key2_out_value_wd;
  logic auto_block_out_ctl_key2_out_value_we;
  logic com_sel_ctl_0_key0_in_sel_0_qs;
  logic com_sel_ctl_0_key0_in_sel_0_wd;
  logic com_sel_ctl_0_key0_in_sel_0_we;
  logic com_sel_ctl_0_key1_in_sel_0_qs;
  logic com_sel_ctl_0_key1_in_sel_0_wd;
  logic com_sel_ctl_0_key1_in_sel_0_we;
  logic com_sel_ctl_0_key2_in_sel_0_qs;
  logic com_sel_ctl_0_key2_in_sel_0_wd;
  logic com_sel_ctl_0_key2_in_sel_0_we;
  logic com_sel_ctl_0_pwrb_in_sel_0_qs;
  logic com_sel_ctl_0_pwrb_in_sel_0_wd;
  logic com_sel_ctl_0_pwrb_in_sel_0_we;
  logic com_sel_ctl_0_ac_present_sel_0_qs;
  logic com_sel_ctl_0_ac_present_sel_0_wd;
  logic com_sel_ctl_0_ac_present_sel_0_we;
  logic com_sel_ctl_1_key0_in_sel_1_qs;
  logic com_sel_ctl_1_key0_in_sel_1_wd;
  logic com_sel_ctl_1_key0_in_sel_1_we;
  logic com_sel_ctl_1_key1_in_sel_1_qs;
  logic com_sel_ctl_1_key1_in_sel_1_wd;
  logic com_sel_ctl_1_key1_in_sel_1_we;
  logic com_sel_ctl_1_key2_in_sel_1_qs;
  logic com_sel_ctl_1_key2_in_sel_1_wd;
  logic com_sel_ctl_1_key2_in_sel_1_we;
  logic com_sel_ctl_1_pwrb_in_sel_1_qs;
  logic com_sel_ctl_1_pwrb_in_sel_1_wd;
  logic com_sel_ctl_1_pwrb_in_sel_1_we;
  logic com_sel_ctl_1_ac_present_sel_1_qs;
  logic com_sel_ctl_1_ac_present_sel_1_wd;
  logic com_sel_ctl_1_ac_present_sel_1_we;
  logic com_sel_ctl_2_key0_in_sel_2_qs;
  logic com_sel_ctl_2_key0_in_sel_2_wd;
  logic com_sel_ctl_2_key0_in_sel_2_we;
  logic com_sel_ctl_2_key1_in_sel_2_qs;
  logic com_sel_ctl_2_key1_in_sel_2_wd;
  logic com_sel_ctl_2_key1_in_sel_2_we;
  logic com_sel_ctl_2_key2_in_sel_2_qs;
  logic com_sel_ctl_2_key2_in_sel_2_wd;
  logic com_sel_ctl_2_key2_in_sel_2_we;
  logic com_sel_ctl_2_pwrb_in_sel_2_qs;
  logic com_sel_ctl_2_pwrb_in_sel_2_wd;
  logic com_sel_ctl_2_pwrb_in_sel_2_we;
  logic com_sel_ctl_2_ac_present_sel_2_qs;
  logic com_sel_ctl_2_ac_present_sel_2_wd;
  logic com_sel_ctl_2_ac_present_sel_2_we;
  logic com_sel_ctl_3_key0_in_sel_3_qs;
  logic com_sel_ctl_3_key0_in_sel_3_wd;
  logic com_sel_ctl_3_key0_in_sel_3_we;
  logic com_sel_ctl_3_key1_in_sel_3_qs;
  logic com_sel_ctl_3_key1_in_sel_3_wd;
  logic com_sel_ctl_3_key1_in_sel_3_we;
  logic com_sel_ctl_3_key2_in_sel_3_qs;
  logic com_sel_ctl_3_key2_in_sel_3_wd;
  logic com_sel_ctl_3_key2_in_sel_3_we;
  logic com_sel_ctl_3_pwrb_in_sel_3_qs;
  logic com_sel_ctl_3_pwrb_in_sel_3_wd;
  logic com_sel_ctl_3_pwrb_in_sel_3_we;
  logic com_sel_ctl_3_ac_present_sel_3_qs;
  logic com_sel_ctl_3_ac_present_sel_3_wd;
  logic com_sel_ctl_3_ac_present_sel_3_we;
  logic [31:0] com_det_ctl_0_qs;
  logic [31:0] com_det_ctl_0_wd;
  logic com_det_ctl_0_we;
  logic [31:0] com_det_ctl_1_qs;
  logic [31:0] com_det_ctl_1_wd;
  logic com_det_ctl_1_we;
  logic [31:0] com_det_ctl_2_qs;
  logic [31:0] com_det_ctl_2_wd;
  logic com_det_ctl_2_we;
  logic [31:0] com_det_ctl_3_qs;
  logic [31:0] com_det_ctl_3_wd;
  logic com_det_ctl_3_we;
  logic com_out_ctl_0_bat_disable_0_qs;
  logic com_out_ctl_0_bat_disable_0_wd;
  logic com_out_ctl_0_bat_disable_0_we;
  logic com_out_ctl_0_interrupt_0_qs;
  logic com_out_ctl_0_interrupt_0_wd;
  logic com_out_ctl_0_interrupt_0_we;
  logic com_out_ctl_0_ec_rst_0_qs;
  logic com_out_ctl_0_ec_rst_0_wd;
  logic com_out_ctl_0_ec_rst_0_we;
  logic com_out_ctl_0_gsc_rst_0_qs;
  logic com_out_ctl_0_gsc_rst_0_wd;
  logic com_out_ctl_0_gsc_rst_0_we;
  logic com_out_ctl_1_bat_disable_1_qs;
  logic com_out_ctl_1_bat_disable_1_wd;
  logic com_out_ctl_1_bat_disable_1_we;
  logic com_out_ctl_1_interrupt_1_qs;
  logic com_out_ctl_1_interrupt_1_wd;
  logic com_out_ctl_1_interrupt_1_we;
  logic com_out_ctl_1_ec_rst_1_qs;
  logic com_out_ctl_1_ec_rst_1_wd;
  logic com_out_ctl_1_ec_rst_1_we;
  logic com_out_ctl_1_gsc_rst_1_qs;
  logic com_out_ctl_1_gsc_rst_1_wd;
  logic com_out_ctl_1_gsc_rst_1_we;
  logic com_out_ctl_2_bat_disable_2_qs;
  logic com_out_ctl_2_bat_disable_2_wd;
  logic com_out_ctl_2_bat_disable_2_we;
  logic com_out_ctl_2_interrupt_2_qs;
  logic com_out_ctl_2_interrupt_2_wd;
  logic com_out_ctl_2_interrupt_2_we;
  logic com_out_ctl_2_ec_rst_2_qs;
  logic com_out_ctl_2_ec_rst_2_wd;
  logic com_out_ctl_2_ec_rst_2_we;
  logic com_out_ctl_2_gsc_rst_2_qs;
  logic com_out_ctl_2_gsc_rst_2_wd;
  logic com_out_ctl_2_gsc_rst_2_we;
  logic com_out_ctl_3_bat_disable_3_qs;
  logic com_out_ctl_3_bat_disable_3_wd;
  logic com_out_ctl_3_bat_disable_3_we;
  logic com_out_ctl_3_interrupt_3_qs;
  logic com_out_ctl_3_interrupt_3_wd;
  logic com_out_ctl_3_interrupt_3_we;
  logic com_out_ctl_3_ec_rst_3_qs;
  logic com_out_ctl_3_ec_rst_3_wd;
  logic com_out_ctl_3_ec_rst_3_we;
  logic com_out_ctl_3_gsc_rst_3_qs;
  logic com_out_ctl_3_gsc_rst_3_wd;
  logic com_out_ctl_3_gsc_rst_3_we;
  logic combo_intr_status_combo0_h2l_qs;
  logic combo_intr_status_combo0_h2l_wd;
  logic combo_intr_status_combo0_h2l_we;
  logic combo_intr_status_combo1_h2l_qs;
  logic combo_intr_status_combo1_h2l_wd;
  logic combo_intr_status_combo1_h2l_we;
  logic combo_intr_status_combo2_h2l_qs;
  logic combo_intr_status_combo2_h2l_wd;
  logic combo_intr_status_combo2_h2l_we;
  logic combo_intr_status_combo3_h2l_qs;
  logic combo_intr_status_combo3_h2l_wd;
  logic combo_intr_status_combo3_h2l_we;
  logic key_intr_status_pwrb_h2l_qs;
  logic key_intr_status_pwrb_h2l_wd;
  logic key_intr_status_pwrb_h2l_we;
  logic key_intr_status_key0_in_h2l_qs;
  logic key_intr_status_key0_in_h2l_wd;
  logic key_intr_status_key0_in_h2l_we;
  logic key_intr_status_key1_in_h2l_qs;
  logic key_intr_status_key1_in_h2l_wd;
  logic key_intr_status_key1_in_h2l_we;
  logic key_intr_status_key2_in_h2l_qs;
  logic key_intr_status_key2_in_h2l_wd;
  logic key_intr_status_key2_in_h2l_we;
  logic key_intr_status_ac_present_h2l_qs;
  logic key_intr_status_ac_present_h2l_wd;
  logic key_intr_status_ac_present_h2l_we;
  logic key_intr_status_ec_rst_l_h2l_qs;
  logic key_intr_status_ec_rst_l_h2l_wd;
  logic key_intr_status_ec_rst_l_h2l_we;
  logic key_intr_status_pwrb_l2h_qs;
  logic key_intr_status_pwrb_l2h_wd;
  logic key_intr_status_pwrb_l2h_we;
  logic key_intr_status_key0_in_l2h_qs;
  logic key_intr_status_key0_in_l2h_wd;
  logic key_intr_status_key0_in_l2h_we;
  logic key_intr_status_key1_in_l2h_qs;
  logic key_intr_status_key1_in_l2h_wd;
  logic key_intr_status_key1_in_l2h_we;
  logic key_intr_status_key2_in_l2h_qs;
  logic key_intr_status_key2_in_l2h_wd;
  logic key_intr_status_key2_in_l2h_we;
  logic key_intr_status_ac_present_l2h_qs;
  logic key_intr_status_ac_present_l2h_wd;
  logic key_intr_status_ac_present_l2h_we;
  logic key_intr_status_ec_rst_l_l2h_qs;
  logic key_intr_status_ec_rst_l_l2h_wd;
  logic key_intr_status_ec_rst_l_l2h_we;

  // Register instances
  // R[intr_state]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_we),
    .wd     (intr_state_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.de),
    .d      (hw2reg.intr_state.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.q ),

    // to register interface (read)
    .qs     (intr_state_qs)
  );


  // R[intr_enable]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_we),
    .wd     (intr_enable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.q ),

    // to register interface (read)
    .qs     (intr_enable_qs)
  );


  // R[intr_test]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test (
    .re     (1'b0),
    .we     (intr_test_we),
    .wd     (intr_test_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.qe),
    .q      (reg2hw.intr_test.q ),
    .qs     ()
  );


  // R[regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (regwen_we),
    .wd     (regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (regwen_qs)
  );


  // R[ec_rst_ctl]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h7d0)
  ) u_ec_rst_ctl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (ec_rst_ctl_we & regwen_qs),
    .wd     (ec_rst_ctl_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.ec_rst_ctl.qe),
    .q      (reg2hw.ec_rst_ctl.q ),

    // to register interface (read)
    .qs     (ec_rst_ctl_qs)
  );


  // R[key_invert_ctl]: V(False)

  //   F[key0_in]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_key0_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_key0_in_we & regwen_qs),
    .wd     (key_invert_ctl_key0_in_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.key0_in.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_key0_in_qs)
  );


  //   F[key0_out]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_key0_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_key0_out_we & regwen_qs),
    .wd     (key_invert_ctl_key0_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.key0_out.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_key0_out_qs)
  );


  //   F[key1_in]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_key1_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_key1_in_we & regwen_qs),
    .wd     (key_invert_ctl_key1_in_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.key1_in.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_key1_in_qs)
  );


  //   F[key1_out]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_key1_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_key1_out_we & regwen_qs),
    .wd     (key_invert_ctl_key1_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.key1_out.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_key1_out_qs)
  );


  //   F[key2_in]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_key2_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_key2_in_we & regwen_qs),
    .wd     (key_invert_ctl_key2_in_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.key2_in.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_key2_in_qs)
  );


  //   F[key2_out]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_key2_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_key2_out_we & regwen_qs),
    .wd     (key_invert_ctl_key2_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.key2_out.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_key2_out_qs)
  );


  //   F[pwrb_in]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_pwrb_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_pwrb_in_we & regwen_qs),
    .wd     (key_invert_ctl_pwrb_in_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.pwrb_in.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_pwrb_in_qs)
  );


  //   F[pwrb_out]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_pwrb_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_pwrb_out_we & regwen_qs),
    .wd     (key_invert_ctl_pwrb_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.pwrb_out.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_pwrb_out_qs)
  );


  //   F[ac_present]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_ac_present (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_ac_present_we & regwen_qs),
    .wd     (key_invert_ctl_ac_present_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.ac_present.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_ac_present_qs)
  );


  //   F[bat_disable]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_invert_ctl_bat_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_invert_ctl_bat_disable_we & regwen_qs),
    .wd     (key_invert_ctl_bat_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_invert_ctl.bat_disable.q ),

    // to register interface (read)
    .qs     (key_invert_ctl_bat_disable_qs)
  );


  // R[pin_allowed_ctl]: V(False)

  //   F[bat_disable_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_bat_disable_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_bat_disable_0_we & regwen_qs),
    .wd     (pin_allowed_ctl_bat_disable_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.bat_disable_0.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_bat_disable_0_qs)
  );


  //   F[ec_rst_l_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_pin_allowed_ctl_ec_rst_l_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_ec_rst_l_0_we & regwen_qs),
    .wd     (pin_allowed_ctl_ec_rst_l_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.ec_rst_l_0.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_ec_rst_l_0_qs)
  );


  //   F[pwrb_out_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_pwrb_out_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_pwrb_out_0_we & regwen_qs),
    .wd     (pin_allowed_ctl_pwrb_out_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.pwrb_out_0.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_pwrb_out_0_qs)
  );


  //   F[key0_out_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_key0_out_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_key0_out_0_we & regwen_qs),
    .wd     (pin_allowed_ctl_key0_out_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.key0_out_0.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_key0_out_0_qs)
  );


  //   F[key1_out_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_key1_out_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_key1_out_0_we & regwen_qs),
    .wd     (pin_allowed_ctl_key1_out_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.key1_out_0.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_key1_out_0_qs)
  );


  //   F[key2_out_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_key2_out_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_key2_out_0_we & regwen_qs),
    .wd     (pin_allowed_ctl_key2_out_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.key2_out_0.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_key2_out_0_qs)
  );


  //   F[bat_disable_1]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_bat_disable_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_bat_disable_1_we & regwen_qs),
    .wd     (pin_allowed_ctl_bat_disable_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.bat_disable_1.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_bat_disable_1_qs)
  );


  //   F[ec_rst_l_1]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_ec_rst_l_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_ec_rst_l_1_we & regwen_qs),
    .wd     (pin_allowed_ctl_ec_rst_l_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.ec_rst_l_1.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_ec_rst_l_1_qs)
  );


  //   F[pwrb_out_1]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_pwrb_out_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_pwrb_out_1_we & regwen_qs),
    .wd     (pin_allowed_ctl_pwrb_out_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.pwrb_out_1.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_pwrb_out_1_qs)
  );


  //   F[key0_out_1]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_key0_out_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_key0_out_1_we & regwen_qs),
    .wd     (pin_allowed_ctl_key0_out_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.key0_out_1.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_key0_out_1_qs)
  );


  //   F[key1_out_1]: 10:10
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_key1_out_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_key1_out_1_we & regwen_qs),
    .wd     (pin_allowed_ctl_key1_out_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.key1_out_1.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_key1_out_1_qs)
  );


  //   F[key2_out_1]: 11:11
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_allowed_ctl_key2_out_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pin_allowed_ctl_key2_out_1_we & regwen_qs),
    .wd     (pin_allowed_ctl_key2_out_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_allowed_ctl.key2_out_1.q ),

    // to register interface (read)
    .qs     (pin_allowed_ctl_key2_out_1_qs)
  );


  // R[pin_out_ctl]: V(False)

  //   F[bat_disable]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_ctl_bat_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_ctl_bat_disable_we),
    .wd     (pin_out_ctl_bat_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_ctl.bat_disable.q ),

    // to register interface (read)
    .qs     (pin_out_ctl_bat_disable_qs)
  );


  //   F[ec_rst_l]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_pin_out_ctl_ec_rst_l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_ctl_ec_rst_l_we),
    .wd     (pin_out_ctl_ec_rst_l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_ctl.ec_rst_l.q ),

    // to register interface (read)
    .qs     (pin_out_ctl_ec_rst_l_qs)
  );


  //   F[pwrb_out]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_ctl_pwrb_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_ctl_pwrb_out_we),
    .wd     (pin_out_ctl_pwrb_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_ctl.pwrb_out.q ),

    // to register interface (read)
    .qs     (pin_out_ctl_pwrb_out_qs)
  );


  //   F[key0_out]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_ctl_key0_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_ctl_key0_out_we),
    .wd     (pin_out_ctl_key0_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_ctl.key0_out.q ),

    // to register interface (read)
    .qs     (pin_out_ctl_key0_out_qs)
  );


  //   F[key1_out]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_ctl_key1_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_ctl_key1_out_we),
    .wd     (pin_out_ctl_key1_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_ctl.key1_out.q ),

    // to register interface (read)
    .qs     (pin_out_ctl_key1_out_qs)
  );


  //   F[key2_out]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_ctl_key2_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_ctl_key2_out_we),
    .wd     (pin_out_ctl_key2_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_ctl.key2_out.q ),

    // to register interface (read)
    .qs     (pin_out_ctl_key2_out_qs)
  );


  // R[pin_out_value]: V(False)

  //   F[bat_disable]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_value_bat_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_value_bat_disable_we),
    .wd     (pin_out_value_bat_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_value.bat_disable.q ),

    // to register interface (read)
    .qs     (pin_out_value_bat_disable_qs)
  );


  //   F[ec_rst_l]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_value_ec_rst_l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_value_ec_rst_l_we),
    .wd     (pin_out_value_ec_rst_l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_value.ec_rst_l.q ),

    // to register interface (read)
    .qs     (pin_out_value_ec_rst_l_qs)
  );


  //   F[pwrb_out]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_value_pwrb_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_value_pwrb_out_we),
    .wd     (pin_out_value_pwrb_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_value.pwrb_out.q ),

    // to register interface (read)
    .qs     (pin_out_value_pwrb_out_qs)
  );


  //   F[key0_out]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_value_key0_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_value_key0_out_we),
    .wd     (pin_out_value_key0_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_value.key0_out.q ),

    // to register interface (read)
    .qs     (pin_out_value_key0_out_qs)
  );


  //   F[key1_out]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_value_key1_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_value_key1_out_we),
    .wd     (pin_out_value_key1_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_value.key1_out.q ),

    // to register interface (read)
    .qs     (pin_out_value_key1_out_qs)
  );


  //   F[key2_out]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_pin_out_value_key2_out (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (pin_out_value_key2_out_we),
    .wd     (pin_out_value_key2_out_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pin_out_value.key2_out.q ),

    // to register interface (read)
    .qs     (pin_out_value_key2_out_qs)
  );


  // R[pin_in_value]: V(False)

  //   F[ac_present]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_pin_in_value_ac_present (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.pin_in_value.ac_present.de),
    .d      (hw2reg.pin_in_value.ac_present.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (pin_in_value_ac_present_qs)
  );


  //   F[ec_rst_l]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_pin_in_value_ec_rst_l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.pin_in_value.ec_rst_l.de),
    .d      (hw2reg.pin_in_value.ec_rst_l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (pin_in_value_ec_rst_l_qs)
  );


  //   F[pwrb_in]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_pin_in_value_pwrb_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.pin_in_value.pwrb_in.de),
    .d      (hw2reg.pin_in_value.pwrb_in.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (pin_in_value_pwrb_in_qs)
  );


  //   F[key0_in]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_pin_in_value_key0_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.pin_in_value.key0_in.de),
    .d      (hw2reg.pin_in_value.key0_in.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (pin_in_value_key0_in_qs)
  );


  //   F[key1_in]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_pin_in_value_key1_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.pin_in_value.key1_in.de),
    .d      (hw2reg.pin_in_value.key1_in.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (pin_in_value_key1_in_qs)
  );


  //   F[key2_in]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_pin_in_value_key2_in (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.pin_in_value.key2_in.de),
    .d      (hw2reg.pin_in_value.key2_in.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (pin_in_value_key2_in_qs)
  );


  // R[key_intr_ctl]: V(False)

  //   F[pwrb_in_h2l]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_pwrb_in_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_pwrb_in_h2l_we & regwen_qs),
    .wd     (key_intr_ctl_pwrb_in_h2l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.pwrb_in_h2l.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_pwrb_in_h2l_qs)
  );


  //   F[key0_in_h2l]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_key0_in_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_key0_in_h2l_we & regwen_qs),
    .wd     (key_intr_ctl_key0_in_h2l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.key0_in_h2l.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_key0_in_h2l_qs)
  );


  //   F[key1_in_h2l]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_key1_in_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_key1_in_h2l_we & regwen_qs),
    .wd     (key_intr_ctl_key1_in_h2l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.key1_in_h2l.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_key1_in_h2l_qs)
  );


  //   F[key2_in_h2l]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_key2_in_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_key2_in_h2l_we & regwen_qs),
    .wd     (key_intr_ctl_key2_in_h2l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.key2_in_h2l.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_key2_in_h2l_qs)
  );


  //   F[ac_present_h2l]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_ac_present_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_ac_present_h2l_we & regwen_qs),
    .wd     (key_intr_ctl_ac_present_h2l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.ac_present_h2l.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_ac_present_h2l_qs)
  );


  //   F[ec_rst_l_h2l]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_ec_rst_l_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_ec_rst_l_h2l_we & regwen_qs),
    .wd     (key_intr_ctl_ec_rst_l_h2l_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.ec_rst_l_h2l.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_ec_rst_l_h2l_qs)
  );


  //   F[pwrb_in_l2h]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_pwrb_in_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_pwrb_in_l2h_we & regwen_qs),
    .wd     (key_intr_ctl_pwrb_in_l2h_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.pwrb_in_l2h.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_pwrb_in_l2h_qs)
  );


  //   F[key0_in_l2h]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_key0_in_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_key0_in_l2h_we & regwen_qs),
    .wd     (key_intr_ctl_key0_in_l2h_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.key0_in_l2h.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_key0_in_l2h_qs)
  );


  //   F[key1_in_l2h]: 10:10
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_key1_in_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_key1_in_l2h_we & regwen_qs),
    .wd     (key_intr_ctl_key1_in_l2h_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.key1_in_l2h.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_key1_in_l2h_qs)
  );


  //   F[key2_in_l2h]: 11:11
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_key2_in_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_key2_in_l2h_we & regwen_qs),
    .wd     (key_intr_ctl_key2_in_l2h_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.key2_in_l2h.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_key2_in_l2h_qs)
  );


  //   F[ac_present_l2h]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_ac_present_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_ac_present_l2h_we & regwen_qs),
    .wd     (key_intr_ctl_ac_present_l2h_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.ac_present_l2h.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_ac_present_l2h_qs)
  );


  //   F[ec_rst_l_l2h]: 13:13
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_key_intr_ctl_ec_rst_l_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_ctl_ec_rst_l_l2h_we & regwen_qs),
    .wd     (key_intr_ctl_ec_rst_l_l2h_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_intr_ctl.ec_rst_l_l2h.q ),

    // to register interface (read)
    .qs     (key_intr_ctl_ec_rst_l_l2h_qs)
  );


  // R[key_intr_debounce_ctl]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_key_intr_debounce_ctl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_intr_debounce_ctl_we & regwen_qs),
    .wd     (key_intr_debounce_ctl_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.key_intr_debounce_ctl.qe),
    .q      (reg2hw.key_intr_debounce_ctl.q ),

    // to register interface (read)
    .qs     (key_intr_debounce_ctl_qs)
  );


  // R[auto_block_debounce_ctl]: V(False)

  //   F[debounce_timer]: 15:0
  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_auto_block_debounce_ctl_debounce_timer (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_debounce_ctl_debounce_timer_we & regwen_qs),
    .wd     (auto_block_debounce_ctl_debounce_timer_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.auto_block_debounce_ctl.debounce_timer.qe),
    .q      (reg2hw.auto_block_debounce_ctl.debounce_timer.q ),

    // to register interface (read)
    .qs     (auto_block_debounce_ctl_debounce_timer_qs)
  );


  //   F[auto_block_enable]: 16:16
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_auto_block_debounce_ctl_auto_block_enable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_debounce_ctl_auto_block_enable_we & regwen_qs),
    .wd     (auto_block_debounce_ctl_auto_block_enable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.auto_block_debounce_ctl.auto_block_enable.qe),
    .q      (reg2hw.auto_block_debounce_ctl.auto_block_enable.q ),

    // to register interface (read)
    .qs     (auto_block_debounce_ctl_auto_block_enable_qs)
  );


  // R[auto_block_out_ctl]: V(False)

  //   F[key0_out_sel]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_auto_block_out_ctl_key0_out_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_out_ctl_key0_out_sel_we & regwen_qs),
    .wd     (auto_block_out_ctl_key0_out_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.auto_block_out_ctl.key0_out_sel.q ),

    // to register interface (read)
    .qs     (auto_block_out_ctl_key0_out_sel_qs)
  );


  //   F[key1_out_sel]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_auto_block_out_ctl_key1_out_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_out_ctl_key1_out_sel_we & regwen_qs),
    .wd     (auto_block_out_ctl_key1_out_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.auto_block_out_ctl.key1_out_sel.q ),

    // to register interface (read)
    .qs     (auto_block_out_ctl_key1_out_sel_qs)
  );


  //   F[key2_out_sel]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_auto_block_out_ctl_key2_out_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_out_ctl_key2_out_sel_we & regwen_qs),
    .wd     (auto_block_out_ctl_key2_out_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.auto_block_out_ctl.key2_out_sel.q ),

    // to register interface (read)
    .qs     (auto_block_out_ctl_key2_out_sel_qs)
  );


  //   F[key0_out_value]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_auto_block_out_ctl_key0_out_value (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_out_ctl_key0_out_value_we & regwen_qs),
    .wd     (auto_block_out_ctl_key0_out_value_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.auto_block_out_ctl.key0_out_value.q ),

    // to register interface (read)
    .qs     (auto_block_out_ctl_key0_out_value_qs)
  );


  //   F[key1_out_value]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_auto_block_out_ctl_key1_out_value (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_out_ctl_key1_out_value_we & regwen_qs),
    .wd     (auto_block_out_ctl_key1_out_value_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.auto_block_out_ctl.key1_out_value.q ),

    // to register interface (read)
    .qs     (auto_block_out_ctl_key1_out_value_qs)
  );


  //   F[key2_out_value]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_auto_block_out_ctl_key2_out_value (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (auto_block_out_ctl_key2_out_value_we & regwen_qs),
    .wd     (auto_block_out_ctl_key2_out_value_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.auto_block_out_ctl.key2_out_value.q ),

    // to register interface (read)
    .qs     (auto_block_out_ctl_key2_out_value_qs)
  );



  // Subregister 0 of Multireg com_sel_ctl
  // R[com_sel_ctl_0]: V(False)

  // F[key0_in_sel_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_0_key0_in_sel_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_0_key0_in_sel_0_we & regwen_qs),
    .wd     (com_sel_ctl_0_key0_in_sel_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[0].key0_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_0_key0_in_sel_0_qs)
  );


  // F[key1_in_sel_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_0_key1_in_sel_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_0_key1_in_sel_0_we & regwen_qs),
    .wd     (com_sel_ctl_0_key1_in_sel_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[0].key1_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_0_key1_in_sel_0_qs)
  );


  // F[key2_in_sel_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_0_key2_in_sel_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_0_key2_in_sel_0_we & regwen_qs),
    .wd     (com_sel_ctl_0_key2_in_sel_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[0].key2_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_0_key2_in_sel_0_qs)
  );


  // F[pwrb_in_sel_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_0_pwrb_in_sel_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_0_pwrb_in_sel_0_we & regwen_qs),
    .wd     (com_sel_ctl_0_pwrb_in_sel_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[0].pwrb_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_0_pwrb_in_sel_0_qs)
  );


  // F[ac_present_sel_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_0_ac_present_sel_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_0_ac_present_sel_0_we & regwen_qs),
    .wd     (com_sel_ctl_0_ac_present_sel_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[0].ac_present_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_0_ac_present_sel_0_qs)
  );


  // Subregister 1 of Multireg com_sel_ctl
  // R[com_sel_ctl_1]: V(False)

  // F[key0_in_sel_1]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_1_key0_in_sel_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_1_key0_in_sel_1_we & regwen_qs),
    .wd     (com_sel_ctl_1_key0_in_sel_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[1].key0_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_1_key0_in_sel_1_qs)
  );


  // F[key1_in_sel_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_1_key1_in_sel_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_1_key1_in_sel_1_we & regwen_qs),
    .wd     (com_sel_ctl_1_key1_in_sel_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[1].key1_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_1_key1_in_sel_1_qs)
  );


  // F[key2_in_sel_1]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_1_key2_in_sel_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_1_key2_in_sel_1_we & regwen_qs),
    .wd     (com_sel_ctl_1_key2_in_sel_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[1].key2_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_1_key2_in_sel_1_qs)
  );


  // F[pwrb_in_sel_1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_1_pwrb_in_sel_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_1_pwrb_in_sel_1_we & regwen_qs),
    .wd     (com_sel_ctl_1_pwrb_in_sel_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[1].pwrb_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_1_pwrb_in_sel_1_qs)
  );


  // F[ac_present_sel_1]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_1_ac_present_sel_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_1_ac_present_sel_1_we & regwen_qs),
    .wd     (com_sel_ctl_1_ac_present_sel_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[1].ac_present_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_1_ac_present_sel_1_qs)
  );


  // Subregister 2 of Multireg com_sel_ctl
  // R[com_sel_ctl_2]: V(False)

  // F[key0_in_sel_2]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_2_key0_in_sel_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_2_key0_in_sel_2_we & regwen_qs),
    .wd     (com_sel_ctl_2_key0_in_sel_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[2].key0_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_2_key0_in_sel_2_qs)
  );


  // F[key1_in_sel_2]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_2_key1_in_sel_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_2_key1_in_sel_2_we & regwen_qs),
    .wd     (com_sel_ctl_2_key1_in_sel_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[2].key1_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_2_key1_in_sel_2_qs)
  );


  // F[key2_in_sel_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_2_key2_in_sel_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_2_key2_in_sel_2_we & regwen_qs),
    .wd     (com_sel_ctl_2_key2_in_sel_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[2].key2_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_2_key2_in_sel_2_qs)
  );


  // F[pwrb_in_sel_2]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_2_pwrb_in_sel_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_2_pwrb_in_sel_2_we & regwen_qs),
    .wd     (com_sel_ctl_2_pwrb_in_sel_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[2].pwrb_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_2_pwrb_in_sel_2_qs)
  );


  // F[ac_present_sel_2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_2_ac_present_sel_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_2_ac_present_sel_2_we & regwen_qs),
    .wd     (com_sel_ctl_2_ac_present_sel_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[2].ac_present_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_2_ac_present_sel_2_qs)
  );


  // Subregister 3 of Multireg com_sel_ctl
  // R[com_sel_ctl_3]: V(False)

  // F[key0_in_sel_3]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_3_key0_in_sel_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_3_key0_in_sel_3_we & regwen_qs),
    .wd     (com_sel_ctl_3_key0_in_sel_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[3].key0_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_3_key0_in_sel_3_qs)
  );


  // F[key1_in_sel_3]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_3_key1_in_sel_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_3_key1_in_sel_3_we & regwen_qs),
    .wd     (com_sel_ctl_3_key1_in_sel_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[3].key1_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_3_key1_in_sel_3_qs)
  );


  // F[key2_in_sel_3]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_3_key2_in_sel_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_3_key2_in_sel_3_we & regwen_qs),
    .wd     (com_sel_ctl_3_key2_in_sel_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[3].key2_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_3_key2_in_sel_3_qs)
  );


  // F[pwrb_in_sel_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_3_pwrb_in_sel_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_3_pwrb_in_sel_3_we & regwen_qs),
    .wd     (com_sel_ctl_3_pwrb_in_sel_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[3].pwrb_in_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_3_pwrb_in_sel_3_qs)
  );


  // F[ac_present_sel_3]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_sel_ctl_3_ac_present_sel_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_sel_ctl_3_ac_present_sel_3_we & regwen_qs),
    .wd     (com_sel_ctl_3_ac_present_sel_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_sel_ctl[3].ac_present_sel.q ),

    // to register interface (read)
    .qs     (com_sel_ctl_3_ac_present_sel_3_qs)
  );




  // Subregister 0 of Multireg com_det_ctl
  // R[com_det_ctl_0]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_com_det_ctl_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_det_ctl_0_we & regwen_qs),
    .wd     (com_det_ctl_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.com_det_ctl[0].qe),
    .q      (reg2hw.com_det_ctl[0].q ),

    // to register interface (read)
    .qs     (com_det_ctl_0_qs)
  );

  // Subregister 1 of Multireg com_det_ctl
  // R[com_det_ctl_1]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_com_det_ctl_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_det_ctl_1_we & regwen_qs),
    .wd     (com_det_ctl_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.com_det_ctl[1].qe),
    .q      (reg2hw.com_det_ctl[1].q ),

    // to register interface (read)
    .qs     (com_det_ctl_1_qs)
  );

  // Subregister 2 of Multireg com_det_ctl
  // R[com_det_ctl_2]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_com_det_ctl_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_det_ctl_2_we & regwen_qs),
    .wd     (com_det_ctl_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.com_det_ctl[2].qe),
    .q      (reg2hw.com_det_ctl[2].q ),

    // to register interface (read)
    .qs     (com_det_ctl_2_qs)
  );

  // Subregister 3 of Multireg com_det_ctl
  // R[com_det_ctl_3]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_com_det_ctl_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_det_ctl_3_we & regwen_qs),
    .wd     (com_det_ctl_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.com_det_ctl[3].qe),
    .q      (reg2hw.com_det_ctl[3].q ),

    // to register interface (read)
    .qs     (com_det_ctl_3_qs)
  );



  // Subregister 0 of Multireg com_out_ctl
  // R[com_out_ctl_0]: V(False)

  // F[bat_disable_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_0_bat_disable_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_0_bat_disable_0_we & regwen_qs),
    .wd     (com_out_ctl_0_bat_disable_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[0].bat_disable.q ),

    // to register interface (read)
    .qs     (com_out_ctl_0_bat_disable_0_qs)
  );


  // F[interrupt_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_0_interrupt_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_0_interrupt_0_we & regwen_qs),
    .wd     (com_out_ctl_0_interrupt_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[0].interrupt.q ),

    // to register interface (read)
    .qs     (com_out_ctl_0_interrupt_0_qs)
  );


  // F[ec_rst_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_0_ec_rst_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_0_ec_rst_0_we & regwen_qs),
    .wd     (com_out_ctl_0_ec_rst_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[0].ec_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_0_ec_rst_0_qs)
  );


  // F[gsc_rst_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_0_gsc_rst_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_0_gsc_rst_0_we & regwen_qs),
    .wd     (com_out_ctl_0_gsc_rst_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[0].gsc_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_0_gsc_rst_0_qs)
  );


  // Subregister 1 of Multireg com_out_ctl
  // R[com_out_ctl_1]: V(False)

  // F[bat_disable_1]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_1_bat_disable_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_1_bat_disable_1_we & regwen_qs),
    .wd     (com_out_ctl_1_bat_disable_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[1].bat_disable.q ),

    // to register interface (read)
    .qs     (com_out_ctl_1_bat_disable_1_qs)
  );


  // F[interrupt_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_1_interrupt_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_1_interrupt_1_we & regwen_qs),
    .wd     (com_out_ctl_1_interrupt_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[1].interrupt.q ),

    // to register interface (read)
    .qs     (com_out_ctl_1_interrupt_1_qs)
  );


  // F[ec_rst_1]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_1_ec_rst_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_1_ec_rst_1_we & regwen_qs),
    .wd     (com_out_ctl_1_ec_rst_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[1].ec_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_1_ec_rst_1_qs)
  );


  // F[gsc_rst_1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_1_gsc_rst_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_1_gsc_rst_1_we & regwen_qs),
    .wd     (com_out_ctl_1_gsc_rst_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[1].gsc_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_1_gsc_rst_1_qs)
  );


  // Subregister 2 of Multireg com_out_ctl
  // R[com_out_ctl_2]: V(False)

  // F[bat_disable_2]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_2_bat_disable_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_2_bat_disable_2_we & regwen_qs),
    .wd     (com_out_ctl_2_bat_disable_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[2].bat_disable.q ),

    // to register interface (read)
    .qs     (com_out_ctl_2_bat_disable_2_qs)
  );


  // F[interrupt_2]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_2_interrupt_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_2_interrupt_2_we & regwen_qs),
    .wd     (com_out_ctl_2_interrupt_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[2].interrupt.q ),

    // to register interface (read)
    .qs     (com_out_ctl_2_interrupt_2_qs)
  );


  // F[ec_rst_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_2_ec_rst_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_2_ec_rst_2_we & regwen_qs),
    .wd     (com_out_ctl_2_ec_rst_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[2].ec_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_2_ec_rst_2_qs)
  );


  // F[gsc_rst_2]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_2_gsc_rst_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_2_gsc_rst_2_we & regwen_qs),
    .wd     (com_out_ctl_2_gsc_rst_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[2].gsc_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_2_gsc_rst_2_qs)
  );


  // Subregister 3 of Multireg com_out_ctl
  // R[com_out_ctl_3]: V(False)

  // F[bat_disable_3]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_3_bat_disable_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_3_bat_disable_3_we & regwen_qs),
    .wd     (com_out_ctl_3_bat_disable_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[3].bat_disable.q ),

    // to register interface (read)
    .qs     (com_out_ctl_3_bat_disable_3_qs)
  );


  // F[interrupt_3]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_3_interrupt_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_3_interrupt_3_we & regwen_qs),
    .wd     (com_out_ctl_3_interrupt_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[3].interrupt.q ),

    // to register interface (read)
    .qs     (com_out_ctl_3_interrupt_3_qs)
  );


  // F[ec_rst_3]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_3_ec_rst_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_3_ec_rst_3_we & regwen_qs),
    .wd     (com_out_ctl_3_ec_rst_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[3].ec_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_3_ec_rst_3_qs)
  );


  // F[gsc_rst_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_com_out_ctl_3_gsc_rst_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (com_out_ctl_3_gsc_rst_3_we & regwen_qs),
    .wd     (com_out_ctl_3_gsc_rst_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.com_out_ctl[3].gsc_rst.q ),

    // to register interface (read)
    .qs     (com_out_ctl_3_gsc_rst_3_qs)
  );



  // R[combo_intr_status]: V(False)

  //   F[combo0_h2l]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_combo_intr_status_combo0_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (combo_intr_status_combo0_h2l_we),
    .wd     (combo_intr_status_combo0_h2l_wd),

    // from internal hardware
    .de     (hw2reg.combo_intr_status.combo0_h2l.de),
    .d      (hw2reg.combo_intr_status.combo0_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (combo_intr_status_combo0_h2l_qs)
  );


  //   F[combo1_h2l]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_combo_intr_status_combo1_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (combo_intr_status_combo1_h2l_we),
    .wd     (combo_intr_status_combo1_h2l_wd),

    // from internal hardware
    .de     (hw2reg.combo_intr_status.combo1_h2l.de),
    .d      (hw2reg.combo_intr_status.combo1_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (combo_intr_status_combo1_h2l_qs)
  );


  //   F[combo2_h2l]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_combo_intr_status_combo2_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (combo_intr_status_combo2_h2l_we),
    .wd     (combo_intr_status_combo2_h2l_wd),

    // from internal hardware
    .de     (hw2reg.combo_intr_status.combo2_h2l.de),
    .d      (hw2reg.combo_intr_status.combo2_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (combo_intr_status_combo2_h2l_qs)
  );


  //   F[combo3_h2l]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_combo_intr_status_combo3_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (combo_intr_status_combo3_h2l_we),
    .wd     (combo_intr_status_combo3_h2l_wd),

    // from internal hardware
    .de     (hw2reg.combo_intr_status.combo3_h2l.de),
    .d      (hw2reg.combo_intr_status.combo3_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (combo_intr_status_combo3_h2l_qs)
  );


  // R[key_intr_status]: V(False)

  //   F[pwrb_h2l]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_pwrb_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_pwrb_h2l_we),
    .wd     (key_intr_status_pwrb_h2l_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.pwrb_h2l.de),
    .d      (hw2reg.key_intr_status.pwrb_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_pwrb_h2l_qs)
  );


  //   F[key0_in_h2l]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_key0_in_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_key0_in_h2l_we),
    .wd     (key_intr_status_key0_in_h2l_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.key0_in_h2l.de),
    .d      (hw2reg.key_intr_status.key0_in_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_key0_in_h2l_qs)
  );


  //   F[key1_in_h2l]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_key1_in_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_key1_in_h2l_we),
    .wd     (key_intr_status_key1_in_h2l_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.key1_in_h2l.de),
    .d      (hw2reg.key_intr_status.key1_in_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_key1_in_h2l_qs)
  );


  //   F[key2_in_h2l]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_key2_in_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_key2_in_h2l_we),
    .wd     (key_intr_status_key2_in_h2l_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.key2_in_h2l.de),
    .d      (hw2reg.key_intr_status.key2_in_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_key2_in_h2l_qs)
  );


  //   F[ac_present_h2l]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_ac_present_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_ac_present_h2l_we),
    .wd     (key_intr_status_ac_present_h2l_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.ac_present_h2l.de),
    .d      (hw2reg.key_intr_status.ac_present_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_ac_present_h2l_qs)
  );


  //   F[ec_rst_l_h2l]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_ec_rst_l_h2l (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_ec_rst_l_h2l_we),
    .wd     (key_intr_status_ec_rst_l_h2l_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.ec_rst_l_h2l.de),
    .d      (hw2reg.key_intr_status.ec_rst_l_h2l.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_ec_rst_l_h2l_qs)
  );


  //   F[pwrb_l2h]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_pwrb_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_pwrb_l2h_we),
    .wd     (key_intr_status_pwrb_l2h_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.pwrb_l2h.de),
    .d      (hw2reg.key_intr_status.pwrb_l2h.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_pwrb_l2h_qs)
  );


  //   F[key0_in_l2h]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_key0_in_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_key0_in_l2h_we),
    .wd     (key_intr_status_key0_in_l2h_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.key0_in_l2h.de),
    .d      (hw2reg.key_intr_status.key0_in_l2h.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_key0_in_l2h_qs)
  );


  //   F[key1_in_l2h]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_key1_in_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_key1_in_l2h_we),
    .wd     (key_intr_status_key1_in_l2h_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.key1_in_l2h.de),
    .d      (hw2reg.key_intr_status.key1_in_l2h.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_key1_in_l2h_qs)
  );


  //   F[key2_in_l2h]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_key2_in_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_key2_in_l2h_we),
    .wd     (key_intr_status_key2_in_l2h_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.key2_in_l2h.de),
    .d      (hw2reg.key_intr_status.key2_in_l2h.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_key2_in_l2h_qs)
  );


  //   F[ac_present_l2h]: 10:10
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_ac_present_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_ac_present_l2h_we),
    .wd     (key_intr_status_ac_present_l2h_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.ac_present_l2h.de),
    .d      (hw2reg.key_intr_status.ac_present_l2h.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_ac_present_l2h_qs)
  );


  //   F[ec_rst_l_l2h]: 11:11
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_key_intr_status_ec_rst_l_l2h (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (key_intr_status_ec_rst_l_l2h_we),
    .wd     (key_intr_status_ec_rst_l_l2h_wd),

    // from internal hardware
    .de     (hw2reg.key_intr_status.ec_rst_l_l2h.de),
    .d      (hw2reg.key_intr_status.ec_rst_l_l2h.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (key_intr_status_ec_rst_l_l2h_qs)
  );




  logic [27:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == SYSRST_CTRL_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == SYSRST_CTRL_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == SYSRST_CTRL_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == SYSRST_CTRL_REGWEN_OFFSET);
    addr_hit[ 4] = (reg_addr == SYSRST_CTRL_EC_RST_CTL_OFFSET);
    addr_hit[ 5] = (reg_addr == SYSRST_CTRL_KEY_INVERT_CTL_OFFSET);
    addr_hit[ 6] = (reg_addr == SYSRST_CTRL_PIN_ALLOWED_CTL_OFFSET);
    addr_hit[ 7] = (reg_addr == SYSRST_CTRL_PIN_OUT_CTL_OFFSET);
    addr_hit[ 8] = (reg_addr == SYSRST_CTRL_PIN_OUT_VALUE_OFFSET);
    addr_hit[ 9] = (reg_addr == SYSRST_CTRL_PIN_IN_VALUE_OFFSET);
    addr_hit[10] = (reg_addr == SYSRST_CTRL_KEY_INTR_CTL_OFFSET);
    addr_hit[11] = (reg_addr == SYSRST_CTRL_KEY_INTR_DEBOUNCE_CTL_OFFSET);
    addr_hit[12] = (reg_addr == SYSRST_CTRL_AUTO_BLOCK_DEBOUNCE_CTL_OFFSET);
    addr_hit[13] = (reg_addr == SYSRST_CTRL_AUTO_BLOCK_OUT_CTL_OFFSET);
    addr_hit[14] = (reg_addr == SYSRST_CTRL_COM_SEL_CTL_0_OFFSET);
    addr_hit[15] = (reg_addr == SYSRST_CTRL_COM_SEL_CTL_1_OFFSET);
    addr_hit[16] = (reg_addr == SYSRST_CTRL_COM_SEL_CTL_2_OFFSET);
    addr_hit[17] = (reg_addr == SYSRST_CTRL_COM_SEL_CTL_3_OFFSET);
    addr_hit[18] = (reg_addr == SYSRST_CTRL_COM_DET_CTL_0_OFFSET);
    addr_hit[19] = (reg_addr == SYSRST_CTRL_COM_DET_CTL_1_OFFSET);
    addr_hit[20] = (reg_addr == SYSRST_CTRL_COM_DET_CTL_2_OFFSET);
    addr_hit[21] = (reg_addr == SYSRST_CTRL_COM_DET_CTL_3_OFFSET);
    addr_hit[22] = (reg_addr == SYSRST_CTRL_COM_OUT_CTL_0_OFFSET);
    addr_hit[23] = (reg_addr == SYSRST_CTRL_COM_OUT_CTL_1_OFFSET);
    addr_hit[24] = (reg_addr == SYSRST_CTRL_COM_OUT_CTL_2_OFFSET);
    addr_hit[25] = (reg_addr == SYSRST_CTRL_COM_OUT_CTL_3_OFFSET);
    addr_hit[26] = (reg_addr == SYSRST_CTRL_COMBO_INTR_STATUS_OFFSET);
    addr_hit[27] = (reg_addr == SYSRST_CTRL_KEY_INTR_STATUS_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (SYSRST_CTRL_PERMIT[ 0] != (SYSRST_CTRL_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (SYSRST_CTRL_PERMIT[ 1] != (SYSRST_CTRL_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (SYSRST_CTRL_PERMIT[ 2] != (SYSRST_CTRL_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (SYSRST_CTRL_PERMIT[ 3] != (SYSRST_CTRL_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (SYSRST_CTRL_PERMIT[ 4] != (SYSRST_CTRL_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (SYSRST_CTRL_PERMIT[ 5] != (SYSRST_CTRL_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (SYSRST_CTRL_PERMIT[ 6] != (SYSRST_CTRL_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (SYSRST_CTRL_PERMIT[ 7] != (SYSRST_CTRL_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (SYSRST_CTRL_PERMIT[ 8] != (SYSRST_CTRL_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (SYSRST_CTRL_PERMIT[ 9] != (SYSRST_CTRL_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (SYSRST_CTRL_PERMIT[10] != (SYSRST_CTRL_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (SYSRST_CTRL_PERMIT[11] != (SYSRST_CTRL_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (SYSRST_CTRL_PERMIT[12] != (SYSRST_CTRL_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (SYSRST_CTRL_PERMIT[13] != (SYSRST_CTRL_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (SYSRST_CTRL_PERMIT[14] != (SYSRST_CTRL_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (SYSRST_CTRL_PERMIT[15] != (SYSRST_CTRL_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (SYSRST_CTRL_PERMIT[16] != (SYSRST_CTRL_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (SYSRST_CTRL_PERMIT[17] != (SYSRST_CTRL_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (SYSRST_CTRL_PERMIT[18] != (SYSRST_CTRL_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (SYSRST_CTRL_PERMIT[19] != (SYSRST_CTRL_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (SYSRST_CTRL_PERMIT[20] != (SYSRST_CTRL_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (SYSRST_CTRL_PERMIT[21] != (SYSRST_CTRL_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (SYSRST_CTRL_PERMIT[22] != (SYSRST_CTRL_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (SYSRST_CTRL_PERMIT[23] != (SYSRST_CTRL_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (SYSRST_CTRL_PERMIT[24] != (SYSRST_CTRL_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (SYSRST_CTRL_PERMIT[25] != (SYSRST_CTRL_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (SYSRST_CTRL_PERMIT[26] != (SYSRST_CTRL_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (SYSRST_CTRL_PERMIT[27] != (SYSRST_CTRL_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_wd = reg_wdata[0];

  assign intr_enable_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_wd = reg_wdata[0];

  assign intr_test_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_wd = reg_wdata[0];

  assign regwen_we = addr_hit[3] & reg_we & !reg_error;
  assign regwen_wd = reg_wdata[0];

  assign ec_rst_ctl_we = addr_hit[4] & reg_we & !reg_error;
  assign ec_rst_ctl_wd = reg_wdata[15:0];

  assign key_invert_ctl_key0_in_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_key0_in_wd = reg_wdata[0];

  assign key_invert_ctl_key0_out_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_key0_out_wd = reg_wdata[1];

  assign key_invert_ctl_key1_in_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_key1_in_wd = reg_wdata[2];

  assign key_invert_ctl_key1_out_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_key1_out_wd = reg_wdata[3];

  assign key_invert_ctl_key2_in_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_key2_in_wd = reg_wdata[4];

  assign key_invert_ctl_key2_out_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_key2_out_wd = reg_wdata[5];

  assign key_invert_ctl_pwrb_in_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_pwrb_in_wd = reg_wdata[6];

  assign key_invert_ctl_pwrb_out_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_pwrb_out_wd = reg_wdata[7];

  assign key_invert_ctl_ac_present_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_ac_present_wd = reg_wdata[8];

  assign key_invert_ctl_bat_disable_we = addr_hit[5] & reg_we & !reg_error;
  assign key_invert_ctl_bat_disable_wd = reg_wdata[9];

  assign pin_allowed_ctl_bat_disable_0_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_bat_disable_0_wd = reg_wdata[0];

  assign pin_allowed_ctl_ec_rst_l_0_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_ec_rst_l_0_wd = reg_wdata[1];

  assign pin_allowed_ctl_pwrb_out_0_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_pwrb_out_0_wd = reg_wdata[2];

  assign pin_allowed_ctl_key0_out_0_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_key0_out_0_wd = reg_wdata[3];

  assign pin_allowed_ctl_key1_out_0_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_key1_out_0_wd = reg_wdata[4];

  assign pin_allowed_ctl_key2_out_0_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_key2_out_0_wd = reg_wdata[5];

  assign pin_allowed_ctl_bat_disable_1_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_bat_disable_1_wd = reg_wdata[6];

  assign pin_allowed_ctl_ec_rst_l_1_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_ec_rst_l_1_wd = reg_wdata[7];

  assign pin_allowed_ctl_pwrb_out_1_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_pwrb_out_1_wd = reg_wdata[8];

  assign pin_allowed_ctl_key0_out_1_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_key0_out_1_wd = reg_wdata[9];

  assign pin_allowed_ctl_key1_out_1_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_key1_out_1_wd = reg_wdata[10];

  assign pin_allowed_ctl_key2_out_1_we = addr_hit[6] & reg_we & !reg_error;
  assign pin_allowed_ctl_key2_out_1_wd = reg_wdata[11];

  assign pin_out_ctl_bat_disable_we = addr_hit[7] & reg_we & !reg_error;
  assign pin_out_ctl_bat_disable_wd = reg_wdata[0];

  assign pin_out_ctl_ec_rst_l_we = addr_hit[7] & reg_we & !reg_error;
  assign pin_out_ctl_ec_rst_l_wd = reg_wdata[1];

  assign pin_out_ctl_pwrb_out_we = addr_hit[7] & reg_we & !reg_error;
  assign pin_out_ctl_pwrb_out_wd = reg_wdata[2];

  assign pin_out_ctl_key0_out_we = addr_hit[7] & reg_we & !reg_error;
  assign pin_out_ctl_key0_out_wd = reg_wdata[3];

  assign pin_out_ctl_key1_out_we = addr_hit[7] & reg_we & !reg_error;
  assign pin_out_ctl_key1_out_wd = reg_wdata[4];

  assign pin_out_ctl_key2_out_we = addr_hit[7] & reg_we & !reg_error;
  assign pin_out_ctl_key2_out_wd = reg_wdata[5];

  assign pin_out_value_bat_disable_we = addr_hit[8] & reg_we & !reg_error;
  assign pin_out_value_bat_disable_wd = reg_wdata[0];

  assign pin_out_value_ec_rst_l_we = addr_hit[8] & reg_we & !reg_error;
  assign pin_out_value_ec_rst_l_wd = reg_wdata[1];

  assign pin_out_value_pwrb_out_we = addr_hit[8] & reg_we & !reg_error;
  assign pin_out_value_pwrb_out_wd = reg_wdata[2];

  assign pin_out_value_key0_out_we = addr_hit[8] & reg_we & !reg_error;
  assign pin_out_value_key0_out_wd = reg_wdata[3];

  assign pin_out_value_key1_out_we = addr_hit[8] & reg_we & !reg_error;
  assign pin_out_value_key1_out_wd = reg_wdata[4];

  assign pin_out_value_key2_out_we = addr_hit[8] & reg_we & !reg_error;
  assign pin_out_value_key2_out_wd = reg_wdata[5];

  assign key_intr_ctl_pwrb_in_h2l_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_pwrb_in_h2l_wd = reg_wdata[0];

  assign key_intr_ctl_key0_in_h2l_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_key0_in_h2l_wd = reg_wdata[1];

  assign key_intr_ctl_key1_in_h2l_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_key1_in_h2l_wd = reg_wdata[2];

  assign key_intr_ctl_key2_in_h2l_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_key2_in_h2l_wd = reg_wdata[3];

  assign key_intr_ctl_ac_present_h2l_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_ac_present_h2l_wd = reg_wdata[4];

  assign key_intr_ctl_ec_rst_l_h2l_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_ec_rst_l_h2l_wd = reg_wdata[5];

  assign key_intr_ctl_pwrb_in_l2h_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_pwrb_in_l2h_wd = reg_wdata[8];

  assign key_intr_ctl_key0_in_l2h_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_key0_in_l2h_wd = reg_wdata[9];

  assign key_intr_ctl_key1_in_l2h_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_key1_in_l2h_wd = reg_wdata[10];

  assign key_intr_ctl_key2_in_l2h_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_key2_in_l2h_wd = reg_wdata[11];

  assign key_intr_ctl_ac_present_l2h_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_ac_present_l2h_wd = reg_wdata[12];

  assign key_intr_ctl_ec_rst_l_l2h_we = addr_hit[10] & reg_we & !reg_error;
  assign key_intr_ctl_ec_rst_l_l2h_wd = reg_wdata[13];

  assign key_intr_debounce_ctl_we = addr_hit[11] & reg_we & !reg_error;
  assign key_intr_debounce_ctl_wd = reg_wdata[15:0];

  assign auto_block_debounce_ctl_debounce_timer_we = addr_hit[12] & reg_we & !reg_error;
  assign auto_block_debounce_ctl_debounce_timer_wd = reg_wdata[15:0];

  assign auto_block_debounce_ctl_auto_block_enable_we = addr_hit[12] & reg_we & !reg_error;
  assign auto_block_debounce_ctl_auto_block_enable_wd = reg_wdata[16];

  assign auto_block_out_ctl_key0_out_sel_we = addr_hit[13] & reg_we & !reg_error;
  assign auto_block_out_ctl_key0_out_sel_wd = reg_wdata[0];

  assign auto_block_out_ctl_key1_out_sel_we = addr_hit[13] & reg_we & !reg_error;
  assign auto_block_out_ctl_key1_out_sel_wd = reg_wdata[1];

  assign auto_block_out_ctl_key2_out_sel_we = addr_hit[13] & reg_we & !reg_error;
  assign auto_block_out_ctl_key2_out_sel_wd = reg_wdata[2];

  assign auto_block_out_ctl_key0_out_value_we = addr_hit[13] & reg_we & !reg_error;
  assign auto_block_out_ctl_key0_out_value_wd = reg_wdata[4];

  assign auto_block_out_ctl_key1_out_value_we = addr_hit[13] & reg_we & !reg_error;
  assign auto_block_out_ctl_key1_out_value_wd = reg_wdata[5];

  assign auto_block_out_ctl_key2_out_value_we = addr_hit[13] & reg_we & !reg_error;
  assign auto_block_out_ctl_key2_out_value_wd = reg_wdata[6];

  assign com_sel_ctl_0_key0_in_sel_0_we = addr_hit[14] & reg_we & !reg_error;
  assign com_sel_ctl_0_key0_in_sel_0_wd = reg_wdata[0];

  assign com_sel_ctl_0_key1_in_sel_0_we = addr_hit[14] & reg_we & !reg_error;
  assign com_sel_ctl_0_key1_in_sel_0_wd = reg_wdata[1];

  assign com_sel_ctl_0_key2_in_sel_0_we = addr_hit[14] & reg_we & !reg_error;
  assign com_sel_ctl_0_key2_in_sel_0_wd = reg_wdata[2];

  assign com_sel_ctl_0_pwrb_in_sel_0_we = addr_hit[14] & reg_we & !reg_error;
  assign com_sel_ctl_0_pwrb_in_sel_0_wd = reg_wdata[3];

  assign com_sel_ctl_0_ac_present_sel_0_we = addr_hit[14] & reg_we & !reg_error;
  assign com_sel_ctl_0_ac_present_sel_0_wd = reg_wdata[4];

  assign com_sel_ctl_1_key0_in_sel_1_we = addr_hit[15] & reg_we & !reg_error;
  assign com_sel_ctl_1_key0_in_sel_1_wd = reg_wdata[0];

  assign com_sel_ctl_1_key1_in_sel_1_we = addr_hit[15] & reg_we & !reg_error;
  assign com_sel_ctl_1_key1_in_sel_1_wd = reg_wdata[1];

  assign com_sel_ctl_1_key2_in_sel_1_we = addr_hit[15] & reg_we & !reg_error;
  assign com_sel_ctl_1_key2_in_sel_1_wd = reg_wdata[2];

  assign com_sel_ctl_1_pwrb_in_sel_1_we = addr_hit[15] & reg_we & !reg_error;
  assign com_sel_ctl_1_pwrb_in_sel_1_wd = reg_wdata[3];

  assign com_sel_ctl_1_ac_present_sel_1_we = addr_hit[15] & reg_we & !reg_error;
  assign com_sel_ctl_1_ac_present_sel_1_wd = reg_wdata[4];

  assign com_sel_ctl_2_key0_in_sel_2_we = addr_hit[16] & reg_we & !reg_error;
  assign com_sel_ctl_2_key0_in_sel_2_wd = reg_wdata[0];

  assign com_sel_ctl_2_key1_in_sel_2_we = addr_hit[16] & reg_we & !reg_error;
  assign com_sel_ctl_2_key1_in_sel_2_wd = reg_wdata[1];

  assign com_sel_ctl_2_key2_in_sel_2_we = addr_hit[16] & reg_we & !reg_error;
  assign com_sel_ctl_2_key2_in_sel_2_wd = reg_wdata[2];

  assign com_sel_ctl_2_pwrb_in_sel_2_we = addr_hit[16] & reg_we & !reg_error;
  assign com_sel_ctl_2_pwrb_in_sel_2_wd = reg_wdata[3];

  assign com_sel_ctl_2_ac_present_sel_2_we = addr_hit[16] & reg_we & !reg_error;
  assign com_sel_ctl_2_ac_present_sel_2_wd = reg_wdata[4];

  assign com_sel_ctl_3_key0_in_sel_3_we = addr_hit[17] & reg_we & !reg_error;
  assign com_sel_ctl_3_key0_in_sel_3_wd = reg_wdata[0];

  assign com_sel_ctl_3_key1_in_sel_3_we = addr_hit[17] & reg_we & !reg_error;
  assign com_sel_ctl_3_key1_in_sel_3_wd = reg_wdata[1];

  assign com_sel_ctl_3_key2_in_sel_3_we = addr_hit[17] & reg_we & !reg_error;
  assign com_sel_ctl_3_key2_in_sel_3_wd = reg_wdata[2];

  assign com_sel_ctl_3_pwrb_in_sel_3_we = addr_hit[17] & reg_we & !reg_error;
  assign com_sel_ctl_3_pwrb_in_sel_3_wd = reg_wdata[3];

  assign com_sel_ctl_3_ac_present_sel_3_we = addr_hit[17] & reg_we & !reg_error;
  assign com_sel_ctl_3_ac_present_sel_3_wd = reg_wdata[4];

  assign com_det_ctl_0_we = addr_hit[18] & reg_we & !reg_error;
  assign com_det_ctl_0_wd = reg_wdata[31:0];

  assign com_det_ctl_1_we = addr_hit[19] & reg_we & !reg_error;
  assign com_det_ctl_1_wd = reg_wdata[31:0];

  assign com_det_ctl_2_we = addr_hit[20] & reg_we & !reg_error;
  assign com_det_ctl_2_wd = reg_wdata[31:0];

  assign com_det_ctl_3_we = addr_hit[21] & reg_we & !reg_error;
  assign com_det_ctl_3_wd = reg_wdata[31:0];

  assign com_out_ctl_0_bat_disable_0_we = addr_hit[22] & reg_we & !reg_error;
  assign com_out_ctl_0_bat_disable_0_wd = reg_wdata[0];

  assign com_out_ctl_0_interrupt_0_we = addr_hit[22] & reg_we & !reg_error;
  assign com_out_ctl_0_interrupt_0_wd = reg_wdata[1];

  assign com_out_ctl_0_ec_rst_0_we = addr_hit[22] & reg_we & !reg_error;
  assign com_out_ctl_0_ec_rst_0_wd = reg_wdata[2];

  assign com_out_ctl_0_gsc_rst_0_we = addr_hit[22] & reg_we & !reg_error;
  assign com_out_ctl_0_gsc_rst_0_wd = reg_wdata[3];

  assign com_out_ctl_1_bat_disable_1_we = addr_hit[23] & reg_we & !reg_error;
  assign com_out_ctl_1_bat_disable_1_wd = reg_wdata[0];

  assign com_out_ctl_1_interrupt_1_we = addr_hit[23] & reg_we & !reg_error;
  assign com_out_ctl_1_interrupt_1_wd = reg_wdata[1];

  assign com_out_ctl_1_ec_rst_1_we = addr_hit[23] & reg_we & !reg_error;
  assign com_out_ctl_1_ec_rst_1_wd = reg_wdata[2];

  assign com_out_ctl_1_gsc_rst_1_we = addr_hit[23] & reg_we & !reg_error;
  assign com_out_ctl_1_gsc_rst_1_wd = reg_wdata[3];

  assign com_out_ctl_2_bat_disable_2_we = addr_hit[24] & reg_we & !reg_error;
  assign com_out_ctl_2_bat_disable_2_wd = reg_wdata[0];

  assign com_out_ctl_2_interrupt_2_we = addr_hit[24] & reg_we & !reg_error;
  assign com_out_ctl_2_interrupt_2_wd = reg_wdata[1];

  assign com_out_ctl_2_ec_rst_2_we = addr_hit[24] & reg_we & !reg_error;
  assign com_out_ctl_2_ec_rst_2_wd = reg_wdata[2];

  assign com_out_ctl_2_gsc_rst_2_we = addr_hit[24] & reg_we & !reg_error;
  assign com_out_ctl_2_gsc_rst_2_wd = reg_wdata[3];

  assign com_out_ctl_3_bat_disable_3_we = addr_hit[25] & reg_we & !reg_error;
  assign com_out_ctl_3_bat_disable_3_wd = reg_wdata[0];

  assign com_out_ctl_3_interrupt_3_we = addr_hit[25] & reg_we & !reg_error;
  assign com_out_ctl_3_interrupt_3_wd = reg_wdata[1];

  assign com_out_ctl_3_ec_rst_3_we = addr_hit[25] & reg_we & !reg_error;
  assign com_out_ctl_3_ec_rst_3_wd = reg_wdata[2];

  assign com_out_ctl_3_gsc_rst_3_we = addr_hit[25] & reg_we & !reg_error;
  assign com_out_ctl_3_gsc_rst_3_wd = reg_wdata[3];

  assign combo_intr_status_combo0_h2l_we = addr_hit[26] & reg_we & !reg_error;
  assign combo_intr_status_combo0_h2l_wd = reg_wdata[0];

  assign combo_intr_status_combo1_h2l_we = addr_hit[26] & reg_we & !reg_error;
  assign combo_intr_status_combo1_h2l_wd = reg_wdata[1];

  assign combo_intr_status_combo2_h2l_we = addr_hit[26] & reg_we & !reg_error;
  assign combo_intr_status_combo2_h2l_wd = reg_wdata[2];

  assign combo_intr_status_combo3_h2l_we = addr_hit[26] & reg_we & !reg_error;
  assign combo_intr_status_combo3_h2l_wd = reg_wdata[3];

  assign key_intr_status_pwrb_h2l_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_pwrb_h2l_wd = reg_wdata[0];

  assign key_intr_status_key0_in_h2l_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_key0_in_h2l_wd = reg_wdata[1];

  assign key_intr_status_key1_in_h2l_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_key1_in_h2l_wd = reg_wdata[2];

  assign key_intr_status_key2_in_h2l_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_key2_in_h2l_wd = reg_wdata[3];

  assign key_intr_status_ac_present_h2l_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_ac_present_h2l_wd = reg_wdata[4];

  assign key_intr_status_ec_rst_l_h2l_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_ec_rst_l_h2l_wd = reg_wdata[5];

  assign key_intr_status_pwrb_l2h_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_pwrb_l2h_wd = reg_wdata[6];

  assign key_intr_status_key0_in_l2h_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_key0_in_l2h_wd = reg_wdata[7];

  assign key_intr_status_key1_in_l2h_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_key1_in_l2h_wd = reg_wdata[8];

  assign key_intr_status_key2_in_l2h_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_key2_in_l2h_wd = reg_wdata[9];

  assign key_intr_status_ac_present_l2h_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_ac_present_l2h_wd = reg_wdata[10];

  assign key_intr_status_ec_rst_l_l2h_we = addr_hit[27] & reg_we & !reg_error;
  assign key_intr_status_ec_rst_l_l2h_wd = reg_wdata[11];

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = regwen_qs;
      end

      addr_hit[4]: begin
        reg_rdata_next[15:0] = ec_rst_ctl_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[0] = key_invert_ctl_key0_in_qs;
        reg_rdata_next[1] = key_invert_ctl_key0_out_qs;
        reg_rdata_next[2] = key_invert_ctl_key1_in_qs;
        reg_rdata_next[3] = key_invert_ctl_key1_out_qs;
        reg_rdata_next[4] = key_invert_ctl_key2_in_qs;
        reg_rdata_next[5] = key_invert_ctl_key2_out_qs;
        reg_rdata_next[6] = key_invert_ctl_pwrb_in_qs;
        reg_rdata_next[7] = key_invert_ctl_pwrb_out_qs;
        reg_rdata_next[8] = key_invert_ctl_ac_present_qs;
        reg_rdata_next[9] = key_invert_ctl_bat_disable_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[0] = pin_allowed_ctl_bat_disable_0_qs;
        reg_rdata_next[1] = pin_allowed_ctl_ec_rst_l_0_qs;
        reg_rdata_next[2] = pin_allowed_ctl_pwrb_out_0_qs;
        reg_rdata_next[3] = pin_allowed_ctl_key0_out_0_qs;
        reg_rdata_next[4] = pin_allowed_ctl_key1_out_0_qs;
        reg_rdata_next[5] = pin_allowed_ctl_key2_out_0_qs;
        reg_rdata_next[6] = pin_allowed_ctl_bat_disable_1_qs;
        reg_rdata_next[7] = pin_allowed_ctl_ec_rst_l_1_qs;
        reg_rdata_next[8] = pin_allowed_ctl_pwrb_out_1_qs;
        reg_rdata_next[9] = pin_allowed_ctl_key0_out_1_qs;
        reg_rdata_next[10] = pin_allowed_ctl_key1_out_1_qs;
        reg_rdata_next[11] = pin_allowed_ctl_key2_out_1_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[0] = pin_out_ctl_bat_disable_qs;
        reg_rdata_next[1] = pin_out_ctl_ec_rst_l_qs;
        reg_rdata_next[2] = pin_out_ctl_pwrb_out_qs;
        reg_rdata_next[3] = pin_out_ctl_key0_out_qs;
        reg_rdata_next[4] = pin_out_ctl_key1_out_qs;
        reg_rdata_next[5] = pin_out_ctl_key2_out_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[0] = pin_out_value_bat_disable_qs;
        reg_rdata_next[1] = pin_out_value_ec_rst_l_qs;
        reg_rdata_next[2] = pin_out_value_pwrb_out_qs;
        reg_rdata_next[3] = pin_out_value_key0_out_qs;
        reg_rdata_next[4] = pin_out_value_key1_out_qs;
        reg_rdata_next[5] = pin_out_value_key2_out_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[0] = pin_in_value_ac_present_qs;
        reg_rdata_next[1] = pin_in_value_ec_rst_l_qs;
        reg_rdata_next[2] = pin_in_value_pwrb_in_qs;
        reg_rdata_next[3] = pin_in_value_key0_in_qs;
        reg_rdata_next[4] = pin_in_value_key1_in_qs;
        reg_rdata_next[5] = pin_in_value_key2_in_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[0] = key_intr_ctl_pwrb_in_h2l_qs;
        reg_rdata_next[1] = key_intr_ctl_key0_in_h2l_qs;
        reg_rdata_next[2] = key_intr_ctl_key1_in_h2l_qs;
        reg_rdata_next[3] = key_intr_ctl_key2_in_h2l_qs;
        reg_rdata_next[4] = key_intr_ctl_ac_present_h2l_qs;
        reg_rdata_next[5] = key_intr_ctl_ec_rst_l_h2l_qs;
        reg_rdata_next[8] = key_intr_ctl_pwrb_in_l2h_qs;
        reg_rdata_next[9] = key_intr_ctl_key0_in_l2h_qs;
        reg_rdata_next[10] = key_intr_ctl_key1_in_l2h_qs;
        reg_rdata_next[11] = key_intr_ctl_key2_in_l2h_qs;
        reg_rdata_next[12] = key_intr_ctl_ac_present_l2h_qs;
        reg_rdata_next[13] = key_intr_ctl_ec_rst_l_l2h_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[15:0] = key_intr_debounce_ctl_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[15:0] = auto_block_debounce_ctl_debounce_timer_qs;
        reg_rdata_next[16] = auto_block_debounce_ctl_auto_block_enable_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[0] = auto_block_out_ctl_key0_out_sel_qs;
        reg_rdata_next[1] = auto_block_out_ctl_key1_out_sel_qs;
        reg_rdata_next[2] = auto_block_out_ctl_key2_out_sel_qs;
        reg_rdata_next[4] = auto_block_out_ctl_key0_out_value_qs;
        reg_rdata_next[5] = auto_block_out_ctl_key1_out_value_qs;
        reg_rdata_next[6] = auto_block_out_ctl_key2_out_value_qs;
      end

      addr_hit[14]: begin
        reg_rdata_next[0] = com_sel_ctl_0_key0_in_sel_0_qs;
        reg_rdata_next[1] = com_sel_ctl_0_key1_in_sel_0_qs;
        reg_rdata_next[2] = com_sel_ctl_0_key2_in_sel_0_qs;
        reg_rdata_next[3] = com_sel_ctl_0_pwrb_in_sel_0_qs;
        reg_rdata_next[4] = com_sel_ctl_0_ac_present_sel_0_qs;
      end

      addr_hit[15]: begin
        reg_rdata_next[0] = com_sel_ctl_1_key0_in_sel_1_qs;
        reg_rdata_next[1] = com_sel_ctl_1_key1_in_sel_1_qs;
        reg_rdata_next[2] = com_sel_ctl_1_key2_in_sel_1_qs;
        reg_rdata_next[3] = com_sel_ctl_1_pwrb_in_sel_1_qs;
        reg_rdata_next[4] = com_sel_ctl_1_ac_present_sel_1_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[0] = com_sel_ctl_2_key0_in_sel_2_qs;
        reg_rdata_next[1] = com_sel_ctl_2_key1_in_sel_2_qs;
        reg_rdata_next[2] = com_sel_ctl_2_key2_in_sel_2_qs;
        reg_rdata_next[3] = com_sel_ctl_2_pwrb_in_sel_2_qs;
        reg_rdata_next[4] = com_sel_ctl_2_ac_present_sel_2_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[0] = com_sel_ctl_3_key0_in_sel_3_qs;
        reg_rdata_next[1] = com_sel_ctl_3_key1_in_sel_3_qs;
        reg_rdata_next[2] = com_sel_ctl_3_key2_in_sel_3_qs;
        reg_rdata_next[3] = com_sel_ctl_3_pwrb_in_sel_3_qs;
        reg_rdata_next[4] = com_sel_ctl_3_ac_present_sel_3_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[31:0] = com_det_ctl_0_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[31:0] = com_det_ctl_1_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[31:0] = com_det_ctl_2_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[31:0] = com_det_ctl_3_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[0] = com_out_ctl_0_bat_disable_0_qs;
        reg_rdata_next[1] = com_out_ctl_0_interrupt_0_qs;
        reg_rdata_next[2] = com_out_ctl_0_ec_rst_0_qs;
        reg_rdata_next[3] = com_out_ctl_0_gsc_rst_0_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[0] = com_out_ctl_1_bat_disable_1_qs;
        reg_rdata_next[1] = com_out_ctl_1_interrupt_1_qs;
        reg_rdata_next[2] = com_out_ctl_1_ec_rst_1_qs;
        reg_rdata_next[3] = com_out_ctl_1_gsc_rst_1_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[0] = com_out_ctl_2_bat_disable_2_qs;
        reg_rdata_next[1] = com_out_ctl_2_interrupt_2_qs;
        reg_rdata_next[2] = com_out_ctl_2_ec_rst_2_qs;
        reg_rdata_next[3] = com_out_ctl_2_gsc_rst_2_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[0] = com_out_ctl_3_bat_disable_3_qs;
        reg_rdata_next[1] = com_out_ctl_3_interrupt_3_qs;
        reg_rdata_next[2] = com_out_ctl_3_ec_rst_3_qs;
        reg_rdata_next[3] = com_out_ctl_3_gsc_rst_3_qs;
      end

      addr_hit[26]: begin
        reg_rdata_next[0] = combo_intr_status_combo0_h2l_qs;
        reg_rdata_next[1] = combo_intr_status_combo1_h2l_qs;
        reg_rdata_next[2] = combo_intr_status_combo2_h2l_qs;
        reg_rdata_next[3] = combo_intr_status_combo3_h2l_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[0] = key_intr_status_pwrb_h2l_qs;
        reg_rdata_next[1] = key_intr_status_key0_in_h2l_qs;
        reg_rdata_next[2] = key_intr_status_key1_in_h2l_qs;
        reg_rdata_next[3] = key_intr_status_key2_in_h2l_qs;
        reg_rdata_next[4] = key_intr_status_ac_present_h2l_qs;
        reg_rdata_next[5] = key_intr_status_ec_rst_l_h2l_qs;
        reg_rdata_next[6] = key_intr_status_pwrb_l2h_qs;
        reg_rdata_next[7] = key_intr_status_key0_in_l2h_qs;
        reg_rdata_next[8] = key_intr_status_key1_in_l2h_qs;
        reg_rdata_next[9] = key_intr_status_key2_in_l2h_qs;
        reg_rdata_next[10] = key_intr_status_ac_present_l2h_qs;
        reg_rdata_next[11] = key_intr_status_ec_rst_l_l2h_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
