// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// SECDED Encoder generated by
// util/design/secded_gen.py -m 6 -k 16 -s 1592631616 -c hamming

module prim_secded_hamming_22_16_enc (
  input        [15:0] in,
  output logic [21:0] out
);

  always_comb begin : p_encode
    out = 22'(in);
    out[16] = ^(out & 22'h00AD5B);
    out[17] = ^(out & 22'h00366D);
    out[18] = ^(out & 22'h00C78E);
    out[19] = ^(out & 22'h0007F0);
    out[20] = ^(out & 22'h00F800);
    out[21] = ^(out & 22'h1FFFFF);
  end

endmodule : prim_secded_hamming_22_16_enc
