// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// SECDED FPV testbench generated by util/design/secded_gen.py

module prim_secded_64_57_fpv (
  input               clk_i,
  input               rst_ni,
  input        [56:0] in,
  output logic [56:0] d_o,
  output logic [6:0] syndrome_o,
  output logic [1:0]  err_o,
  input        [63:0] error_inject_i
);

  logic [63:0] data_enc;

  prim_secded_64_57_enc prim_secded_64_57_enc (
    .in,
    .out(data_enc)
  );

  prim_secded_64_57_dec prim_secded_64_57_dec (
    .in(data_enc ^ error_inject_i),
    .d_o,
    .syndrome_o,
    .err_o
  );

endmodule : prim_secded_64_57_fpv
