// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module otp_ctrl_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,

  // Output port for window
  output tlul_pkg::tl_h2d_t tl_win_o  [2],
  input  tlul_pkg::tl_d2h_t tl_win_i  [2],

  // To HW
  output otp_ctrl_reg_pkg::otp_ctrl_reg2hw_t reg2hw, // Write
  input  otp_ctrl_reg_pkg::otp_ctrl_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import otp_ctrl_reg_pkg::* ;

  localparam int AW = 14;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  tlul_pkg::tl_h2d_t tl_socket_h2d [3];
  tlul_pkg::tl_d2h_t tl_socket_d2h [3];

  logic [1:0] reg_steer;

  // socket_1n connection
  assign tl_reg_h2d = tl_socket_h2d[2];
  assign tl_socket_d2h[2] = tl_reg_d2h;

  assign tl_win_o[0] = tl_socket_h2d[0];
  assign tl_socket_d2h[0] = tl_win_i[0];
  assign tl_win_o[1] = tl_socket_h2d[1];
  assign tl_socket_d2h[1] = tl_win_i[1];

  // Create Socket_1n
  tlul_socket_1n #(
    .N          (3),
    .HReqPass   (1'b1),
    .HRspPass   (1'b1),
    .DReqPass   ({3{1'b1}}),
    .DRspPass   ({3{1'b1}}),
    .HReqDepth  (4'h0),
    .HRspDepth  (4'h0),
    .DReqDepth  ({3{4'h0}}),
    .DRspDepth  ({3{4'h0}})
  ) u_socket (
    .clk_i,
    .rst_ni,
    .tl_h_i (tl_i),
    .tl_h_o (tl_o_pre),
    .tl_d_o (tl_socket_h2d),
    .tl_d_i (tl_socket_d2h),
    .dev_select_i (reg_steer)
  );

  // Create steering logic
  always_comb begin
    reg_steer = 2;       // Default set to register

    // TODO: Can below codes be unique case () inside ?
    if (tl_i.a_address[AW-1:0] >= 4096 && tl_i.a_address[AW-1:0] < 6144) begin
      reg_steer = 0;
    end
    if (tl_i.a_address[AW-1:0] >= 8192 && tl_i.a_address[AW-1:0] < 8256) begin
      reg_steer = 1;
    end
    if (intg_err) begin
      reg_steer = 2;
    end
  end

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_otp_operation_done_qs;
  logic intr_state_otp_operation_done_wd;
  logic intr_state_otp_operation_done_we;
  logic intr_state_otp_error_qs;
  logic intr_state_otp_error_wd;
  logic intr_state_otp_error_we;
  logic intr_enable_otp_operation_done_qs;
  logic intr_enable_otp_operation_done_wd;
  logic intr_enable_otp_operation_done_we;
  logic intr_enable_otp_error_qs;
  logic intr_enable_otp_error_wd;
  logic intr_enable_otp_error_we;
  logic intr_test_otp_operation_done_wd;
  logic intr_test_otp_operation_done_we;
  logic intr_test_otp_error_wd;
  logic intr_test_otp_error_we;
  logic alert_test_fatal_macro_error_wd;
  logic alert_test_fatal_macro_error_we;
  logic alert_test_fatal_check_error_wd;
  logic alert_test_fatal_check_error_we;
  logic status_creator_sw_cfg_error_qs;
  logic status_creator_sw_cfg_error_re;
  logic status_owner_sw_cfg_error_qs;
  logic status_owner_sw_cfg_error_re;
  logic status_hw_cfg_error_qs;
  logic status_hw_cfg_error_re;
  logic status_secret0_error_qs;
  logic status_secret0_error_re;
  logic status_secret1_error_qs;
  logic status_secret1_error_re;
  logic status_secret2_error_qs;
  logic status_secret2_error_re;
  logic status_life_cycle_error_qs;
  logic status_life_cycle_error_re;
  logic status_dai_error_qs;
  logic status_dai_error_re;
  logic status_lci_error_qs;
  logic status_lci_error_re;
  logic status_timeout_error_qs;
  logic status_timeout_error_re;
  logic status_lfsr_fsm_error_qs;
  logic status_lfsr_fsm_error_re;
  logic status_scrambling_fsm_error_qs;
  logic status_scrambling_fsm_error_re;
  logic status_key_deriv_fsm_error_qs;
  logic status_key_deriv_fsm_error_re;
  logic status_dai_idle_qs;
  logic status_dai_idle_re;
  logic status_check_pending_qs;
  logic status_check_pending_re;
  logic [2:0] err_code_err_code_0_qs;
  logic err_code_err_code_0_re;
  logic [2:0] err_code_err_code_1_qs;
  logic err_code_err_code_1_re;
  logic [2:0] err_code_err_code_2_qs;
  logic err_code_err_code_2_re;
  logic [2:0] err_code_err_code_3_qs;
  logic err_code_err_code_3_re;
  logic [2:0] err_code_err_code_4_qs;
  logic err_code_err_code_4_re;
  logic [2:0] err_code_err_code_5_qs;
  logic err_code_err_code_5_re;
  logic [2:0] err_code_err_code_6_qs;
  logic err_code_err_code_6_re;
  logic [2:0] err_code_err_code_7_qs;
  logic err_code_err_code_7_re;
  logic [2:0] err_code_err_code_8_qs;
  logic err_code_err_code_8_re;
  logic direct_access_regwen_qs;
  logic direct_access_regwen_re;
  logic direct_access_cmd_rd_wd;
  logic direct_access_cmd_rd_we;
  logic direct_access_cmd_wr_wd;
  logic direct_access_cmd_wr_we;
  logic direct_access_cmd_digest_wd;
  logic direct_access_cmd_digest_we;
  logic [10:0] direct_access_address_qs;
  logic [10:0] direct_access_address_wd;
  logic direct_access_address_we;
  logic [31:0] direct_access_wdata_0_qs;
  logic [31:0] direct_access_wdata_0_wd;
  logic direct_access_wdata_0_we;
  logic [31:0] direct_access_wdata_1_qs;
  logic [31:0] direct_access_wdata_1_wd;
  logic direct_access_wdata_1_we;
  logic [31:0] direct_access_rdata_0_qs;
  logic direct_access_rdata_0_re;
  logic [31:0] direct_access_rdata_1_qs;
  logic direct_access_rdata_1_re;
  logic check_trigger_regwen_qs;
  logic check_trigger_regwen_wd;
  logic check_trigger_regwen_we;
  logic check_trigger_integrity_wd;
  logic check_trigger_integrity_we;
  logic check_trigger_consistency_wd;
  logic check_trigger_consistency_we;
  logic check_regwen_qs;
  logic check_regwen_wd;
  logic check_regwen_we;
  logic [31:0] check_timeout_qs;
  logic [31:0] check_timeout_wd;
  logic check_timeout_we;
  logic [31:0] integrity_check_period_qs;
  logic [31:0] integrity_check_period_wd;
  logic integrity_check_period_we;
  logic [31:0] consistency_check_period_qs;
  logic [31:0] consistency_check_period_wd;
  logic consistency_check_period_we;
  logic creator_sw_cfg_read_lock_qs;
  logic creator_sw_cfg_read_lock_wd;
  logic creator_sw_cfg_read_lock_we;
  logic owner_sw_cfg_read_lock_qs;
  logic owner_sw_cfg_read_lock_wd;
  logic owner_sw_cfg_read_lock_we;
  logic [31:0] creator_sw_cfg_digest_0_qs;
  logic creator_sw_cfg_digest_0_re;
  logic [31:0] creator_sw_cfg_digest_1_qs;
  logic creator_sw_cfg_digest_1_re;
  logic [31:0] owner_sw_cfg_digest_0_qs;
  logic owner_sw_cfg_digest_0_re;
  logic [31:0] owner_sw_cfg_digest_1_qs;
  logic owner_sw_cfg_digest_1_re;
  logic [31:0] hw_cfg_digest_0_qs;
  logic hw_cfg_digest_0_re;
  logic [31:0] hw_cfg_digest_1_qs;
  logic hw_cfg_digest_1_re;
  logic [31:0] secret0_digest_0_qs;
  logic secret0_digest_0_re;
  logic [31:0] secret0_digest_1_qs;
  logic secret0_digest_1_re;
  logic [31:0] secret1_digest_0_qs;
  logic secret1_digest_0_re;
  logic [31:0] secret1_digest_1_qs;
  logic secret1_digest_1_re;
  logic [31:0] secret2_digest_0_qs;
  logic secret2_digest_0_re;
  logic [31:0] secret2_digest_1_qs;
  logic secret2_digest_1_re;

  // Register instances
  // R[intr_state]: V(False)

  //   F[otp_operation_done]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_otp_operation_done (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_otp_operation_done_we),
    .wd     (intr_state_otp_operation_done_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.otp_operation_done.de),
    .d      (hw2reg.intr_state.otp_operation_done.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.otp_operation_done.q ),

    // to register interface (read)
    .qs     (intr_state_otp_operation_done_qs)
  );


  //   F[otp_error]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_otp_error (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_otp_error_we),
    .wd     (intr_state_otp_error_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.otp_error.de),
    .d      (hw2reg.intr_state.otp_error.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.otp_error.q ),

    // to register interface (read)
    .qs     (intr_state_otp_error_qs)
  );


  // R[intr_enable]: V(False)

  //   F[otp_operation_done]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_otp_operation_done (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_otp_operation_done_we),
    .wd     (intr_enable_otp_operation_done_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.otp_operation_done.q ),

    // to register interface (read)
    .qs     (intr_enable_otp_operation_done_qs)
  );


  //   F[otp_error]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_otp_error (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_otp_error_we),
    .wd     (intr_enable_otp_error_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.otp_error.q ),

    // to register interface (read)
    .qs     (intr_enable_otp_error_qs)
  );


  // R[intr_test]: V(True)

  //   F[otp_operation_done]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_otp_operation_done (
    .re     (1'b0),
    .we     (intr_test_otp_operation_done_we),
    .wd     (intr_test_otp_operation_done_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.otp_operation_done.qe),
    .q      (reg2hw.intr_test.otp_operation_done.q ),
    .qs     ()
  );


  //   F[otp_error]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_otp_error (
    .re     (1'b0),
    .we     (intr_test_otp_error_we),
    .wd     (intr_test_otp_error_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.otp_error.qe),
    .q      (reg2hw.intr_test.otp_error.q ),
    .qs     ()
  );


  // R[alert_test]: V(True)

  //   F[fatal_macro_error]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_fatal_macro_error (
    .re     (1'b0),
    .we     (alert_test_fatal_macro_error_we),
    .wd     (alert_test_fatal_macro_error_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.fatal_macro_error.qe),
    .q      (reg2hw.alert_test.fatal_macro_error.q ),
    .qs     ()
  );


  //   F[fatal_check_error]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_fatal_check_error (
    .re     (1'b0),
    .we     (alert_test_fatal_check_error_we),
    .wd     (alert_test_fatal_check_error_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.fatal_check_error.qe),
    .q      (reg2hw.alert_test.fatal_check_error.q ),
    .qs     ()
  );


  // R[status]: V(True)

  //   F[creator_sw_cfg_error]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_creator_sw_cfg_error (
    .re     (status_creator_sw_cfg_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.creator_sw_cfg_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_creator_sw_cfg_error_qs)
  );


  //   F[owner_sw_cfg_error]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_owner_sw_cfg_error (
    .re     (status_owner_sw_cfg_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.owner_sw_cfg_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_owner_sw_cfg_error_qs)
  );


  //   F[hw_cfg_error]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_hw_cfg_error (
    .re     (status_hw_cfg_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.hw_cfg_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_hw_cfg_error_qs)
  );


  //   F[secret0_error]: 3:3
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_secret0_error (
    .re     (status_secret0_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.secret0_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_secret0_error_qs)
  );


  //   F[secret1_error]: 4:4
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_secret1_error (
    .re     (status_secret1_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.secret1_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_secret1_error_qs)
  );


  //   F[secret2_error]: 5:5
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_secret2_error (
    .re     (status_secret2_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.secret2_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_secret2_error_qs)
  );


  //   F[life_cycle_error]: 6:6
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_life_cycle_error (
    .re     (status_life_cycle_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.life_cycle_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_life_cycle_error_qs)
  );


  //   F[dai_error]: 7:7
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_dai_error (
    .re     (status_dai_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.dai_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_dai_error_qs)
  );


  //   F[lci_error]: 8:8
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_lci_error (
    .re     (status_lci_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.lci_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_lci_error_qs)
  );


  //   F[timeout_error]: 9:9
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_timeout_error (
    .re     (status_timeout_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.timeout_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_timeout_error_qs)
  );


  //   F[lfsr_fsm_error]: 10:10
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_lfsr_fsm_error (
    .re     (status_lfsr_fsm_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.lfsr_fsm_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_lfsr_fsm_error_qs)
  );


  //   F[scrambling_fsm_error]: 11:11
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_scrambling_fsm_error (
    .re     (status_scrambling_fsm_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.scrambling_fsm_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_scrambling_fsm_error_qs)
  );


  //   F[key_deriv_fsm_error]: 12:12
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_key_deriv_fsm_error (
    .re     (status_key_deriv_fsm_error_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.key_deriv_fsm_error.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_key_deriv_fsm_error_qs)
  );


  //   F[dai_idle]: 13:13
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_dai_idle (
    .re     (status_dai_idle_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.dai_idle.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_dai_idle_qs)
  );


  //   F[check_pending]: 14:14
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_check_pending (
    .re     (status_check_pending_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.check_pending.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_check_pending_qs)
  );



  // Subregister 0 of Multireg err_code
  // R[err_code]: V(True)

  // F[err_code_0]: 2:0
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_0 (
    .re     (err_code_err_code_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_0_qs)
  );


  // F[err_code_1]: 5:3
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_1 (
    .re     (err_code_err_code_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_1_qs)
  );


  // F[err_code_2]: 8:6
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_2 (
    .re     (err_code_err_code_2_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[2].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_2_qs)
  );


  // F[err_code_3]: 11:9
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_3 (
    .re     (err_code_err_code_3_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[3].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_3_qs)
  );


  // F[err_code_4]: 14:12
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_4 (
    .re     (err_code_err_code_4_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[4].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_4_qs)
  );


  // F[err_code_5]: 17:15
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_5 (
    .re     (err_code_err_code_5_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[5].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_5_qs)
  );


  // F[err_code_6]: 20:18
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_6 (
    .re     (err_code_err_code_6_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[6].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_6_qs)
  );


  // F[err_code_7]: 23:21
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_7 (
    .re     (err_code_err_code_7_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[7].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_7_qs)
  );


  // F[err_code_8]: 26:24
  prim_subreg_ext #(
    .DW    (3)
  ) u_err_code_err_code_8 (
    .re     (err_code_err_code_8_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.err_code[8].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (err_code_err_code_8_qs)
  );



  // R[direct_access_regwen]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_direct_access_regwen (
    .re     (direct_access_regwen_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.direct_access_regwen.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (direct_access_regwen_qs)
  );


  // R[direct_access_cmd]: V(True)

  //   F[rd]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_direct_access_cmd_rd (
    .re     (1'b0),
    // qualified with register enable
    .we     (direct_access_cmd_rd_we & direct_access_regwen_qs),
    .wd     (direct_access_cmd_rd_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.direct_access_cmd.rd.qe),
    .q      (reg2hw.direct_access_cmd.rd.q ),
    .qs     ()
  );


  //   F[wr]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_direct_access_cmd_wr (
    .re     (1'b0),
    // qualified with register enable
    .we     (direct_access_cmd_wr_we & direct_access_regwen_qs),
    .wd     (direct_access_cmd_wr_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.direct_access_cmd.wr.qe),
    .q      (reg2hw.direct_access_cmd.wr.q ),
    .qs     ()
  );


  //   F[digest]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_direct_access_cmd_digest (
    .re     (1'b0),
    // qualified with register enable
    .we     (direct_access_cmd_digest_we & direct_access_regwen_qs),
    .wd     (direct_access_cmd_digest_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.direct_access_cmd.digest.qe),
    .q      (reg2hw.direct_access_cmd.digest.q ),
    .qs     ()
  );


  // R[direct_access_address]: V(False)

  prim_subreg #(
    .DW      (11),
    .SWACCESS("RW"),
    .RESVAL  (11'h0)
  ) u_direct_access_address (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (direct_access_address_we & direct_access_regwen_qs),
    .wd     (direct_access_address_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.direct_access_address.q ),

    // to register interface (read)
    .qs     (direct_access_address_qs)
  );



  // Subregister 0 of Multireg direct_access_wdata
  // R[direct_access_wdata_0]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_direct_access_wdata_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (direct_access_wdata_0_we & direct_access_regwen_qs),
    .wd     (direct_access_wdata_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.direct_access_wdata[0].q ),

    // to register interface (read)
    .qs     (direct_access_wdata_0_qs)
  );

  // Subregister 1 of Multireg direct_access_wdata
  // R[direct_access_wdata_1]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_direct_access_wdata_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (direct_access_wdata_1_we & direct_access_regwen_qs),
    .wd     (direct_access_wdata_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.direct_access_wdata[1].q ),

    // to register interface (read)
    .qs     (direct_access_wdata_1_qs)
  );



  // Subregister 0 of Multireg direct_access_rdata
  // R[direct_access_rdata_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_direct_access_rdata_0 (
    .re     (direct_access_rdata_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.direct_access_rdata[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (direct_access_rdata_0_qs)
  );

  // Subregister 1 of Multireg direct_access_rdata
  // R[direct_access_rdata_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_direct_access_rdata_1 (
    .re     (direct_access_rdata_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.direct_access_rdata[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (direct_access_rdata_1_qs)
  );


  // R[check_trigger_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_check_trigger_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (check_trigger_regwen_we),
    .wd     (check_trigger_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (check_trigger_regwen_qs)
  );


  // R[check_trigger]: V(True)

  //   F[integrity]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_check_trigger_integrity (
    .re     (1'b0),
    // qualified with register enable
    .we     (check_trigger_integrity_we & check_trigger_regwen_qs),
    .wd     (check_trigger_integrity_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.check_trigger.integrity.qe),
    .q      (reg2hw.check_trigger.integrity.q ),
    .qs     ()
  );


  //   F[consistency]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_check_trigger_consistency (
    .re     (1'b0),
    // qualified with register enable
    .we     (check_trigger_consistency_we & check_trigger_regwen_qs),
    .wd     (check_trigger_consistency_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.check_trigger.consistency.qe),
    .q      (reg2hw.check_trigger.consistency.q ),
    .qs     ()
  );


  // R[check_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_check_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (check_regwen_we),
    .wd     (check_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (check_regwen_qs)
  );


  // R[check_timeout]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_check_timeout (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (check_timeout_we & check_regwen_qs),
    .wd     (check_timeout_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.check_timeout.q ),

    // to register interface (read)
    .qs     (check_timeout_qs)
  );


  // R[integrity_check_period]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_integrity_check_period (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (integrity_check_period_we & check_regwen_qs),
    .wd     (integrity_check_period_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.integrity_check_period.q ),

    // to register interface (read)
    .qs     (integrity_check_period_qs)
  );


  // R[consistency_check_period]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_consistency_check_period (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (consistency_check_period_we & check_regwen_qs),
    .wd     (consistency_check_period_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.consistency_check_period.q ),

    // to register interface (read)
    .qs     (consistency_check_period_qs)
  );


  // R[creator_sw_cfg_read_lock]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h1)
  ) u_creator_sw_cfg_read_lock (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (creator_sw_cfg_read_lock_we & direct_access_regwen_qs),
    .wd     (creator_sw_cfg_read_lock_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.creator_sw_cfg_read_lock.q ),

    // to register interface (read)
    .qs     (creator_sw_cfg_read_lock_qs)
  );


  // R[owner_sw_cfg_read_lock]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h1)
  ) u_owner_sw_cfg_read_lock (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (owner_sw_cfg_read_lock_we & direct_access_regwen_qs),
    .wd     (owner_sw_cfg_read_lock_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.owner_sw_cfg_read_lock.q ),

    // to register interface (read)
    .qs     (owner_sw_cfg_read_lock_qs)
  );



  // Subregister 0 of Multireg creator_sw_cfg_digest
  // R[creator_sw_cfg_digest_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_creator_sw_cfg_digest_0 (
    .re     (creator_sw_cfg_digest_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.creator_sw_cfg_digest[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (creator_sw_cfg_digest_0_qs)
  );

  // Subregister 1 of Multireg creator_sw_cfg_digest
  // R[creator_sw_cfg_digest_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_creator_sw_cfg_digest_1 (
    .re     (creator_sw_cfg_digest_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.creator_sw_cfg_digest[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (creator_sw_cfg_digest_1_qs)
  );



  // Subregister 0 of Multireg owner_sw_cfg_digest
  // R[owner_sw_cfg_digest_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_owner_sw_cfg_digest_0 (
    .re     (owner_sw_cfg_digest_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.owner_sw_cfg_digest[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (owner_sw_cfg_digest_0_qs)
  );

  // Subregister 1 of Multireg owner_sw_cfg_digest
  // R[owner_sw_cfg_digest_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_owner_sw_cfg_digest_1 (
    .re     (owner_sw_cfg_digest_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.owner_sw_cfg_digest[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (owner_sw_cfg_digest_1_qs)
  );



  // Subregister 0 of Multireg hw_cfg_digest
  // R[hw_cfg_digest_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_hw_cfg_digest_0 (
    .re     (hw_cfg_digest_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.hw_cfg_digest[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (hw_cfg_digest_0_qs)
  );

  // Subregister 1 of Multireg hw_cfg_digest
  // R[hw_cfg_digest_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_hw_cfg_digest_1 (
    .re     (hw_cfg_digest_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.hw_cfg_digest[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (hw_cfg_digest_1_qs)
  );



  // Subregister 0 of Multireg secret0_digest
  // R[secret0_digest_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_secret0_digest_0 (
    .re     (secret0_digest_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.secret0_digest[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (secret0_digest_0_qs)
  );

  // Subregister 1 of Multireg secret0_digest
  // R[secret0_digest_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_secret0_digest_1 (
    .re     (secret0_digest_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.secret0_digest[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (secret0_digest_1_qs)
  );



  // Subregister 0 of Multireg secret1_digest
  // R[secret1_digest_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_secret1_digest_0 (
    .re     (secret1_digest_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.secret1_digest[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (secret1_digest_0_qs)
  );

  // Subregister 1 of Multireg secret1_digest
  // R[secret1_digest_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_secret1_digest_1 (
    .re     (secret1_digest_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.secret1_digest[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (secret1_digest_1_qs)
  );



  // Subregister 0 of Multireg secret2_digest
  // R[secret2_digest_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_secret2_digest_0 (
    .re     (secret2_digest_0_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.secret2_digest[0].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (secret2_digest_0_qs)
  );

  // Subregister 1 of Multireg secret2_digest
  // R[secret2_digest_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_secret2_digest_1 (
    .re     (secret2_digest_1_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.secret2_digest[1].d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (secret2_digest_1_qs)
  );




  logic [32:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == OTP_CTRL_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == OTP_CTRL_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == OTP_CTRL_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == OTP_CTRL_ALERT_TEST_OFFSET);
    addr_hit[ 4] = (reg_addr == OTP_CTRL_STATUS_OFFSET);
    addr_hit[ 5] = (reg_addr == OTP_CTRL_ERR_CODE_OFFSET);
    addr_hit[ 6] = (reg_addr == OTP_CTRL_DIRECT_ACCESS_REGWEN_OFFSET);
    addr_hit[ 7] = (reg_addr == OTP_CTRL_DIRECT_ACCESS_CMD_OFFSET);
    addr_hit[ 8] = (reg_addr == OTP_CTRL_DIRECT_ACCESS_ADDRESS_OFFSET);
    addr_hit[ 9] = (reg_addr == OTP_CTRL_DIRECT_ACCESS_WDATA_0_OFFSET);
    addr_hit[10] = (reg_addr == OTP_CTRL_DIRECT_ACCESS_WDATA_1_OFFSET);
    addr_hit[11] = (reg_addr == OTP_CTRL_DIRECT_ACCESS_RDATA_0_OFFSET);
    addr_hit[12] = (reg_addr == OTP_CTRL_DIRECT_ACCESS_RDATA_1_OFFSET);
    addr_hit[13] = (reg_addr == OTP_CTRL_CHECK_TRIGGER_REGWEN_OFFSET);
    addr_hit[14] = (reg_addr == OTP_CTRL_CHECK_TRIGGER_OFFSET);
    addr_hit[15] = (reg_addr == OTP_CTRL_CHECK_REGWEN_OFFSET);
    addr_hit[16] = (reg_addr == OTP_CTRL_CHECK_TIMEOUT_OFFSET);
    addr_hit[17] = (reg_addr == OTP_CTRL_INTEGRITY_CHECK_PERIOD_OFFSET);
    addr_hit[18] = (reg_addr == OTP_CTRL_CONSISTENCY_CHECK_PERIOD_OFFSET);
    addr_hit[19] = (reg_addr == OTP_CTRL_CREATOR_SW_CFG_READ_LOCK_OFFSET);
    addr_hit[20] = (reg_addr == OTP_CTRL_OWNER_SW_CFG_READ_LOCK_OFFSET);
    addr_hit[21] = (reg_addr == OTP_CTRL_CREATOR_SW_CFG_DIGEST_0_OFFSET);
    addr_hit[22] = (reg_addr == OTP_CTRL_CREATOR_SW_CFG_DIGEST_1_OFFSET);
    addr_hit[23] = (reg_addr == OTP_CTRL_OWNER_SW_CFG_DIGEST_0_OFFSET);
    addr_hit[24] = (reg_addr == OTP_CTRL_OWNER_SW_CFG_DIGEST_1_OFFSET);
    addr_hit[25] = (reg_addr == OTP_CTRL_HW_CFG_DIGEST_0_OFFSET);
    addr_hit[26] = (reg_addr == OTP_CTRL_HW_CFG_DIGEST_1_OFFSET);
    addr_hit[27] = (reg_addr == OTP_CTRL_SECRET0_DIGEST_0_OFFSET);
    addr_hit[28] = (reg_addr == OTP_CTRL_SECRET0_DIGEST_1_OFFSET);
    addr_hit[29] = (reg_addr == OTP_CTRL_SECRET1_DIGEST_0_OFFSET);
    addr_hit[30] = (reg_addr == OTP_CTRL_SECRET1_DIGEST_1_OFFSET);
    addr_hit[31] = (reg_addr == OTP_CTRL_SECRET2_DIGEST_0_OFFSET);
    addr_hit[32] = (reg_addr == OTP_CTRL_SECRET2_DIGEST_1_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (OTP_CTRL_PERMIT[ 0] != (OTP_CTRL_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (OTP_CTRL_PERMIT[ 1] != (OTP_CTRL_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (OTP_CTRL_PERMIT[ 2] != (OTP_CTRL_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (OTP_CTRL_PERMIT[ 3] != (OTP_CTRL_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (OTP_CTRL_PERMIT[ 4] != (OTP_CTRL_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (OTP_CTRL_PERMIT[ 5] != (OTP_CTRL_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (OTP_CTRL_PERMIT[ 6] != (OTP_CTRL_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (OTP_CTRL_PERMIT[ 7] != (OTP_CTRL_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (OTP_CTRL_PERMIT[ 8] != (OTP_CTRL_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (OTP_CTRL_PERMIT[ 9] != (OTP_CTRL_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (OTP_CTRL_PERMIT[10] != (OTP_CTRL_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (OTP_CTRL_PERMIT[11] != (OTP_CTRL_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (OTP_CTRL_PERMIT[12] != (OTP_CTRL_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (OTP_CTRL_PERMIT[13] != (OTP_CTRL_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (OTP_CTRL_PERMIT[14] != (OTP_CTRL_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (OTP_CTRL_PERMIT[15] != (OTP_CTRL_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (OTP_CTRL_PERMIT[16] != (OTP_CTRL_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (OTP_CTRL_PERMIT[17] != (OTP_CTRL_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (OTP_CTRL_PERMIT[18] != (OTP_CTRL_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (OTP_CTRL_PERMIT[19] != (OTP_CTRL_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (OTP_CTRL_PERMIT[20] != (OTP_CTRL_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (OTP_CTRL_PERMIT[21] != (OTP_CTRL_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (OTP_CTRL_PERMIT[22] != (OTP_CTRL_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (OTP_CTRL_PERMIT[23] != (OTP_CTRL_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (OTP_CTRL_PERMIT[24] != (OTP_CTRL_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (OTP_CTRL_PERMIT[25] != (OTP_CTRL_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (OTP_CTRL_PERMIT[26] != (OTP_CTRL_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (OTP_CTRL_PERMIT[27] != (OTP_CTRL_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[28] && reg_we && (OTP_CTRL_PERMIT[28] != (OTP_CTRL_PERMIT[28] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[29] && reg_we && (OTP_CTRL_PERMIT[29] != (OTP_CTRL_PERMIT[29] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[30] && reg_we && (OTP_CTRL_PERMIT[30] != (OTP_CTRL_PERMIT[30] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[31] && reg_we && (OTP_CTRL_PERMIT[31] != (OTP_CTRL_PERMIT[31] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[32] && reg_we && (OTP_CTRL_PERMIT[32] != (OTP_CTRL_PERMIT[32] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_otp_operation_done_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_otp_operation_done_wd = reg_wdata[0];

  assign intr_state_otp_error_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_otp_error_wd = reg_wdata[1];

  assign intr_enable_otp_operation_done_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_otp_operation_done_wd = reg_wdata[0];

  assign intr_enable_otp_error_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_otp_error_wd = reg_wdata[1];

  assign intr_test_otp_operation_done_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_otp_operation_done_wd = reg_wdata[0];

  assign intr_test_otp_error_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_otp_error_wd = reg_wdata[1];

  assign alert_test_fatal_macro_error_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_fatal_macro_error_wd = reg_wdata[0];

  assign alert_test_fatal_check_error_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_fatal_check_error_wd = reg_wdata[1];

  assign status_creator_sw_cfg_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_owner_sw_cfg_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_hw_cfg_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_secret0_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_secret1_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_secret2_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_life_cycle_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_dai_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_lci_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_timeout_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_lfsr_fsm_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_scrambling_fsm_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_key_deriv_fsm_error_re = addr_hit[4] & reg_re & !reg_error;

  assign status_dai_idle_re = addr_hit[4] & reg_re & !reg_error;

  assign status_check_pending_re = addr_hit[4] & reg_re & !reg_error;

  assign err_code_err_code_0_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_1_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_2_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_3_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_4_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_5_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_6_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_7_re = addr_hit[5] & reg_re & !reg_error;

  assign err_code_err_code_8_re = addr_hit[5] & reg_re & !reg_error;

  assign direct_access_regwen_re = addr_hit[6] & reg_re & !reg_error;

  assign direct_access_cmd_rd_we = addr_hit[7] & reg_we & !reg_error;
  assign direct_access_cmd_rd_wd = reg_wdata[0];

  assign direct_access_cmd_wr_we = addr_hit[7] & reg_we & !reg_error;
  assign direct_access_cmd_wr_wd = reg_wdata[1];

  assign direct_access_cmd_digest_we = addr_hit[7] & reg_we & !reg_error;
  assign direct_access_cmd_digest_wd = reg_wdata[2];

  assign direct_access_address_we = addr_hit[8] & reg_we & !reg_error;
  assign direct_access_address_wd = reg_wdata[10:0];

  assign direct_access_wdata_0_we = addr_hit[9] & reg_we & !reg_error;
  assign direct_access_wdata_0_wd = reg_wdata[31:0];

  assign direct_access_wdata_1_we = addr_hit[10] & reg_we & !reg_error;
  assign direct_access_wdata_1_wd = reg_wdata[31:0];

  assign direct_access_rdata_0_re = addr_hit[11] & reg_re & !reg_error;

  assign direct_access_rdata_1_re = addr_hit[12] & reg_re & !reg_error;

  assign check_trigger_regwen_we = addr_hit[13] & reg_we & !reg_error;
  assign check_trigger_regwen_wd = reg_wdata[0];

  assign check_trigger_integrity_we = addr_hit[14] & reg_we & !reg_error;
  assign check_trigger_integrity_wd = reg_wdata[0];

  assign check_trigger_consistency_we = addr_hit[14] & reg_we & !reg_error;
  assign check_trigger_consistency_wd = reg_wdata[1];

  assign check_regwen_we = addr_hit[15] & reg_we & !reg_error;
  assign check_regwen_wd = reg_wdata[0];

  assign check_timeout_we = addr_hit[16] & reg_we & !reg_error;
  assign check_timeout_wd = reg_wdata[31:0];

  assign integrity_check_period_we = addr_hit[17] & reg_we & !reg_error;
  assign integrity_check_period_wd = reg_wdata[31:0];

  assign consistency_check_period_we = addr_hit[18] & reg_we & !reg_error;
  assign consistency_check_period_wd = reg_wdata[31:0];

  assign creator_sw_cfg_read_lock_we = addr_hit[19] & reg_we & !reg_error;
  assign creator_sw_cfg_read_lock_wd = reg_wdata[0];

  assign owner_sw_cfg_read_lock_we = addr_hit[20] & reg_we & !reg_error;
  assign owner_sw_cfg_read_lock_wd = reg_wdata[0];

  assign creator_sw_cfg_digest_0_re = addr_hit[21] & reg_re & !reg_error;

  assign creator_sw_cfg_digest_1_re = addr_hit[22] & reg_re & !reg_error;

  assign owner_sw_cfg_digest_0_re = addr_hit[23] & reg_re & !reg_error;

  assign owner_sw_cfg_digest_1_re = addr_hit[24] & reg_re & !reg_error;

  assign hw_cfg_digest_0_re = addr_hit[25] & reg_re & !reg_error;

  assign hw_cfg_digest_1_re = addr_hit[26] & reg_re & !reg_error;

  assign secret0_digest_0_re = addr_hit[27] & reg_re & !reg_error;

  assign secret0_digest_1_re = addr_hit[28] & reg_re & !reg_error;

  assign secret1_digest_0_re = addr_hit[29] & reg_re & !reg_error;

  assign secret1_digest_1_re = addr_hit[30] & reg_re & !reg_error;

  assign secret2_digest_0_re = addr_hit[31] & reg_re & !reg_error;

  assign secret2_digest_1_re = addr_hit[32] & reg_re & !reg_error;

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_otp_operation_done_qs;
        reg_rdata_next[1] = intr_state_otp_error_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_otp_operation_done_qs;
        reg_rdata_next[1] = intr_enable_otp_error_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
      end

      addr_hit[4]: begin
        reg_rdata_next[0] = status_creator_sw_cfg_error_qs;
        reg_rdata_next[1] = status_owner_sw_cfg_error_qs;
        reg_rdata_next[2] = status_hw_cfg_error_qs;
        reg_rdata_next[3] = status_secret0_error_qs;
        reg_rdata_next[4] = status_secret1_error_qs;
        reg_rdata_next[5] = status_secret2_error_qs;
        reg_rdata_next[6] = status_life_cycle_error_qs;
        reg_rdata_next[7] = status_dai_error_qs;
        reg_rdata_next[8] = status_lci_error_qs;
        reg_rdata_next[9] = status_timeout_error_qs;
        reg_rdata_next[10] = status_lfsr_fsm_error_qs;
        reg_rdata_next[11] = status_scrambling_fsm_error_qs;
        reg_rdata_next[12] = status_key_deriv_fsm_error_qs;
        reg_rdata_next[13] = status_dai_idle_qs;
        reg_rdata_next[14] = status_check_pending_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[2:0] = err_code_err_code_0_qs;
        reg_rdata_next[5:3] = err_code_err_code_1_qs;
        reg_rdata_next[8:6] = err_code_err_code_2_qs;
        reg_rdata_next[11:9] = err_code_err_code_3_qs;
        reg_rdata_next[14:12] = err_code_err_code_4_qs;
        reg_rdata_next[17:15] = err_code_err_code_5_qs;
        reg_rdata_next[20:18] = err_code_err_code_6_qs;
        reg_rdata_next[23:21] = err_code_err_code_7_qs;
        reg_rdata_next[26:24] = err_code_err_code_8_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[0] = direct_access_regwen_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
        reg_rdata_next[2] = '0;
      end

      addr_hit[8]: begin
        reg_rdata_next[10:0] = direct_access_address_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[31:0] = direct_access_wdata_0_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[31:0] = direct_access_wdata_1_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[31:0] = direct_access_rdata_0_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[31:0] = direct_access_rdata_1_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[0] = check_trigger_regwen_qs;
      end

      addr_hit[14]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
      end

      addr_hit[15]: begin
        reg_rdata_next[0] = check_regwen_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[31:0] = check_timeout_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[31:0] = integrity_check_period_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[31:0] = consistency_check_period_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[0] = creator_sw_cfg_read_lock_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[0] = owner_sw_cfg_read_lock_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[31:0] = creator_sw_cfg_digest_0_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[31:0] = creator_sw_cfg_digest_1_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[31:0] = owner_sw_cfg_digest_0_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[31:0] = owner_sw_cfg_digest_1_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[31:0] = hw_cfg_digest_0_qs;
      end

      addr_hit[26]: begin
        reg_rdata_next[31:0] = hw_cfg_digest_1_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[31:0] = secret0_digest_0_qs;
      end

      addr_hit[28]: begin
        reg_rdata_next[31:0] = secret0_digest_1_qs;
      end

      addr_hit[29]: begin
        reg_rdata_next[31:0] = secret1_digest_0_qs;
      end

      addr_hit[30]: begin
        reg_rdata_next[31:0] = secret1_digest_1_qs;
      end

      addr_hit[31]: begin
        reg_rdata_next[31:0] = secret2_digest_0_qs;
      end

      addr_hit[32]: begin
        reg_rdata_next[31:0] = secret2_digest_1_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
