// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Package auto-generated by `reggen` containing data structure

package nmi_gen_reg_pkg;

  // Address widths within the block
  parameter int BlockAw = 4;

  ////////////////////////////
  // Typedefs for registers //
  ////////////////////////////

  typedef struct packed {
    struct packed {
      logic        q;
    } esc0;
    struct packed {
      logic        q;
    } esc1;
    struct packed {
      logic        q;
    } esc2;
  } nmi_gen_reg2hw_intr_state_reg_t;

  typedef struct packed {
    struct packed {
      logic        q;
    } esc0;
    struct packed {
      logic        q;
    } esc1;
    struct packed {
      logic        q;
    } esc2;
  } nmi_gen_reg2hw_intr_enable_reg_t;

  typedef struct packed {
    struct packed {
      logic        q;
      logic        qe;
    } esc0;
    struct packed {
      logic        q;
      logic        qe;
    } esc1;
    struct packed {
      logic        q;
      logic        qe;
    } esc2;
  } nmi_gen_reg2hw_intr_test_reg_t;

  typedef struct packed {
    struct packed {
      logic        d;
      logic        de;
    } esc0;
    struct packed {
      logic        d;
      logic        de;
    } esc1;
    struct packed {
      logic        d;
      logic        de;
    } esc2;
  } nmi_gen_hw2reg_intr_state_reg_t;

  // Register -> HW type
  typedef struct packed {
    nmi_gen_reg2hw_intr_state_reg_t intr_state; // [11:9]
    nmi_gen_reg2hw_intr_enable_reg_t intr_enable; // [8:6]
    nmi_gen_reg2hw_intr_test_reg_t intr_test; // [5:0]
  } nmi_gen_reg2hw_t;

  // HW -> register type
  typedef struct packed {
    nmi_gen_hw2reg_intr_state_reg_t intr_state; // [5:0]
  } nmi_gen_hw2reg_t;

  // Register offsets
  parameter logic [BlockAw-1:0] NMI_GEN_INTR_STATE_OFFSET = 4'h 0;
  parameter logic [BlockAw-1:0] NMI_GEN_INTR_ENABLE_OFFSET = 4'h 4;
  parameter logic [BlockAw-1:0] NMI_GEN_INTR_TEST_OFFSET = 4'h 8;

  // Reset values for hwext registers and their fields
  parameter logic [2:0] NMI_GEN_INTR_TEST_RESVAL = 3'h 0;
  parameter logic [0:0] NMI_GEN_INTR_TEST_ESC0_RESVAL = 1'h 0;
  parameter logic [0:0] NMI_GEN_INTR_TEST_ESC1_RESVAL = 1'h 0;
  parameter logic [0:0] NMI_GEN_INTR_TEST_ESC2_RESVAL = 1'h 0;

  // Register index
  typedef enum int {
    NMI_GEN_INTR_STATE,
    NMI_GEN_INTR_ENABLE,
    NMI_GEN_INTR_TEST
  } nmi_gen_id_e;

  // Register width information to check illegal writes
  parameter logic [3:0] NMI_GEN_PERMIT [3] = '{
    4'b 0001, // index[0] NMI_GEN_INTR_STATE
    4'b 0001, // index[1] NMI_GEN_INTR_ENABLE
    4'b 0001  // index[2] NMI_GEN_INTR_TEST
  };

endpackage

